/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import nl.mpi.arbil.data.ArbilDataNodeLoader;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.kinnate.entityindexer.EntityCollection;
import nl.mpi.kinnate.entityindexer.EntityServiceException;
import nl.mpi.kinnate.gedcomimport.ImportException;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindocument.EntityDocument;
import nl.mpi.kinnate.kindocument.EntityMerger;
import nl.mpi.kinnate.kindocument.ImportTranslator;
import nl.mpi.kinnate.kindocument.RelationLinker;
import nl.mpi.kinnate.svg.DataStoreSvg;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.svg.SvgUpdateHandler;
import nl.mpi.kinnate.ui.KinDiagramPanel;
import nl.mpi.kinnate.ui.entityprofiles.ProfileRecord;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

public class GraphPanelContextMenu
extends JPopupMenu
implements ActionListener {
    private static final ResourceBundle menus = ResourceBundle.getBundle("nl/mpi/kinoath/localisation/Menus");
    private KinDiagramPanel kinDiagramPanel;
    private GraphPanel graphPanel;
    private JMenu addEntityMenu;
    private JMenuItem duplicateEntitiesMenu;
    private JMenuItem mergeEntitiesMenu;
    private JMenuItem addRelationEntityMenu;
    private JMenuItem removeRelationEntityMenu;
    private JMenuItem setAsEgoMenuItem;
    private JMenuItem addAsEgoMenuItem;
    private JMenuItem removeEgoMenuItem;
    private JMenuItem addAsRequiredMenuItem;
    private JMenuItem removeRequiredMenuItem;
    private JMenuItem saveFileMenuItem;
    private JMenuItem deleteMenu;
    final JSeparator jSeparator2 = new JSeparator();
    final JSeparator jSeparator3 = new JSeparator();
    private UniqueIdentifier[] selectedIdentifiers = null;
    private Point eventLocation;
    private ArbilDataNodeLoader dataNodeLoader;

    public GraphPanelContextMenu(KinDiagramPanel egoSelectionPanelLocal, final GraphPanel graphPanelLocal, final EntityCollection entityCollection, final ArbilWindowManager arbilWindowManager, ArbilDataNodeLoader dataNodeLoaderL, final SessionStorage sessionStorage) {
        this.kinDiagramPanel = egoSelectionPanelLocal;
        this.graphPanel = graphPanelLocal;
        this.dataNodeLoader = dataNodeLoaderL;
        if (egoSelectionPanelLocal != null) {
            final ActionListener addMenuActionListener = new ActionListener(){

                @Override
                public void actionPerformed(final ActionEvent evt) {
                    if (!GraphPanelContextMenu.this.kinDiagramPanel.verifyDiagramDataLoaded()) {
                        return;
                    }
                    new Thread(){

                        @Override
                        public void run() {
                            GraphPanelContextMenu.this.kinDiagramPanel.showProgressBar();
                            String nodeType = evt.getActionCommand();
                            try {
                                EntityDocument entityDocument = new EntityDocument(nodeType, new ImportTranslator(true), sessionStorage, entityCollection.getProjectRecord());
                                entityDocument.saveDocument();
                                URI addedEntityUri = entityDocument.getFile().toURI();
                                entityCollection.updateDatabase(entityDocument.getFile().toURI(), entityDocument.getUniqueIdentifier());
                                GraphPanelContextMenu.this.kinDiagramPanel.addRequiredNodes(new UniqueIdentifier[]{entityDocument.getUniqueIdentifier()}, GraphPanelContextMenu.this.eventLocation);
                            }
                            catch (ImportException exception) {
                                GraphPanelContextMenu.this.kinDiagramPanel.clearProgressBar();
                                BugCatcherManager.getBugCatcher().logError((Exception)exception);
                                String message = MessageFormat.format(menus.getString("FAILED TO CREATE ENTITY: {0}"), exception.getMessage());
                                arbilWindowManager.addMessageDialogToQueue(message, menus.getString("ADD ENTITY"));
                            }
                            catch (EntityServiceException exception) {
                                BugCatcherManager.getBugCatcher().logError((Exception)exception);
                                arbilWindowManager.addMessageDialogToQueue(exception.getMessage(), "Update Database");
                            }
                        }
                    }.start();
                }
            };
            this.addEntityMenu = new JMenu(menus.getString("ADD"));
            this.addEntityMenu.addMenuListener(new MenuListener(){

                @Override
                public void menuSelected(MenuEvent e) {
                    GraphPanelContextMenu.this.addEntityMenu.removeAll();
                    for (ProfileRecord profileRecord : graphPanelLocal.dataStoreSvg.selectedProfiles) {
                        JMenuItem addMenuItem = new JMenuItem(profileRecord.profileName);
                        addMenuItem.setActionCommand(profileRecord.profileId);
                        addMenuItem.addActionListener(addMenuActionListener);
                        GraphPanelContextMenu.this.addEntityMenu.add(addMenuItem);
                    }
                }

                @Override
                public void menuDeselected(MenuEvent e) {
                }

                @Override
                public void menuCanceled(MenuEvent e) {
                }
            });
            this.add(this.addEntityMenu);
            JMenu shapeSubMenu = new JMenu(menus.getString("ADD GEOMETRY"));
            for (SvgUpdateHandler.GraphicsTypes graphicsTypes : SvgUpdateHandler.GraphicsTypes.values()) {
                JMenuItem addLabel = new JMenuItem(MessageFormat.format(menus.getString("ADD {0}"), graphicsTypes.name()));
                addLabel.setActionCommand(graphicsTypes.name());
                shapeSubMenu.add(addLabel);
                if (SvgUpdateHandler.GraphicsTypes.Polyline.equals((Object)graphicsTypes)) {
                    addLabel.setEnabled(false);
                }
                addLabel.addActionListener(this);
            }
            this.add(shapeSubMenu);
            this.deleteMenu = new JMenuItem(menus.getString("DELETE SELECTED FROM PROJECT"));
            this.deleteMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    int entityCount = 0;
                    for (UniqueIdentifier uniqueIdentifier : GraphPanelContextMenu.this.selectedIdentifiers) {
                        if (uniqueIdentifier.isGraphicsIdentifier() || uniqueIdentifier.isTransientIdentifier()) continue;
                        ++entityCount;
                    }
                    boolean doDelete = false;
                    if (entityCount == 0) {
                        doDelete = true;
                    } else if (0 == arbilWindowManager.showDialogBox(entityCount + menus.getString(" ENTITIES WILL BE DELETED FROM THE CURRENT PROJECT"), menus.getString("DELETE ENTITY"), 2, 2)) {
                        doDelete = true;
                    }
                    if (doDelete) {
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                GraphPanelContextMenu.this.kinDiagramPanel.showProgressBar();
                                ArrayList<UniqueIdentifier> affectedIdentifiers = new ArrayList<UniqueIdentifier>();
                                for (UniqueIdentifier uniqueIdentifier : GraphPanelContextMenu.this.selectedIdentifiers) {
                                    if (uniqueIdentifier.isGraphicsIdentifier()) {
                                        ((GraphPanelContextMenu)GraphPanelContextMenu.this).graphPanel.svgUpdateHandler.deleteGraphics(uniqueIdentifier);
                                        continue;
                                    }
                                    if (uniqueIdentifier.isTransientIdentifier()) {
                                        GraphPanelContextMenu.this.kinDiagramPanel.clearProgressBar();
                                        throw new UnsupportedOperationException(menus.getString("CANNOT DELETE TRANSIENT ENTITIES."));
                                    }
                                    affectedIdentifiers.add(uniqueIdentifier);
                                }
                                UniqueIdentifier[] affectedIdentifiersArray = affectedIdentifiers.toArray(new UniqueIdentifier[0]);
                                try {
                                    RelationLinker relationLinker = new RelationLinker(sessionStorage, (MessageDialogHandler)arbilWindowManager, entityCollection);
                                    relationLinker.deleteEntity(affectedIdentifiersArray);
                                }
                                catch (ImportException exception) {
                                    String message = MessageFormat.format(ResourceBundle.getBundle("nl/mpi/kinoath/localisation/Menus").getString("FAILED TO DELETE: {0}"), exception.getMessage());
                                    arbilWindowManager.addMessageDialogToQueue(message, GraphPanelContextMenu.this.mergeEntitiesMenu.getText());
                                }
                                GraphPanelContextMenu.this.kinDiagramPanel.removeRequiredNodes(affectedIdentifiersArray);
                                GraphPanelContextMenu.this.kinDiagramPanel.removeEgoNodes(affectedIdentifiersArray);
                                GraphPanelContextMenu.this.kinDiagramPanel.clearProgressBar();
                            }
                        }).start();
                    }
                }
            });
            this.add(this.deleteMenu);
            this.mergeEntitiesMenu = new JMenuItem(menus.getString("MERGE SELECTED ENTITIES"));
            this.mergeEntitiesMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String messageString = MessageFormat.format(menus.getString("THE SELECTED ENTITES WILL BE MERGED,ALL RELATIONS WILL BE PRESERVED AND {0} ENTITIES WILL BE DELETED."), GraphPanelContextMenu.this.selectedIdentifiers.length - 1);
                    if (0 == arbilWindowManager.showDialogBox(messageString = messageString + menus.getString("DO YOU WISH TO CONTINUE?"), menus.getString("MERGE ENTITIES"), 2, 2)) {
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                GraphPanelContextMenu.this.kinDiagramPanel.showProgressBar();
                                try {
                                    EntityMerger entityMerger = new EntityMerger(sessionStorage, (MessageDialogHandler)arbilWindowManager, entityCollection);
                                    UniqueIdentifier leadMergedEntity = entityMerger.mergeEntities(GraphPanelContextMenu.this.selectedIdentifiers);
                                    GraphPanelContextMenu.this.dataNodeLoader.requestReload(GraphPanelContextMenu.this.dataNodeLoader.getArbilDataNode(null, leadMergedEntity.getFileInProject(GraphPanelContextMenu.this.kinDiagramPanel.getEntityCollection().getProjectRecord()).toURI()));
                                    GraphPanelContextMenu.this.kinDiagramPanel.entityRelationsChanged(entityMerger.getAffectedIdentifiersArray());
                                    GraphPanelContextMenu.this.kinDiagramPanel.removeRequiredNodes(entityMerger.getDeletedIdentifiersArray());
                                }
                                catch (ImportException exception) {
                                    arbilWindowManager.addMessageDialogToQueue(MessageFormat.format(menus.getString("FAILED TO MERGE: {0}"), exception.getMessage()), GraphPanelContextMenu.this.mergeEntitiesMenu.getText());
                                }
                                catch (EntityServiceException exception) {
                                    arbilWindowManager.addMessageDialogToQueue(MessageFormat.format(menus.getString("FAILED TO MERGE: {0}"), exception.getMessage()), GraphPanelContextMenu.this.mergeEntitiesMenu.getText());
                                }
                                GraphPanelContextMenu.this.kinDiagramPanel.clearProgressBar();
                            }
                        }).start();
                    }
                }
            });
            this.add(this.mergeEntitiesMenu);
            this.duplicateEntitiesMenu = new JMenuItem(menus.getString("DUPLICATE SELECTED ENTITIES"));
            this.duplicateEntitiesMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            GraphPanelContextMenu.this.kinDiagramPanel.showProgressBar();
                            try {
                                UniqueIdentifier[] duplicateEntities = new EntityMerger(sessionStorage, (MessageDialogHandler)arbilWindowManager, entityCollection).duplicateEntities(GraphPanelContextMenu.this.selectedIdentifiers);
                                GraphPanelContextMenu.this.kinDiagramPanel.entityRelationsChanged(GraphPanelContextMenu.this.selectedIdentifiers);
                                GraphPanelContextMenu.this.kinDiagramPanel.addRequiredNodes(duplicateEntities, GraphPanelContextMenu.this.eventLocation);
                            }
                            catch (ImportException exception) {
                                arbilWindowManager.addMessageDialogToQueue(MessageFormat.format(menus.getString("FAILED TO DUPLICATE: {0}"), exception.getMessage()), GraphPanelContextMenu.this.duplicateEntitiesMenu.getText());
                            }
                            catch (EntityServiceException exception) {
                                arbilWindowManager.addMessageDialogToQueue(MessageFormat.format(menus.getString("FAILED TO DUPLICATE: {0}"), exception.getMessage()), GraphPanelContextMenu.this.duplicateEntitiesMenu.getText());
                            }
                            GraphPanelContextMenu.this.kinDiagramPanel.clearProgressBar();
                        }
                    }).start();
                }
            });
            this.add(this.duplicateEntitiesMenu);
            this.addRelationEntityMenu = new JMenu(menus.getString("ADD RELATION"));
            this.add(this.addRelationEntityMenu);
            for (Enum enum_ : DataTypes.RelationType.values()) {
                JMenuItem addRelationEntityMenuItem = new JMenuItem(enum_.name());
                addRelationEntityMenuItem.setActionCommand(enum_.name());
                addRelationEntityMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(final ActionEvent evt) {
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                GraphPanelContextMenu.this.kinDiagramPanel.showProgressBar();
                                try {
                                    UniqueIdentifier[] affectedIdentifiers = new RelationLinker(sessionStorage, (MessageDialogHandler)arbilWindowManager, entityCollection).linkEntities(GraphPanelContextMenu.this.selectedIdentifiers, DataTypes.RelationType.valueOf(evt.getActionCommand()), null, null);
                                    GraphPanelContextMenu.this.kinDiagramPanel.entityRelationsChanged(affectedIdentifiers);
                                }
                                catch (ImportException exception) {
                                    arbilWindowManager.addMessageDialogToQueue(MessageFormat.format(menus.getString("FAILED TO CREATE RELATION: {0}"), exception.getMessage()), GraphPanelContextMenu.this.addRelationEntityMenu.getText());
                                }
                                GraphPanelContextMenu.this.kinDiagramPanel.clearProgressBar();
                            }
                        }).start();
                    }
                });
                this.addRelationEntityMenu.add(addRelationEntityMenuItem);
            }
            this.removeRelationEntityMenu = new JMenu(menus.getString("REMOVE RELATIONS"));
            this.add(this.removeRelationEntityMenu);
            String actionString = menus.getString("REMOVE RELATIONS BETWEEN SELECTED");
            JMenuItem removeRelationEntityMenuItem = new JMenuItem(actionString);
            removeRelationEntityMenuItem.setActionCommand(actionString);
            removeRelationEntityMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            GraphPanelContextMenu.this.kinDiagramPanel.showProgressBar();
                            try {
                                new RelationLinker(sessionStorage, (MessageDialogHandler)arbilWindowManager, entityCollection).unlinkEntities(GraphPanelContextMenu.this.graphPanel, GraphPanelContextMenu.this.selectedIdentifiers);
                                GraphPanelContextMenu.this.kinDiagramPanel.entityRelationsChanged(GraphPanelContextMenu.this.selectedIdentifiers);
                            }
                            catch (ImportException exception) {
                                arbilWindowManager.addMessageDialogToQueue(MessageFormat.format(menus.getString("FAILED TO REMOVE RELATIONS: {0}"), exception.getMessage()), GraphPanelContextMenu.this.removeRelationEntityMenu.getText());
                            }
                            GraphPanelContextMenu.this.kinDiagramPanel.clearProgressBar();
                        }
                    }).start();
                }
            });
            this.removeRelationEntityMenu.add(removeRelationEntityMenuItem);
            this.add(new JSeparator());
        }
        this.setAsEgoMenuItem = new JMenuItem(menus.getString("SET AS EGO (LIST WILL BE CLEARED)"));
        this.setAsEgoMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphPanelContextMenu.this.kinDiagramPanel.setEgoNodes(GraphPanelContextMenu.this.selectedIdentifiers);
            }
        });
        this.add(this.setAsEgoMenuItem);
        this.addAsEgoMenuItem = new JMenuItem(menus.getString("ADD TO EGO LIST"));
        this.addAsEgoMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphPanelContextMenu.this.kinDiagramPanel.addEgoNodes(GraphPanelContextMenu.this.selectedIdentifiers);
            }
        });
        this.add(this.addAsEgoMenuItem);
        this.removeEgoMenuItem = new JMenuItem(menus.getString("REMOVE FROM EGO LIST"));
        this.removeEgoMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphPanelContextMenu.this.kinDiagramPanel.removeEgoNodes(GraphPanelContextMenu.this.selectedIdentifiers);
            }
        });
        this.add(this.removeEgoMenuItem);
        this.add(this.jSeparator2);
        this.addAsRequiredMenuItem = new JMenuItem(menus.getString("ATTACH TO DIAGRAM"));
        this.addAsRequiredMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphPanelContextMenu.this.kinDiagramPanel.addRequiredNodes(GraphPanelContextMenu.this.selectedIdentifiers, null);
            }
        });
        this.add(this.addAsRequiredMenuItem);
        this.removeRequiredMenuItem = new JMenuItem(menus.getString("RELEASE FROM DIAGRAM"));
        this.removeRequiredMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphPanelContextMenu.this.kinDiagramPanel.removeRequiredNodes(GraphPanelContextMenu.this.selectedIdentifiers);
            }
        });
        this.add(this.removeRequiredMenuItem);
        this.add(this.jSeparator3);
        JMenuItem resetZoomMenuItem = new JMenuItem(menus.getString("RESET ZOOM"));
        resetZoomMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphPanelContextMenu.this.graphPanel.resetZoom();
            }
        });
        this.add(resetZoomMenuItem);
        JMenuItem resetLayoutMenuItem = new JMenuItem(menus.getString("RESET LAYOUT"));
        resetLayoutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (!GraphPanelContextMenu.this.kinDiagramPanel.verifyDiagramDataLoaded()) {
                    return;
                }
                GraphPanelContextMenu.this.graphPanel.resetLayout(true);
            }
        });
        this.add(resetLayoutMenuItem);
        JMenuItem searchEntityServiceMenuItem = new JMenuItem(menus.getString("SEARCH ENTITY SERVICE"));
        searchEntityServiceMenuItem.setToolTipText(menus.getString("SEARCH THE ENTITY DATABASE FOR ENTITIES MATCHING THE CURRENT KIN TERMS AND POPULATE HE DIAGRAM WITH THE RESULTS"));
        searchEntityServiceMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
            }
        });
        searchEntityServiceMenuItem.setEnabled(false);
        this.add(searchEntityServiceMenuItem);
        this.saveFileMenuItem = new JMenuItem();
        this.saveFileMenuItem.setText(menus.getString("SAVE ALL DATA CHANGES"));
        this.saveFileMenuItem.setEnabled(false);
        this.saveFileMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        GraphPanelContextMenu.this.kinDiagramPanel.showProgressBar();
                        try {
                            arbilWindowManager.stopEditingInCurrentWindow();
                            GraphPanelContextMenu.this.dataNodeLoader.saveNodesNeedingSave(true);
                        }
                        catch (Exception ex) {
                            BugCatcherManager.getBugCatcher().logError(ex);
                        }
                        GraphPanelContextMenu.this.kinDiagramPanel.clearProgressBar();
                    }
                }).start();
            }
        });
        this.add(this.saveFileMenuItem);
    }

    @Override
    public void show(Component cmpnt, int i, int i1) {
        boolean showNonTransientMenus;
        this.eventLocation = new Point(i, i1);
        this.selectedIdentifiers = this.graphPanel.getSelectedIds();
        int nonTransientNodeCount = 0;
        int transientNodeCount = 0;
        int graphicsIdentifierCount = 0;
        for (UniqueIdentifier uniqueIdentifier : this.selectedIdentifiers) {
            if (uniqueIdentifier.isGraphicsIdentifier()) {
                ++graphicsIdentifierCount;
                continue;
            }
            if (uniqueIdentifier.isTransientIdentifier()) {
                ++transientNodeCount;
                continue;
            }
            ++nonTransientNodeCount;
        }
        if (this.graphPanel.dataStoreSvg.diagramMode != DataStoreSvg.DiagramMode.FreeForm) {
            this.duplicateEntitiesMenu.setEnabled(nonTransientNodeCount > 0);
            this.removeRelationEntityMenu.setEnabled(nonTransientNodeCount > 1);
            this.mergeEntitiesMenu.setEnabled(nonTransientNodeCount > 1);
            this.addRelationEntityMenu.setEnabled(nonTransientNodeCount > 1);
            this.setAsEgoMenuItem.setEnabled(nonTransientNodeCount > 0);
            this.addAsEgoMenuItem.setEnabled(nonTransientNodeCount > 0);
            this.removeEgoMenuItem.setEnabled(nonTransientNodeCount > 0);
            this.addAsRequiredMenuItem.setEnabled(nonTransientNodeCount > 0);
            this.removeRequiredMenuItem.setEnabled(nonTransientNodeCount > 0);
            showNonTransientMenus = true;
        } else {
            showNonTransientMenus = false;
        }
        this.removeRelationEntityMenu.setVisible(showNonTransientMenus);
        this.mergeEntitiesMenu.setVisible(showNonTransientMenus);
        this.duplicateEntitiesMenu.setVisible(showNonTransientMenus);
        this.addRelationEntityMenu.setVisible(showNonTransientMenus);
        this.setAsEgoMenuItem.setVisible(showNonTransientMenus);
        this.addAsEgoMenuItem.setVisible(showNonTransientMenus);
        this.removeEgoMenuItem.setVisible(showNonTransientMenus);
        this.addAsRequiredMenuItem.setVisible(showNonTransientMenus);
        this.removeRequiredMenuItem.setVisible(showNonTransientMenus);
        this.addEntityMenu.setVisible(showNonTransientMenus);
        this.jSeparator2.setVisible(showNonTransientMenus);
        this.jSeparator3.setVisible(showNonTransientMenus);
        this.deleteMenu.setEnabled(nonTransientNodeCount + graphicsIdentifierCount > 0 && transientNodeCount == 0);
        this.saveFileMenuItem.setEnabled(this.dataNodeLoader.nodesNeedSave());
        super.show(cmpnt, i, i1);
    }

    @Override
    public void actionPerformed(final ActionEvent e) {
        if (!this.kinDiagramPanel.verifyDiagramDataLoaded()) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                GraphPanelContextMenu.this.kinDiagramPanel.showProgressBar();
                ((GraphPanelContextMenu)GraphPanelContextMenu.this).graphPanel.svgUpdateHandler.addGraphics(SvgUpdateHandler.GraphicsTypes.valueOf(e.getActionCommand()), GraphPanelContextMenu.this.eventLocation);
                GraphPanelContextMenu.this.kinDiagramPanel.clearProgressBar();
            }
        }).start();
    }
}

