/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.EventQueue;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import nl.mpi.arbil.ArbilIcons;
import nl.mpi.arbil.ArbilMain;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.ApplicationVersion;
import nl.mpi.arbil.util.ApplicationVersionManager;
import nl.mpi.arbil.util.ArbilLogConfigurer;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbilcommons.ui.LocalisationSelector;
import nl.mpi.flap.plugin.PluginBugCatcher;
import nl.mpi.flap.plugin.PluginDialogHandler;
import nl.mpi.flap.plugin.PluginSessionStorage;
import nl.mpi.kinnate.KinOathVersion;
import nl.mpi.kinnate.KinnateArbilInjector;
import nl.mpi.kinnate.entityindexer.EntityCollection;
import nl.mpi.kinnate.entityindexer.EntityServiceException;
import nl.mpi.kinnate.gedcomimport.ImportException;
import nl.mpi.kinnate.plugins.export.MigrationWizard;
import nl.mpi.kinnate.projects.ProjectManager;
import nl.mpi.kinnate.ui.KinDiagramPanel;
import nl.mpi.kinnate.ui.window.AbstractDiagramManager;
import nl.mpi.kinnate.ui.window.WindowedDiagramManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainFrame
extends JFrame {
    private static final ResourceBundle menus = ResourceBundle.getBundle("nl/mpi/kinoath/localisation/Menus");
    private static final Logger logger = LoggerFactory.getLogger(MainFrame.class);

    public MainFrame() {
        this.initComponents();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(3);
        this.pack();
    }

    public static void main(String[] args) {
        final ApplicationVersionManager versionManager = new ApplicationVersionManager((ApplicationVersion)new KinOathVersion());
        final ArbilLogConfigurer logConfigurer = new ArbilLogConfigurer(versionManager.getApplicationVersion(), "kinoath-log-");
        if (System.getProperty("java.util.logging.config.file") == null) {
            logConfigurer.configureLoggingFromResource(ArbilMain.class, "/logging-initial.properties");
        }
        logger.info("Starting KinOath");
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                KinnateArbilInjector injector = new KinnateArbilInjector();
                injector.injectHandlers(versionManager);
                final ArbilWindowManager windowManager = injector.getWindowManager();
                final SessionStorage sessionStorage = injector.getSessionStorage();
                final ProjectManager projectManager = new ProjectManager(sessionStorage, windowManager);
                String availableLanguages = ResourceBundle.getBundle("nl/mpi/kinoath/localisation/AvailableLanguages").getString("LANGUAGE CODES");
                LocalisationSelector localisationSelector = new LocalisationSelector((PluginSessionStorage)sessionStorage, availableLanguages.split(","));
                if (!localisationSelector.hasSavedLocal()) {
                    String please_select_your_preferred_language = menus.getString("PLEASE SELECT YOUR PREFERRED LANGUAGE");
                    String language_Selection = menus.getString("LANGUAGE SELECTION");
                    String system_Default = menus.getString("SYSTEM DEFAULT");
                    localisationSelector.askUser(null, (Icon)ArbilIcons.getSingleInstance().linorgIcon, please_select_your_preferred_language, language_Selection, system_Default);
                }
                localisationSelector.setLanguageFromSaved();
                final WindowedDiagramManager abstractDiagramManager = new WindowedDiagramManager(versionManager, windowManager, sessionStorage, injector.getDataNodeLoader(), injector.getTreeHelper(), projectManager, logConfigurer, injector.getArbilTableController(), injector.getWindowManager());
                try {
                    boolean databaseDirectoryOk = false;
                    while (!databaseDirectoryOk) {
                        try {
                            String storedDatabasePath = sessionStorage.loadString("KinOathDatabaseDirectory");
                            File databaseDirectory = storedDatabasePath == null ? sessionStorage.getApplicationSettingsDirectory() : new File(storedDatabasePath);
                            File globalDatabaseDirectory = new File(databaseDirectory, "BaseXData");
                            if (!globalDatabaseDirectory.exists()) {
                                globalDatabaseDirectory.mkdir();
                            }
                            new File(globalDatabaseDirectory, ".basexhome").createNewFile();
                            Properties props = System.getProperties();
                            props.setProperty("org.basex.path", globalDatabaseDirectory.getAbsolutePath());
                            EntityCollection.testGlobalDatabasePath(databaseDirectory);
                            databaseDirectoryOk = true;
                        }
                        catch (EntityServiceException entityServiceException) {
                            File[] databaseDirectorySelection;
                            String kinOath_Database_Directory = "KinOath Database Directory";
                            if (!windowManager.showConfirmDialogBox("The KinOath database could not be created. Do you want to choose another location?", "KinOath Database Directory")) {
                                System.exit(-1);
                            }
                            if ((databaseDirectorySelection = windowManager.showDirectorySelectBox("KinOath Database Directory", false)) == null || databaseDirectorySelection.length == 0) {
                                System.exit(-1);
                            }
                            sessionStorage.saveString("KinOathDatabaseDirectory", databaseDirectorySelection[0].toString());
                        }
                        catch (IOException exception2) {
                            logger.warn("Could not create the basexhome file: " + exception2.getMessage());
                        }
                    }
                    final KinDiagramPanel initialDiagram = abstractDiagramManager.newDiagram(new Rectangle(0, 0, 640, 480), null);
                    ((AbstractDiagramManager)abstractDiagramManager).createApplicationWindow();
                    windowManager.setMessagesCanBeShown(true);
                    new Thread(){

                        @Override
                        public void run() {
                            ApplicationVersion applicationVersion = versionManager.getApplicationVersion();
                            File oldAppExportFile = new MigrationWizard((PluginBugCatcher)BugCatcherManager.getBugCatcher(), (PluginDialogHandler)windowManager, (PluginSessionStorage)sessionStorage).checkAndOfferMigration(Integer.parseInt(applicationVersion.currentMajor), Integer.parseInt(applicationVersion.currentMinor));
                            if (oldAppExportFile != null) {
                                try {
                                    abstractDiagramManager.openImportPanel(oldAppExportFile, initialDiagram, projectManager.getEntityCollectionForProject(projectManager.getDefaultProject(sessionStorage)));
                                }
                                catch (ImportException exception) {
                                    windowManager.addMessageDialogToQueue(exception.getMessage() + "\n" + oldAppExportFile.getAbsolutePath(), "Import Existing Data");
                                }
                                catch (EntityServiceException exception) {
                                    windowManager.addMessageDialogToQueue(exception.getMessage() + "\n" + oldAppExportFile.getAbsolutePath(), "Import Existing Data");
                                }
                            }
                        }
                    }.start();
                }
                catch (EntityServiceException entityServiceException) {
                    System.out.println(entityServiceException.getMessage());
                    JOptionPane.showMessageDialog(null, "Failed to create a new diagram: " + entityServiceException.getMessage(), "Launch Diagram Error", -1);
                    System.exit(-1);
                }
                versionManager.checkForUpdate();
            }
        });
    }
}

