/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.TransferHandler;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilDataNodeLoader;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.data.ContainerNode;
import nl.mpi.arbil.ui.ArbilTable;
import nl.mpi.arbil.ui.ArbilTableController;
import nl.mpi.arbil.ui.ArbilTableModel;
import nl.mpi.arbil.ui.ArbilTree;
import nl.mpi.arbil.ui.ArbilTreeController;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.ui.ImageBoxRenderer;
import nl.mpi.arbil.ui.PreviewSplitPanel;
import nl.mpi.arbil.ui.TableController;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.arbil.util.TreeHelper;
import nl.mpi.arbil.util.WindowManager;
import nl.mpi.kinnate.entityindexer.EntityCollection;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kindata.ExternalLink;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.ui.HidePane;
import nl.mpi.kinnate.ui.KinDiagramPanel;
import nl.mpi.kinnate.ui.SvgElementEditor;
import nl.mpi.kinnate.ui.TableCellDragHandler;
import nl.mpi.kinnate.ui.menu.TableMenu;

public class MetadataPanel
extends JPanel {
    private ArbilTree arbilTree;
    private ArbilTableModel kinTableModel;
    private ArbilTableModel archiveTableModel;
    private JScrollPane kinTableScrollPane;
    private HidePane editorHidePane;
    private ArrayList<ArbilDataNode> metadataNodes = new ArrayList();
    private ArrayList<ArbilDataNode> archiveTreeNodes = new ArrayList();
    private ArrayList<ArbilDataNode> archiveRootNodes = new ArrayList();
    private ArrayList<SvgElementEditor> elementEditors = new ArrayList();
    private ArbilDataNodeLoader dataNodeLoader;
    private final KinDiagramPanel kinDiagramPanel;
    private ContainerNode rootNode;
    private EntityCollection entityCollection;
    private final MessageDialogHandler dialogHandler;
    final SessionStorage sessionStorage;

    public MetadataPanel(GraphPanel graphPanel, final EntityCollection entityCollection, final KinDiagramPanel kinDiagramPanel, HidePane editorHidePane, TableCellDragHandler tableCellDragHandler, ArbilDataNodeLoader dataNodeLoader, ImageBoxRenderer imageBoxRenderer, final SessionStorage sessionStorage, final MessageDialogHandler dialogHandler, ArbilTreeController treeController, TreeHelper treeHelper, ArbilTableController arbilTableController, ArbilWindowManager windowManager) {
        this.arbilTree = new ArbilTree(treeController, treeHelper, new PreviewSplitPanel((WindowManager)windowManager, (TableController)arbilTableController));
        this.kinDiagramPanel = kinDiagramPanel;
        this.entityCollection = entityCollection;
        this.dialogHandler = dialogHandler;
        this.sessionStorage = sessionStorage;
        this.rootNode = new ContainerNode(null, "links", null, new ArbilNode[0]);
        this.arbilTree.setModel((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode(this.rootNode)));
        this.kinTableModel = new ArbilTableModel(imageBoxRenderer);
        this.archiveTableModel = new ArbilTableModel(imageBoxRenderer);
        this.dataNodeLoader = dataNodeLoader;
        ArbilTableController tableController = new ArbilTableController(treeHelper, dialogHandler, (WindowManager)windowManager){

            public void checkPopup(MouseEvent evt, boolean checkSelection) {
                Object source = evt.getSource();
                if (source instanceof ArbilTable) {
                    ArbilTable targetTable = (ArbilTable)source;
                    if (evt.isPopupTrigger()) {
                        Point p = evt.getPoint();
                        int clickedRow = targetTable.rowAtPoint(p);
                        int clickedColumn = targetTable.columnAtPoint(p);
                        boolean clickedRowAlreadySelected = targetTable.isRowSelected(clickedRow);
                        if (!(!checkSelection || evt.isShiftDown() || evt.isControlDown() || evt.isPopupTrigger() && clickedRowAlreadySelected || !(clickedRow > -1 & clickedRow > -1))) {
                            targetTable.getSelectionModel().clearSelection();
                            targetTable.changeSelection(clickedRow, clickedColumn, false, evt.isShiftDown());
                        }
                    }
                    if (evt.isPopupTrigger()) {
                        TableCellEditor tableCellEditor = targetTable.getCellEditor();
                        if (tableCellEditor != null) {
                            tableCellEditor.stopCellEditing();
                        }
                        new TableMenu(sessionStorage, dialogHandler, entityCollection, kinDiagramPanel, targetTable.getSelectedRowsFromTable(), targetTable.getSelectedFields()).show((Component)targetTable, evt.getX(), evt.getY());
                    }
                }
            }
        };
        ArbilTable kinTable = new ArbilTable(this.kinTableModel, (TableController)tableController, "Selected Nodes");
        ArbilTable archiveTable = new ArbilTable(this.archiveTableModel, (TableController)arbilTableController, "Selected Nodes");
        this.arbilTree.setCustomPreviewTable(archiveTable);
        kinTable.setTransferHandler((TransferHandler)tableCellDragHandler);
        kinTable.setDragEnabled(true);
        this.editorHidePane = editorHidePane;
        this.setLayout(new BorderLayout());
        this.kinTableScrollPane = new JScrollPane((Component)kinTable);
        JScrollPane archiveTableScrollPane = new JScrollPane((Component)archiveTable);
        this.add((Component)archiveTableScrollPane, "Center");
        this.add((Component)this.arbilTree, "Before");
    }

    public void removeAllEditors() {
        while (!this.elementEditors.isEmpty()) {
            this.editorHidePane.removeTab(this.elementEditors.remove(0));
        }
    }

    public void removeAllArbilDataNodeRows() {
        this.kinTableModel.removeAllArbilDataNodeRows();
        this.archiveTableModel.removeAllArbilDataNodeRows();
        for (ArbilDataNode arbilDataNode : this.metadataNodes) {
            if (!arbilDataNode.getParentDomNode().getNeedsSaveToDisk(false)) continue;
            this.dataNodeLoader.requestReload(arbilDataNode.getParentDomNode());
        }
        this.metadataNodes.clear();
    }

    public void addArbilDataNode(ArbilDataNode arbilDataNode) {
        this.archiveTableModel.addSingleArbilDataNode(arbilDataNode);
        this.archiveRootNodes.clear();
        this.metadataNodes.add(arbilDataNode);
    }

    public void addEntityDataNode(EntityData entityData) {
        File entityFile = entityData.getUniqueIdentifier().getFileInProject(this.entityCollection.getProjectRecord());
        System.out.println("entity path: " + entityFile);
        if (entityFile != null && entityFile.exists()) {
            ArbilDataNode arbilDataNode = this.dataNodeLoader.getArbilDataNode(null, entityFile.toURI());
            this.kinDiagramPanel.registerArbilNode(entityData.getUniqueIdentifier(), arbilDataNode);
            this.kinTableModel.addSingleArbilDataNode(arbilDataNode);
            this.metadataNodes.add(arbilDataNode);
            if (entityData.externalLinks != null) {
                for (ExternalLink archiveLink : entityData.externalLinks) {
                    ArbilDataNode archiveLinkNode = this.dataNodeLoader.getArbilDataNode(null, archiveLink.getLinkUri());
                    this.archiveTableModel.addSingleArbilDataNode(archiveLinkNode);
                    this.archiveTreeNodes.add(archiveLinkNode);
                    this.archiveRootNodes.add(archiveLinkNode.getParentDomNode());
                    this.metadataNodes.add(archiveLinkNode);
                }
            }
        } else {
            this.dialogHandler.addMessageDialogToQueue("One or more items could not be displayed in the table.", "Table View");
        }
    }

    public void addTab(String labelString, SvgElementEditor elementEditor) {
        this.editorHidePane.addTab(labelString, elementEditor);
        this.elementEditors.add(elementEditor);
    }

    public void removeTab(Component elementEditor) {
        this.editorHidePane.removeTab(elementEditor);
    }

    public void updateEditorPane() {
        if (this.archiveTableModel.getArbilDataNodeCount() > 0) {
            this.editorHidePane.addTab("External Links", this);
        } else {
            this.removeTab(this);
        }
        if (this.kinTableModel.getArbilDataNodeCount() > 0) {
            this.editorHidePane.addTab("Kinship Data", this.kinTableScrollPane);
            this.editorHidePane.setSelectedComponent(this.kinTableScrollPane);
        } else {
            this.removeTab(this.kinTableScrollPane);
        }
        if (!this.archiveRootNodes.isEmpty()) {
            this.rootNode.setChildNodes(this.archiveRootNodes.toArray(new ArbilNode[0]));
            this.arbilTree.requestResort();
        }
        this.arbilTree.setVisible(!this.archiveRootNodes.isEmpty());
        this.editorHidePane.setHiddeState();
    }
}

