/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui.window;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import nl.mpi.arbil.data.ArbilDataNodeLoader;
import nl.mpi.arbil.data.ArbilTreeHelper;
import nl.mpi.arbil.ui.ArbilTableController;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.ApplicationVersionManager;
import nl.mpi.arbil.util.ArbilLogConfigurer;
import nl.mpi.kinnate.projects.ProjectManager;
import nl.mpi.kinnate.ui.window.AbstractDiagramManager;

public class LayeredDiagramManager
extends AbstractDiagramManager {
    private JPanel mainPanel;
    private HashMap<Component, String> titleMap = new HashMap();
    private ArrayList<Component> diagramArray = new ArrayList();
    private JFrame mainFrame;

    public LayeredDiagramManager(ApplicationVersionManager versionManager, ArbilWindowManager dialogHandler, SessionStorage sessionStorage, ArbilDataNodeLoader dataNodeLoader, ArbilTreeHelper treeHelper, ProjectManager projectManager, ArbilLogConfigurer arbilLogConfigurer, ArbilTableController arbilTableController, ArbilWindowManager windowManager) {
        super(versionManager, dialogHandler, sessionStorage, dataNodeLoader, treeHelper, projectManager, arbilLogConfigurer, arbilTableController, windowManager);
        this.mainPanel = new JPanel(new BorderLayout());
    }

    @Override
    public void createApplicationWindow() {
        this.mainFrame = this.createDiagramWindow(this.getSavePanelTitle(this.getSavePanelIndex(null)), this.mainPanel, null);
    }

    @Override
    public Component createDiagramContainer(Component diagramComponent, Rectangle preferredSizeLocation) {
        String diagramTitle = diagramComponent.getName();
        this.titleMap.put(diagramComponent, diagramTitle);
        this.diagramArray.add(diagramComponent);
        this.setSelectedDiagram(diagramComponent);
        return diagramComponent;
    }

    @Override
    public void createDiagramSubPanel(String diagramTitle, Component diagramComponent, Component parentPanel) {
        JTabbedPane tabbedPane;
        int currentDiagramIndex = this.getSavePanelIndex(null);
        Component currentComponent = this.getDiagramAt(currentDiagramIndex);
        if (!(currentComponent instanceof JTabbedPane)) {
            tabbedPane = new JTabbedPane();
            String savePanelTitle = this.getSavePanelTitle(currentDiagramIndex);
            tabbedPane.addTab(savePanelTitle, currentComponent);
            this.titleMap.remove(currentComponent);
            this.titleMap.put(tabbedPane, savePanelTitle);
            this.diagramArray.set(currentDiagramIndex, tabbedPane);
            this.setSelectedDiagram(currentDiagramIndex);
        } else {
            tabbedPane = (JTabbedPane)currentComponent;
        }
        tabbedPane.addTab(diagramTitle, diagramComponent);
    }

    @Override
    Component getSelectedDiagram() {
        if (this.mainPanel.getComponents().length > 0) {
            return this.mainPanel.getComponent(0);
        }
        return null;
    }

    @Override
    public void setSelectedDiagram(Component diagramComponent) {
        this.mainPanel.removeAll();
        String diagramTitle = null;
        if (diagramComponent != null) {
            this.mainPanel.add(diagramComponent, "Center");
            diagramTitle = this.titleMap.get(diagramComponent);
        }
        if (this.mainFrame != null) {
            this.setWindowTitle(this.mainFrame, diagramTitle);
        }
        this.mainPanel.revalidate();
        this.mainPanel.repaint();
    }

    @Override
    public void setSelectedDiagram(int diagramIndex) {
        if (this.diagramArray.size() > diagramIndex) {
            this.setSelectedDiagram(this.diagramArray.get(diagramIndex));
        } else {
            this.setSelectedDiagram(null);
        }
    }

    @Override
    public int getSavePanelIndex(Component eventTarget) {
        return this.diagramArray.indexOf(this.getSelectedDiagram());
    }

    @Override
    public String getSavePanelTitle(int selectedIndex) {
        return this.titleMap.get(this.diagramArray.get(selectedIndex));
    }

    @Override
    Component getDiagramAt(int diagramIndex) {
        return this.diagramArray.get(diagramIndex);
    }

    @Override
    public void closeSavePanel(int selectedIndex) {
        this.titleMap.remove(this.diagramArray.get(selectedIndex));
        this.diagramArray.remove(selectedIndex);
        while (this.diagramArray.size() <= selectedIndex && selectedIndex > 0) {
            --selectedIndex;
        }
        this.setSelectedDiagram(selectedIndex);
    }

    @Override
    public void setDiagramTitle(int diagramIndex, String diagramTitle) {
        this.titleMap.put(this.getSelectedDiagram(), diagramTitle);
        if (this.mainFrame != null) {
            this.setWindowTitle(this.mainFrame, diagramTitle);
        }
    }

    @Override
    public Component[] getAllDiagrams() {
        return this.diagramArray.toArray(new Component[0]);
    }
}

