/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.util.gui;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class XNumericalJTextFieldFilter
extends PlainDocument {
    public static final int POS_INTEGER = 0;
    public static final int POS_INTEGER_WITH_INFINITY = 1;
    public static final int INTEGER_WITH_INFINITY = 2;
    public static final int FLOAT_WITH_INFINITY = 3;
    public static final int INTEGER_WITH_POS_INFINITY = 4;
    public static final int INTEGER_WITH_NEG_INFINITY = 5;
    protected static final String POS_INTEGER_CHARS = "+0123456789";
    protected static final String POS_INTEGER_CHARS_WITH_INFINITY = "+0123456789X";
    protected static final String INTEGER_CHARS = "-+0123456789X";
    protected static final String FLOAT_CHARS = "-+0123456789X.";
    protected String acceptedChars = null;
    private final int mode;

    public XNumericalJTextFieldFilter() {
        this.mode = 0;
        this.acceptedChars = POS_INTEGER_CHARS_WITH_INFINITY;
    }

    public XNumericalJTextFieldFilter(int mode) {
        this.mode = mode;
        switch (mode) {
            case 1: {
                this.acceptedChars = INTEGER_CHARS;
                break;
            }
            case 3: {
                this.acceptedChars = FLOAT_CHARS;
                break;
            }
            case 4: {
                this.acceptedChars = INTEGER_CHARS;
                break;
            }
            case 5: {
                this.acceptedChars = INTEGER_CHARS;
                break;
            }
            default: {
                this.acceptedChars = POS_INTEGER_CHARS;
            }
        }
    }

    @Override
    public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
        if (str == null) {
            return;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (this.acceptedChars.indexOf(str.charAt(i)) != -1) continue;
            return;
        }
        if (this.acceptedChars.equals(FLOAT_CHARS) && str.indexOf(".") != -1 && this.getText(0, this.getLength()).indexOf(".") != -1) {
            return;
        }
        if (str.indexOf("-") != -1 && (str.indexOf("-") != 0 || offset != 0)) {
            return;
        }
        if (str.indexOf("+") != -1 && (str.indexOf("+") != 0 || offset != 0)) {
            return;
        }
        if (!(this.getText(0, this.getLength()).indexOf(88) == -1 || str.equals("+") && this.mode != 5 || !str.equals("-") && this.mode != 4)) {
            return;
        }
        if (str.indexOf("X") != -1) {
            if (this.getLength() > 1) {
                return;
            }
            if (this.getLength() == 0 ? (!str.equals("+X") && !str.equals("X") || this.mode == 5) && (!str.equals("-X") || this.mode == 4) : !(this.getText(0, 1).equals("+") && this.mode != 5 || this.getText(0, 1).equals("-") && this.mode != 4 || !str.equals("X"))) {
                return;
            }
        }
        super.insertString(offset, str, attr);
    }
}

