/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.userstorage;

import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import nl.mpi.flap.plugin.PluginDialogHandler;
import nl.mpi.flap.plugin.PluginSessionStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonsSessionStorage
implements PluginSessionStorage {
    private static final Logger logger = LoggerFactory.getLogger(CommonsSessionStorage.class);
    protected File localCacheDirectory = null;
    private File storageDirectory = null;
    protected PluginDialogHandler messageDialogHandler;

    protected abstract String[] getAppDirectoryAlternatives();

    protected abstract String getProjectDirectoryName();

    protected abstract void logError(Exception var1);

    protected abstract void logError(String var1, Exception var2);

    public abstract Object loadObject(String var1) throws Exception;

    private void checkForMultipleStorageDirectories(String[] locationOptions) {
        int foundDirectoryCount = 0;
        StringBuilder storageDirectoryMessageString = new StringBuilder();
        for (String currentStorageDirectory : locationOptions) {
            File storageFile = new File(currentStorageDirectory);
            if (!storageFile.exists()) continue;
            ++foundDirectoryCount;
            storageDirectoryMessageString.append(currentStorageDirectory).append("\n");
        }
        if (foundDirectoryCount > 1) {
            String errorMessage = "More than one storage directory has been found.\nIt is recommended to remove any unused directories in this list.\nNote that the first occurrence is currently in use:\n" + storageDirectoryMessageString;
            this.logError(new Exception(errorMessage));
            try {
                if (!GraphicsEnvironment.isHeadless()) {
                    JOptionPane.showMessageDialog(null, "More than one storage directory has been found.\nIt is recommended to remove any unused directories in this list.\nNote that the first occurrence is currently in use:\n" + storageDirectoryMessageString, "Multiple storage directories", 2);
                }
            }
            catch (HeadlessException hEx) {
                throw new AssertionError((Object)hEx);
            }
        }
    }

    protected String[] getLocationOptions() {
        ArrayList<String> locationOptions = new ArrayList<String>();
        for (String appDir : this.getAppDirectoryAlternatives()) {
            locationOptions.add(System.getProperty("user.home") + File.separatorChar + "Local Settings" + File.separatorChar + "Application Data" + File.separatorChar + appDir + File.separatorChar);
            locationOptions.add(System.getenv("APPDATA") + File.separatorChar + appDir + File.separatorChar);
            locationOptions.add(System.getProperty("user.home") + File.separatorChar + appDir + File.separatorChar);
            locationOptions.add(System.getenv("USERPROFILE") + File.separatorChar + appDir + File.separatorChar);
            locationOptions.add(System.getProperty("user.dir") + File.separatorChar + appDir + File.separatorChar);
        }
        ArrayList<String> uniqueArray = new ArrayList<String>();
        for (String location : locationOptions) {
            if (location == null || location.startsWith("null") || uniqueArray.contains(location)) continue;
            uniqueArray.add(location);
        }
        locationOptions = uniqueArray;
        for (String currentLocationOption : locationOptions) {
            logger.debug("LocationOption: " + currentLocationOption);
        }
        return locationOptions.toArray(new String[0]);
    }

    private File determineStorageDirectory() throws RuntimeException {
        String[] storageDirectoryArray;
        File storageDirectoryFile = null;
        for (String currentStorageDirectory : storageDirectoryArray = this.getLocationOptions()) {
            File storageFile = new File(currentStorageDirectory);
            if (!storageFile.exists()) continue;
            logger.debug("existing storage directory found: " + currentStorageDirectory);
            storageDirectoryFile = storageFile;
            break;
        }
        String testedStorageDirectories = "";
        if (storageDirectoryFile == null) {
            for (String currentStorageDirectory : storageDirectoryArray) {
                File storageFile;
                if (currentStorageDirectory.startsWith("null") || (storageFile = new File(currentStorageDirectory)).exists()) continue;
                if (!storageFile.mkdir()) {
                    testedStorageDirectories = testedStorageDirectories + currentStorageDirectory + "\n";
                    this.logError("failed to create: " + currentStorageDirectory, null);
                    continue;
                }
                logger.debug("created new storage directory: " + currentStorageDirectory);
                storageDirectoryFile = storageFile;
                break;
            }
        }
        if (storageDirectoryFile == null) {
            this.logError("Could not create a working directory in any of the potential location:\n" + testedStorageDirectories + "Please check that you have write permissions in at least one of these locations.\nThe application will now exit.", null);
            System.exit(-1);
        } else {
            try {
                File testFile = File.createTempFile("testfile", ".tmp", storageDirectoryFile);
                boolean success = testFile.exists();
                if (!success) {
                    success = testFile.createNewFile();
                }
                if (success) {
                    testFile.deleteOnExit();
                    success = testFile.exists();
                    if (success) {
                        success = testFile.delete();
                    }
                }
                if (!success) {
                    this.logError("Could not write to the working directory.\nThere will be issues creating, editing and saving any file.", null);
                }
            }
            catch (IOException exception) {
                logger.debug("Sending exception to logger", (Throwable)exception);
                this.logError(exception);
                this.messageDialogHandler.addMessageDialogToQueue("Could not create a test file in the working directory.", "Arbil Critical Error");
                throw new RuntimeException("Exception while testing working directory writability", exception);
            }
        }
        logger.debug("storageDirectory: " + storageDirectoryFile);
        this.checkForMultipleStorageDirectories(storageDirectoryArray);
        return storageDirectoryFile;
    }

    public synchronized File getApplicationSettingsDirectory() {
        if (this.storageDirectory == null) {
            this.storageDirectory = this.determineStorageDirectory();
        }
        return this.storageDirectory;
    }

    public File getProjectDirectory() {
        return this.getProjectWorkingDirectory().getParentFile();
    }

    public File getProjectWorkingDirectory() {
        if (this.localCacheDirectory == null) {
            String localCacheDirectoryPathString = this.loadString("cacheDirectory");
            if (localCacheDirectoryPathString != null) {
                this.localCacheDirectory = new File(localCacheDirectoryPathString);
            } else {
                try {
                    File localWorkingDirectory;
                    this.localCacheDirectory = localWorkingDirectory = (File)this.loadObject("cacheDirectory");
                }
                catch (Exception exception) {
                    this.localCacheDirectory = new File(this.getApplicationSettingsDirectory(), "imdicache").exists() ? new File(this.getApplicationSettingsDirectory(), "imdicache") : new File(this.getApplicationSettingsDirectory(), this.getProjectDirectoryName());
                }
                this.saveString("cacheDirectory", this.localCacheDirectory.getAbsolutePath());
            }
            boolean cacheDirExists = this.localCacheDirectory.exists();
            if (!cacheDirExists && !this.localCacheDirectory.mkdirs()) {
                this.logError("Could not create cache directory", null);
                return null;
            }
        }
        return this.localCacheDirectory;
    }
}

