/*
 * Decompiled with CFR 0.152.
 */
package org.basex;

import java.awt.Font;
import java.awt.Toolkit;
import java.util.Enumeration;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.core.cmd.Check;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIMacOSX;
import org.basex.gui.GUIOptions;
import org.basex.gui.dialog.DialogProgress;
import org.basex.gui.layout.BaseXDialog;
import org.basex.io.IOFile;
import org.basex.util.Args;
import org.basex.util.Prop;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class BaseXGUI {
    private final Context context = new Context();
    private final StringList files = new StringList();
    GUIMacOSX osxGUI;

    public static void main(String ... args) {
        try {
            new BaseXGUI(args);
        }
        catch (BaseXException ex) {
            Util.errln(ex, new Object[0]);
            System.exit(1);
        }
    }

    public BaseXGUI(String ... args) throws BaseXException {
        this.parseArguments(args);
        if (Prop.MAC) {
            try {
                this.osxGUI = new GUIMacOSX();
            }
            catch (Exception ex) {
                throw new BaseXException("Failed to initialize native Mac OS X interface", new Object[]{ex});
            }
        }
        final GUIOptions gopts = new GUIOptions();
        this.context.options.set(MainOptions.CACHEQUERY, true);
        this.context.options.set(MainOptions.MAXHITS, gopts.get(GUIOptions.MAXHITS));
        GUIConstants.init(gopts);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BaseXGUI.init(gopts);
                GUI gui = new GUI(BaseXGUI.this.context, gopts);
                if (BaseXGUI.this.osxGUI != null) {
                    BaseXGUI.this.osxGUI.init(gui);
                }
                for (String file : BaseXGUI.this.files) {
                    if (file.matches("^.*\\.basex[^.]*$")) continue;
                    IOFile io = new IOFile(file);
                    boolean xml = file.endsWith(".xml");
                    if (xml && BaseXDialog.confirm(gui, Util.info(Text.CREATE_DB_FILE, io))) {
                        gopts.set(GUIOptions.INPUTPATH, io.path());
                        gopts.set(GUIOptions.DBNAME, io.dbname());
                        DialogProgress.execute(gui, new Check(file));
                        continue;
                    }
                    gui.editor.open(io);
                }
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public synchronized void run() {
                BaseXGUI.this.context.close();
            }
        });
    }

    private static void init(GUIOptions opts) {
        block6: {
            UIManager.LookAndFeelInfo[] lafis = UIManager.getInstalledLookAndFeels();
            String laf = opts.get(GUIOptions.LOOKANDFEEL);
            try {
                Toolkit.getDefaultToolkit().setDynamicLayout(true);
                if (laf.equals("Metal")) {
                    UIDefaults def = UIManager.getDefaults();
                    Enumeration en = def.keys();
                    while (en.hasMoreElements()) {
                        Object k = en.nextElement();
                        Object v = def.get(k);
                        if (!(v instanceof Font)) continue;
                        def.put(k, ((Font)v).deriveFont(0));
                    }
                    break block6;
                }
                if (laf.isEmpty()) {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    break block6;
                }
                for (UIManager.LookAndFeelInfo lafi : lafis) {
                    if (!lafi.getName().equals(laf)) continue;
                    UIManager.setLookAndFeel(lafi.getClassName());
                    break;
                }
            }
            catch (Exception ex) {
                Util.stack(ex);
            }
        }
    }

    private void parseArguments(String[] args) throws BaseXException {
        Args arg = new Args(args, this, Text.S_GUIINFO, Util.info(Text.S_CONSOLE, "GUI"));
        while (arg.more()) {
            if (arg.dash()) {
                throw arg.usage();
            }
            this.files.add(arg.string());
        }
    }
}

