/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.Text;
import org.basex.core.cmd.Exit;
import org.basex.core.cmd.XQuery;
import org.basex.core.parse.CommandParser;
import org.basex.core.parse.PasswordReader;
import org.basex.query.QueryException;
import org.basex.server.Session;
import org.basex.util.ConsoleReader;
import org.basex.util.Token;
import org.basex.util.Util;

public abstract class Main {
    public final Context context;
    protected OutputStream out = System.out;
    protected boolean console;
    protected Session session;
    protected boolean verbose;
    protected boolean newline;
    private final PasswordReader pwReader = new PasswordReader(){

        @Override
        public String password() {
            Util.out(Text.PASSWORD + ": ", new Object[0]);
            return Token.md5(Util.password());
        }
    };

    protected Main(String[] args) throws IOException {
        this(args, null);
    }

    protected Main(String[] args, Context ctx) throws IOException {
        this.context = ctx != null ? ctx : new Context();
        this.parseArguments(args);
        this.verbose |= this.console;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public synchronized void run() {
                Main.this.context.close();
            }
        });
    }

    protected final void console() {
        String in;
        ConsoleReader cr = ConsoleReader.get();
        while (this.console && (in = cr.readLine()) != null) {
            if (in.isEmpty()) continue;
            try {
                if (this.execute(new CommandParser(in, this.context).pwReader(cr.pwReader()))) continue;
                Util.outln(Text.BYE[new Random().nextInt(4)], new Object[0]);
                return;
            }
            catch (IOException ex) {
                Util.errln(ex, new Object[0]);
            }
        }
    }

    protected void quit() throws IOException {
        if (this.out == System.out || this.out == System.err) {
            this.out.flush();
        } else {
            this.out.close();
        }
    }

    protected final void execute(String in) throws IOException {
        this.execute(new CommandParser(in, this.context).pwReader(this.pwReader));
    }

    private boolean execute(CommandParser parser) throws IOException {
        try {
            for (Command cmd : parser.parse()) {
                if (cmd instanceof Exit) {
                    return false;
                }
                this.execute(cmd, this.verbose);
            }
        }
        catch (QueryException ex) {
            throw new BaseXException(ex);
        }
        return true;
    }

    protected final void execute(Command cmd, boolean info) throws IOException {
        Session ss = this.session();
        ss.execute(cmd);
        if (this.newline && cmd instanceof XQuery) {
            this.out.write(Token.token(Text.NL));
        }
        if (info) {
            Util.out(ss.info(), new Object[0]);
        }
    }

    protected abstract Session session() throws IOException;

    protected abstract void parseArguments(String ... var1) throws IOException;
}

