/*
 * Decompiled with CFR 0.152.
 */
package org.basex.data.atomic;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.basex.data.Data;
import org.basex.data.atomic.BasicUpdate;
import org.basex.data.atomic.DataClip;
import org.basex.data.atomic.Delete;
import org.basex.data.atomic.Insert;
import org.basex.data.atomic.InsertAttr;
import org.basex.data.atomic.Rename;
import org.basex.data.atomic.Replace;
import org.basex.data.atomic.StructuralUpdate;
import org.basex.data.atomic.UpdateValue;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.IntSet;

public final class AtomicUpdateCache {
    private final List<StructuralUpdate> struct = new ArrayList<StructuralUpdate>();
    private final List<BasicUpdate> val = new ArrayList<BasicUpdate>();
    private BasicUpdate recent;
    private BasicUpdate recentStruct;
    public final Data data;

    public AtomicUpdateCache(Data d) {
        this.data = d;
    }

    public void addDelete(int pre) {
        this.considerAtomic(Delete.getInstance(this.data, pre), false);
    }

    public void addInsert(int pre, int par, DataClip clip, boolean attr) {
        this.considerAtomic(attr ? InsertAttr.getInstance(pre, par, clip) : Insert.getInstance(pre, par, clip), false);
    }

    public void addReplace(int pre, DataClip clip) {
        this.considerAtomic(Replace.getInstance(this.data, pre, clip), false);
    }

    public void addRename(int pre, byte[] n, byte[] u) {
        this.considerAtomic(Rename.getInstance(this.data, pre, n, u), false);
    }

    public void addUpdateValue(int pre, byte[] v) {
        this.considerAtomic(UpdateValue.getInstance(this.data, pre, v), false);
    }

    public void clear() {
        this.struct.clear();
        this.val.clear();
        this.recent = null;
        this.recentStruct = null;
    }

    private void considerAtomic(BasicUpdate candidate, boolean slack) {
        if (this.recent == null) {
            this.recent = candidate;
            if (this.recent instanceof StructuralUpdate) {
                this.recentStruct = candidate;
            }
            return;
        }
        if (candidate instanceof StructuralUpdate) {
            ((StructuralUpdate)candidate).accumulatedShifts = ((StructuralUpdate)candidate).accumulatedShifts + (this.recentStruct == null ? 0 : this.recentStruct.accumulatedShifts());
        }
        if (slack) {
            this.add(candidate, false);
        } else {
            AtomicUpdateCache.check(this.recent, candidate);
            if (this.treeAwareUpdates(this.recent, candidate)) {
                return;
            }
            BasicUpdate m = this.recent.merge(this.data, candidate);
            if (m != null) {
                this.add(m, true);
            } else {
                this.add(candidate, false);
            }
        }
    }

    private void add(BasicUpdate u, boolean merged) {
        if (u == null) {
            return;
        }
        if (!merged) {
            if (this.recent instanceof StructuralUpdate) {
                this.struct.add((StructuralUpdate)this.recent);
            } else {
                this.val.add(this.recent);
            }
        }
        this.recent = u;
        if (u instanceof StructuralUpdate) {
            this.recentStruct = u;
        }
    }

    private void flush() {
        if (this.recent != null) {
            this.add(this.recent, false);
            this.recent = null;
            this.recentStruct = null;
        }
    }

    public int updatesSize() {
        this.flush();
        return this.struct.size() + this.val.size();
    }

    static void check(BasicUpdate a, BasicUpdate b) {
        if (b.location < a.location) {
            throw Util.notExpected("Invalid order at location " + a.location);
        }
        if (b.location == a.location) {
            if (b instanceof Insert || b instanceof InsertAttr) {
                if (a instanceof Delete) {
                    throw Util.notExpected("Invalid sequence of delete, insert at location " + a.location);
                }
                if (a instanceof Replace) {
                    throw Util.notExpected("Invalid sequence of replace, insert at location " + a.location);
                }
            }
            if (b.destructive() && a.destructive()) {
                throw Util.notExpected("Multiple deletes/replaces on node " + a.location);
            }
            if (b instanceof Rename && a instanceof Rename) {
                throw Util.notExpected("Multiple renames on node " + a.location);
            }
            if (b instanceof UpdateValue && a instanceof UpdateValue) {
                throw Util.notExpected("Multiple updates on node " + a.location);
            }
            if (b.destructive() && !(a instanceof StructuralUpdate)) {
                throw Util.notExpected("Invalid sequence of value update and destructive update at location " + a.location);
            }
        }
    }

    private boolean treeAwareUpdates(BasicUpdate a, BasicUpdate b) {
        int pre;
        int fol;
        return a.destructive() && (b.location <= (fol = (pre = a.location) + this.data.size(pre, this.data.kind(pre))) && (b instanceof Insert || b instanceof InsertAttr) && b.parent >= pre && b.parent < fol || b.location < fol);
    }

    public void execute(boolean mergeTexts) {
        this.data.cache = true;
        this.applyUpdates();
        this.adjustDistances();
        if (mergeTexts) {
            this.resolveTextAdjacency();
        }
        this.data.cache = false;
        this.clear();
    }

    public void applyUpdates() {
        this.flush();
        for (BasicUpdate u : this.val) {
            u.apply(this.data);
        }
        for (int i = this.struct.size() - 1; i >= 0; --i) {
            this.struct.get(i).apply(this.data);
        }
    }

    private void adjustDistances() {
        IntSet alreadyUpdatedNodes = new IntSet();
        for (StructuralUpdate update : this.struct) {
            for (int newPreOfAffectedNode = update.preOfAffectedNode + update.accumulatedShifts; newPreOfAffectedNode < this.data.meta.size && !alreadyUpdatedNodes.contains(newPreOfAffectedNode); newPreOfAffectedNode += this.data.size(newPreOfAffectedNode, this.data.kind(newPreOfAffectedNode))) {
                this.data.dist(newPreOfAffectedNode, this.data.kind(newPreOfAffectedNode), this.calculateNewDistance(newPreOfAffectedNode));
                alreadyUpdatedNodes.add(newPreOfAffectedNode);
            }
        }
    }

    private int calculateNewDistance(int pre) {
        int kind = this.data.kind(pre);
        int distanceBefore = this.data.dist(pre, kind);
        int preBefore = this.calculatePreValue(pre, true);
        int parentBefore = preBefore - distanceBefore;
        int parentAfter = this.calculatePreValue(parentBefore, false);
        return pre - parentAfter;
    }

    public int calculatePreValue(int pre, boolean beforeUpdates) {
        int i = this.find(pre, beforeUpdates);
        if (i == -1) {
            return pre;
        }
        i = AtomicUpdateCache.refine(this.struct, i, beforeUpdates);
        int acm = this.struct.get((int)i).accumulatedShifts;
        return beforeUpdates ? pre - acm : pre + acm;
    }

    private int find(int pre, boolean beforeUpdates) {
        int left = 0;
        int right = this.struct.size() - 1;
        while (left <= right) {
            if (left == right) {
                if (AtomicUpdateCache.c(this.struct, left, beforeUpdates) <= pre) {
                    return left;
                }
                return -1;
            }
            if (right - left == 1) {
                if (AtomicUpdateCache.c(this.struct, right, beforeUpdates) <= pre) {
                    return right;
                }
                if (AtomicUpdateCache.c(this.struct, left, beforeUpdates) <= pre) {
                    return left;
                }
                return -1;
            }
            int middle = left + right >>> 1;
            int value = AtomicUpdateCache.c(this.struct, middle, beforeUpdates);
            if (value == pre) {
                return middle;
            }
            if (value > pre) {
                right = middle - 1;
                continue;
            }
            left = middle;
        }
        return -1;
    }

    private static int refine(List<StructuralUpdate> l, int index, boolean beforeUpdates) {
        int i = index;
        int value = AtomicUpdateCache.c(l, i++, beforeUpdates);
        while (i < l.size() && AtomicUpdateCache.c(l, i, beforeUpdates) == value) {
            ++i;
        }
        return i - 1;
    }

    private static int c(List<StructuralUpdate> l, int index, boolean beforeUpdates) {
        StructuralUpdate u = l.get(index);
        return u.preOfAffectedNode + (beforeUpdates ? u.accumulatedShifts : 0);
    }

    private void resolveTextAdjacency() {
        LinkedList<Delete> deletes = new LinkedList<Delete>();
        int smallestVisited = Integer.MAX_VALUE;
        for (int i = this.struct.size() - 1; i >= 0; --i) {
            int followingNode;
            int beforeFollowingNode;
            StructuralUpdate u = this.struct.get(i);
            DataClip insseq = u.getInsertionData();
            int newLocation = u.location + u.accumulatedShifts - u.shifts;
            int beforeNewLocation = newLocation - 1;
            if (insseq != null && (beforeFollowingNode = (followingNode = newLocation + insseq.size()) - 1) < smallestVisited) {
                Delete del = this.mergeTextNodes(beforeFollowingNode);
                if (del != null) {
                    deletes.add(0, del);
                }
                smallestVisited = beforeFollowingNode;
            }
            if (beforeNewLocation >= smallestVisited) continue;
            Delete del = this.mergeTextNodes(beforeNewLocation);
            if (del != null) {
                deletes.add(0, del);
            }
            smallestVisited = beforeNewLocation;
        }
        AtomicUpdateCache atomicDeletes = new AtomicUpdateCache(this.data);
        for (Delete delete : deletes) {
            atomicDeletes.considerAtomic(delete, true);
        }
        deletes.clear();
        atomicDeletes.applyUpdates();
        atomicDeletes.adjustDistances();
        atomicDeletes.clear();
    }

    private Delete mergeTextNodes(int a) {
        int s = this.data.meta.size;
        int b = a + 1;
        if (a >= s || b >= s || a < 0 || b < 0) {
            return null;
        }
        if (this.data.kind(a) != 2 || this.data.kind(b) != 2) {
            return null;
        }
        if (this.data.parent(a, 2) != this.data.parent(b, 2)) {
            return null;
        }
        UpdateValue.getInstance(this.data, a, Token.concat(this.data.text(a, true), this.data.text(b, true))).apply(this.data);
        return Delete.getInstance(this.data, b);
    }
}

