/*
 * Decompiled with CFR 0.152.
 */
package org.basex.data.atomic;

import java.util.ArrayList;
import org.basex.data.Data;
import org.basex.data.atomic.BasicUpdate;
import org.basex.data.atomic.DataClip;
import org.basex.data.atomic.Rename;
import org.basex.data.atomic.StructuralUpdate;
import org.basex.data.atomic.UpdateValue;
import org.basex.util.Token;

final class Replace
extends StructuralUpdate {
    private final DataClip insseq;

    Replace(int l, int s, int a, int f, DataClip c, int p) {
        super(l, s, a, f, p);
        this.insseq = c;
    }

    static Replace getInstance(Data data, int pre, DataClip clip) {
        int oldsize = data.size(pre, data.kind(pre));
        int newsize = clip.size();
        int sh = newsize - oldsize;
        return new Replace(pre, sh, sh, pre + oldsize, clip, data.parent(pre, data.kind(pre)));
    }

    @Override
    void apply(Data targetData) {
        if (targetData.nspaces.size() == 0 && this.insseq.data.nspaces.size() == 0) {
            if (this.lazyReplace(targetData)) {
                return;
            }
            targetData.replace(this.location, this.insseq);
        } else {
            int targetKind = targetData.kind(this.location);
            int targetParent = targetData.parent(this.location, targetKind);
            targetData.delete(this.location);
            if (targetKind == 3) {
                targetData.insertAttr(this.location, targetParent, this.insseq);
            } else {
                targetData.insert(this.location, targetParent, this.insseq);
            }
        }
    }

    boolean lazyReplace(Data trg) {
        Data src = this.insseq.data;
        int srcSize = this.insseq.size();
        if (srcSize != trg.size(this.location, trg.kind(this.location))) {
            return false;
        }
        ArrayList<BasicUpdate> valueUpdates = new ArrayList<BasicUpdate>();
        block5: for (int c = 0; c < srcSize; ++c) {
            byte[] trgName;
            int tk;
            int s = this.insseq.start + c;
            int t = this.location + c;
            int sk = src.kind(s);
            if (sk != (tk = trg.kind(t))) {
                return false;
            }
            if (c > 0 && src.dist(s, sk) != trg.dist(t, tk)) {
                return false;
            }
            if (sk == 2 || sk == 4) {
                byte[] srcText = src.text(s, true);
                if (trg.textLen(t, true) == src.textLen(s, true) && Token.eq(trg.text(t, true), srcText)) continue;
                valueUpdates.add(UpdateValue.getInstance(trg, t, srcText));
                continue;
            }
            byte[] srcName = src.name(s, sk);
            if (!Token.eq(srcName, trgName = trg.name(t, tk))) {
                valueUpdates.add(Rename.getInstance(trg, t, srcName, Token.EMPTY));
            }
            switch (sk) {
                case 1: {
                    if (src.attSize(s, sk) == trg.attSize(t, tk) && src.size(s, sk) == trg.size(t, tk)) continue block5;
                    return false;
                }
                case 3: {
                    byte[] srcValue = src.text(s, false);
                    if (Token.eq(trg.text(t, false), srcValue)) continue block5;
                    valueUpdates.add(UpdateValue.getInstance(trg, t, srcValue));
                    continue block5;
                }
                case 5: {
                    byte[] srcText = src.text(s, true);
                    byte[] trgText = trg.text(t, true);
                    int i = Token.indexOf(srcText, 32);
                    byte[] srcValue = i == -1 ? Token.EMPTY : Token.substring(srcText, i + 1);
                    if (Token.eq(srcValue, Token.indexOf(trgText, 32) == -1 ? Token.EMPTY : Token.substring(trgText, i + 1))) continue block5;
                    valueUpdates.add(UpdateValue.getInstance(trg, t, srcValue));
                }
            }
        }
        for (BasicUpdate u : valueUpdates) {
            u.apply(trg);
        }
        return true;
    }

    @Override
    DataClip getInsertionData() {
        return this.insseq;
    }

    @Override
    boolean destructive() {
        return true;
    }

    @Override
    public String toString() {
        return "\nReplace: " + super.toString();
    }
}

