/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui;

import java.awt.ComponentOrientation;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.basex.gui.GUI;
import org.basex.gui.GUICommand;
import org.basex.gui.GUIConstants;
import org.basex.gui.layout.BaseXLayout;
import org.basex.util.Prop;

public final class GUIMenu
extends JMenuBar {
    private final JMenuItem[] items;
    private final GUI gui;

    GUIMenu(GUI main) {
        this.gui = main;
        if (Prop.langright) {
            this.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        }
        int c = 0;
        for (int b = 0; b < GUIConstants.MENUBAR.length; ++b) {
            for (int i = 0; i < GUIConstants.MENUITEMS[b].length; ++i) {
                ++c;
            }
        }
        this.items = new JMenuItem[c];
        c = 0;
        StringBuilder gmnem = new StringBuilder();
        for (int b = 0; b < GUIConstants.MENUBAR.length; ++b) {
            JMenu menu = new JMenu(GUIConstants.MENUBAR[b]);
            BaseXLayout.setMnemonic(menu, gmnem);
            StringBuilder mnemCache = new StringBuilder();
            for (int i = 0; i < GUIConstants.MENUITEMS[b].length; ++i) {
                GUICommand cmd = GUIConstants.MENUITEMS[b][i];
                if (cmd == GUICommand.SEPARATOR) {
                    menu.addSeparator();
                    continue;
                }
                if (cmd == null) continue;
                JMenuItem item = GUIMenu.newItem(cmd, this.gui, mnemCache);
                item.setAccelerator(BaseXLayout.keyStroke(cmd));
                this.items[c++] = item;
                if (Prop.langright) {
                    item.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
                }
                menu.add(item);
            }
            this.add(menu);
        }
    }

    public static JMenuItem newItem(final GUICommand cmd, final GUI gui, StringBuilder mnem) {
        String desc = cmd.label();
        JMenuItem item = cmd.toggle() ? new JCheckBoxMenuItem(desc) : new JMenuItem(desc);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                cmd.execute(gui);
            }
        });
        BaseXLayout.setMnemonic(item, mnem);
        return item;
    }

    void refresh() {
        int c = 0;
        for (int b = 0; b < GUIConstants.MENUBAR.length; ++b) {
            for (int i = 0; i < GUIConstants.MENUITEMS[b].length; ++i) {
                GUICommand item = GUIConstants.MENUITEMS[b][i];
                if (item == GUICommand.SEPARATOR || item == null) continue;
                this.items[c].setEnabled(item.enabled(this.gui));
                this.items[c++].setSelected(item.selected(this.gui));
            }
        }
    }
}

