/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXCheckBox;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXFileChooser;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.TableLayout;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.Language;
import org.basex.util.list.StringList;

final class DialogFT
extends BaseXBack {
    private static final int F_LANG = 0;
    private static final int F_STEM = 1;
    private static final int F_CASE = 2;
    private static final int F_DIA = 3;
    private static final int F_STOP = 4;
    private static final int FLAGS = 5;
    private final BaseXDialog dialog;
    private final BaseXCheckBox[] check = new BaseXCheckBox[5];
    private final BaseXCombo language;
    private final BaseXTextField swpath;
    private final BaseXButton swbrowse;

    DialogFT(BaseXDialog d, boolean create) {
        this.dialog = d;
        this.layout(new TableLayout(create ? 9 : 15, 1));
        MainOptions opts = d.gui.context.options;
        this.add(new BaseXLabel(Text.H_FULLTEXT_INDEX, true, false).border(0, 0, 6, 0));
        String sw = opts.get(MainOptions.STOPWORDS);
        String[] cb = new String[]{Text.LANGUAGE, Text.STEMMING, Text.CASE_SENSITIVE, Text.DIACRITICS, Text.STOPWORD_LIST};
        String[] desc = new String[]{Text.H_LANGUAGE, Text.H_STEMMING, Text.H_CASE, Text.H_DIACRITICS, Text.H_STOPWORDS};
        boolean[] val = new boolean[]{!opts.get(MainOptions.LANGUAGE).isEmpty(), opts.get(MainOptions.STEMMING), opts.get(MainOptions.CASESENS), opts.get(MainOptions.DIACRITICS), !sw.isEmpty()};
        BaseXLabel[] labels = new BaseXLabel[5];
        for (int f = 0; f < this.check.length; ++f) {
            this.check[f] = new BaseXCheckBox(cb[f], val[f], d);
            if (create) {
                this.check[f].setToolTipText(desc[f]);
                continue;
            }
            this.check[f].bold();
            labels[f] = new BaseXLabel(desc[f], true, false);
        }
        BaseXBack b1 = new BaseXBack(new TableLayout(1, 2, 8, 0));
        b1.add(this.check[0]);
        StringList langs = FTLexer.languages();
        this.language = new BaseXCombo((Window)d, langs.toArray());
        Language ln = Language.get(opts);
        for (String l : langs) {
            String s = l.replaceFirst(" \\(.*", "");
            if (!s.equals(ln.toString())) continue;
            this.language.setSelectedItem(l);
        }
        b1.add(this.language);
        this.add(b1);
        if (!create) {
            this.add(labels[0]);
        }
        for (int f = 1; f < 4; ++f) {
            this.add(this.check[f]);
            if (create) continue;
            this.add(labels[f]);
        }
        this.add(this.check[4]);
        this.add(Box.createVerticalStrut(4));
        BaseXBack b3 = new BaseXBack(new TableLayout(1, 2, 8, 0));
        this.swpath = new BaseXTextField(sw.isEmpty() ? d.gui.gopts.get(GUIOptions.DATAPATH) : sw, d);
        b3.add(this.swpath);
        this.swbrowse = new BaseXButton(Text.BROWSE_D, d);
        this.swbrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogFT.this.chooseStop();
            }
        });
        b3.add(this.swbrowse);
        this.add(b3);
        if (!create) {
            this.add(labels[4]);
        }
    }

    void chooseStop() {
        GUIOptions gopts = this.dialog.gui.gopts;
        BaseXFileChooser fc = new BaseXFileChooser(Text.FILE_OR_DIR, gopts.get(GUIOptions.DATAPATH), this.dialog.gui);
        IOFile file = fc.select(BaseXFileChooser.Mode.FOPEN);
        if (file != null) {
            this.swpath.setText(file.path());
            gopts.set(GUIOptions.DATAPATH, file.path());
        }
    }

    void action(boolean enabled) {
        boolean exists;
        for (BaseXCheckBox c : this.check) {
            c.setEnabled(enabled);
        }
        this.language.setEnabled(enabled && this.check[0].isSelected());
        this.swbrowse.setEnabled(enabled && this.check[4].isSelected());
        this.swpath.setEnabled(enabled && this.check[4].isSelected());
        String sw = this.swpath.getText().trim();
        IO file = IO.get(sw);
        boolean bl = exists = !sw.isEmpty() && file.exists();
        if (exists) {
            this.dialog.gui.gopts.set(GUIOptions.DATAPATH, sw);
        }
    }

    void setOptions() {
        GUI gui = this.dialog.gui;
        String lang = this.language.getSelectedItem();
        gui.set(MainOptions.LANGUAGE, this.check[0].isSelected() ? Language.get(lang.replaceFirst(" \\(.*", "")).code() : "");
        gui.set(MainOptions.STEMMING, this.check[1].isSelected());
        gui.set(MainOptions.CASESENS, this.check[2].isSelected());
        gui.set(MainOptions.DIACRITICS, this.check[3].isSelected());
        gui.set(MainOptions.STOPWORDS, this.check[4].isSelected() ? this.swpath.getText() : "");
    }
}

