/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.basex.core.GlobalOptions;
import org.basex.core.Lang;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.core.cmd.Close;
import org.basex.gui.GUI;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXCheckBox;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXFileChooser;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXSlider;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.TableLayout;
import org.basex.io.IOFile;

final class DialogGeneralPrefs
extends BaseXBack {
    private final GUI gui;
    private static final int[] HITS = new int[]{10, 25, 100, 250, 1000, 2500, 10000, 25000, 100000, 250000, 1000000, -1};
    private static final String[][] LANGS = Lang.parse();
    private final BaseXTextField path;
    private final BaseXSlider limit;
    private final BaseXLabel label;
    private final BaseXLabel creds;
    private final BaseXCombo lang;
    private final BaseXCheckBox mousefocus;
    private final BaseXCheckBox simplefd;
    private final BaseXButton button;

    DialogGeneralPrefs(BaseXDialog d) {
        this.border(8).setLayout(new TableLayout(8, 1));
        this.gui = d.gui;
        GlobalOptions opts = this.gui.context.globalopts;
        GUIOptions gopts = this.gui.gopts;
        this.path = new BaseXTextField(opts.dbpath().path(), d);
        this.button = new BaseXButton(Text.BROWSE_D, d);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IOFile dir = new BaseXFileChooser(Text.CHOOSE_DIR, DialogGeneralPrefs.this.path.getText(), DialogGeneralPrefs.this.gui).select(BaseXFileChooser.Mode.DOPEN);
                if (dir != null) {
                    DialogGeneralPrefs.this.path.setText(dir.dirPath());
                }
            }
        });
        this.mousefocus = new BaseXCheckBox(Text.RT_FOCUS, GUIOptions.MOUSEFOCUS, gopts, d);
        this.simplefd = new BaseXCheckBox(Text.SIMPLE_FILE_CHOOSER, GUIOptions.SIMPLEFD, gopts, d);
        int val = this.hitsForSlider();
        this.limit = new BaseXSlider(0, HITS.length - 1, val, d);
        this.limit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogGeneralPrefs.this.action(DialogGeneralPrefs.this.limit);
            }
        });
        this.label = new BaseXLabel(" ");
        this.lang = new BaseXCombo((Window)d, LANGS[0]);
        this.lang.setSelectedItem(opts.get(GlobalOptions.LANG));
        this.creds = new BaseXLabel(" ");
        this.add(new BaseXLabel(Text.DATABASE_PATH + ":", true, true));
        BaseXBack p = new BaseXBack(new TableLayout(1, 2, 8, 0));
        p.add(this.path);
        p.add(this.button);
        this.add(p);
        this.add(new BaseXLabel(Text.GUI_INTERACTIONS + ":", true, true).border(8, 0, 8, 0));
        p = new BaseXBack(new TableLayout(2, 2, 40, 0));
        p.add(this.mousefocus);
        p.add(new BaseXLabel(Text.MAX_NO_OF_HITS + ":"));
        p.add(this.simplefd);
        BaseXBack pp = new BaseXBack(new TableLayout(1, 2, 12, 0)).border(0);
        pp.add(this.limit);
        pp.add(this.label);
        p.add(pp);
        this.add(p);
        this.add(new BaseXLabel(Text.LANGUAGE_RESTART + ":", true, true).border(8, 0, 8, 0));
        p = new BaseXBack(new TableLayout(1, 2, 12, 0));
        p.add(this.lang);
        p.add(this.creds);
        this.add(p);
    }

    private int hitsForSlider() {
        int mh = this.gui.gopts.get(MainOptions.MAXHITS);
        if (mh == -1) {
            mh = Integer.MAX_VALUE;
        }
        int hl = HITS.length - 1;
        int h = -1;
        while (++h < hl && HITS[h] < mh) {
        }
        return h;
    }

    static String creds(String lng) {
        for (int i = 0; i < LANGS[0].length; ++i) {
            if (!LANGS[0][i].equals(lng)) continue;
            return LANGS[1][i];
        }
        return "";
    }

    void action(Object source) {
        this.mousefocus.assign();
        this.simplefd.assign();
        GlobalOptions opts = this.gui.context.globalopts;
        if (source == this.path || source == this.button) {
            String dbpath = this.path.getText();
            if (!opts.get(GlobalOptions.DBPATH).equals(dbpath) && this.gui.context.data() != null) {
                new Close().run(this.gui.context);
                this.gui.notify.init();
            }
            opts.set(GlobalOptions.DBPATH, dbpath);
        }
        opts.set(GlobalOptions.LANG, this.lang.getSelectedItem());
        this.gui.gopts.set(GUIOptions.MAXHITS, HITS[this.limit.getValue()]);
        this.creds.setText(Text.TRANSLATION + ": " + DialogGeneralPrefs.creds(this.lang.getSelectedItem()));
        int mh = HITS[this.limit.getValue()];
        this.label.setText(mh == -1 ? Text.ALL : Integer.toString(mh));
    }
}

