/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.core.cmd.CreateIndex;
import org.basex.core.cmd.DropIndex;
import org.basex.core.cmd.InfoDB;
import org.basex.core.cmd.Optimize;
import org.basex.data.Data;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.dialog.DialogAdd;
import org.basex.gui.dialog.DialogFT;
import org.basex.gui.dialog.DialogProgress;
import org.basex.gui.dialog.DialogResources;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXTabs;
import org.basex.gui.text.SearchEditor;
import org.basex.gui.text.TextPanel;
import org.basex.index.IndexType;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.list.IntList;

public final class DialogProps
extends BaseXDialog {
    private static final String[] HELP = new String[]{"", "", Text.H_PATH_INDEX, Text.H_TEXT_INDEX, Text.H_ATTR_INDEX, ""};
    private static final IndexType[] TYPES = new IndexType[]{IndexType.TAG, IndexType.ATTNAME, IndexType.PATH, IndexType.TEXT, IndexType.ATTRIBUTE, IndexType.FULLTEXT};
    private static final String[] LABELS = new String[]{Text.ELEMENTS, Text.ATTRIBUTES, Text.PATH_INDEX, Text.TEXT_INDEX, Text.ATTRIBUTE_INDEX, Text.FULLTEXT_INDEX};
    private final BaseXBack tabFT;
    private final BaseXBack tabNames;
    private final BaseXBack tabPath;
    private final BaseXBack tabValues;
    private final IntList updated = new IntList();
    private final BaseXTabs tabs;
    final DialogResources resources;
    final DialogAdd add;
    private final TextPanel[] infos = new TextPanel[LABELS.length];
    private final BaseXLabel[] labels = new BaseXLabel[LABELS.length];
    private final BaseXButton[] indxs = new BaseXButton[LABELS.length];
    private final BaseXBack[] panels = new BaseXBack[LABELS.length];
    private final DialogFT ft;

    public DialogProps(GUI main) {
        super(main, Text.DB_PROPS);
        main.setCursor(GUIConstants.CURSORWAIT);
        this.panel.setLayout(new BorderLayout(5, 0));
        this.resources = new DialogResources(this);
        this.add = new DialogAdd(this);
        this.ft = new DialogFT(this, false);
        BaseXBack tabRes = this.add.border(8);
        Data data = main.context.data();
        for (int i = 0; i < LABELS.length; ++i) {
            this.labels[i] = new BaseXLabel(LABELS[i]).large();
            this.panels[i] = new BaseXBack(new BorderLayout(0, 4));
            this.infos[i] = new TextPanel(Token.token(Text.PLEASE_WAIT_D), false, this);
            BaseXLayout.setHeight(this.infos[i], 200);
            if (i == 1) continue;
            this.indxs[i] = new BaseXButton(" ", this);
            this.indxs[i].setEnabled(!data.inMemory());
        }
        this.tabNames = new BaseXBack(new GridLayout(2, 1, 0, 8)).border(8);
        this.add(0, this.tabNames, null);
        this.add(1, this.tabNames, null);
        this.tabPath = new BaseXBack(new GridLayout(1, 1)).border(8);
        this.add(2, this.tabPath, null);
        this.tabValues = new BaseXBack(new GridLayout(2, 1, 0, 8)).border(8);
        this.add(3, this.tabValues, null);
        this.add(4, this.tabValues, null);
        this.tabFT = new BaseXBack(new GridLayout(1, 1)).border(8);
        this.add(5, this.tabFT, null);
        BaseXBack tabGeneral = new BaseXBack(new BorderLayout(0, 8)).border(8);
        Font f = tabGeneral.getFont();
        BaseXLabel doc = new BaseXLabel(data.meta.name).border(0, 0, 6, 0).large();
        BaseXLayout.setWidth(doc, 400);
        tabGeneral.add((Component)doc, "North");
        String db = InfoDB.db(data.meta, true, false, true);
        TokenBuilder info = new TokenBuilder(db);
        if (data.nspaces.size() != 0) {
            info.bold().add(Text.NL + Text.NAMESPACES + Text.NL).norm().add(data.nspaces.info());
        }
        TextPanel text = new TextPanel(info.finish(), false, this);
        text.setFont(f);
        BaseXLayout.setHeight(text, 200);
        tabGeneral.add((Component)new SearchEditor(main, text), "Center");
        this.tabs = new BaseXTabs(this);
        this.tabs.addTab(Text.RESOURCES, tabRes);
        this.tabs.addTab(Text.NAMES, this.tabNames);
        this.tabs.addTab(Text.PATH_INDEX, this.tabPath);
        this.tabs.addTab(Text.INDEXES, this.tabValues);
        this.tabs.addTab(Text.FULLTEXT, this.tabFT);
        this.tabs.addTab(Text.GENERAL, tabGeneral);
        this.tabs.addChangeListener(new ChangeListener(){

            @Override
            public synchronized void stateChanged(ChangeEvent evt) {
                DialogProps.this.updateInfo();
            }
        });
        this.set(this.resources, "West");
        this.set(this.tabs, "Center");
        this.action(this);
        this.setResizable(true);
        main.setCursor(GUIConstants.CURSORARROW);
        this.finish(null);
    }

    synchronized void updateInfo() {
        Component o = this.tabs.getSelectedComponent();
        IntList il = new IntList();
        if (o == this.tabNames) {
            il.add(0);
            il.add(1);
        } else if (o == this.tabPath) {
            il.add(2);
        } else if (o == this.tabValues) {
            il.add(3);
            il.add(4);
        } else if (o == this.tabFT) {
            il.add(5);
        }
        final Data data = this.gui.context.data();
        final boolean[] val = new boolean[]{true, true, true, data.meta.textindex, data.meta.attrindex, data.meta.ftxtindex};
        for (int i = 0; i < il.size(); ++i) {
            final int idx = il.get(i);
            if (this.updated.contains(idx)) continue;
            this.updated.add(idx);
            new Thread(){

                @Override
                public void run() {
                    DialogProps.this.infos[idx].setText(val[idx] ? data.info(TYPES[idx]) : Token.token(HELP[idx]));
                    DialogProps.this.updated.delete(idx);
                }
            }.start();
        }
    }

    private void add(int i, BaseXBack tab, BaseXBack info) {
        BaseXBack idx = new BaseXBack(new BorderLayout(8, 0));
        idx.add((Component)this.labels[i], "West");
        if (this.indxs[i] != null) {
            idx.add((Component)this.indxs[i], "East");
        }
        this.panels[i].add((Component)idx, "North");
        BaseXBack b = info != null ? info : new SearchEditor(this.gui, this.infos[i]);
        this.panels[i].add((Component)b, "Center");
        tab.add(this.panels[i]);
    }

    @Override
    public void action(Object cmp) {
        if (cmp != null) {
            for (int i = 0; i < LABELS.length; ++i) {
                ACreate cmd;
                if (cmp != this.indxs[i]) continue;
                String label = this.indxs[i].getText();
                if (label.equals(Text.OPTIMIZE + "...")) {
                    cmd = new Optimize();
                } else if (label.equals(Text.DROP + "...")) {
                    cmd = new DropIndex((Object)TYPES[i]);
                } else {
                    cmd = new CreateIndex((Object)TYPES[i]);
                    this.ft.setOptions();
                }
                this.infos[i].setText(Text.PLEASE_WAIT_D);
                DialogProgress.execute((BaseXDialog)this, cmd);
                return;
            }
        }
        this.resources.action(cmp);
        this.add.action(cmp);
        Data data = this.gui.context.data();
        boolean[] val = new boolean[]{true, true, true, data.meta.textindex, data.meta.attrindex, data.meta.ftxtindex};
        if (cmp == this) {
            boolean utd = data.meta.uptodate;
            for (int i = 0; i < LABELS.length; ++i) {
                boolean struct = i < 3;
                String lbl = LABELS[i];
                if (struct && !utd) {
                    lbl = lbl + " (" + Text.OUT_OF_DATE + ')';
                }
                this.labels[i].setText(lbl);
                if (this.indxs[i] == null) continue;
                this.indxs[i].setText((struct ? Text.OPTIMIZE : (val[i] ? Text.DROP : Text.CREATE)) + "...");
                if (!struct) continue;
                this.indxs[i].setEnabled(!utd);
            }
            this.tabFT.removeAll();
            int f = 5;
            this.panels[5].removeAll();
            this.add(5, this.tabFT, val[5] ? null : this.ft);
            this.panels[5].revalidate();
            this.panels[5].repaint();
            this.updateInfo();
        }
        this.ft.action(true);
    }

    @Override
    public void close() {
        super.close();
        this.ft.setOptions();
    }
}

