/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.basex.core.Text;
import org.basex.core.cmd.Delete;
import org.basex.core.cmd.Rename;
import org.basex.data.Data;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIPopupCmd;
import org.basex.gui.dialog.DialogInput;
import org.basex.gui.dialog.DialogProgress;
import org.basex.gui.dialog.DialogProps;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXImages;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXPopup;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.BaseXTree;
import org.basex.gui.layout.TreeFolder;
import org.basex.gui.layout.TreeLeaf;
import org.basex.gui.layout.TreeNode;
import org.basex.gui.layout.TreeRootFolder;
import org.basex.util.Token;

public final class DialogResources
extends BaseXBack {
    private final BaseXTextField filterText;
    private final TreeFolder root;
    private final BaseXDialog dialog;
    private final BaseXTree tree;
    private final BaseXButton filter;
    private final BaseXButton clear;
    private boolean filtered;

    DialogResources(final DialogProps dp) {
        this.setLayout(new BorderLayout(0, 5));
        this.dialog = dp;
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        this.tree = new BaseXTree(rootNode, dp).border(4, 4, 4, 4);
        this.tree.setRootVisible(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setCellRenderer(new TreeNodeRenderer());
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreeNode n = (TreeNode)e.getPath().getLastPathComponent();
                String filt = n.equals(DialogResources.this.root) ? "" : n.path();
                String trgt = filt + '/';
                if (n.isLeaf()) {
                    n = (TreeNode)n.getParent();
                    trgt = (n == null || n.equals(DialogResources.this.root) ? "" : n.path()) + '/';
                } else {
                    filt = trgt;
                }
                DialogResources.this.filterText.setText(filt);
                dp.add.target.setText(trgt);
                DialogResources.this.filtered = false;
            }
        });
        Data data = dp.gui.context.data();
        String label = data.meta.name + " (/)";
        this.root = new TreeRootFolder(Token.token(label), Token.token("/"), this.tree, data);
        ((DefaultTreeModel)this.tree.getModel()).insertNodeInto(this.root, rootNode, 0);
        this.filter = new BaseXButton(Text.FILTER, dp);
        this.clear = new BaseXButton(Text.CLEAR, dp);
        this.filter.setEnabled(false);
        this.clear.setEnabled(false);
        new BaseXPopup(this.tree, dp.gui, new DeleteCmd(), new RenameCmd());
        BaseXBack buttons = new BaseXBack();
        buttons.add(this.filter);
        buttons.add(this.clear);
        BaseXBack btn = new BaseXBack().layout(new BorderLayout());
        btn.add((Component)buttons, "East");
        this.filterText = new BaseXTextField(Text.PLEASE_WAIT_D, dp);
        this.filterText.setEnabled(false);
        BaseXLayout.setWidth(this.filterText, 250);
        BaseXBack panel = new BaseXBack(new BorderLayout());
        panel.add((Component)this.filterText, "Center");
        panel.add((Component)btn, "South");
        JScrollPane sp = new JScrollPane(this.tree);
        BaseXLayout.setWidth(sp, 250);
        this.add((Component)sp, "Center");
        this.add((Component)panel, "South");
        new Thread(){

            @Override
            public void run() {
                DialogResources.this.tree.setCursor(GUIConstants.CURSORWAIT);
                DialogResources.this.tree.expandPath(new TreePath(DialogResources.this.root.getPath()));
                DialogResources.this.filterText.setText("/");
                DialogResources.this.filterText.setEnabled(true);
                DialogResources.this.tree.setCursor(GUIConstants.CURSORARROW);
                DialogResources.this.filter.setEnabled(true);
                DialogResources.this.clear.setEnabled(true);
            }
        }.start();
    }

    TreeNode selection() {
        TreePath t = this.tree.getSelectionPath();
        return t == null ? null : (TreeNode)t.getLastPathComponent();
    }

    private void refreshFolder(TreeFolder n) {
        if (n == null) {
            return;
        }
        n.removeChildren();
        TreePath path = new TreePath(n.getPath());
        this.tree.collapsePath(path);
        this.tree.expandPath(path);
    }

    void action(Object comp) {
        if (comp == this.filter && !this.filtered) {
            this.filter();
            this.filtered = true;
        } else if (comp == this.clear) {
            this.filterText.setText("/");
            this.filterText.requestFocusInWindow();
            this.refreshFolder(this.root);
            this.filtered = false;
        }
    }

    private void filter() {
        byte[] filterPath = TreeNode.preparePath(Token.token(this.filterText.getText()));
        if (Token.eq(filterPath, Token.SLASH)) {
            this.refreshFolder(this.root);
            return;
        }
        Data data = this.dialog.gui.context.data();
        this.root.removeAllChildren();
        int cmax = 10000;
        if (data.resources.isDir(filterPath)) {
            this.root.add(new TreeFolder(TreeFolder.name(filterPath), TreeFolder.path(filterPath), this.tree, data));
            --cmax;
        }
        byte[] name = TreeFolder.name(filterPath);
        byte[] sub = TreeFolder.path(filterPath);
        TreeFolder f = new TreeFolder(TreeFolder.name(sub), TreeFolder.path(sub), this.tree, data);
        cmax = f.addLeaves(name, cmax, this.root);
        if (cmax <= 0) {
            this.root.add(new TreeLeaf(Token.token("..."), sub, false, true, this.tree, data));
        }
        ((DefaultTreeModel)this.tree.getModel()).nodeStructureChanged(this.root);
    }

    void refreshNewFolder(String p) {
        byte[][] pathComp = Token.split(Token.token(p), 47);
        TreeNode n = this.root;
        block0: for (byte[] c : pathComp) {
            if (n instanceof TreeFolder) {
                ((TreeFolder)n).reload();
            }
            for (int i = 0; i < n.getChildCount(); ++i) {
                TreeNode ch = (TreeNode)n.getChildAt(i);
                if (!Token.eq(ch.name, c)) continue;
                n = ch;
                continue block0;
            }
        }
        this.refreshFolder((TreeFolder)(n instanceof TreeFolder ? n : (TreeFolder)n.getParent()));
    }

    final class RenameCmd
    extends GUIPopupCmd {
        RenameCmd() {
            super(Text.RENAME + "...", BaseXKeys.RENAME);
        }

        @Override
        public void execute() {
            TreeNode n = DialogResources.this.selection();
            if (n == null) {
                return;
            }
            DialogInput d = new DialogInput(n.path(), Text.RENAME, DialogResources.this.dialog, 0);
            if (!d.ok()) {
                return;
            }
            final String p = Token.string(TreeNode.preparePath(Token.token(d.input())));
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    DialogResources.this.refreshNewFolder(p);
                }
            };
            DialogProgress.execute(DialogResources.this.dialog, run, new Rename(n.path(), p));
        }

        @Override
        public boolean enabled(GUI main) {
            TreeNode n = DialogResources.this.selection();
            return n instanceof TreeLeaf ? !((TreeLeaf)n).abbr : n != null && !n.equals(DialogResources.this.root);
        }
    }

    final class DeleteCmd
    extends GUIPopupCmd {
        DeleteCmd() {
            super(Text.DELETE + "...", BaseXKeys.DELNEXT);
        }

        @Override
        public void execute() {
            final TreeNode n = DialogResources.this.selection();
            if (n == null || !BaseXDialog.confirm(((DialogResources)DialogResources.this).dialog.gui, Text.DELETE_NODES)) {
                return;
            }
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    DialogResources.this.refreshNewFolder(n.path());
                }
            };
            DialogProgress.execute(DialogResources.this.dialog, run, new Delete(n.path()));
        }

        @Override
        public boolean enabled(GUI main) {
            TreeNode n = DialogResources.this.selection();
            return n instanceof TreeLeaf ? !((TreeLeaf)n).abbr : n != null && !n.equals(DialogResources.this.root);
        }
    }

    private static final class TreeNodeRenderer
    extends DefaultTreeCellRenderer {
        private TreeNodeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object val, boolean sel, boolean exp, boolean leaf, int row, boolean focus) {
            super.getTreeCellRendererComponent(tree, val, sel, exp, leaf, row, focus);
            if (leaf) {
                this.setIcon(BaseXImages.text(((TreeLeaf)val).raw));
            }
            return this;
        }
    }
}

