/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.Window;
import javax.swing.UIManager;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXCheckBox;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXSlider;
import org.basex.gui.layout.TableLayout;
import org.basex.util.list.StringList;
import org.basex.util.options.Options;

final class DialogVisualPrefs
extends BaseXBack {
    private final GUI gui;
    private final BaseXCheckBox showNames;
    private final BaseXCheckBox treeSlims;
    private final BaseXCheckBox treeAtts;
    private final BaseXCombo mapAlgo;
    private final BaseXSlider mapWeight;
    private final BaseXCheckBox mapAtts;
    private final BaseXCombo mapOffsets;
    private final BaseXCombo lookfeel;

    DialogVisualPrefs(BaseXDialog d) {
        this.border(8).setLayout(new TableLayout(1, 2, 40, 0));
        this.gui = d.gui;
        GUIOptions gopts = d.gui.gopts;
        this.showNames = new BaseXCheckBox(Text.SHOW_NAME_ATTS, GUIOptions.SHOWNAME, gopts, d);
        this.treeSlims = new BaseXCheckBox(Text.ADJUST_NODES, GUIOptions.TREESLIMS, gopts, d);
        this.treeAtts = new BaseXCheckBox(Text.SHOW_ATTS, GUIOptions.TREEATTS, gopts, d);
        this.mapAlgo = new BaseXCombo((Window)d, GUIOptions.MAPALGO, (Options)gopts, Text.MAP_LAYOUTS);
        this.mapOffsets = new BaseXCombo((Window)d, GUIOptions.MAPOFFSETS, (Options)gopts, Text.MAP_CHOICES);
        this.mapWeight = new BaseXSlider(0, 100, GUIOptions.MAPWEIGHT, gopts, d);
        this.mapAtts = new BaseXCheckBox(Text.SHOW_ATTS, GUIOptions.MAPATTS, gopts, d);
        this.mapAlgo.setSize(200, 100);
        BaseXLayout.setWidth(this.mapWeight, 150);
        StringList lafs = new StringList("(default)");
        for (UIManager.LookAndFeelInfo lafi : UIManager.getInstalledLookAndFeels()) {
            lafs.add(lafi.getName());
        }
        this.lookfeel = new BaseXCombo((Window)d, lafs.toArray());
        String laf = gopts.get(GUIOptions.LOOKANDFEEL);
        if (laf.isEmpty()) {
            this.lookfeel.setSelectedIndex(0);
        } else {
            this.lookfeel.setSelectedItem(laf);
        }
        BaseXBack pp = new BaseXBack().layout(new TableLayout(3, 1, 0, 8));
        BaseXBack p = new BaseXBack(new TableLayout(2, 1));
        p.add(new BaseXLabel(Text.GENERAL + ":", true, true));
        p.add(this.showNames);
        pp.add(p);
        p = new BaseXBack(new TableLayout(3, 1));
        p.add(new BaseXLabel(Text.TREE + ":", true, true));
        p.add(this.treeSlims);
        p.add(this.treeAtts);
        pp.add(p);
        p = new BaseXBack(new TableLayout(2, 1));
        p.add(new BaseXLabel(Text.JAVA_LF + ":", true, true));
        p.add(this.lookfeel);
        pp.add(p);
        this.add(pp);
        pp = new BaseXBack(new TableLayout(3, 1));
        pp.add(new BaseXLabel(Text.MAP + ":", true, true));
        p = new BaseXBack(new TableLayout(2, 2, 8, 8));
        p.add(new BaseXLabel(Text.ALGORITHM + ":"));
        p.add(this.mapAlgo);
        p.add(new BaseXLabel(Text.OFFSETS + ":"));
        p.add(this.mapOffsets);
        pp.add(p);
        p = new BaseXBack(new TableLayout(3, 1, 0, 8));
        p.add(new BaseXLabel(Text.RATIO + ": "));
        p.add(this.mapWeight);
        p.add(this.mapAtts);
        pp.add(p);
        this.add(pp);
    }

    void action() {
        this.treeSlims.assign();
        this.treeAtts.assign();
        this.mapAtts.assign();
        this.showNames.assign();
        this.mapWeight.assign();
        this.mapAlgo.assign();
        this.mapOffsets.assign();
        this.gui.gopts.set(GUIOptions.LOOKANDFEEL, this.lookfeel.getSelectedIndex() == 0 ? "" : this.lookfeel.getSelectedItem());
    }
}

