/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.project;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUIPopupCmd;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXPopup;
import org.basex.gui.layout.BaseXTree;
import org.basex.gui.view.project.ProjectCellEditor;
import org.basex.gui.view.project.ProjectCellRenderer;
import org.basex.gui.view.project.ProjectDir;
import org.basex.gui.view.project.ProjectFile;
import org.basex.gui.view.project.ProjectNode;
import org.basex.gui.view.project.ProjectView;
import org.basex.io.IOFile;
import org.basex.util.Util;

public class ProjectTree
extends BaseXTree
implements TreeWillExpandListener {
    final ProjectView view;

    public ProjectTree(final ProjectView pv) {
        super(new DefaultMutableTreeNode(), pv.gui);
        this.view = pv;
        this.border(4, 4, 4, 4);
        this.setExpandsSelectedPaths(true);
        ProjectCellRenderer renderer = new ProjectCellRenderer();
        this.setCellRenderer(renderer);
        this.addTreeWillExpandListener(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    new OpenCmd().execute(pv.gui);
                }
            }
        });
        this.setCellEditor(new ProjectCellEditor(this, renderer));
        this.setEditable(true);
        new BaseXPopup(this, pv.gui, new OpenCmd(), new OpenExternalCmd(), null, new DeleteCmd(), new RenameCmd(), new NewDirCmd(), null, new RefreshCmd(), new CopyPathCmd());
    }

    void init(ProjectNode node) {
        ((DefaultMutableTreeNode)this.getModel().getRoot()).add(node);
        for (int r = 0; r < 2; ++r) {
            this.expandRow(r);
        }
        this.setRootVisible(false);
        this.setSelectionRow(0);
    }

    public boolean expand(ProjectNode node, String path) {
        TreePath tp = node.path();
        if (!this.isExpanded(tp)) {
            this.expandPath(tp);
        }
        int ns = node.getChildCount();
        for (int n = 0; n < ns; ++n) {
            ProjectNode ch = (ProjectNode)node.getChildAt(n);
            String np = ch.file.path();
            if (path.equals(np)) {
                TreePath cp = ch.path();
                this.setSelectionPath(cp);
                this.scrollPathToVisible(cp);
                return true;
            }
            if (!path.startsWith(np)) continue;
            return this.expand(ch, path);
        }
        return false;
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        Object obj = event.getPath().getLastPathComponent();
        if (obj instanceof ProjectNode) {
            ProjectNode node = (ProjectNode)obj;
            node.expand();
            node.updateTree();
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
        Object obj = event.getPath().getLastPathComponent();
        if (obj instanceof ProjectNode) {
            ProjectNode node = (ProjectNode)obj;
            node.collapse();
            node.updateTree();
        }
    }

    ProjectNode selectedNode() {
        Object node;
        TreePath tp = this.selectedPath();
        if (tp != null && (node = tp.getLastPathComponent()) instanceof ProjectNode) {
            return (ProjectNode)node;
        }
        return null;
    }

    private ArrayList<ProjectNode> selectedNodes() {
        ArrayList<ProjectNode> nodes = new ArrayList<ProjectNode>();
        TreePath[] paths = this.getSelectionPaths();
        if (paths != null) {
            for (TreePath tp : paths) {
                Object node = tp.getLastPathComponent();
                if (!(node instanceof ProjectNode)) continue;
                nodes.add((ProjectNode)node);
            }
        }
        return nodes;
    }

    private TreePath selectedPath() {
        TreePath[] tps = this.getSelectionPaths();
        return tps == null || tps.length > 1 ? null : tps[0];
    }

    final class CopyPathCmd
    extends GUIPopupCmd {
        CopyPathCmd() {
            super(Text.COPY_PATH, BaseXKeys.COPYPATH);
        }

        @Override
        public void execute() {
            BaseXLayout.copy(ProjectTree.this.selectedNode().file.path());
        }

        @Override
        public boolean enabled(GUI main) {
            return ProjectTree.this.selectedNode() != null;
        }
    }

    final class OpenExternalCmd
    extends GUIPopupCmd {
        OpenExternalCmd() {
            super(Text.OPEN_EXTERNALLY, BaseXKeys.OPEN);
        }

        @Override
        public void execute() {
            for (ProjectNode node : ProjectTree.this.selectedNodes()) {
                try {
                    node.file.open();
                }
                catch (IOException ex) {
                    BaseXDialog.error(ProjectTree.this.view.gui, Util.info(Text.FILE_NOT_OPENED_X, node.file));
                }
            }
        }
    }

    final class OpenCmd
    extends GUIPopupCmd {
        OpenCmd() {
            super(Text.OPEN, BaseXKeys.ENTER);
        }

        @Override
        public void execute() {
            for (ProjectNode node : ProjectTree.this.selectedNodes()) {
                ProjectTree.this.view.open(node.file, null);
            }
        }

        @Override
        public boolean enabled(GUI main) {
            for (ProjectNode node : ProjectTree.this.selectedNodes()) {
                if (!node.file.isDir()) continue;
                return false;
            }
            return true;
        }
    }

    final class RenameCmd
    extends GUIPopupCmd {
        RenameCmd() {
            super(Text.RENAME, BaseXKeys.RENAME);
        }

        @Override
        public void execute() {
            ProjectTree.this.startEditingAtPath(ProjectTree.this.selectedNode().path());
            ProjectTree.this.view.filter.reset();
        }

        @Override
        public boolean enabled(GUI main) {
            ProjectNode node = ProjectTree.this.selectedNode();
            return node != null && !node.root();
        }
    }

    final class DeleteCmd
    extends GUIPopupCmd {
        DeleteCmd() {
            super(Text.DELETE + "...", BaseXKeys.DELNEXT);
        }

        @Override
        public void execute() {
            ProjectNode node = ProjectTree.this.selectedNode();
            if (BaseXDialog.confirm(ProjectTree.this.view.gui, Util.info(Text.DELETE_FILE_X, node.file))) {
                ProjectNode parent = (ProjectNode)node.getParent();
                if (!ProjectTree.this.view.editor.delete(node.file)) {
                    BaseXDialog.error(ProjectTree.this.view.gui, Util.info(Text.FILE_NOT_DELETED_X, node.file));
                } else {
                    parent.refresh();
                    ProjectTree.this.setSelectionPath(parent.path());
                    ProjectTree.this.view.filter.reset();
                }
            }
        }

        @Override
        public boolean enabled(GUI main) {
            ProjectNode node = ProjectTree.this.selectedNode();
            return node != null && !node.root();
        }
    }

    final class NewDirCmd
    extends GUIPopupCmd {
        NewDirCmd() {
            super(Text.NEW_DIR, BaseXKeys.NEWDIR);
        }

        @Override
        public void execute() {
            ProjectNode parent = ProjectTree.this.selectedNode();
            if (parent instanceof ProjectFile) {
                parent = (ProjectDir)parent.getParent();
            }
            String name = '(' + Text.NEW_DIR + ')';
            IOFile file = new IOFile(parent.file, name);
            int c = 1;
            while (file.exists()) {
                name = '(' + Text.NEW_DIR + ' ' + ++c + ')';
                file = new IOFile(parent.file, name);
            }
            if (file.md()) {
                ProjectTree.this.setSelectionPaths(null);
                parent.refresh();
                int cl = parent.getChildCount();
                for (int i = 0; i < cl; ++i) {
                    ProjectNode node = (ProjectNode)parent.getChildAt(i);
                    if (!node.file.name().equals(name)) continue;
                    TreePath tp = node.path();
                    ProjectTree.this.setSelectionPath(tp);
                    ProjectTree.this.startEditingAtPath(tp);
                    break;
                }
            }
        }

        @Override
        public boolean enabled(GUI main) {
            return ProjectTree.this.selectedNode() != null;
        }
    }

    final class RefreshCmd
    extends GUIPopupCmd {
        RefreshCmd() {
            super(Text.REFRESH, BaseXKeys.REFRESH);
        }

        @Override
        public void execute() {
            ProjectTree.this.view.filter.reset();
            ProjectTree.this.selectedNode().refresh();
        }

        @Override
        public boolean enabled(GUI main) {
            return ProjectTree.this.selectedNode() != null;
        }
    }
}

