/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import javax.xml.transform.stream.StreamSource;
import org.basex.core.Databases;
import org.basex.io.IOContent;
import org.basex.io.IOFile;
import org.basex.io.IOUrl;
import org.basex.io.in.TextInput;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.xml.sax.InputSource;

public abstract class IO {
    public static final String BASEXSUFFIX = ".basex";
    public static final String BXSSUFFIX = ".bxs";
    public static final String XQSUFFIX = ".xq";
    public static final String XQMSUFFIX = ".xqm";
    public static final String XMLSUFFIX = ".xml";
    public static final String ZIPSUFFIX = ".zip";
    public static final String CSVSUFFIX = ".csv";
    public static final String JSONSUFFIX = ".json";
    public static final String JARSUFFIX = ".jar";
    public static final String TGZSUFFIX = ".tgz";
    public static final String GZSUFFIX = ".gz";
    public static final String TARSUFFIX = ".tar";
    public static final String XARSUFFIX = ".xar";
    public static final String LOGSUFFIX = ".log";
    public static final String RAW = "raw";
    public static final String FILEPREF = "file:";
    public static final String[] XQSUFFIXES = new String[]{".xq", ".xqm", ".xqy", ".xql", ".xqu", ".xquery"};
    public static final String[] ZIPSUFFIXES = new String[]{".zip", ".gz", ".tgz", ".tar", ".xar", ".docx", ".pptx", ".xslx", ".odt", ".odp", ".ods"};
    public static final String[] XMLSUFFIXES = new String[]{".xml", ".xsd", ".svg", ".rdf", ".rss", ".rng", ".sch", ".xhtml"};
    public static final String[] XSLSUFFIXES = new String[]{".xsl", ".xslt", ".fo", ".fob"};
    public static final String[] HTMLSUFFIXES = new String[]{".html", ".htm"};
    public static final String[] TXTSUFFIXES = new String[]{".txt", ".text", ".ini", ".conf", ".md", ".log"};
    public static final int BLOCKSIZE = 4096;
    public static final int NODEPOWER = 4;
    public static final int NODESIZE = 16;
    public static final int ENTRIES = 256;
    public static final int MAXATTS = 31;
    public static final long OFFNUM = 0x8000000000L;
    public static final long OFFCOMP = 0x4000000000L;
    String path;
    private String name;
    long len = -1L;

    IO(String p) {
        this.init(p);
    }

    final void init(String p) {
        this.path = p;
        String n = p.substring(p.lastIndexOf(47) + 1);
        this.name = n.isEmpty() ? Long.toString(System.currentTimeMillis()) + BASEXSUFFIX + XMLSUFFIX : n;
    }

    public static IO get(String source) {
        if (source == null) {
            return new IOContent("");
        }
        String s = source.trim();
        return s.indexOf(60) == 0 ? new IOContent(s) : (IOUrl.isFileURL(s) ? IOFile.get(s) : (IOFile.isValid(s) ? new IOFile(s) : (IOUrl.isValid(s) ? new IOUrl(s) : new IOContent(s))));
    }

    public abstract byte[] read() throws IOException;

    public final String string() throws IOException {
        return new TextInput(this).cache().toString();
    }

    public boolean exists() {
        return true;
    }

    public boolean isDir() {
        return false;
    }

    public boolean hasSuffix(String ... suffixes) {
        int i = this.path.lastIndexOf(46);
        if (i == -1) {
            return false;
        }
        String suf = this.path.substring(i).toLowerCase(Locale.ENGLISH);
        for (String z : suffixes) {
            if (!suf.equals(z)) continue;
            return true;
        }
        return false;
    }

    public long timeStamp() {
        return System.currentTimeMillis();
    }

    public void length(long l) {
        this.len = l;
    }

    public long length() {
        return this.len;
    }

    public abstract InputSource inputSource();

    public abstract StreamSource streamSource();

    public abstract InputStream inputStream() throws IOException;

    public IO merge(String in) {
        return IO.get(in);
    }

    public final boolean isArchive() {
        return this.hasSuffix(ZIPSUFFIXES);
    }

    public final String dbname() {
        TokenBuilder tb = new TokenBuilder();
        byte[] n = Token.token(this.name());
        int i = Token.lastIndexOf(n, 46);
        if (i == -1) {
            i = n.length;
        }
        for (int c = 0; c < i; c += Token.cl(n, c)) {
            int ch = Token.norm(Token.cp(n, c));
            if (!Databases.validChar(ch)) continue;
            tb.add(ch);
        }
        return tb.toString();
    }

    public final String name() {
        return this.name;
    }

    public final void name(String n) {
        this.name = n;
        if (this.path.isEmpty()) {
            this.path = n;
        }
    }

    public final String path() {
        return this.path;
    }

    public String url() {
        return this.path;
    }

    public String dirPath() {
        return "";
    }

    public boolean eq(IO io) {
        return this.path.equals(io.path);
    }

    public String toString() {
        return this.path;
    }
}

