/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.in;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.basex.io.in.TarEntry;
import org.basex.util.Util;

public final class TarInputStream
extends FilterInputStream {
    private static final int BLOCK = 512;
    private final byte[] buf = new byte[1];
    private TarEntry entry;
    private long size;

    public TarInputStream(InputStream is) {
        super(is);
    }

    @Override
    public int read() throws IOException {
        int res = this.read(this.buf, 0, 1);
        return res == -1 ? -1 : this.buf[0] & 0xFF;
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        int br;
        int l = len;
        if (this.entry != null) {
            long ln = this.entry.getSize() - this.size;
            if (ln == 0L) {
                return -1;
            }
            if (ln < (long)len) {
                l = (int)ln;
            }
        }
        if ((br = super.read(bytes, off, l)) != -1 && this.entry != null) {
            this.size += (long)br;
        }
        return br;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void mark(int limit) {
        Util.notImplemented(new Object[0]);
    }

    @Override
    public synchronized void reset() throws IOException {
        Util.notImplemented(new Object[0]);
    }

    public TarEntry getNextEntry() throws IOException {
        int res;
        if (this.entry != null) {
            for (long ln = this.entry.getSize() - this.size + 512L - (this.size & 0x1FFL); ln != 512L && ln > 0L; ln -= this.skip(ln)) {
            }
            this.entry = null;
            this.size = 0L;
        }
        byte[] header = new byte[512];
        for (int tr = 0; tr < 512 && (res = this.read(header, tr, 512 - tr)) >= 0; tr += res) {
        }
        for (byte b : header) {
            if (b == 0) continue;
            this.entry = new TarEntry(header);
            break;
        }
        return this.entry;
    }
}

