/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.json;

import org.basex.build.JsonOptions;
import org.basex.build.JsonParserOptions;
import org.basex.io.parse.json.JsonConverter;
import org.basex.io.parse.json.JsonParser;
import org.basex.query.QueryIOException;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class JsonStringConverter
extends JsonConverter {
    private final TokenBuilder tb;
    private boolean first = true;

    private JsonStringConverter(JsonParserOptions opts, TokenBuilder builder) {
        super(opts);
        this.tb = builder;
    }

    public static void print(String json, JsonOptions.JsonSpec spec, boolean un, TokenBuilder tb) throws QueryIOException {
        JsonParserOptions jopts = new JsonParserOptions();
        jopts.set(JsonOptions.SPEC, spec);
        jopts.set(JsonParserOptions.UNESCAPE, un);
        JsonParser.parse(json, null, jopts, new JsonStringConverter(jopts, tb));
    }

    @Override
    public void openObject() {
        this.tb.add("{ ");
        this.first = true;
    }

    @Override
    public void openPair(byte[] key) {
        if (!this.first) {
            this.tb.add(", ");
        }
        this.stringLit(key);
        this.tb.add(": ");
    }

    @Override
    public void closePair() {
        this.first = false;
    }

    @Override
    public void closeObject() {
        this.tb.add(this.first ? "}" : " }");
    }

    @Override
    public void openArray() {
        this.tb.add("[ ");
        this.first = true;
    }

    @Override
    public void openItem() {
        if (!this.first) {
            this.tb.add(", ");
        }
    }

    @Override
    public void closeItem() {
        this.first = false;
    }

    @Override
    public void closeArray() {
        this.tb.add(this.first ? "]" : " ]");
    }

    @Override
    public void openConstr(byte[] name) {
        this.tb.add("new ").add(name).addByte((byte)40);
        this.first = true;
    }

    @Override
    public void openArg() {
        if (!this.first) {
            this.tb.add(", ");
        }
    }

    @Override
    public void closeArg() {
        this.first = false;
    }

    @Override
    public void closeConstr() {
        this.tb.addByte((byte)41);
    }

    @Override
    public void numberLit(byte[] value) {
        this.tb.add(value);
    }

    @Override
    void stringLit(byte[] value) {
        this.tb.addByte((byte)34);
        block8: for (int i = 0; i < value.length; i += Token.cl(value, i)) {
            int cp = Token.cp(value, i);
            switch (cp) {
                case 34: 
                case 92: {
                    this.tb.addByte((byte)92).addByte((byte)cp);
                    continue block8;
                }
                case 8: {
                    this.tb.add("\\b");
                    continue block8;
                }
                case 12: {
                    this.tb.add("\\f");
                    continue block8;
                }
                case 9: {
                    this.tb.add("\\t");
                    continue block8;
                }
                case 13: {
                    this.tb.add("\\r");
                    continue block8;
                }
                case 10: {
                    this.tb.add("\\n");
                    continue block8;
                }
                default: {
                    if (Character.isISOControl(cp)) {
                        this.tb.addByte((byte)92).addByte((byte)117);
                        int j = 4;
                        while (--j >= 0) {
                            int hex;
                            this.tb.addByte((byte)(hex + ((hex = cp >>> (j << 2) & 0xF) > 9 ? 55 : 48)));
                        }
                        continue block8;
                    }
                    this.tb.add(cp);
                }
            }
        }
        this.tb.addByte((byte)34);
    }

    @Override
    public void nullLit() {
        this.tb.add(Token.NULL);
    }

    @Override
    public void booleanLit(byte[] b) {
        this.tb.add(b);
    }

    @Override
    public Item finish() {
        return Str.get(this.tb.finish());
    }
}

