/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial.json;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.build.JsonOptions;
import org.basex.io.parse.json.JsonConstants;
import org.basex.io.serial.SerializerOptions;
import org.basex.io.serial.json.JsonSerializer;
import org.basex.query.util.Err;
import org.basex.query.value.item.Item;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.XMLToken;
import org.basex.util.hash.TokenMap;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.BoolList;
import org.basex.util.list.TokenList;

public final class JsonNodeSerializer
extends JsonSerializer {
    private final TokenSet[] typeCache = new TokenSet[JsonConstants.TYPES.length];
    private final BoolList comma = new BoolList();
    private final TokenList types = new TokenList();
    private final boolean lax;
    private final boolean atts;
    private byte[] key;

    public JsonNodeSerializer(OutputStream os, SerializerOptions opts) throws IOException {
        super(os, opts);
        for (int t = 0; t < this.typeCache.length; ++t) {
            this.typeCache[t] = new TokenMap();
        }
        this.atts = this.jopts.get(JsonOptions.FORMAT) == JsonOptions.JsonFormat.ATTRIBUTES;
        this.lax = this.jopts.get(JsonOptions.LAX) != false || this.atts;
    }

    @Override
    protected void startOpen(byte[] name) throws IOException {
        if (this.level == 0 && !Token.eq(name, JsonConstants.JSON)) {
            JsonNodeSerializer.error("<%> expected as root node", new Object[]{JsonConstants.JSON});
        }
        this.types.set(this.level, null);
        this.comma.set(this.level + 1, false);
        this.key = this.atts ? null : name;
    }

    @Override
    protected void attribute(byte[] name, byte[] value) throws IOException {
        if (this.level == 0) {
            int tl = this.typeCache.length;
            for (int t = 0; t < tl; ++t) {
                if (!Token.eq(name, JsonConstants.ATTRS[t])) continue;
                for (byte[] b : Token.split(value, 32)) {
                    this.typeCache[t].add(b);
                }
                return;
            }
        }
        if (Token.eq(name, JsonConstants.TYPE)) {
            if (!Token.eq(value, JsonConstants.TYPES)) {
                JsonNodeSerializer.error("<%> has invalid type \"%\"", this.tag, value);
            }
            this.types.set(this.level, value);
        } else if (this.atts && Token.eq(name, JsonConstants.NAME)) {
            this.key = value;
            if (!Token.eq(this.tag, JsonConstants.PAIR)) {
                JsonNodeSerializer.error("<%> found, <pair> expected", new Object[]{this.tag});
            }
        } else if (!Token.eq(name, Token.XMLNS) && !Token.startsWith(name, Token.XMLNSC)) {
            JsonNodeSerializer.error("<%> has invalid attribute \"%\"", this.tag, name);
        }
    }

    @Override
    protected void finishOpen() throws IOException {
        byte[] type;
        if (this.comma.get(this.level)) {
            this.print(44);
        } else {
            this.comma.set(this.level, true);
        }
        if (this.level > 0) {
            this.indent(this.level);
            byte[] ptype = this.types.get(this.level - 1);
            if (Token.eq(ptype, JsonConstants.OBJECT)) {
                byte[] name;
                if (this.atts && !Token.eq(this.tag, JsonConstants.PAIR)) {
                    JsonNodeSerializer.error("<%> found, <%> expected", this.tag, JsonConstants.PAIR);
                }
                if (this.key == null) {
                    JsonNodeSerializer.error("<%> has no name attribute", new Object[]{this.tag});
                }
                this.print(34);
                byte[] byArray = name = this.atts ? this.key : XMLToken.decode(this.key, this.lax);
                if (name == null) {
                    JsonNodeSerializer.error("Name of element <%> is invalid", new Object[]{this.key});
                }
                this.print(name);
                this.print("\":");
                if (this.indent) {
                    this.print(32);
                }
            } else if (Token.eq(ptype, JsonConstants.ARRAY)) {
                if (this.atts) {
                    if (!Token.eq(this.tag, JsonConstants.ITEM)) {
                        JsonNodeSerializer.error("<%> found, <%> expected", this.tag, JsonConstants.ITEM);
                    }
                    if (this.key != null) {
                        JsonNodeSerializer.error("<%> must have no name attribute", new Object[]{this.tag});
                    }
                } else if (!Token.eq(this.tag, JsonConstants.VALUE)) {
                    JsonNodeSerializer.error("<%> found, <%> expected", this.tag, JsonConstants.VALUE);
                }
            } else {
                JsonNodeSerializer.error("<%> is typed as \"%\" and cannot be nested", this.tags.get(this.level - 1), ptype);
            }
        }
        if ((type = this.types.get(this.level)) == null) {
            if (this.key != null) {
                int tl = this.typeCache.length;
                for (int t = 0; t < tl && type == null; ++t) {
                    if (!this.typeCache[t].contains(this.key)) continue;
                    type = JsonConstants.TYPES[t];
                }
            }
            if (type == null) {
                type = JsonConstants.STRING;
            }
            this.types.set(this.level, type);
        }
        if (Token.eq(type, JsonConstants.OBJECT)) {
            this.print(123);
        } else if (Token.eq(type, JsonConstants.ARRAY)) {
            this.print(91);
        } else if (this.level == 0 && this.spec == JsonOptions.JsonSpec.RFC4627) {
            JsonNodeSerializer.error("<%> must be typed as \"%\" or \"%\"", JsonConstants.JSON, JsonConstants.OBJECT, JsonConstants.ARRAY);
        }
    }

    @Override
    protected void finishText(byte[] text) throws IOException {
        byte[] type = this.types.get(this.level - 1);
        if (Token.eq(type, JsonConstants.STRING)) {
            this.print(34);
            for (byte ch : text) {
                this.encode(ch);
            }
            this.print(34);
        } else if (Token.eq(type, JsonConstants.BOOLEAN)) {
            if (!Token.eq(text, Token.TRUE, Token.FALSE)) {
                JsonNodeSerializer.error("Value of <%> is no boolean: \"%\"", this.tags.get(this.level - 1), text);
            }
            this.print(text);
        } else if (Token.eq(type, JsonConstants.NUMBER)) {
            if (Double.isNaN(Token.toDouble(text))) {
                JsonNodeSerializer.error("Value of <%> is no number: \"%\"", this.tags.get(this.level - 1), text);
            }
            this.print(text);
        } else if (Token.trim(text).length != 0) {
            JsonNodeSerializer.error("<%> is typed as \"%\" and cannot have a value", this.tags.get(this.level - 1), type);
        }
    }

    @Override
    protected void finishEmpty() throws IOException {
        this.finishOpen();
        byte[] type = this.types.get(this.level);
        if (Token.eq(type, JsonConstants.STRING)) {
            this.print("\"\"");
        } else if (Token.eq(type, Token.NULL)) {
            this.print(Token.NULL);
        } else if (!Token.eq(type, JsonConstants.OBJECT, JsonConstants.ARRAY)) {
            JsonNodeSerializer.error("Value expected for type \"%\"", new Object[]{type});
        }
        this.finishClose();
    }

    @Override
    protected void finishClose() throws IOException {
        byte[] type = this.types.get(this.level);
        if (Token.eq(type, JsonConstants.ARRAY)) {
            this.indent(this.level);
            this.print(93);
        } else if (Token.eq(type, JsonConstants.OBJECT)) {
            this.indent(this.level);
            this.print(125);
        }
    }

    @Override
    protected void finishComment(byte[] value) throws IOException {
        JsonNodeSerializer.error("Comments cannot be serialized", new Object[0]);
    }

    @Override
    protected void finishPi(byte[] name, byte[] value) throws IOException {
        JsonNodeSerializer.error("Processing instructions cannot be serialized", new Object[0]);
    }

    @Override
    protected void atomic(Item value, boolean iter) throws IOException {
        JsonNodeSerializer.error("Atomic values cannot be serialized", new Object[0]);
    }

    void indent(int lvl) throws IOException {
        if (!this.indent) {
            return;
        }
        this.print(this.nl);
        int ls = lvl * this.indents;
        for (int l = 0; l < ls; ++l) {
            this.print(this.tab);
        }
    }

    private static void error(String msg, Object ... ext) throws IOException {
        throw Err.BXJS_SERIAL.getIO(new Object[]{Util.inf(msg, ext)});
    }
}

