/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import org.basex.core.BaseXException;
import org.basex.core.MainOptions;
import org.basex.core.Perm;
import org.basex.io.IO;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.LibraryModule;
import org.basex.query.MainModule;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.expr.And;
import org.basex.query.expr.Arith;
import org.basex.query.expr.CAttr;
import org.basex.query.expr.CComm;
import org.basex.query.expr.CDoc;
import org.basex.query.expr.CElem;
import org.basex.query.expr.CNSpace;
import org.basex.query.expr.CPI;
import org.basex.query.expr.CTxt;
import org.basex.query.expr.Calc;
import org.basex.query.expr.Cast;
import org.basex.query.expr.Castable;
import org.basex.query.expr.Catch;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.CmpN;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Context;
import org.basex.query.expr.DBPragma;
import org.basex.query.expr.Except;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Extension;
import org.basex.query.expr.Filter;
import org.basex.query.expr.If;
import org.basex.query.expr.Instance;
import org.basex.query.expr.InterSect;
import org.basex.query.expr.List;
import org.basex.query.expr.LitMap;
import org.basex.query.expr.Or;
import org.basex.query.expr.Pragma;
import org.basex.query.expr.Quantifier;
import org.basex.query.expr.Range;
import org.basex.query.expr.Root;
import org.basex.query.expr.Switch;
import org.basex.query.expr.SwitchCase;
import org.basex.query.expr.Treat;
import org.basex.query.expr.Try;
import org.basex.query.expr.TypeCase;
import org.basex.query.expr.TypeSwitch;
import org.basex.query.expr.Unary;
import org.basex.query.expr.Union;
import org.basex.query.ft.FTAnd;
import org.basex.query.ft.FTContainsExpr;
import org.basex.query.ft.FTContent;
import org.basex.query.ft.FTDistance;
import org.basex.query.ft.FTExpr;
import org.basex.query.ft.FTExtensionSelection;
import org.basex.query.ft.FTMildNot;
import org.basex.query.ft.FTNot;
import org.basex.query.ft.FTOpts;
import org.basex.query.ft.FTOr;
import org.basex.query.ft.FTOrder;
import org.basex.query.ft.FTScope;
import org.basex.query.ft.FTWeight;
import org.basex.query.ft.FTWindow;
import org.basex.query.ft.FTWords;
import org.basex.query.ft.ThesQuery;
import org.basex.query.ft.Thesaurus;
import org.basex.query.func.Closure;
import org.basex.query.func.DynFuncCall;
import org.basex.query.func.FNInfo;
import org.basex.query.func.FuncLit;
import org.basex.query.func.FuncOptions;
import org.basex.query.func.Function;
import org.basex.query.func.Functions;
import org.basex.query.func.PartFunc;
import org.basex.query.func.StaticFunc;
import org.basex.query.gflwor.Count;
import org.basex.query.gflwor.For;
import org.basex.query.gflwor.GFLWOR;
import org.basex.query.gflwor.GroupBy;
import org.basex.query.gflwor.Let;
import org.basex.query.gflwor.OrderBy;
import org.basex.query.gflwor.Where;
import org.basex.query.gflwor.Window;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.path.Axis;
import org.basex.query.path.Bang;
import org.basex.query.path.DocTest;
import org.basex.query.path.NameTest;
import org.basex.query.path.NodeTest;
import org.basex.query.path.Path;
import org.basex.query.path.Step;
import org.basex.query.path.Test;
import org.basex.query.up.expr.Delete;
import org.basex.query.up.expr.Insert;
import org.basex.query.up.expr.Modify;
import org.basex.query.up.expr.Rename;
import org.basex.query.up.expr.Replace;
import org.basex.query.up.expr.Transform;
import org.basex.query.util.Ann;
import org.basex.query.util.Collation;
import org.basex.query.util.Err;
import org.basex.query.util.ExprList;
import org.basex.query.util.TypedFunc;
import org.basex.query.util.format.DecFormatter;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Atm;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.Uri;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.ListType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.StaticVar;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.query.var.VarScope;
import org.basex.query.var.VarStack;
import org.basex.util.Array;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.InputParser;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.XMLToken;
import org.basex.util.ft.FTCase;
import org.basex.util.ft.FTContents;
import org.basex.util.ft.FTFlag;
import org.basex.util.ft.FTMode;
import org.basex.util.ft.FTOpt;
import org.basex.util.ft.FTUnit;
import org.basex.util.ft.Language;
import org.basex.util.ft.Stemmer;
import org.basex.util.ft.StopWords;
import org.basex.util.ft.Tokenizer;
import org.basex.util.hash.TokenMap;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.hash.TokenSet;
import org.basex.util.options.Option;
import org.basex.util.options.StringOption;

public class QueryParser
extends InputParser {
    private static final byte[] URICHECK;
    private static final byte[] SKIPCHECK;
    private static final TokenSet KEYWORDS10;
    private static final TokenSet KEYWORDS30;
    public final TokenSet modules = new TokenSet();
    public final ArrayList<StaticVar> vars = new ArrayList();
    public final ArrayList<StaticFunc> funcs = new ArrayList();
    public final TokenMap namespaces = new TokenMap();
    private final QueryContext ctx;
    private final StaticContext sc;
    private final TokenBuilder tok = new TokenBuilder();
    private final StringBuilder currDoc = new StringBuilder();
    private String moduleDoc = "";
    private QNm module;
    private Err alter;
    private QNm alterFunc;
    private int alterPos;
    private final HashSet<String> decl = new HashSet();
    private final ArrayList<QNmCheck> names = new ArrayList();
    private final ArrayList<VarContext> localVars = new ArrayList();

    public QueryParser(String in, String path, QueryContext c, StaticContext sctx) throws QueryException {
        super(in);
        this.ctx = c;
        MainOptions opts = c.context.options;
        String bi = path != null ? path : opts.get(MainOptions.QUERYPATH);
        StaticContext staticContext = this.sc = sctx != null ? sctx : new StaticContext(opts.get(MainOptions.XQUERY3));
        if (!bi.isEmpty()) {
            this.sc.baseURI(bi);
        }
        String bind = opts.get(MainOptions.BINDINGS).trim();
        StringBuilder key = new StringBuilder();
        StringBuilder val = new StringBuilder();
        boolean first = true;
        int sl = bind.length();
        for (int s = 0; s < sl; ++s) {
            char ch = bind.charAt(s);
            if (first) {
                if (ch == '=') {
                    first = false;
                    continue;
                }
                key.append(ch);
                continue;
            }
            if (ch == ',') {
                if (s + 1 == sl || bind.charAt(s + 1) != ',') {
                    this.bind(key, val);
                    key.setLength(0);
                    val.setLength(0);
                    first = true;
                    continue;
                }
                ++s;
            }
            val.append(ch);
        }
        this.bind(key, val);
    }

    private void bind(StringBuilder key, StringBuilder val) throws QueryException {
        String k = key.toString().trim();
        if (!k.isEmpty()) {
            this.ctx.bind(k, new Atm(val.toString()), null);
        }
    }

    public final MainModule parseMain() throws QueryException {
        this.init();
        try {
            this.versionDecl();
            int i = this.pos;
            if (this.wsConsumeWs("module", "namespace", null)) {
                throw this.error(Err.MAINMOD, new Object[0]);
            }
            this.pos = i;
            this.prolog1();
            this.prolog2();
            this.pushVarContext(null);
            Expr e = this.expr();
            if (e == null) {
                throw this.alter == null ? this.error(Err.EXPREMPTY, new Object[0]) : this.error();
            }
            VarScope scope = this.popVarContext();
            MainModule mm = new MainModule(e, scope, this.moduleDoc, this.sc);
            this.finish(mm, true);
            return mm;
        }
        catch (QueryException ex) {
            this.mark();
            ex.pos(this);
            throw ex;
        }
    }

    public final LibraryModule parseLibrary(boolean check) throws QueryException {
        this.init();
        try {
            this.versionDecl();
            this.wsCheck("module");
            this.wsCheck("namespace");
            this.skipWs();
            byte[] pref = this.ncName(Err.NONAME);
            this.wsCheck("=");
            byte[] uri = this.stringLiteral();
            if (uri.length == 0) {
                throw this.error(Err.NSMODURI, new Object[0]);
            }
            this.module = new QNm(pref, uri);
            this.sc.ns.add(pref, uri, this.info());
            this.namespaces.put(pref, uri);
            this.wsCheck(";");
            IO base = this.sc.baseIO();
            byte[] p = Token.token(base == null ? "" : base.path());
            this.ctx.modParsed.put(p, uri);
            this.ctx.modStack.push(p);
            this.prolog1();
            this.prolog2();
            this.finish(null, check);
            this.ctx.modStack.pop();
            return new LibraryModule(this.module, this.moduleDoc, this.sc);
        }
        catch (QueryException ex) {
            this.mark();
            ex.pos(this);
            throw ex;
        }
    }

    private void init() throws QueryException {
        int cp;
        boolean hs;
        IO baseIO = this.sc.baseIO();
        String string = baseIO == null ? null : (this.file = this.ctx.context.user.has(Perm.ADMIN) ? baseIO.path() : baseIO.name());
        if (!this.more()) {
            throw this.error(Err.QUERYEMPTY, new Object[0]);
        }
        for (int i = 0; i < this.length; i += hs ? Character.charCount(cp) : 1) {
            cp = this.input.charAt(i);
            boolean bl = hs = cp >= 55296;
            if (hs) {
                cp = this.input.codePointAt(i);
            }
            if (XMLToken.valid(cp)) continue;
            this.pos = i;
            throw this.error(Err.QUERYINV, cp);
        }
    }

    private void finish(MainModule mm, boolean check) throws QueryException {
        byte[] empty;
        if (this.more()) {
            if (this.alter != null) {
                throw this.error();
            }
            String rest = this.rest();
            ++this.pos;
            if (mm == null) {
                throw this.error(Err.MODEXPR, rest);
            }
            throw this.error(Err.QUERYEND, rest);
        }
        this.assignURI(0);
        if (this.sc.elemNS != null) {
            this.sc.ns.add(Token.EMPTY, this.sc.elemNS, null);
        }
        if (this.sc.decFormats.get(empty = new QNm(Token.EMPTY).id()) == null) {
            this.sc.decFormats.put(empty, new DecFormatter());
        }
        if (check) {
            this.ctx.funcs.check(this.ctx);
            this.ctx.vars.check();
            if (this.ctx.updates != null) {
                this.ctx.funcs.checkUp();
                this.ctx.vars.checkUp();
                if (mm != null) {
                    mm.expr.checkUp();
                }
            }
        }
    }

    private void versionDecl() throws QueryException {
        int i = this.pos;
        if (!this.wsConsumeWs("xquery")) {
            return;
        }
        boolean version = this.wsConsumeWs("version");
        if (version) {
            String ver = Token.string(this.stringLiteral());
            if (ver.equals("1.0")) {
                this.sc.xquery3 = false;
            } else if (Token.eq(ver, "1.1", "3.0")) {
                this.sc.xquery3 = true;
            } else {
                throw this.error(Err.XQUERYVER, ver);
            }
        }
        if ((version || this.sc.xquery3()) && this.wsConsumeWs("encoding")) {
            String enc = Token.string(this.stringLiteral());
            if (!Token.supported(enc)) {
                throw this.error(Err.XQUERYENC2, enc);
            }
        } else if (!version) {
            this.pos = i;
            return;
        }
        this.wsCheck(";");
    }

    /*
     * Enabled aggressive block sorting
     */
    private void prolog1() throws QueryException {
        while (true) {
            block12: {
                int i;
                block13: {
                    block20: {
                        block19: {
                            block18: {
                                block17: {
                                    block16: {
                                        block15: {
                                            block14: {
                                                i = this.pos;
                                                if (!this.wsConsumeWs("declare")) break block13;
                                                if (!this.wsConsumeWs("default")) break block14;
                                                if (!(this.defaultNamespaceDecl() || this.defaultCollationDecl() || this.emptyOrderDecl() || this.sc.xquery3() && this.decimalFormatDecl(true))) {
                                                    throw this.error(Err.DECLINCOMPLETE, new Object[0]);
                                                }
                                                break block12;
                                            }
                                            if (!this.wsConsumeWs("boundary-space")) break block15;
                                            this.boundarySpaceDecl();
                                            break block12;
                                        }
                                        if (!this.wsConsumeWs("base-uri")) break block16;
                                        this.baseURIDecl();
                                        break block12;
                                    }
                                    if (!this.wsConsumeWs("construction")) break block17;
                                    this.constructionDecl();
                                    break block12;
                                }
                                if (!this.wsConsumeWs("ordering")) break block18;
                                this.orderingModeDecl();
                                break block12;
                            }
                            if (!this.wsConsumeWs("revalidation")) break block19;
                            this.revalidationDecl();
                            break block12;
                        }
                        if (!this.wsConsumeWs("copy-namespaces")) break block20;
                        this.copyNamespacesDecl();
                        break block12;
                    }
                    if (this.sc.xquery3() && this.wsConsumeWs("decimal-format")) {
                        this.decimalFormatDecl(false);
                        break block12;
                    } else if (this.wsConsumeWs("namespace")) {
                        this.namespaceDecl();
                        break block12;
                    } else {
                        if (!this.wsConsumeWs("ft-option")) {
                            this.pos = i;
                            return;
                        }
                        FTOpt fto = new FTOpt();
                        while (this.ftMatchOption(fto)) {
                        }
                        this.ctx.ftOpt().copy(fto);
                    }
                    break block12;
                }
                if (!this.wsConsumeWs("import")) {
                    return;
                }
                if (this.wsConsumeWs("schema")) {
                    this.schemaImport();
                } else {
                    if (!this.wsConsumeWs("module")) {
                        this.pos = i;
                        return;
                    }
                    this.moduleImport();
                }
            }
            this.currDoc.setLength(0);
            this.skipWs();
            this.check(59);
        }
    }

    private void prolog2() throws QueryException {
        while (true) {
            int i = this.pos;
            if (!this.wsConsumeWs("declare")) break;
            if (this.sc.xquery3() && this.wsConsumeWs("context")) {
                this.contextItemDecl();
            } else if (this.wsConsumeWs("option")) {
                this.optionDecl();
            } else {
                if (this.wsConsumeWs("default")) {
                    throw this.error(Err.PROLOGORDER, new Object[0]);
                }
                Ann ann = new Ann();
                while (true) {
                    if (this.wsConsumeWs("updating")) {
                        ann.add(Ann.Q_UPDATING, Empty.SEQ, this.info());
                        continue;
                    }
                    if (!this.sc.xquery3() || !this.consume(37)) break;
                    this.annotation(ann);
                }
                if (this.wsConsumeWs("variable")) {
                    if (ann.contains(Ann.Q_UPDATING)) {
                        throw this.error(Err.UPDATINGVAR, new Object[0]);
                    }
                    ann.check(true);
                    this.varDecl(ann);
                } else if (this.wsConsumeWs("function")) {
                    ann.check(false);
                    this.functionDecl(ann);
                } else {
                    if (!ann.isEmpty()) {
                        throw this.error(Err.VARFUNC, new Object[0]);
                    }
                    this.pos = i;
                    break;
                }
            }
            this.currDoc.setLength(0);
            this.skipWs();
            this.check(59);
        }
    }

    private Ann annotations() throws QueryException {
        Ann ann = new Ann();
        while (this.wsConsume("%")) {
            this.annotation(ann);
        }
        ann.check(false);
        this.skipWs();
        return ann;
    }

    private void annotation(Ann ann) throws QueryException {
        this.skipWs();
        InputInfo info = this.info();
        QNm name = this.eQName(Err.QNAMEINV, QueryText.XQURI);
        ValueBuilder vb = new ValueBuilder();
        if (this.wsConsumeWs("(")) {
            do {
                Expr ex;
                if (!((ex = this.literal()) instanceof Item)) {
                    throw this.error(Err.ANNVALUE, new Object[0]);
                }
                vb.add((Item)ex);
            } while (this.wsConsumeWs(","));
            this.wsCheck(")");
        }
        this.skipWs();
        ann.add(name, vb.value(), info);
    }

    private void namespaceDecl() throws QueryException {
        byte[] pref = this.ncName(Err.NONAME);
        this.wsCheck("=");
        byte[] uri = this.stringLiteral();
        if (this.sc.ns.staticURI(pref) != null) {
            throw this.error(Err.DUPLNSDECL, new Object[]{pref});
        }
        this.sc.ns.add(pref, uri, this.info());
        this.namespaces.put(pref, uri);
    }

    private void revalidationDecl() throws QueryException {
        if (!this.decl.add("revalidation")) {
            throw this.error(Err.DUPLREVAL, new Object[0]);
        }
        if (this.wsConsumeWs("strict") || this.wsConsumeWs("lax")) {
            throw this.error(Err.NOREVAL, new Object[0]);
        }
        this.wsCheck("skip");
    }

    private void boundarySpaceDecl() throws QueryException {
        if (!this.decl.add("boundary-space")) {
            throw this.error(Err.DUPLBOUND, new Object[0]);
        }
        boolean spaces = this.wsConsumeWs("preserve");
        if (!spaces) {
            this.wsCheck("strip");
        }
        this.sc.spaces = spaces;
    }

    private boolean defaultNamespaceDecl() throws QueryException {
        boolean elem = this.wsConsumeWs("element");
        if (!elem && !this.wsConsumeWs("function")) {
            return false;
        }
        this.wsCheck("namespace");
        byte[] uri = this.stringLiteral();
        if (Token.eq(QueryText.XMLURI, uri)) {
            throw this.error(Err.BINDXMLURI, uri, Token.XML);
        }
        if (Token.eq(QueryText.XMLNSURI, uri)) {
            throw this.error(Err.BINDXMLURI, uri, Token.XMLNS);
        }
        if (elem) {
            if (!this.decl.add("element")) {
                throw this.error(Err.DUPLNS, new Object[0]);
            }
            this.sc.elemNS = uri.length == 0 ? null : uri;
        } else {
            if (!this.decl.add("function")) {
                throw this.error(Err.DUPLNS, new Object[0]);
            }
            this.sc.funcNS = uri.length == 0 ? null : uri;
        }
        return true;
    }

    private void optionDecl() throws QueryException {
        this.skipWs();
        QNm qnm = this.eQName(Err.QNAMEINV, this.sc.xquery3() ? QueryText.XQURI : URICHECK);
        byte[] val = this.stringLiteral();
        String name = Token.string(qnm.local());
        if (this.sc.xquery3() && Token.eq(qnm.uri(), QueryText.OUTPUTURI)) {
            if (this.module != null) {
                throw this.error(Err.MODOUT, new Object[0]);
            }
            if (this.ctx.serialOpts == null) {
                this.ctx.serialOpts = this.ctx.context.options.get(MainOptions.SERIALIZER);
            }
            if (!this.decl.add("S " + name)) {
                throw this.error(Err.OUTDUPL, name);
            }
            try {
                this.ctx.serialOpts.assign(name, Token.string(val));
            }
            catch (BaseXException ex) {
                for (Option<?> o : this.ctx.serialOpts) {
                    if (!o.name().equals(name)) continue;
                    throw this.error(Err.SERANY, ex);
                }
                throw this.error(Err.OUTINVALID, ex);
            }
            if (name.equals(SerializerOptions.PARAMETER_DOCUMENT.name())) {
                IO io = IO.get(Token.string(this.resolvedUri(val).string()));
                try {
                    ANode node = new DBNode(io, this.ctx.context.options).children().next();
                    InputInfo info = this.info();
                    FuncOptions.serializer(node, this.ctx.serialOpts, info);
                    HashMap<String, String> free = this.ctx.serialOpts.free();
                    if (!free.isEmpty()) {
                        throw Err.SERWHICH.get(info, free.keySet().iterator().next());
                    }
                    StringOption cm = SerializerOptions.USE_CHARACTER_MAPS;
                    if (!this.ctx.serialOpts.get(cm).isEmpty()) {
                        throw Err.SERWHICH.get(info, cm.name());
                    }
                }
                catch (IOException ex) {
                    throw this.error(Err.OUTDOC, new Object[]{val});
                }
            }
        } else {
            if (this.sc.xquery3() && Token.eq(qnm.uri(), QueryText.XQURI)) {
                throw this.error(Err.DECLOPTION, qnm);
            }
            if (Token.eq(qnm.uri(), QueryText.DBURI)) {
                String ukey = name.toUpperCase(Locale.ENGLISH);
                Option<?> opt = this.ctx.context.options.option(ukey);
                if (opt == null) {
                    throw this.error(Err.BASX_OPTIONS, ukey);
                }
                this.ctx.staticOpts.put(opt, this.ctx.context.options.get(opt));
                this.ctx.tempOpts.add(name).add(Token.string(val));
            } else if (Token.eq(qnm.uri(), QueryText.QUERYURI)) {
                if (name.equals("read-lock")) {
                    for (byte[] lock : Token.split(val, 44)) {
                        this.ctx.readLocks.add("+" + Token.string(lock).trim());
                    }
                } else if (name.equals("write-lock")) {
                    for (byte[] lock : Token.split(val, 44)) {
                        this.ctx.writeLocks.add("+" + Token.string(lock).trim());
                    }
                } else {
                    throw this.error(Err.BASX_OPTIONS, name);
                }
            }
        }
    }

    private void orderingModeDecl() throws QueryException {
        if (!this.decl.add("ordering")) {
            throw this.error(Err.DUPLORD, new Object[0]);
        }
        this.sc.ordered = this.wsConsumeWs("ordered");
        if (!this.sc.ordered) {
            this.wsCheck("unordered");
        }
    }

    private boolean emptyOrderDecl() throws QueryException {
        if (!this.wsConsumeWs("order")) {
            return false;
        }
        this.wsCheck("empty");
        if (!this.decl.add("empty")) {
            throw this.error(Err.DUPLORDEMP, new Object[0]);
        }
        this.sc.orderGreatest = this.wsConsumeWs("greatest");
        if (!this.sc.orderGreatest) {
            this.wsCheck("least");
        }
        return true;
    }

    private void copyNamespacesDecl() throws QueryException {
        if (!this.decl.add("copy-namespaces")) {
            throw this.error(Err.DUPLCOPYNS, new Object[0]);
        }
        this.sc.preserveNS = this.wsConsumeWs("preserve");
        if (!this.sc.preserveNS) {
            this.wsCheck("no-preserve");
        }
        this.wsCheck(",");
        this.sc.inheritNS = this.wsConsumeWs("inherit");
        if (!this.sc.inheritNS) {
            this.wsCheck("no-inherit");
        }
    }

    private boolean decimalFormatDecl(boolean def) throws QueryException {
        int n;
        QNm name;
        if (def && !this.wsConsumeWs("decimal-format")) {
            return false;
        }
        QNm qNm = name = def ? new QNm() : this.eQName(Err.QNAMEINV, null);
        if (this.sc.decFormats.get(name.id()) != null) {
            throw this.error(Err.DECDUPL, new Object[0]);
        }
        TokenMap map = new TokenMap();
        do {
            n = map.size();
            this.skipWs();
            byte[] prop = this.ncName(null);
            for (byte[] s : QueryText.DECFORMATS) {
                if (!Token.eq(prop, s)) continue;
                if (map.get(s) != null) {
                    throw this.error(Err.DECDUPLPROP, new Object[]{s});
                }
                this.wsCheck("=");
                map.put(s, this.stringLiteral());
                break;
            }
            if (!map.isEmpty()) continue;
            throw this.error(Err.NODECLFORM, new Object[]{prop});
        } while (n != map.size());
        this.sc.decFormats.put(name.id(), new DecFormatter(this.info(), map));
        return true;
    }

    private boolean defaultCollationDecl() throws QueryException {
        if (!this.wsConsumeWs("collation")) {
            return false;
        }
        if (!this.decl.add("collation")) {
            throw this.error(Err.DUPLCOLL, new Object[0]);
        }
        this.sc.collation = Collation.get(this.stringLiteral(), this.ctx, this.sc, this.info(), Err.WHICHDEFCOLL);
        return true;
    }

    private void baseURIDecl() throws QueryException {
        if (!this.decl.add("base-uri")) {
            throw this.error(Err.DUPLBASE, new Object[0]);
        }
        byte[] base = this.stringLiteral();
        if (base.length != 0) {
            this.sc.baseURI(Token.string(base));
        }
    }

    private void schemaImport() throws QueryException {
        byte[] pref = null;
        if (this.wsConsumeWs("namespace")) {
            pref = this.ncName(Err.NONAME);
            if (Token.eq(pref, Token.XML, Token.XMLNS)) {
                throw this.error(Err.BINDXML, new Object[]{pref});
            }
            this.wsCheck("=");
        } else if (this.wsConsumeWs("default")) {
            this.wsCheck("element");
            this.wsCheck("namespace");
        }
        byte[] ns = this.stringLiteral();
        if (pref != null && ns.length == 0) {
            throw this.error(Err.NSEMPTY, new Object[0]);
        }
        if (!Uri.uri(ns).isValid()) {
            throw this.error(Err.INVURI, new Object[]{ns});
        }
        if (this.wsConsumeWs("at")) {
            do {
                if (Uri.uri(ns = this.stringLiteral()).isValid()) continue;
                throw this.error(Err.INVURI, new Object[]{ns});
            } while (this.wsConsumeWs(","));
        }
        throw this.error(Err.IMPLSCHEMA, new Object[0]);
    }

    private void moduleImport() throws QueryException {
        byte[] uri;
        byte[] pref = Token.EMPTY;
        if (this.wsConsumeWs("namespace")) {
            pref = this.ncName(Err.NONAME);
            this.wsCheck("=");
        }
        if ((uri = Token.trim(this.stringLiteral())).length == 0) {
            throw this.error(Err.NSMODURI, new Object[0]);
        }
        if (!Uri.uri(uri).isValid()) {
            throw this.error(Err.INVURI, new Object[]{uri});
        }
        if (this.modules.contains(uri)) {
            throw this.error(Err.DUPLMODULE, new Object[]{uri});
        }
        this.modules.add(uri);
        if (pref != Token.EMPTY) {
            if (this.sc.ns.staticURI(pref) != null) {
                throw this.error(Err.DUPLNSDECL, new Object[]{pref});
            }
            this.sc.ns.add(pref, uri, this.info());
            this.namespaces.put(pref, uri);
        }
        if (this.wsConsumeWs("at")) {
            do {
                this.module(this.stringLiteral(), uri);
            } while (this.wsConsumeWs(","));
            return;
        }
        byte[] path = this.ctx.modDeclared.get(uri);
        if (path != null) {
            this.module(path, uri);
            return;
        }
        for (byte[] u : Function.URIS.values()) {
            if (!Token.eq(uri, u)) continue;
            return;
        }
        if (this.ctx.modules.addImport(uri, this.info(), this)) {
            return;
        }
        throw this.error(Err.WHICHMODULE, new Object[]{uri});
    }

    public void module(byte[] path, byte[] uri) throws QueryException {
        IO io = this.sc.io(Token.string(path));
        byte[] p = Token.token(io.path());
        byte[] u = this.ctx.modParsed.get(p);
        if (u != null) {
            if (!Token.eq(uri, u)) {
                throw this.error(Err.WRONGMODULE, uri, this.ctx.context.user.has(Perm.ADMIN) ? io.path() : io.name());
            }
            if (!this.sc.xquery3() && this.ctx.modStack.contains(p)) {
                throw this.error(Err.CIRCMODULE, new Object[0]);
            }
            return;
        }
        this.ctx.modParsed.put(p, uri);
        String qu = null;
        try {
            qu = Token.string(io.read());
        }
        catch (IOException ex) {
            throw this.error(Err.WHICHMODFILE, this.ctx.context.user.has(Perm.ADMIN) ? io.path() : io.name());
        }
        this.ctx.modStack.push(p);
        StaticContext sub = new StaticContext(this.sc.xquery3());
        LibraryModule lib = new QueryParser(qu, io.path(), this.ctx, sub).parseLibrary(false);
        byte[] muri = lib.name.uri();
        if (!Token.eq(uri, muri)) {
            throw this.error(Err.WRONGMODULE, muri, this.file);
        }
        if (sub.initType != null) {
            if (this.sc.initType == null) {
                this.sc.initType = sub.initType;
            } else if (!sub.initType.eq(this.sc.initType)) {
                throw this.error(Err.CITYPES, sub.initType, this.sc.initType);
            }
        }
        this.ctx.modStack.pop();
    }

    private void contextItemDecl() throws QueryException {
        this.wsCheck("item");
        if (!this.decl.add("item")) {
            throw this.error(Err.DUPLITEM, new Object[0]);
        }
        if (this.wsConsumeWs("as")) {
            SeqType type = this.itemType();
            if (this.sc.initType == null) {
                this.sc.initType = type;
            } else if (!this.sc.initType.eq(type)) {
                throw this.error(Err.CITYPES, this.sc.initType, type);
            }
        }
        if (!this.wsConsumeWs("external")) {
            this.wsCheck(":=");
        } else if (!this.wsConsumeWs(":=")) {
            return;
        }
        this.pushVarContext(null);
        Expr e = this.check(this.single(), Err.NOVARDECL);
        SeqType type = this.sc.initType == null ? SeqType.ITEM : this.sc.initType;
        VarScope scope = this.popVarContext();
        this.ctx.ctxItem = new MainModule(e, scope, type, this.currDoc.toString(), this.sc, this.info());
        if (this.module != null) {
            throw this.error(Err.DECITEM, new Object[0]);
        }
        if (e.has(Expr.Flag.UPD)) {
            throw this.error(Err.UPCTX, e);
        }
    }

    private void varDecl(Ann ann) throws QueryException {
        Expr bind;
        QNm vn = this.varName();
        SeqType tp = this.optAsType();
        if (this.module != null && !Token.eq(vn.uri(), this.module.uri())) {
            throw this.error(Err.MODNS, vn);
        }
        this.pushVarContext(null);
        boolean external = this.wsConsumeWs("external");
        if (external) {
            bind = this.sc.xquery3() && this.wsConsumeWs(":=") ? this.check(this.single(), Err.NOVARDECL) : null;
        } else {
            this.wsCheck(":=");
            bind = this.check(this.single(), Err.NOVARDECL);
        }
        VarScope scope = this.popVarContext();
        this.vars.add(this.ctx.vars.declare(vn, tp, ann, bind, external, this.sc, scope, this.currDoc.toString(), this.info()));
    }

    private SeqType optAsType() throws QueryException {
        return this.wsConsumeWs("as") ? this.sequenceType() : null;
    }

    private void constructionDecl() throws QueryException {
        if (!this.decl.add("construction")) {
            throw this.error(Err.DUPLCONS, new Object[0]);
        }
        this.sc.strip = this.wsConsumeWs("strip");
        if (!this.sc.strip) {
            this.wsCheck("preserve");
        }
    }

    private void functionDecl(Ann ann) throws QueryException {
        InputInfo ii = this.info();
        QNm name = this.eQName(Err.FUNCNAME, this.sc.funcNS);
        if (this.sc.xquery3() && this.keyword(name)) {
            throw this.error(Err.RESERVED, new Object[]{name.local()});
        }
        this.wsCheck("(");
        if (this.module != null && !Token.eq(name.uri(), this.module.uri())) {
            throw this.error(Err.MODNS, name);
        }
        this.pushVarContext(null);
        Var[] args = this.paramList();
        this.wsCheck(")");
        SeqType tp = this.optAsType();
        if (ann.contains(Ann.Q_UPDATING)) {
            this.ctx.updating(false);
        }
        Expr body = this.wsConsumeWs("external") ? null : this.enclosed(Err.NOFUNBODY);
        VarScope scope = this.popVarContext();
        this.funcs.add(this.ctx.funcs.declare(ann, name, args, tp, body, this.sc, scope, this.currDoc.toString(), ii));
    }

    private boolean keyword(QNm name) {
        return !name.hasPrefix() && (this.sc.xquery3() ? KEYWORDS30 : KEYWORDS10).contains(name.string());
    }

    private Var[] paramList() throws QueryException {
        Var[] args = new Var[]{};
        do {
            this.skipWs();
            if (this.curr() != '$') {
                if (args.length == 0) break;
                this.check(36);
            }
            Var var = this.addVar(this.varName(), this.optAsType(), true);
            for (Var v : args) {
                if (!v.name.eq(var.name)) continue;
                throw this.error(Err.FUNCDUPL, var);
            }
            args = Array.add(args, new Var[args.length + 1], var);
        } while (this.consume(44));
        return args;
    }

    private Expr enclosed(Err err) throws QueryException {
        this.wsCheck("{");
        Expr e = this.check(this.expr(), err);
        this.wsCheck("}");
        return e;
    }

    private Expr expr() throws QueryException {
        Expr e = this.single();
        if (e == null) {
            if (this.more()) {
                return null;
            }
            throw this.alter == null ? this.error(Err.NOEXPR, new Object[0]) : this.error();
        }
        if (!this.wsConsume(",")) {
            return e;
        }
        ExprList el = new ExprList(e);
        do {
            this.add(el, this.single());
        } while (this.wsConsume(","));
        return new List(this.info(), el.finish());
    }

    private Expr single() throws QueryException {
        this.alter = null;
        Expr e = this.flwor();
        if (e == null) {
            e = this.quantified();
        }
        if (e == null) {
            e = this.switchh();
        }
        if (e == null) {
            e = this.typeswitch();
        }
        if (e == null) {
            e = this.iff();
        }
        if (e == null) {
            e = this.tryCatch();
        }
        if (e == null) {
            e = this.insert();
        }
        if (e == null) {
            e = this.deletee();
        }
        if (e == null) {
            e = this.rename();
        }
        if (e == null) {
            e = this.replace();
        }
        if (e == null) {
            e = this.transform();
        }
        if (e == null) {
            e = this.or();
        }
        return e;
    }

    private Expr flwor() throws QueryException {
        int s = this.openSubScope();
        LinkedList<GFLWOR.Clause> clauses = this.initialClause(null);
        if (clauses == null) {
            return null;
        }
        TokenObjMap<Var> curr = new TokenObjMap<Var>();
        for (GFLWOR.Clause fl : clauses) {
            for (Var v : fl.vars()) {
                curr.put(v.name.id(), v);
            }
        }
        while (true) {
            boolean stable;
            int size = clauses.size();
            this.initialClause(clauses);
            for (int i = size; i < clauses.size(); ++i) {
                for (Var v : clauses.get(i).vars()) {
                    curr.put(v.name.id(), v);
                }
            }
            if (size < clauses.size()) continue;
            if (this.wsConsumeWs("where")) {
                this.alterPos = this.pos;
                clauses.add(new Where(this.check(this.single(), Err.NOWHERE), this.info()));
                this.alter = Err.NOWHERE;
            }
            if (this.sc.xquery3() && this.wsConsumeWs("group")) {
                this.wsCheck("by");
                this.skipWs();
                this.alterPos = this.pos;
                GroupBy.Spec[] specs = this.groupSpecs(clauses);
                ArrayList<VarRef> ng = new ArrayList<VarRef>();
                for (GroupBy.Spec spec : specs) {
                    curr.put(spec.var.name.id(), spec.var);
                }
                block6: for (Var v : curr.values()) {
                    for (GroupBy.Spec spec : specs) {
                        if (spec.var.is(v)) continue block6;
                    }
                    ng.add(new VarRef(specs[0].info, v));
                }
                Var[] ngrp = new Var[ng.size()];
                int i = ng.size();
                while (--i >= 0) {
                    VarRef v = (VarRef)ng.get(i);
                    Var nv = this.addVar(v.var.name, null, false);
                    if (v.type().one()) {
                        nv.refineType(SeqType.get(v.type().type, SeqType.Occ.ONE_MORE), this.ctx, this.info());
                    }
                    ngrp[i] = nv;
                    curr.put(nv.name.id(), nv);
                }
                VarRef[] pre = new VarRef[ng.size()];
                clauses.add(new GroupBy(specs, ng.toArray(pre), ngrp, specs[0].info));
                this.alter = Err.GRPBY;
            }
            if (stable = this.wsConsumeWs("stable")) {
                this.wsCheck("order");
            }
            if (stable || this.wsConsumeWs("order")) {
                this.wsCheck("by");
                this.alterPos = this.pos;
                OrderBy.Key[] ob = null;
                do {
                    OrderBy.Key[] keyArray;
                    OrderBy.Key key = this.orderSpec();
                    if (ob == null) {
                        OrderBy.Key[] keyArray2 = new OrderBy.Key[1];
                        keyArray = keyArray2;
                        keyArray2[0] = key;
                        continue;
                    }
                    keyArray = ob = Array.add(ob, key);
                } while (this.wsConsume(","));
                VarRef[] vs = new VarRef[curr.size()];
                int i = 0;
                for (Var v : curr.values()) {
                    vs[i++] = new VarRef(ob[0].info, v);
                }
                clauses.add(new OrderBy(vs, ob, ob[0].info));
                this.alter = Err.ORDERBY;
            }
            if (this.sc.xquery3() && this.wsConsumeWs("count", "$", Err.NOCOUNT)) {
                Var v = this.addVar(this.varName(), SeqType.ITR, false);
                curr.put(v.name.id(), v);
                clauses.add(new Count(v, this.info()));
            }
            if (!this.sc.xquery3() || size >= clauses.size()) break;
        }
        if (!this.wsConsumeWs("return")) {
            throw this.alter == null ? this.error(Err.FLWORRETURN, new Object[0]) : this.error();
        }
        Expr ret = this.check(this.single(), Err.NORETURN);
        this.closeSubScope(s);
        return new GFLWOR(clauses.get((int)0).info, clauses, ret);
    }

    private LinkedList<GFLWOR.Clause> initialClause(LinkedList<GFLWOR.Clause> clauses) throws QueryException {
        boolean slide;
        boolean let;
        LinkedList<GFLWOR.Clause> cls = clauses;
        boolean bl = let = this.wsConsumeWs("let", "score", Err.NOLET) || this.wsConsumeWs("let", "$", Err.NOLET);
        if (let || this.wsConsumeWs("for", "$", Err.NOFOR)) {
            if (cls == null) {
                cls = new LinkedList();
            }
            if (let) {
                this.letClause(cls);
            } else {
                this.forClause(cls);
            }
        } else if (this.sc.xquery3() && ((slide = this.wsConsumeWs("for", "sliding", Err.NOWINDOW)) || this.wsConsumeWs("for", "tumbling", Err.NOWINDOW))) {
            if (cls == null) {
                cls = new LinkedList();
            }
            cls.add(this.windowClause(slide));
        }
        return cls;
    }

    private void forClause(LinkedList<GFLWOR.Clause> cls) throws QueryException {
        do {
            Var scr;
            boolean emp;
            QNm nm = this.varName();
            SeqType tp = this.optAsType();
            boolean bl = emp = this.sc.xquery3() && this.wsConsume("allowing");
            if (emp) {
                this.wsCheck("empty");
            }
            QNm p = this.wsConsumeWs("at") ? this.varName() : null;
            QNm s = this.wsConsumeWs("score") ? this.varName() : null;
            this.wsCheck("in");
            Expr e = this.check(this.single(), Err.NOVARDECL);
            Var var = this.addVar(nm, tp, false);
            Var ps = p != null ? this.addVar(p, SeqType.ITR, false) : null;
            Var var2 = scr = s != null ? this.addVar(s, SeqType.DBL, false) : null;
            if (p != null) {
                if (nm.eq(p)) {
                    throw this.error(Err.DUPLVAR, var);
                }
                if (s != null && p.eq(s)) {
                    throw this.error(Err.DUPLVAR, ps);
                }
            }
            if (s != null && nm.eq(s)) {
                throw this.error(Err.DUPLVAR, var);
            }
            cls.add(new For(var, ps, scr, e, emp, this.info()));
        } while (this.wsConsumeWs(","));
    }

    private void letClause(LinkedList<GFLWOR.Clause> cls) throws QueryException {
        do {
            boolean score = this.wsConsumeWs("score");
            QNm nm = this.varName();
            SeqType tp = score ? SeqType.DBL : this.optAsType();
            this.wsCheck(":=");
            Expr e = this.check(this.single(), Err.NOVARDECL);
            cls.add(new Let(this.addVar(nm, tp, false), e, score, this.info()));
        } while (this.wsConsume(","));
    }

    private Window windowClause(boolean slide) throws QueryException {
        boolean check;
        this.wsCheck(slide ? "sliding" : "tumbling");
        this.wsCheck("window");
        this.skipWs();
        QNm nm = this.varName();
        SeqType tp = this.optAsType();
        this.wsCheck("in");
        Expr e = this.check(this.single(), Err.NOVARDECL);
        this.wsCheck("start");
        Window.Condition start = this.windowCond(true);
        Window.Condition end = null;
        boolean only = this.wsConsume("only");
        boolean bl = check = slide || only;
        if (check || this.wsConsume("end")) {
            if (check) {
                this.wsCheck("end");
            }
            end = this.windowCond(false);
        }
        return new Window(this.info(), slide, this.addVar(nm, tp, false), e, start, only, end);
    }

    private Window.Condition windowCond(boolean start) throws QueryException {
        this.skipWs();
        InputInfo ii = this.info();
        Var var = this.curr(36) ? this.addVar(this.varName(), null, false) : null;
        Var at = this.wsConsumeWs("at") ? this.addVar(this.varName(), null, false) : null;
        Var prv = this.wsConsumeWs("previous") ? this.addVar(this.varName(), null, false) : null;
        Var nxt = this.wsConsumeWs("next") ? this.addVar(this.varName(), null, false) : null;
        this.wsCheck("when");
        return new Window.Condition(start, var, at, prv, nxt, this.check(this.single(), Err.NOEXPR), ii);
    }

    private OrderBy.Key orderSpec() throws QueryException {
        boolean least;
        Expr e = this.check(this.single(), Err.ORDERBY);
        boolean desc = false;
        if (!this.wsConsumeWs("ascending")) {
            desc = this.wsConsumeWs("descending");
        }
        boolean bl = least = !this.sc.orderGreatest;
        if (this.wsConsumeWs("empty")) {
            boolean bl2 = least = !this.wsConsumeWs("greatest");
            if (least) {
                this.wsCheck("least");
            }
        }
        Collation coll = this.wsConsumeWs("collation") ? Collation.get(this.stringLiteral(), this.ctx, this.sc, this.info(), Err.FLWORCOLL) : this.sc.collation;
        return new OrderBy.Key(this.info(), e, desc, least, coll);
    }

    private GroupBy.Spec[] groupSpecs(LinkedList<GFLWOR.Clause> cl) throws QueryException {
        GroupBy.Spec[] specs = null;
        do {
            Expr by;
            InputInfo ii = this.info();
            QNm name = this.varName();
            SeqType type = this.optAsType();
            if (type != null || this.wsConsume(":=")) {
                if (type != null) {
                    this.wsCheck(":=");
                }
                by = this.check(this.single(), Err.NOVARDECL);
            } else {
                VarRef vr = this.resolveLocalVar(name, ii);
                boolean dec = false;
                if (vr != null) {
                    for (GFLWOR.Clause f : cl) {
                        if (!f.declares(vr.var)) continue;
                        dec = true;
                        break;
                    }
                    if (!dec && specs != null) {
                        for (void var12_15 : specs) {
                            if (!var12_15.var.is(vr.var)) continue;
                            dec = true;
                            break;
                        }
                    }
                }
                if (!dec) {
                    throw this.error(Err.GVARNOTDEFINED, '$' + Token.string(name.string()));
                }
                by = vr;
            }
            Collation coll = this.wsConsumeWs("collation") ? Collation.get(this.stringLiteral(), this.ctx, this.sc, this.info(), Err.FLWORCOLL) : this.sc.collation;
            GroupBy.Spec spec = new GroupBy.Spec(ii, this.addVar(name, type, false), by, coll);
            if (specs == null) {
                specs = new GroupBy.Spec[]{spec};
                continue;
            }
            int i = specs.length;
            while (--i >= 0) {
                if (!specs[i].var.name.eq(spec.var.name)) continue;
                specs[i].occluded = true;
                break;
            }
            specs = Array.add(specs, spec);
        } while (this.wsConsumeWs(","));
        return specs;
    }

    private Expr quantified() throws QueryException {
        boolean some = this.wsConsumeWs("some", "$", Err.NOSOME);
        if (!some && !this.wsConsumeWs("every", "$", Err.NOSOME)) {
            return null;
        }
        int s = this.openSubScope();
        For[] fl = new For[]{};
        do {
            QNm nm = this.varName();
            SeqType tp = this.optAsType();
            this.wsCheck("in");
            Expr e = this.check(this.single(), Err.NOSOME);
            fl = Array.add(fl, new For(this.addVar(nm, tp, false), null, null, e, false, this.info()));
        } while (this.wsConsumeWs(","));
        this.wsCheck("satisfies");
        Expr e = this.check(this.single(), Err.NOSOME);
        this.closeSubScope(s);
        return new Quantifier(this.info(), fl, e, !some);
    }

    private Expr switchh() throws QueryException {
        ExprList cases;
        if (!this.sc.xquery3() || !this.wsConsumeWs("switch", "(", Err.TYPEPAR)) {
            return null;
        }
        this.wsCheck("(");
        Expr expr = this.check(this.expr(), Err.NOSWITCH);
        SwitchCase[] exprs = new SwitchCase[]{};
        this.wsCheck(")");
        do {
            cases = new ExprList(null);
            while (this.wsConsumeWs("case")) {
                this.add(cases, this.single());
            }
            if (cases.size() == 1) {
                if (exprs.length == 0) {
                    throw this.error(Err.WRONGCHAR, "case", this.found());
                }
                this.wsCheck("default");
            }
            this.wsCheck("return");
            cases.set(0, this.check(this.single(), Err.NOSWITCH));
            exprs = Array.add(exprs, new SwitchCase(this.info(), cases.finish()));
        } while (cases.size() != 1);
        return new Switch(this.info(), expr, exprs);
    }

    private Expr typeswitch() throws QueryException {
        boolean cs;
        if (!this.wsConsumeWs("typeswitch", "(", Err.TYPEPAR)) {
            return null;
        }
        this.wsCheck("(");
        Expr ts = this.check(this.expr(), Err.NOTYPESWITCH);
        this.wsCheck(")");
        TypeCase[] cases = new TypeCase[]{};
        ArrayList<SeqType> types = new ArrayList<SeqType>();
        int s = this.openSubScope();
        do {
            types.clear();
            cs = this.wsConsumeWs("case");
            if (!cs) {
                this.wsCheck("default");
                this.skipWs();
            }
            Var var = null;
            if (this.curr(36)) {
                var = this.addVar(this.varName(), null, false);
                if (cs) {
                    this.wsCheck("as");
                }
            }
            if (cs) {
                do {
                    types.add(this.sequenceType());
                } while (this.sc.xquery3() && this.wsConsume("|"));
            }
            this.wsCheck("return");
            Expr ret = this.check(this.single(), Err.NOTYPESWITCH);
            cases = Array.add(cases, new TypeCase(this.info(), var, types.toArray(new SeqType[types.size()]), ret));
            this.closeSubScope(s);
        } while (cs);
        if (cases.length == 1) {
            throw this.error(Err.NOTYPESWITCH, new Object[0]);
        }
        return new TypeSwitch(this.info(), ts, cases);
    }

    private Expr iff() throws QueryException {
        if (!this.wsConsumeWs("if", "(", Err.IFPAR)) {
            return null;
        }
        this.wsCheck("(");
        Expr iff = this.check(this.expr(), Err.NOIF);
        this.wsCheck(")");
        if (!this.wsConsumeWs("then")) {
            throw this.error(Err.NOIF, new Object[0]);
        }
        Expr thn = this.check(this.single(), Err.NOIF);
        if (!this.wsConsumeWs("else")) {
            throw this.error(Err.NOIF, new Object[0]);
        }
        Expr els = this.check(this.single(), Err.NOIF);
        return new If(this.info(), iff, thn, els);
    }

    private Expr or() throws QueryException {
        Expr e = this.and();
        if (!this.wsConsumeWs("or")) {
            return e;
        }
        ExprList el = new ExprList(e);
        do {
            this.add(el, this.and());
        } while (this.wsConsumeWs("or"));
        return new Or(this.info(), el.finish());
    }

    private Expr and() throws QueryException {
        Expr e = this.modify();
        if (!this.wsConsumeWs("and")) {
            return e;
        }
        ExprList el = new ExprList(e);
        do {
            this.add(el, this.modify());
        } while (this.wsConsumeWs("and"));
        return new And(this.info(), el.finish());
    }

    private Expr modify() throws QueryException {
        Expr e = this.comparison();
        if (e != null && this.wsConsumeWs("update")) {
            int s = this.openSubScope();
            boolean u = this.ctx.updating;
            this.ctx.updating(false);
            Expr m = this.check(this.single(), Err.COPYEXPR);
            this.closeSubScope(s);
            this.ctx.updating = u;
            return new Modify(this.info(), e, m);
        }
        return e;
    }

    private Expr comparison() throws QueryException {
        Expr e = this.ftContains();
        if (e != null) {
            for (CmpV.OpV opV : CmpV.OpV.VALUES) {
                if (!this.wsConsumeWs(opV.name)) continue;
                return new CmpV(e, this.check(this.ftContains(), Err.CMPEXPR), opV, this.sc.collation, this.info());
            }
            for (Enum enum_ : CmpN.OpN.VALUES) {
                if (!this.wsConsumeWs(((CmpN.OpN)enum_).name)) continue;
                return new CmpN(e, this.check(this.ftContains(), Err.CMPEXPR), (CmpN.OpN)enum_, this.info());
            }
            for (Enum enum_ : CmpG.OpG.VALUES) {
                if (!this.wsConsumeWs(((CmpG.OpG)enum_).name)) continue;
                return new CmpG(e, this.check(this.ftContains(), Err.CMPEXPR), (CmpG.OpG)enum_, this.sc.collation, this.info());
            }
        }
        return e;
    }

    private Expr ftContains() throws QueryException {
        Expr e = this.stringConcat();
        int i = this.pos;
        if (this.consume(61) && this.consume(62) || this.consume(60) && this.consume(45)) {
            this.skipWs();
        } else if (!this.wsConsumeWs("contains") || !this.wsConsumeWs("text")) {
            this.pos = i;
            return e;
        }
        FTExpr select = this.ftSelection(false);
        if (this.wsConsumeWs("without")) {
            this.wsCheck("content");
            this.union();
            throw this.error(Err.FTIGNORE, new Object[0]);
        }
        return new FTContainsExpr(e, select, this.info());
    }

    private Expr stringConcat() throws QueryException {
        Expr e = this.range();
        if (e == null || !this.consume("||")) {
            return e;
        }
        ExprList el = new ExprList(e);
        do {
            this.add(el, this.range());
        } while (this.wsConsume("||"));
        return Function.CONCAT.get(this.sc, this.info(), el.finish());
    }

    private Expr range() throws QueryException {
        Expr e = this.additive();
        if (!this.wsConsumeWs("to")) {
            return e;
        }
        return new Range(this.info(), e, this.check(this.additive(), Err.INCOMPLETE));
    }

    private Expr additive() throws QueryException {
        Expr e = this.multiplicative();
        while (e != null) {
            Calc c;
            Calc calc = this.consume(43) ? Calc.PLUS : (c = this.consume(45) ? Calc.MINUS : null);
            if (c == null) break;
            e = new Arith(this.info(), e, this.check(this.multiplicative(), Err.CALCEXPR), c);
        }
        return e;
    }

    private Expr multiplicative() throws QueryException {
        Expr e = this.union();
        while (e != null) {
            Calc c;
            Calc calc = this.consume(42) ? Calc.MULT : (this.wsConsumeWs("div") ? Calc.DIV : (this.wsConsumeWs("idiv") ? Calc.IDIV : (c = this.wsConsumeWs("mod") ? Calc.MOD : null)));
            if (c == null) break;
            e = new Arith(this.info(), e, this.check(this.union(), Err.CALCEXPR), c);
        }
        return e;
    }

    private Expr union() throws QueryException {
        Expr e = this.intersect();
        if (e == null || !this.isUnion()) {
            return e;
        }
        ExprList el = new ExprList(e);
        do {
            this.add(el, this.intersect());
        } while (this.isUnion());
        return new Union(this.info(), el.finish());
    }

    private boolean isUnion() throws QueryException {
        if (this.wsConsumeWs("union")) {
            return true;
        }
        int i = this.pos;
        if (this.consume("|") && !this.consume("|")) {
            return true;
        }
        this.pos = i;
        return false;
    }

    private Expr intersect() throws QueryException {
        Expr e = this.instanceoff();
        if (this.wsConsumeWs("intersect")) {
            ExprList el = new ExprList(e);
            do {
                this.add(el, this.instanceoff());
            } while (this.wsConsumeWs("intersect"));
            return new InterSect(this.info(), el.finish());
        }
        if (this.wsConsumeWs("except")) {
            ExprList el = new ExprList(e);
            do {
                this.add(el, this.instanceoff());
            } while (this.wsConsumeWs("except"));
            return new Except(this.info(), el.finish());
        }
        return e;
    }

    private Expr instanceoff() throws QueryException {
        Expr e = this.treat();
        if (!this.wsConsumeWs("instance")) {
            return e;
        }
        this.wsCheck("of");
        return new Instance(this.info(), e, this.sequenceType());
    }

    private Expr treat() throws QueryException {
        Expr e = this.castable();
        if (!this.wsConsumeWs("treat")) {
            return e;
        }
        this.wsCheck("as");
        return new Treat(this.info(), e, this.sequenceType());
    }

    private Expr castable() throws QueryException {
        Expr e = this.cast();
        if (!this.wsConsumeWs("castable")) {
            return e;
        }
        this.wsCheck("as");
        return new Castable(this.sc, this.info(), e, this.simpleType());
    }

    private Expr cast() throws QueryException {
        Expr e = this.unary();
        if (!this.wsConsumeWs("cast")) {
            return e;
        }
        this.wsCheck("as");
        return new Cast(this.sc, this.info(), e, this.simpleType());
    }

    private Expr unary() throws QueryException {
        boolean minus = false;
        boolean found = false;
        while (true) {
            this.skipWs();
            if (this.consume(45)) {
                minus ^= true;
                found = true;
                continue;
            }
            if (!this.consume(43)) break;
            found = true;
        }
        Expr e = this.value();
        return found ? new Unary(this.info(), this.check(e, Err.EVALUNARY), minus) : e;
    }

    private Expr value() throws QueryException {
        this.validate();
        Expr e = this.path();
        return e != null ? e : this.extension();
    }

    private void validate() throws QueryException {
        int i = this.pos;
        if (!this.wsConsumeWs("validate")) {
            return;
        }
        boolean brace = true;
        if (this.consume("{")) {
            brace = false;
        } else if (this.consume("type")) {
            QNm qnm = this.eQName(Err.QNAMEINV, SKIPCHECK);
            this.names.add(new QNmCheck(qnm));
        } else if (!this.consume("strict") && !this.consume("lax")) {
            this.pos = i;
            return;
        }
        if (brace) {
            this.wsCheck("{");
        }
        this.check(this.single(), Err.NOVALIDATE);
        this.wsCheck("}");
        throw this.error(Err.IMPLVAL, new Object[0]);
    }

    private Expr extension() throws QueryException {
        Pragma[] pragmas = this.pragma();
        if (pragmas == null) {
            return null;
        }
        Expr expr = this.enclosed(Err.NOPRAGMA);
        return pragmas.length == 0 ? expr : new Extension(this.info(), pragmas, expr);
    }

    private Pragma[] pragma() throws QueryException {
        if (!this.wsConsumeWs("(#")) {
            return null;
        }
        ArrayList<DBPragma> el = new ArrayList<DBPragma>();
        do {
            QNm name = this.eQName(Err.QNAMEINV, URICHECK);
            char c = this.curr();
            if (c != '#' && !Token.ws(c)) {
                throw this.error(Err.PRAGMAINV, new Object[0]);
            }
            this.tok.reset();
            while (c != '#' || this.next() != ')') {
                if (c == '\u0000') {
                    throw this.error(Err.PRAGMAINV, new Object[0]);
                }
                this.tok.add(this.consume());
                c = this.curr();
            }
            byte[] v = this.tok.trim().finish();
            if (Token.eq(name.prefix(), QueryText.DB)) {
                String key = Token.string(Token.uc(name.local()));
                Option<?> opt = this.ctx.context.options.option(key);
                if (opt == null) {
                    throw this.error(Err.BASX_OPTIONS, key);
                }
                el.add(new DBPragma(name, opt, v));
            }
            this.pos += 2;
        } while (this.wsConsumeWs("(#"));
        return el.toArray(new Pragma[el.size()]);
    }

    private Expr path() throws QueryException {
        ExprList el;
        this.checkInit();
        Expr root = null;
        if (this.consume(47)) {
            Expr ex;
            root = new Root(this.info());
            el = new ExprList();
            if (this.consume(47)) {
                this.checkAxis(Axis.DESC);
                this.add(el, this.descOrSelf());
                this.mark();
                ex = this.step();
                if (ex == null) {
                    if (this.more()) {
                        this.checkInit();
                    }
                    throw this.error(Err.PATHMISS, new Object[]{this.found()});
                }
            } else {
                this.checkAxis(Axis.CHILD);
                this.mark();
                ex = this.step();
                if (ex == null) {
                    return root;
                }
            }
            this.add(el, ex);
            this.relativePath(el);
        } else {
            boolean nostep;
            this.mark();
            Expr ex = this.step();
            if (ex == null) {
                return null;
            }
            boolean bl = nostep = this.curr() != '/' && (this.curr() != '!' || this.next() == '=');
            if (nostep && !(ex instanceof Step)) {
                return ex;
            }
            el = new ExprList();
            if (ex instanceof Step) {
                this.add(el, ex);
            } else {
                root = ex;
            }
            this.relativePath(el);
        }
        return Path.get(this.info(), root, el.finish());
    }

    void relativePath(ExprList el) throws QueryException {
        while (true) {
            boolean map = false;
            if (this.consume(47)) {
                if (this.consume(47)) {
                    this.add(el, this.descOrSelf());
                    this.checkAxis(Axis.DESC);
                } else {
                    this.checkAxis(Axis.CHILD);
                }
            } else if (this.next() != '=' && this.consume(33)) {
                map = true;
            } else {
                return;
            }
            this.mark();
            Expr st = this.step();
            if (st == null) {
                throw this.error(Err.PATHMISS, new Object[]{this.found()});
            }
            if (map) {
                st = new Bang(this.info(), st);
            }
            this.add(el, st);
        }
    }

    private Step descOrSelf() {
        return Step.get(this.info(), Axis.DESCORSELF, Test.NOD, new Expr[0]);
    }

    void checkInit() {
    }

    protected void checkAxis(Axis axis) {
    }

    protected void checkTest(Test test, boolean attr) {
    }

    protected void checkPred(boolean open) {
    }

    private Expr step() throws QueryException {
        Expr e = this.postfix();
        return e != null ? e : this.axisStep();
    }

    private Step axisStep() throws QueryException {
        Axis ax = null;
        Test test = null;
        if (this.wsConsume("..")) {
            ax = Axis.PARENT;
            test = Test.NOD;
            this.checkTest(test, false);
        } else if (this.consume(64)) {
            ax = Axis.ATTR;
            test = this.nodeTest(true, true);
            this.checkTest(test, true);
            if (test == null) {
                --this.pos;
                throw this.error(Err.NOATTNAME, new Object[0]);
            }
        } else {
            for (Axis a : Axis.VALUES) {
                int i = this.pos;
                if (!this.wsConsumeWs(a.name)) continue;
                this.alter = Err.NOLOCSTEP;
                if (this.wsConsumeWs("::")) {
                    this.alterPos = this.pos;
                    ax = a;
                    test = this.nodeTest(a == Axis.ATTR, true);
                    this.checkTest(test, a == Axis.ATTR);
                    break;
                }
                this.pos = i;
            }
        }
        if (ax == null) {
            ax = Axis.CHILD;
            test = this.nodeTest(false, true);
            if (test == Test.NSP) {
                throw this.error(Err.NSNOTALL, new Object[0]);
            }
            if (test != null && test.type == NodeType.ATT) {
                ax = Axis.ATTR;
            }
            this.checkTest(test, ax == Axis.ATTR);
        }
        if (test == null) {
            return null;
        }
        ExprList el = new ExprList();
        while (this.wsConsume("[")) {
            this.checkPred(true);
            this.add(el, this.expr());
            this.wsCheck("]");
            this.checkPred(false);
        }
        return Step.get(this.info(), ax, test, el.finish());
    }

    private Test nodeTest(boolean att, boolean all) throws QueryException {
        int i = this.pos;
        if (this.consume(42)) {
            if (!this.consume(58)) {
                return new NameTest(att);
            }
            return new NameTest(new QNm(this.ncName(Err.QNAMEINV)), Test.Mode.LN, att, this.sc.elemNS);
        }
        if (this.sc.xquery3() && this.consume("Q{")) {
            byte[] uri = this.bracedURILiteral();
            if (this.consume(42)) {
                QNm nm = new QNm(Token.COLON, uri);
                return new NameTest(nm, Test.Mode.NS, att, this.sc.elemNS);
            }
        }
        this.pos = i;
        QNm name = this.eQName(null, SKIPCHECK);
        if (name != null) {
            int i2 = this.pos;
            if (all && this.wsConsumeWs("(")) {
                NodeType type = NodeType.find(name);
                if (type != null) {
                    return this.kindTest(type);
                }
            } else {
                this.pos = i2;
                if (name.hasPrefix() || !this.consume(58)) {
                    this.skipWs();
                    this.names.add(new QNmCheck(name, !att));
                    return new NameTest(name, Test.Mode.STD, att, this.sc.elemNS);
                }
                if (this.consume(42)) {
                    QNm nm = new QNm(Token.concat(name.string(), Token.COLON));
                    this.names.add(new QNmCheck(nm, !att));
                    return new NameTest(nm, Test.Mode.NS, att, this.sc.elemNS);
                }
            }
        }
        this.pos = i;
        return null;
    }

    private Expr postfix() throws QueryException {
        Expr old;
        Expr e = this.primary();
        do {
            old = e;
            if (this.wsConsume("[")) {
                if (e == null) {
                    throw this.error(Err.PREDMISSING, new Object[0]);
                }
                ExprList el = new ExprList();
                do {
                    this.add(el, this.expr());
                    this.wsCheck("]");
                } while (this.wsConsume("["));
                e = Filter.get(this.info(), e, el.finish());
                continue;
            }
            if (e == null) continue;
            if (!this.wsConsume("(")) break;
            InputInfo ii = this.info();
            ExprList argList = new ExprList();
            int[] holes = this.argumentList(argList, e);
            Expr[] args = argList.finish();
            Expr expr = e = holes == null ? new DynFuncCall(ii, e, args) : new PartFunc(this.sc, ii, e, args, holes);
        } while (e != old);
        return e;
    }

    private Expr primary() throws QueryException {
        Expr e;
        this.skipWs();
        char c = this.curr();
        if (c == '$') {
            InputInfo ii = this.info();
            return this.resolveVar(this.varName(), ii);
        }
        if (c == '(' && this.next() != '#') {
            return this.parenthesized();
        }
        if (c == '<') {
            return this.constructor();
        }
        if (this.sc.xquery3() && (e = this.functionItem()) != null) {
            return e;
        }
        e = this.functionCall();
        if (e != null) {
            return e;
        }
        e = this.compConstructor();
        if (e != null) {
            return e;
        }
        if (this.wsConsumeWs("ordered", "{", Err.INCOMPLETE) || this.wsConsumeWs("unordered", "{", Err.INCOMPLETE)) {
            return this.enclosed(Err.NOENCLEXPR);
        }
        if (this.wsConsumeWs("map", "{", Err.INCOMPLETE) || this.curr(123)) {
            return new LitMap(this.info(), this.keyValues());
        }
        if (c == '.' && !Token.digit(this.next())) {
            if (this.next() == '.') {
                return null;
            }
            this.consume(46);
            return new Context(this.info());
        }
        return this.literal();
    }

    private Expr[] keyValues() throws QueryException {
        this.wsCheck("{");
        ExprList el = new ExprList();
        if (!this.wsConsume("}")) {
            do {
                this.add(el, this.check(this.single(), Err.INVMAPKEY));
                if (!this.wsConsume(":=")) {
                    this.check(58);
                }
                this.add(el, this.check(this.single(), Err.INVMAPVAL));
            } while (this.wsConsume(","));
            this.wsCheck("}");
        }
        return el.finish();
    }

    private Expr functionItem() throws QueryException {
        Ann ann;
        this.skipWs();
        int ip = this.pos;
        Ann ann2 = ann = this.curr(37) ? this.annotations() : null;
        if (this.wsConsume("function") && this.wsConsume("(")) {
            if (ann != null) {
                if (ann.contains(Ann.Q_UPDATING)) {
                    throw this.error(Err.UPFUNCITEM, new Object[0]);
                }
                if (ann.contains(Ann.Q_PRIVATE) || ann.contains(Ann.Q_PUBLIC)) {
                    throw this.error(Err.INVISIBLE, new Object[0]);
                }
            }
            HashMap<Var, Expr> nonLocal = new HashMap<Var, Expr>();
            this.pushVarContext(nonLocal);
            Var[] args = this.paramList();
            this.wsCheck(")");
            SeqType type = this.optAsType();
            Expr body = this.enclosed(Err.NOFUNBODY);
            VarScope scope = this.popVarContext();
            return new Closure(this.info(), type, args, body, ann, nonLocal, this.sc, scope);
        }
        if (ann != null) {
            throw this.error(Err.NOANN, new Object[0]);
        }
        this.pos = ip;
        QNm name = this.eQName(null, this.sc.funcNS);
        if (name != null && this.consume(35)) {
            if (this.keyword(name)) {
                throw this.error(Err.RESERVED, new Object[]{name.local()});
            }
            Expr ex = this.numericLiteral(true);
            if (!(ex instanceof Int)) {
                return ex;
            }
            long card = ((ANum)ex).itr();
            Expr lit = Functions.getLiteral(name, (int)card, this.ctx, this.sc, this.info());
            return lit != null ? lit : FuncLit.unknown(name, card, this.ctx, this.sc, this.info());
        }
        this.pos = ip;
        return null;
    }

    private Expr literal() throws QueryException {
        char c = this.curr();
        if (Token.digit(c) || c == '.') {
            return this.numericLiteral(false);
        }
        return QueryParser.quote(c) ? Str.get(this.stringLiteral()) : null;
    }

    private Expr numericLiteral(boolean itr) throws QueryException {
        this.tok.reset();
        while (Token.digit(this.curr())) {
            this.tok.add(this.consume());
        }
        boolean dec = this.consume(46);
        if (dec) {
            if (itr) {
                throw this.error(Err.NUMBERITR, new Object[0]);
            }
            this.tok.add(46);
            while (Token.digit(this.curr())) {
                this.tok.add(this.consume());
            }
        }
        if (XMLToken.isNCStartChar(this.curr())) {
            return this.checkDbl();
        }
        if (dec) {
            byte[] t = this.tok.finish();
            if (t.length == 1 && t[0] == 46) {
                throw this.error(Err.NUMBERDEC, new Object[]{t});
            }
            return new Dec(t);
        }
        long l = Token.toLong(this.tok.finish());
        if (l != Long.MIN_VALUE) {
            return Int.get(l);
        }
        return FNInfo.error(new QueryException(this.info(), Err.RANGE, this.tok), SeqType.ITR);
    }

    private Dbl checkDbl() throws QueryException {
        if (!this.consume(101) && !this.consume(69)) {
            throw this.error(Err.NUMBERWS, new Object[0]);
        }
        this.tok.add(101);
        if (this.curr(43) || this.curr(45)) {
            this.tok.add(this.consume());
        }
        int s = this.tok.size();
        while (Token.digit(this.curr())) {
            this.tok.add(this.consume());
        }
        if (s == this.tok.size()) {
            throw this.error(Err.NUMBERDBL, this.tok);
        }
        if (XMLToken.isNCStartChar(this.curr())) {
            throw this.error(Err.NUMBERWS, new Object[0]);
        }
        return Dbl.get(this.tok.finish(), this.info());
    }

    private byte[] stringLiteral() throws QueryException {
        this.skipWs();
        char del = this.curr();
        if (!QueryParser.quote(del)) {
            throw this.error(Err.NOQUOTE, new Object[]{this.found()});
        }
        this.consume();
        this.tok.reset();
        while (true) {
            if (!this.consume(del)) {
                if (!this.more()) {
                    throw this.error(Err.NOQUOTE, new Object[]{this.found()});
                }
                this.entity(this.tok);
                continue;
            }
            if (!this.consume(del)) break;
            this.tok.add(del);
        }
        return this.tok.finish();
    }

    private Uri resolvedUri(byte[] string) throws QueryException {
        Uri uri = Uri.uri(string);
        if (!uri.isValid()) {
            throw this.error(Err.INVURI, new Object[]{string});
        }
        return uri.isAbsolute() ? uri : this.sc.baseURI().resolve(uri, this.info());
    }

    private byte[] bracedURILiteral() throws QueryException {
        this.tok.reset();
        while (!this.consume(125)) {
            if (!this.more()) {
                throw this.error(Err.WRONGCHAR, "}", this.found());
            }
            this.entity(this.tok);
        }
        return this.tok.finish();
    }

    private QNm varName() throws QueryException {
        this.check(36);
        this.skipWs();
        return this.eQName(Err.NOVARNAME, null);
    }

    private Expr parenthesized() throws QueryException {
        this.wsCheck("(");
        Expr e = this.expr();
        this.wsCheck(")");
        return e == null ? Empty.SEQ : e;
    }

    private Expr functionCall() throws QueryException {
        int i = this.pos;
        QNm name = this.eQName(null, this.sc.funcNS);
        if (name != null && !this.keyword(name) && this.wsConsume("(")) {
            Expr ret;
            InputInfo ii = this.info();
            ExprList argList = new ExprList();
            int[] holes = this.argumentList(argList, name.string());
            Expr[] args = argList.finish();
            this.alter = Err.FUNCUNKNOWN;
            this.alterFunc = name;
            this.alterPos = this.pos;
            if (holes != null) {
                int card = args.length + holes.length;
                Expr lit = Functions.getLiteral(name, card, this.ctx, this.sc, ii);
                Expr f = lit != null ? lit : FuncLit.unknown(name, card, this.ctx, this.sc, ii);
                ret = new PartFunc(this.sc, ii, f, args, holes);
            } else {
                TypedFunc f = Functions.get(name, args, false, this.ctx, this.sc, ii);
                Expr expr = ret = f == null ? null : f.fun;
            }
            if (ret != null) {
                this.alter = null;
                return ret;
            }
        }
        this.pos = i;
        return null;
    }

    private int[] argumentList(ExprList args, Object name) throws QueryException {
        int[] holes = null;
        if (!this.wsConsume(")")) {
            int i = 0;
            do {
                if (this.wsConsume("?")) {
                    int[] nArray;
                    if (holes == null) {
                        int[] nArray2 = new int[1];
                        nArray = nArray2;
                        nArray2[0] = i;
                    } else {
                        nArray = Array.add(holes, i);
                    }
                    holes = nArray;
                } else {
                    Expr e = this.single();
                    if (e == null) {
                        throw this.error(Err.FUNCMISS, name);
                    }
                    args.add(e);
                }
                ++i;
            } while (this.wsConsume(","));
            if (!this.wsConsume(")")) {
                throw this.error(Err.FUNCMISS, name);
            }
        }
        return holes;
    }

    private Expr constructor() throws QueryException {
        this.check(60);
        return this.consume(33) ? this.dirComment() : (this.consume(63) ? this.dirPI() : this.dirElement());
    }

    private Expr dirElement() throws QueryException {
        byte[] atn;
        int s = this.sc.ns.size();
        byte[] nse = this.sc.elemNS;
        int npos = this.names.size();
        QNm tag = new QNm(this.qName(Err.TAGNAME));
        this.names.add(new QNmCheck(tag));
        this.consumeWS();
        Atts ns = new Atts();
        ExprList cont = new ExprList();
        boolean xmlDecl = false;
        ArrayList<QNm> atts = null;
        while ((atn = this.qName(null)).length != 0) {
            boolean pr;
            ExprList attv = new ExprList();
            this.consumeWS();
            this.check(61);
            this.consumeWS();
            char delim = this.consume();
            if (!QueryParser.quote(delim)) {
                throw this.error(Err.NOQUOTE, new Object[]{this.found()});
            }
            TokenBuilder tb = new TokenBuilder();
            boolean simple = true;
            while (true) {
                if (!this.consume(delim)) {
                    char ch = this.curr();
                    if (ch == '{') {
                        if (this.next() == '{') {
                            tb.add(this.consume());
                            this.consume();
                            continue;
                        }
                        byte[] text = tb.finish();
                        if (text.length == 0) {
                            this.add(attv, this.enclosed(Err.NOENCLEXPR));
                            simple = false;
                        } else {
                            this.add(attv, Str.get(text));
                        }
                        tb.reset();
                        continue;
                    }
                    if (ch == '}') {
                        this.consume();
                        this.check(125);
                        tb.add(125);
                        continue;
                    }
                    if (ch == '<' || ch == '\u0000') {
                        throw this.error(Err.NOQUOTE, new Object[]{this.found()});
                    }
                    if (ch == '\n' || ch == '\t') {
                        tb.add(32);
                        this.consume();
                        continue;
                    }
                    if (ch == '\r') {
                        if (this.next() != '\n') {
                            tb.add(32);
                        }
                        this.consume();
                        continue;
                    }
                    this.entity(tb);
                    continue;
                }
                if (!this.consume(delim)) break;
                tb.add(delim);
            }
            if (!tb.isEmpty()) {
                this.add(attv, Str.get(tb.finish()));
            }
            if ((pr = Token.startsWith(atn, Token.XMLNSC)) || Token.eq(atn, Token.XMLNS)) {
                byte[] uri;
                if (!simple) {
                    throw this.error(Err.NSCONS, new Object[0]);
                }
                byte[] pref = pr ? Token.local(atn) : Token.EMPTY;
                byte[] byArray = uri = attv.isEmpty() ? Token.EMPTY : ((Str)attv.get(0)).string();
                if (Token.eq(pref, Token.XML) && Token.eq(uri, QueryText.XMLURI)) {
                    if (xmlDecl) {
                        throw this.error(Err.DUPLNSDEF, new Object[]{Token.XML});
                    }
                    xmlDecl = true;
                } else {
                    if (!Uri.uri(uri).isValid()) {
                        throw this.error(Err.INVURI, new Object[]{uri});
                    }
                    if (pr) {
                        if (uri.length == 0) {
                            throw this.error(Err.NSEMPTYURI, new Object[0]);
                        }
                        if (Token.eq(pref, Token.XML, Token.XMLNS)) {
                            throw this.error(Err.BINDXML, new Object[]{pref});
                        }
                        if (Token.eq(uri, QueryText.XMLURI)) {
                            throw this.error(Err.BINDXMLURI, uri, Token.XML);
                        }
                        if (Token.eq(uri, QueryText.XMLNSURI)) {
                            throw this.error(Err.BINDXMLURI, uri, Token.XMLNS);
                        }
                        this.sc.ns.add(pref, uri);
                    } else {
                        if (Token.eq(uri, QueryText.XMLURI)) {
                            throw this.error(Err.XMLNSDEF, new Object[]{uri});
                        }
                        this.sc.elemNS = uri;
                    }
                    if (ns.contains(pref)) {
                        throw this.error(Err.DUPLNSDEF, new Object[]{pref});
                    }
                    ns.add(pref, uri);
                }
            } else {
                QNm attn = new QNm(atn);
                if (atts == null) {
                    atts = new ArrayList<QNm>(1);
                }
                atts.add(attn);
                this.names.add(new QNmCheck(attn, false));
                this.add(cont, new CAttr(this.sc, this.info(), false, (Expr)attn, attv.finish()));
            }
            if (this.consumeWS()) continue;
            break;
        }
        if (this.consume(47)) {
            this.check(62);
        } else {
            this.check(62);
            while (this.curr() != '<' || this.next() != '/') {
                Expr e = this.dirElemContent(tag.string());
                if (e == null) continue;
                this.add(cont, e);
            }
            this.pos += 2;
            byte[] close = this.qName(Err.TAGNAME);
            this.consumeWS();
            this.check(62);
            if (!Token.eq(tag.string(), close)) {
                throw this.error(Err.TAGWRONG, tag.string(), close);
            }
        }
        this.assignURI(npos);
        if (atts != null) {
            int as = atts.size();
            for (int a = 0; a < as - 1; ++a) {
                for (int b = a + 1; b < as; ++b) {
                    if (!((QNm)atts.get(a)).eq((QNm)atts.get(b))) continue;
                    throw this.error(Err.ATTDUPL, atts.get(a));
                }
            }
        }
        this.sc.ns.size(s);
        this.sc.elemNS = nse;
        return new CElem(this.sc, this.info(), (Expr)tag, ns, cont.finish());
    }

    private Expr dirElemContent(byte[] tag) throws QueryException {
        TokenBuilder tb = new TokenBuilder();
        boolean strip = true;
        while (true) {
            char c;
            if ((c = this.curr()) == '<') {
                if (this.wsConsume("<![CDATA[")) {
                    tb.add(this.cDataSection());
                    strip = false;
                    continue;
                }
                Str txt = this.text(tb, strip);
                return txt != null ? txt : (this.next() == '/' ? null : this.constructor());
            }
            if (c == '{') {
                if (this.next() == '{') {
                    tb.add(this.consume());
                    this.consume();
                    continue;
                }
                Str txt = this.text(tb, strip);
                return txt != null ? txt : this.enclosed(Err.NOENCLEXPR);
            }
            if (c == '}') {
                this.consume();
                this.check(125);
                tb.add(125);
                continue;
            }
            if (c == '\u0000') break;
            strip &= !this.entity(tb);
        }
        throw this.error(Err.NOCLOSING, new Object[]{tag});
    }

    private Str text(TokenBuilder tb, boolean strip) {
        byte[] t = tb.finish();
        return t.length == 0 || strip && !this.sc.spaces && Token.ws(t) ? null : Str.get(t);
    }

    private Expr dirComment() throws QueryException {
        this.check(45);
        this.check(45);
        TokenBuilder tb = new TokenBuilder();
        while (true) {
            if (this.not('-')) {
                tb.add(this.consume());
                continue;
            }
            this.consume();
            if (this.consume(45)) {
                this.check(62);
                return new CComm(this.sc, this.info(), (Expr)Str.get(tb.finish()));
            }
            tb.add(45);
        }
    }

    private Expr dirPI() throws QueryException {
        byte[] str = this.ncName(Err.INVALPI);
        if (Token.eq(Token.lc(str), Token.XML)) {
            throw this.error(Err.PIXML, new Object[]{str});
        }
        boolean space = this.skipWs();
        TokenBuilder tb = new TokenBuilder();
        while (true) {
            if (this.not('?')) {
                if (!space) {
                    throw this.error(Err.PIWRONG, new Object[0]);
                }
                tb.add(this.consume());
                continue;
            }
            this.consume();
            if (this.consume(62)) {
                return new CPI(this.sc, this.info(), (Expr)Str.get(str), (Expr)Str.get(tb.finish()));
            }
            tb.add(63);
        }
    }

    private byte[] cDataSection() throws QueryException {
        TokenBuilder tb = new TokenBuilder();
        while (true) {
            if (this.not(']')) {
                int ch = this.consume();
                if (ch == 13 && this.curr(ch = 10)) {
                    this.consume();
                }
                tb.add(ch);
                continue;
            }
            this.consume();
            if (this.curr(93) && this.next() == '>') {
                this.pos += 2;
                return tb.finish();
            }
            tb.add(93);
        }
    }

    private Expr compConstructor() throws QueryException {
        int i = this.pos;
        if (this.wsConsumeWs("document")) {
            return this.consume(this.compDoc(), i);
        }
        if (this.wsConsumeWs("element")) {
            return this.consume(this.compElement(), i);
        }
        if (this.wsConsumeWs("attribute")) {
            return this.consume(this.compAttribute(), i);
        }
        if (this.wsConsumeWs("namespace")) {
            return this.consume(this.compNamespace(), i);
        }
        if (this.wsConsumeWs("text")) {
            return this.consume(this.compText(), i);
        }
        if (this.wsConsumeWs("comment")) {
            return this.consume(this.compComment(), i);
        }
        if (this.wsConsumeWs("processing-instruction")) {
            return this.consume(this.compPI(), i);
        }
        return null;
    }

    private Expr consume(Expr expr, int p) {
        if (expr == null) {
            this.pos = p;
        }
        return expr;
    }

    private Expr compDoc() throws QueryException {
        if (!this.wsConsume("{")) {
            return null;
        }
        Expr e = this.check(this.expr(), Err.NODOCCONS);
        this.wsCheck("}");
        return new CDoc(this.sc, this.info(), e);
    }

    private Expr compElement() throws QueryException {
        Expr[] exprArray;
        Expr name;
        this.skipWs();
        QNm qn = this.eQName(null, SKIPCHECK);
        if (qn != null) {
            name = qn;
            this.names.add(new QNmCheck(qn));
        } else {
            if (!this.wsConsume("{")) {
                return null;
            }
            name = this.check(this.expr(), Err.NOTAG);
            this.wsCheck("}");
        }
        if (!this.wsConsume("{")) {
            return null;
        }
        Expr e = this.expr();
        this.wsCheck("}");
        InputInfo inputInfo = this.info();
        if (e == null) {
            exprArray = new Expr[]{};
        } else {
            Expr[] exprArray2 = new Expr[1];
            exprArray = exprArray2;
            exprArray2[0] = e;
        }
        return new CElem(this.sc, inputInfo, name, null, exprArray);
    }

    private Expr compAttribute() throws QueryException {
        Expr name;
        this.skipWs();
        QNm qn = this.eQName(null, SKIPCHECK);
        if (qn != null) {
            name = qn;
            this.names.add(new QNmCheck(qn, false));
        } else {
            if (!this.wsConsume("{")) {
                return null;
            }
            name = this.check(this.expr(), Err.NOATTNAME);
            this.wsCheck("}");
        }
        if (!this.wsConsume("{")) {
            return null;
        }
        Expr e = this.expr();
        this.wsCheck("}");
        return new CAttr(this.sc, this.info(), true, name, e == null ? Empty.SEQ : e);
    }

    private Expr compNamespace() throws QueryException {
        Expr name;
        if (!this.sc.xquery3()) {
            return null;
        }
        this.skipWs();
        byte[] str = this.ncName(null);
        if (str.length == 0) {
            if (!this.wsConsume("{")) {
                return null;
            }
            name = this.check(this.expr(), Err.NSWRONG);
            this.wsCheck("}");
        } else {
            name = Str.get(str);
        }
        if (!this.wsConsume("{")) {
            return null;
        }
        Expr e = this.expr();
        this.wsCheck("}");
        return new CNSpace(this.sc, this.info(), name, e == null ? Empty.SEQ : e);
    }

    private Expr compText() throws QueryException {
        if (!this.wsConsume("{")) {
            return null;
        }
        Expr e = this.check(this.expr(), Err.NOTXTCONS);
        this.wsCheck("}");
        return new CTxt(this.sc, this.info(), e);
    }

    private Expr compComment() throws QueryException {
        if (!this.wsConsume("{")) {
            return null;
        }
        Expr e = this.check(this.expr(), Err.NOCOMCONS);
        this.wsCheck("}");
        return new CComm(this.sc, this.info(), e);
    }

    private Expr compPI() throws QueryException {
        Expr name;
        this.skipWs();
        byte[] str = this.ncName(null);
        if (str.length == 0) {
            if (!this.wsConsume("{")) {
                return null;
            }
            name = this.check(this.expr(), Err.PIWRONG);
            this.wsCheck("}");
        } else {
            name = Str.get(str);
        }
        if (!this.wsConsume("{")) {
            return null;
        }
        Expr e = this.expr();
        this.wsCheck("}");
        return new CPI(this.sc, this.info(), name, e == null ? Empty.SEQ : e);
    }

    private SeqType simpleType() throws QueryException {
        this.skipWs();
        QNm name = this.eQName(Err.TYPEINVALID, this.sc.elemNS);
        Enum t = ListType.find(name);
        if (t == null) {
            t = AtomType.find(name, false);
            if (t == null) {
                if (this.wsConsume("(")) {
                    throw this.error(Err.SIMPLETYPE, name);
                }
                if (this.sc.xquery3) {
                    if (!AtomType.AST.name.eq(name)) {
                        throw this.error(Err.TYPEUNKNOWN30, name);
                    }
                    t = AtomType.AST;
                } else {
                    throw this.error(Err.TYPEUNKNOWN, name);
                }
            }
            if (t == AtomType.AST || t == AtomType.AAT || t == AtomType.NOT) {
                throw this.error(Err.CASTUNKNOWN, name);
            }
        }
        this.skipWs();
        return SeqType.get((Type)((Object)t), this.consume(63) ? SeqType.Occ.ZERO_ONE : SeqType.Occ.ONE);
    }

    private SeqType sequenceType() throws QueryException {
        if (this.wsConsumeWs("empty-sequence", "(", null)) {
            this.wsCheck("(");
            this.wsCheck(")");
            return SeqType.get((Type)AtomType.ITEM, SeqType.Occ.ZERO);
        }
        SeqType tw = this.itemType();
        this.skipWs();
        SeqType.Occ occ = this.consume(63) ? SeqType.Occ.ZERO_ONE : (this.consume(43) ? SeqType.Occ.ONE_MORE : (this.consume(42) ? SeqType.Occ.ZERO_MORE : SeqType.Occ.ONE));
        this.skipWs();
        return tw.withOcc(occ);
    }

    private SeqType itemType() throws QueryException {
        this.skipWs();
        if (this.consume("(")) {
            SeqType ret = this.itemType();
            this.wsCheck(")");
            return ret;
        }
        Ann ann = this.sc.xquery3() && this.curr(37) ? this.annotations() : null;
        QNm name = this.eQName(Err.TYPEINVALID, null);
        this.skipWs();
        boolean func = this.curr(40);
        Type t = null;
        if (func) {
            this.consume("(");
            if (name.eq(AtomType.ITEM.name)) {
                t = AtomType.ITEM;
            }
            if (t == null) {
                t = NodeType.find(name);
            }
            if (t == null && (t = FuncType.find(name)) != null) {
                return this.functionTest(ann, t).seqType();
            }
            if (t == null) {
                throw this.error(Err.NOTYPE, new Object[]{name.string()});
            }
        } else {
            if (!name.hasURI()) {
                name.uri(this.sc.elemNS);
            }
            if ((t = AtomType.find(name, false)) == null) {
                throw this.error(Err.TYPEUNKNOWN, name);
            }
        }
        if (ann != null) {
            throw this.error(Err.NOANN, new Object[0]);
        }
        if (!func || this.wsConsume(")")) {
            return t.seqType();
        }
        if (!(t instanceof NodeType)) {
            this.wsCheck(")");
        }
        return SeqType.get(t, SeqType.Occ.ONE, this.kindTest((NodeType)t));
    }

    private Type functionTest(Ann ann, Type t) throws QueryException {
        if (this.wsConsume("*")) {
            this.wsCheck(")");
            return t;
        }
        if (t instanceof MapType) {
            Type key = this.itemType().type;
            if (!key.instanceOf(AtomType.AAT)) {
                throw this.error(Err.MAPTAAT, key);
            }
            this.wsCheck(",");
            MapType tp = MapType.get((AtomType)key, this.sequenceType());
            this.wsCheck(")");
            return tp;
        }
        SeqType[] args = new SeqType[]{};
        if (!this.wsConsume(")")) {
            do {
                args = Array.add(args, this.sequenceType());
            } while (this.wsConsume(","));
            this.wsCheck(")");
        }
        this.wsCheck("as");
        SeqType st = this.sequenceType();
        return FuncType.get(ann, st, args);
    }

    private Test kindTest(NodeType t) throws QueryException {
        Test tp = null;
        switch (t) {
            case DOC: {
                tp = this.documentTest();
                break;
            }
            case ELM: {
                tp = this.elementTest();
                break;
            }
            case ATT: {
                tp = this.attributeTest();
                break;
            }
            case PI: {
                tp = this.piTest();
                break;
            }
            case SCE: 
            case SCA: {
                tp = this.schemaTest();
                break;
            }
        }
        this.wsCheck(")");
        if (tp != null) {
            return tp;
        }
        tp = Test.get(t);
        if (tp == Test.NSP && !this.sc.xquery3) {
            throw this.error(Err.NSNOTALL, new Object[0]);
        }
        return tp;
    }

    private Test documentTest() throws QueryException {
        boolean elem = this.consume("element");
        if (!elem && !this.consume("schema-element")) {
            return null;
        }
        this.wsCheck("(");
        this.skipWs();
        Test t = elem ? this.elementTest() : this.schemaTest();
        this.wsCheck(")");
        return new DocTest(t != null ? t : Test.ELM);
    }

    private Test elementTest() throws QueryException {
        QNm name = this.eQName(null, this.sc.elemNS);
        if (name == null && !this.consume("*")) {
            return null;
        }
        Enum type = null;
        if (this.wsConsumeWs(",")) {
            QNm tn = this.eQName(Err.QNAMEINV, this.sc.elemNS);
            type = ListType.find(tn);
            if (type == null) {
                type = AtomType.find(tn, true);
            }
            if (type == null) {
                throw this.error(Err.TYPEUNDEF, tn);
            }
            this.wsConsume("?");
        }
        return new NodeTest(NodeType.ELM, name, (Type)((Object)type), this.sc.strip);
    }

    private Test schemaTest() throws QueryException {
        QNm name = this.eQName(Err.QNAMEINV, this.sc.elemNS);
        throw this.error(Err.SCHEMAINV, name);
    }

    private Test attributeTest() throws QueryException {
        QNm name = this.eQName(null, null);
        if (name == null && !this.consume("*")) {
            return null;
        }
        Enum type = null;
        if (this.wsConsumeWs(",")) {
            QNm tn = this.eQName(Err.QNAMEINV, this.sc.elemNS);
            type = ListType.find(tn);
            if (type == null) {
                type = AtomType.find(tn, true);
            }
            if (type == null) {
                throw this.error(Err.TYPEUNDEF, tn);
            }
        }
        return new NodeTest(NodeType.ATT, name, (Type)((Object)type), this.sc.strip);
    }

    private Test piTest() throws QueryException {
        byte[] nm;
        this.tok.reset();
        if (QueryParser.quote(this.curr())) {
            nm = Token.trim(this.stringLiteral());
            if (!XMLToken.isNCName(nm)) {
                throw this.error(Err.INVNCNAME, new Object[]{nm});
            }
        } else if (this.ncName()) {
            nm = this.tok.finish();
        } else {
            return null;
        }
        return new NodeTest(NodeType.PI, new QNm(nm));
    }

    private Expr tryCatch() throws QueryException {
        if (!this.sc.xquery3() || !this.wsConsumeWs("try")) {
            return null;
        }
        Expr tr = this.enclosed(Err.NOENCLEXPR);
        this.wsCheck("catch");
        Catch[] ct = new Catch[]{};
        do {
            NameTest[] codes = new NameTest[]{};
            do {
                this.skipWs();
                NameTest test = (NameTest)this.nodeTest(false, false);
                if (test == null) {
                    throw this.error(Err.NOCATCH, new Object[0]);
                }
                codes = Array.add(codes, test);
            } while (this.wsConsumeWs("|"));
            int s = this.openSubScope();
            Var[] vs = new Var[Catch.NAMES.length];
            for (int i = 0; i < Catch.NAMES.length; ++i) {
                vs[i] = this.addVar(Catch.NAMES[i], Catch.TYPES[i], false);
            }
            Catch c = new Catch(this.info(), codes, vs);
            c.expr = this.enclosed(Err.NOENCLEXPR);
            this.closeSubScope(s);
            ct = Array.add(ct, c);
        } while (this.wsConsumeWs("catch"));
        return new Try(this.info(), tr, ct);
    }

    private FTExpr ftSelection(boolean prg) throws QueryException {
        FTExpr old;
        FTExpr expr = this.ftOr(prg);
        FTExpr first = null;
        boolean ordered = false;
        do {
            old = expr;
            if (this.wsConsumeWs("ordered")) {
                ordered = true;
                old = null;
            } else if (this.wsConsumeWs("window")) {
                expr = new FTWindow(this.info(), expr, this.additive(), this.ftUnit());
            } else if (this.wsConsumeWs("distance")) {
                Expr[] rng = this.ftRange(false);
                if (rng == null) {
                    throw this.error(Err.FTRANGE, new Object[0]);
                }
                expr = new FTDistance(this.info(), expr, rng[0], rng[1], this.ftUnit());
            } else if (this.wsConsumeWs("at")) {
                FTContents cont;
                FTContents fTContents = this.wsConsumeWs("start") ? FTContents.START : (cont = this.wsConsumeWs("end") ? FTContents.END : null);
                if (cont == null) {
                    throw this.error(Err.INCOMPLETE, new Object[0]);
                }
                expr = new FTContent(this.info(), expr, cont);
            } else if (this.wsConsumeWs("entire")) {
                this.wsCheck("content");
                expr = new FTContent(this.info(), expr, FTContents.ENTIRE);
            } else {
                boolean diff;
                boolean same = this.wsConsumeWs("same");
                boolean bl = diff = !same && this.wsConsumeWs("different");
                if (same || diff) {
                    FTUnit unit = null;
                    if (this.wsConsumeWs("sentence")) {
                        unit = FTUnit.SENTENCES;
                    } else if (this.wsConsumeWs("paragraph")) {
                        unit = FTUnit.PARAGRAPHS;
                    } else {
                        throw this.error(Err.INCOMPLETE, new Object[0]);
                    }
                    expr = new FTScope(this.info(), expr, same, unit);
                }
            }
            if (first != null || old == null || old == expr) continue;
            first = expr;
        } while (old != expr);
        if (ordered) {
            if (first == null) {
                return new FTOrder(this.info(), expr);
            }
            first.expr[0] = new FTOrder(this.info(), first.expr[0]);
        }
        return expr;
    }

    private FTExpr ftOr(boolean prg) throws QueryException {
        FTExpr e = this.ftAnd(prg);
        if (!this.wsConsumeWs("ftor")) {
            return e;
        }
        FTExpr[] list = new FTExpr[]{e};
        do {
            list = Array.add(list, this.ftAnd(prg));
        } while (this.wsConsumeWs("ftor"));
        return new FTOr(this.info(), list);
    }

    private FTExpr ftAnd(boolean prg) throws QueryException {
        FTExpr e = this.ftMildNot(prg);
        if (!this.wsConsumeWs("ftand")) {
            return e;
        }
        FTExpr[] list = new FTExpr[]{e};
        do {
            list = Array.add(list, this.ftMildNot(prg));
        } while (this.wsConsumeWs("ftand"));
        return new FTAnd(this.info(), list);
    }

    private FTExpr ftMildNot(boolean prg) throws QueryException {
        FTExpr e = this.ftUnaryNot(prg);
        if (!this.wsConsumeWs("not")) {
            return e;
        }
        FTExpr[] list = new FTExpr[]{};
        do {
            this.wsCheck("in");
            list = Array.add(list, this.ftUnaryNot(prg));
        } while (this.wsConsumeWs("not"));
        return new FTMildNot(this.info(), e, list.length == 1 ? list[0] : new FTOr(this.info(), list));
    }

    private FTExpr ftUnaryNot(boolean prg) throws QueryException {
        boolean not = this.wsConsumeWs("ftnot");
        FTExpr e = this.ftPrimaryWithOptions(prg);
        return not ? new FTNot(this.info(), e) : e;
    }

    private FTExpr ftPrimaryWithOptions(boolean prg) throws QueryException {
        FTExpr expr = this.ftPrimary(prg);
        FTOpt fto = new FTOpt();
        boolean found = false;
        while (this.ftMatchOption(fto)) {
            found = true;
        }
        if (fto.ln == null) {
            fto.ln = Language.def();
        }
        if (!Tokenizer.supportFor(fto.ln)) {
            throw this.error(Err.FTNOTOK, fto.ln);
        }
        if (fto.is(FTFlag.ST) && fto.sd == null && !Stemmer.supportFor(fto.ln)) {
            throw this.error(Err.FTNOSTEM, fto.ln);
        }
        if (this.wsConsumeWs("weight")) {
            expr = new FTWeight(this.info(), expr, this.enclosed(Err.NOENCLEXPR));
        }
        return found ? new FTOpts(this.info(), expr, fto) : expr;
    }

    private FTExpr ftPrimary(boolean prg) throws QueryException {
        Pragma[] pragmas = this.pragma();
        if (pragmas != null) {
            this.wsCheck("{");
            FTExpr e = this.ftSelection(true);
            this.wsCheck("}");
            return new FTExtensionSelection(this.info(), pragmas, e);
        }
        if (this.wsConsumeWs("(")) {
            FTExpr e = this.ftSelection(false);
            this.wsCheck(")");
            return e;
        }
        this.skipWs();
        Expr e = null;
        if (QueryParser.quote(this.curr())) {
            e = Str.get(this.stringLiteral());
        } else if (this.curr(123)) {
            e = this.enclosed(Err.NOENCLEXPR);
        } else {
            throw this.error(prg ? Err.NOPRAGMA : Err.NOFTSELECT, new Object[]{this.found()});
        }
        FTMode mode = FTMode.ANY;
        if (this.wsConsumeWs("all")) {
            mode = this.wsConsumeWs("words") ? FTMode.ALL_WORDS : FTMode.ALL;
        } else if (this.wsConsumeWs("any")) {
            mode = this.wsConsumeWs("word") ? FTMode.ANY_WORD : FTMode.ANY;
        } else if (this.wsConsumeWs("phrase")) {
            mode = FTMode.PHRASE;
        }
        Expr[] occ = null;
        if (this.wsConsumeWs("occurs")) {
            occ = this.ftRange(false);
            if (occ == null) {
                throw this.error(Err.FTRANGE, new Object[0]);
            }
            this.wsCheck("times");
        }
        return new FTWords(this.info(), e, mode, occ);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Expr[] ftRange(boolean i) throws QueryException {
        Expr[] occ = new Expr[]{Int.get(0L), Int.get(Long.MAX_VALUE)};
        if (this.wsConsumeWs("exactly")) {
            occ[0] = this.ftAdditive(i);
            occ[1] = occ[0];
            return occ;
        } else if (this.wsConsumeWs("at")) {
            if (this.wsConsumeWs("least")) {
                occ[0] = this.ftAdditive(i);
                return occ;
            } else {
                if (!this.wsConsumeWs("most")) return null;
                occ[1] = this.ftAdditive(i);
            }
            return occ;
        } else {
            if (!this.wsConsumeWs("from")) return null;
            occ[0] = this.ftAdditive(i);
            this.wsCheck("to");
            occ[1] = this.ftAdditive(i);
        }
        return occ;
    }

    private Expr ftAdditive(boolean i) throws QueryException {
        if (!i) {
            return this.additive();
        }
        this.skipWs();
        this.tok.reset();
        while (Token.digit(this.curr())) {
            this.tok.add(this.consume());
        }
        if (this.tok.isEmpty()) {
            throw this.error(Err.INTEXP, new Object[0]);
        }
        return Int.get(Token.toLong(this.tok.finish()));
    }

    private FTUnit ftUnit() throws QueryException {
        if (this.wsConsumeWs("words")) {
            return FTUnit.WORDS;
        }
        if (this.wsConsumeWs("sentences")) {
            return FTUnit.SENTENCES;
        }
        if (this.wsConsumeWs("paragraphs")) {
            return FTUnit.PARAGRAPHS;
        }
        throw this.error(Err.INCOMPLETE, new Object[0]);
    }

    private boolean ftMatchOption(FTOpt opt) throws QueryException {
        if (!this.wsConsumeWs("using")) {
            return false;
        }
        if (this.wsConsumeWs("lowercase")) {
            if (opt.cs != null) {
                throw this.error(Err.FTDUP, "case");
            }
            opt.cs = FTCase.LOWER;
        } else if (this.wsConsumeWs("uppercase")) {
            if (opt.cs != null) {
                throw this.error(Err.FTDUP, "case");
            }
            opt.cs = FTCase.UPPER;
        } else if (this.wsConsumeWs("case")) {
            if (opt.cs != null) {
                throw this.error(Err.FTDUP, "case");
            }
            if (this.wsConsumeWs("sensitive")) {
                opt.cs = FTCase.SENSITIVE;
            } else {
                opt.cs = FTCase.INSENSITIVE;
                this.wsCheck("insensitive");
            }
        } else if (this.wsConsumeWs("diacritics")) {
            if (opt.isSet(FTFlag.DC)) {
                throw this.error(Err.FTDUP, "diacritics");
            }
            opt.set(FTFlag.DC, this.wsConsumeWs("sensitive"));
            if (!opt.is(FTFlag.DC)) {
                this.wsCheck("insensitive");
            }
        } else if (this.wsConsumeWs("language")) {
            if (opt.ln != null) {
                throw this.error(Err.FTDUP, "language");
            }
            byte[] lan = this.stringLiteral();
            opt.ln = Language.get(Token.string(lan));
            if (opt.ln == null) {
                throw this.error(Err.FTNOTOK, new Object[]{lan});
            }
        } else if (this.wsConsumeWs("option")) {
            this.optionDecl();
        } else {
            boolean using;
            boolean bl = using = !this.wsConsumeWs("no");
            if (this.wsConsumeWs("stemming")) {
                if (opt.isSet(FTFlag.ST)) {
                    throw this.error(Err.FTDUP, "stemming");
                }
                opt.set(FTFlag.ST, using);
            } else if (this.wsConsumeWs("thesaurus")) {
                if (opt.th != null) {
                    throw this.error(Err.FTDUP, "thesaurus");
                }
                opt.th = new ThesQuery();
                if (using) {
                    boolean par = this.wsConsume("(");
                    if (!this.wsConsumeWs("default")) {
                        this.ftThesaurusID(opt.th);
                    }
                    while (par && this.wsConsume(",")) {
                        this.ftThesaurusID(opt.th);
                    }
                    if (par) {
                        this.wsCheck(")");
                    }
                }
            } else if (this.wsConsumeWs("stop")) {
                this.wsCheck("words");
                if (opt.sw != null) {
                    throw this.error(Err.FTDUP, "stop words");
                }
                opt.sw = new StopWords();
                if (this.wsConsumeWs("default")) {
                    if (!using) {
                        throw this.error(Err.FTSTOP, new Object[0]);
                    }
                } else {
                    boolean union = false;
                    boolean except = false;
                    while (using) {
                        if (this.wsConsume("(")) {
                            do {
                                byte[] sl = this.stringLiteral();
                                if (except) {
                                    opt.sw.delete(sl);
                                    continue;
                                }
                                if (union && opt.sw.contains(sl)) continue;
                                opt.sw.add(sl);
                            } while (this.wsConsume(","));
                            this.wsCheck(")");
                        } else if (this.wsConsumeWs("at")) {
                            IO fl;
                            String fn = Token.string(this.stringLiteral());
                            IO iO = fl = this.ctx.stop != null ? this.ctx.stop.get(fn) : this.sc.io(fn);
                            if (!opt.sw.read(fl, except)) {
                                throw this.error(Err.NOSTOPFILE, fl);
                            }
                        } else if (!union && !except) {
                            throw this.error(Err.FTSTOP, new Object[0]);
                        }
                        union = this.wsConsumeWs("union");
                        boolean bl2 = except = !union && this.wsConsumeWs("except");
                        if (union || except) continue;
                        break;
                    }
                }
            } else if (this.wsConsumeWs("wildcards")) {
                if (opt.isSet(FTFlag.WC)) {
                    throw this.error(Err.FTDUP, "wildcards");
                }
                if (opt.is(FTFlag.FZ)) {
                    throw this.error(Err.BXFT_MATCH, new Object[0]);
                }
                opt.set(FTFlag.WC, using);
            } else if (this.wsConsumeWs("fuzzy")) {
                if (opt.isSet(FTFlag.FZ)) {
                    throw this.error(Err.FTDUP, "fuzzy");
                }
                if (opt.is(FTFlag.WC)) {
                    throw this.error(Err.BXFT_MATCH, new Object[0]);
                }
                opt.set(FTFlag.FZ, using);
            } else {
                throw this.error(Err.FTMATCH, Character.valueOf(this.consume()));
            }
        }
        return true;
    }

    private void ftThesaurusID(ThesQuery thes) throws QueryException {
        this.wsCheck("at");
        String fn = Token.string(this.stringLiteral());
        IO fl = this.ctx.thes != null ? this.ctx.thes.get(fn) : this.sc.io(fn);
        byte[] rel = this.wsConsumeWs("relationship") ? this.stringLiteral() : Token.EMPTY;
        Expr[] range = this.ftRange(true);
        long min = 0L;
        long max = Long.MAX_VALUE;
        if (range != null) {
            this.wsCheck("levels");
            min = ((ANum)range[0]).itr();
            max = ((ANum)range[1]).itr();
        }
        thes.add(new Thesaurus(fl, rel, min, max, this.ctx.context));
    }

    private Expr insert() throws QueryException {
        int i = this.pos;
        if (!this.wsConsumeWs("insert") || !this.wsConsumeWs("node") && !this.wsConsumeWs("nodes")) {
            this.pos = i;
            return null;
        }
        Expr s = this.check(this.single(), Err.INCOMPLETE);
        boolean first = false;
        boolean last = false;
        boolean before = false;
        boolean after = false;
        if (this.wsConsumeWs("as")) {
            first = this.wsConsumeWs("first");
            if (!first) {
                this.wsCheck("last");
                last = true;
            }
            this.wsCheck("into");
        } else if (!this.wsConsumeWs("into")) {
            after = this.wsConsumeWs("after");
            boolean bl = before = !after && this.wsConsumeWs("before");
            if (!after && !before) {
                throw this.error(Err.INCOMPLETE, new Object[0]);
            }
        }
        Expr trg = this.check(this.single(), Err.INCOMPLETE);
        this.ctx.updating(true);
        return new Insert(this.sc, this.info(), s, first, last, before, after, trg);
    }

    private Expr deletee() throws QueryException {
        int i = this.pos;
        if (!this.wsConsumeWs("delete") || !this.wsConsumeWs("nodes") && !this.wsConsumeWs("node")) {
            this.pos = i;
            return null;
        }
        this.ctx.updating(true);
        return new Delete(this.sc, this.info(), this.check(this.single(), Err.INCOMPLETE));
    }

    private Expr rename() throws QueryException {
        int i = this.pos;
        if (!this.wsConsumeWs("rename") || !this.wsConsumeWs("node")) {
            this.pos = i;
            return null;
        }
        Expr trg = this.check(this.single(), Err.INCOMPLETE);
        this.wsCheck("as");
        Expr n = this.check(this.single(), Err.INCOMPLETE);
        this.ctx.updating(true);
        return new Rename(this.sc, this.info(), trg, n);
    }

    private Expr replace() throws QueryException {
        int i = this.pos;
        if (!this.wsConsumeWs("replace")) {
            return null;
        }
        boolean v = this.wsConsumeWs("value");
        if (v) {
            this.wsCheck("of");
            this.wsCheck("node");
        } else if (!this.wsConsumeWs("node")) {
            this.pos = i;
            return null;
        }
        Expr t = this.check(this.single(), Err.INCOMPLETE);
        this.wsCheck("with");
        Expr r = this.check(this.single(), Err.INCOMPLETE);
        this.ctx.updating(true);
        return new Replace(this.sc, this.info(), t, r, v);
    }

    private Expr transform() throws QueryException {
        if (!this.wsConsumeWs("copy", "$", Err.INCOMPLETE)) {
            return null;
        }
        int s = this.openSubScope();
        boolean u = this.ctx.updating;
        this.ctx.updating(false);
        Let[] fl = new Let[]{};
        do {
            QNm name = this.varName();
            this.wsCheck(":=");
            Expr e = this.check(this.single(), Err.INCOMPLETE);
            fl = Array.add(fl, new Let(this.addVar(name, SeqType.NOD, false), e, false, this.info()));
        } while (this.wsConsumeWs(","));
        this.wsCheck("modify");
        Expr m = this.check(this.single(), Err.INCOMPLETE);
        this.wsCheck("return");
        Expr r = this.check(this.single(), Err.INCOMPLETE);
        this.closeSubScope(s);
        this.ctx.updating = u;
        return new Transform(this.info(), fl, m, r);
    }

    private byte[] ncName(Err err) throws QueryException {
        this.tok.reset();
        if (this.ncName()) {
            return this.tok.finish();
        }
        if (err != null) {
            throw this.error(err, Character.valueOf(this.consume()));
        }
        return Token.EMPTY;
    }

    private QNm eQName(Err err, byte[] def) throws QueryException {
        byte[] nm;
        Object name;
        int i = this.pos;
        if (this.sc.xquery3() && this.consume("Q{")) {
            byte[] uri = this.bracedURILiteral();
            name = this.ncName(null);
            if (((byte[])name).length != 0) {
                if (def == URICHECK && uri.length == 0) {
                    this.pos = i;
                    throw this.error(Err.NOURI, name);
                }
                return new QNm((byte[])name, uri);
            }
            this.pos = i;
        }
        if ((nm = this.qName(err)).length == 0) {
            return null;
        }
        if (def == SKIPCHECK) {
            return new QNm(nm);
        }
        name = new QNm(nm, this.sc);
        if (!name.hasURI()) {
            if (def == URICHECK) {
                this.pos = i;
                throw this.error(Err.NSMISS, name);
            }
            if (name.hasPrefix()) {
                this.pos = i;
                throw this.error(Err.NOURI, name);
            }
            name.uri(def);
        }
        return name;
    }

    private byte[] qName(Err err) throws QueryException {
        this.tok.reset();
        if (!this.ncName()) {
            if (err != null) {
                throw this.error(err, Character.valueOf(this.consume()));
            }
        } else if (this.consume(58)) {
            if (XMLToken.isNCStartChar(this.curr())) {
                this.tok.add(58);
                do {
                    this.tok.add(this.consume());
                } while (XMLToken.isNCChar(this.curr()));
            } else {
                --this.pos;
            }
        }
        return this.tok.finish();
    }

    private boolean ncName() {
        if (!XMLToken.isNCStartChar(this.curr())) {
            return false;
        }
        do {
            this.tok.add(this.consume());
        } while (XMLToken.isNCChar(this.curr()));
        return true;
    }

    private boolean entity(TokenBuilder tb) throws QueryException {
        int i = this.pos;
        boolean ent = this.consume(38);
        if (ent) {
            if (this.consume(35)) {
                int b = this.consume(120) ? 16 : 10;
                boolean ok = true;
                int n = 0;
                do {
                    boolean h;
                    char c = this.curr();
                    boolean m = Token.digit(c);
                    boolean bl = h = b == 16 && (c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F');
                    if (!m && !h) {
                        this.entityError(i, Err.INVENTITY);
                    }
                    long nn = n;
                    if ((long)(n = n * b + (this.consume() & 0xF)) < nn) {
                        ok = false;
                    }
                    if (m) continue;
                    n += 9;
                } while (!this.consume(59));
                if (!ok) {
                    this.entityError(i, Err.INVCHARREF);
                }
                if (!XMLToken.valid(n)) {
                    this.entityError(i, Err.INVCHARREF);
                }
                tb.add(n);
            } else {
                if (this.consume("lt")) {
                    tb.add(60);
                } else if (this.consume("gt")) {
                    tb.add(62);
                } else if (this.consume("amp")) {
                    tb.add(38);
                } else if (this.consume("quot")) {
                    tb.add(34);
                } else if (this.consume("apos")) {
                    tb.add(39);
                } else {
                    this.entityError(i, Err.INVENTITY);
                }
                if (!this.consume(59)) {
                    this.entityError(i, Err.INVENTITY);
                }
            }
        } else {
            char c = this.consume();
            char ch = c;
            if (Character.isHighSurrogate(c) && this.curr() != '\u0000' && Character.isLowSurrogate(this.curr())) {
                ch = Character.toCodePoint(c, this.consume());
            }
            if (ch == '\r' && this.curr(ch = '\n')) {
                this.consume();
            }
            tb.add(ch);
        }
        return ent;
    }

    private void entityError(int p, Err c) throws QueryException {
        String sub = this.input.substring(p, Math.min(p + 20, this.length));
        int semi = sub.indexOf(59);
        String ent = semi == -1 ? sub + "..." : sub.substring(0, semi + 1);
        throw this.error(c, ent);
    }

    private <E extends Expr> E check(E expr, Err err) throws QueryException {
        if (expr == null) {
            throw this.error(err, new Object[0]);
        }
        return expr;
    }

    private void check(int ch) throws QueryException {
        if (!this.consume(ch)) {
            throw this.error(Err.WRONGCHAR, Character.valueOf((char)ch), this.found());
        }
    }

    private void wsCheck(String s) throws QueryException {
        if (!this.wsConsume(s)) {
            throw this.error(Err.WRONGCHAR, s, this.found());
        }
    }

    private Var addVar(QNm name, SeqType tp, boolean prm) {
        return this.localVars.get(this.localVars.size() - 1).addVar(name, tp, prm);
    }

    private VarRef resolveLocalVar(QNm name, InputInfo ii) {
        int i = this.localVars.size();
        Var var = null;
        while (--i >= 0 && (var = this.localVars.get((int)i).stack.get(name)) == null) {
        }
        if (var == null) {
            return null;
        }
        while (++i < this.localVars.size()) {
            VarContext vctx = this.localVars.get(i);
            Var local = vctx.addVar(var.name, var.type(), false);
            vctx.nonLocal.put(local, new VarRef(ii, var));
            var = local;
        }
        return new VarRef(ii, var);
    }

    private Expr resolveVar(QNm name, InputInfo ii) throws QueryException {
        VarRef local = this.resolveLocalVar(name, ii);
        if (local != null) {
            return local;
        }
        byte[] uri = name.uri();
        if ((this.sc.xquery3() || this.ctx.vars.declared(name)) && (this.module == null || Token.eq(this.module.uri(), uri) || this.modules.contains(uri))) {
            return this.ctx.vars.newRef(name, this.sc, ii);
        }
        throw this.error(Err.VARUNDEF, '$' + Token.string(name.string()));
    }

    private void pushVarContext(HashMap<Var, Expr> nonLocal) {
        this.localVars.add(new VarContext(nonLocal));
    }

    private VarScope popVarContext() {
        return this.localVars.remove((int)(this.localVars.size() - 1)).scope;
    }

    private int openSubScope() {
        return this.localVars.get((int)(this.localVars.size() - 1)).stack.size();
    }

    private void closeSubScope(int marker) {
        this.localVars.get((int)(this.localVars.size() - 1)).stack.size(marker);
    }

    private boolean not(char ch) throws QueryException {
        char c = this.curr();
        if (c == '\u0000') {
            throw this.error(Err.WRONGCHAR, Character.valueOf(ch), this.found());
        }
        return c != ch;
    }

    private boolean wsConsumeWs(String t) throws QueryException {
        int i = this.pos;
        if (!this.wsConsume(t)) {
            return false;
        }
        if (this.skipWs() || !XMLToken.isNCStartChar(t.charAt(0)) || !XMLToken.isNCChar(this.curr())) {
            return true;
        }
        this.pos = i;
        return false;
    }

    private boolean wsConsumeWs(String s1, String s2, Err expr) throws QueryException {
        int i = this.pos;
        if (!this.wsConsumeWs(s1)) {
            return false;
        }
        this.alter = expr;
        this.alterPos = this.pos;
        int i2 = this.pos;
        boolean ok = this.wsConsume(s2);
        this.pos = ok ? i2 : i;
        return ok;
    }

    private boolean wsConsume(String str) throws QueryException {
        this.skipWs();
        return this.consume(str);
    }

    private boolean skipWs() throws QueryException {
        int i = this.pos;
        while (this.more()) {
            char c = this.curr();
            if (c == '(' && this.next() == ':') {
                this.comment();
                continue;
            }
            if (c <= '\u0000' || c > ' ') {
                return i != this.pos;
            }
            ++this.pos;
        }
        return i != this.pos;
    }

    private void comment() throws QueryException {
        boolean doc;
        ++this.pos;
        boolean bl = doc = this.next() == '~';
        if (doc) {
            this.currDoc.setLength(0);
            ++this.pos;
        }
        while (++this.pos < this.length) {
            char curr = this.curr();
            if (curr == '(' && this.next() == ':') {
                this.comment();
                curr = this.curr();
            }
            if (curr == ':' && this.next() == ')') {
                this.pos += 2;
                if (this.moduleDoc.isEmpty()) {
                    this.moduleDoc = this.currDoc.toString().trim();
                    this.currDoc.setLength(0);
                }
                return;
            }
            if (!doc) continue;
            this.currDoc.append(curr);
        }
        throw this.error(Err.COMCLOSE, new Object[0]);
    }

    private boolean consumeWS() {
        int i = this.pos;
        while (this.more()) {
            char c = this.curr();
            if (c <= '\u0000' || c > ' ') {
                return i != this.pos;
            }
            ++this.pos;
        }
        return true;
    }

    private QueryException error() {
        this.pos = this.alterPos;
        if (this.alter != Err.FUNCUNKNOWN) {
            return this.error(this.alter, new Object[0]);
        }
        QueryException qe = this.ctx.funcs.similarError(this.alterFunc, this.info());
        return qe == null ? this.error(this.alter, new Object[]{this.alterFunc.string()}) : qe;
    }

    private void add(ExprList ar, Expr e) throws QueryException {
        if (e == null) {
            throw this.error(Err.INCOMPLETE, new Object[0]);
        }
        ar.add(e);
    }

    QueryException error(Err err, Object ... arg) {
        return err.get(this.info(), arg);
    }

    private void assignURI(int npos) throws QueryException {
        for (int i = npos; i < this.names.size(); ++i) {
            if (!this.names.get(i).assign(npos == 0)) continue;
            this.names.remove(i--);
        }
    }

    static {
        byte[][] keys;
        URICHECK = new byte[0];
        SKIPCHECK = new byte[0];
        KEYWORDS10 = new TokenSet();
        KEYWORDS30 = new TokenSet();
        for (byte[] key : keys = new byte[][]{NodeType.ATT.string(), NodeType.COM.string(), NodeType.DOC.string(), NodeType.ELM.string(), Token.token("empty-sequence"), Token.token("if"), AtomType.ITEM.string(), NodeType.NOD.string(), NodeType.PI.string(), Token.token("schema-attribute"), Token.token("schema-element"), NodeType.TXT.string(), Token.token("typeswitch")}) {
            KEYWORDS10.add(key);
            KEYWORDS30.add(key);
        }
        KEYWORDS30.add(FuncType.ANY_FUN.string());
        KEYWORDS30.add(NodeType.NSP.string());
        KEYWORDS30.add("switch");
    }

    private class VarContext {
        final VarStack stack = new VarStack();
        final VarScope scope = new VarScope(QueryParser.access$000(QueryParser.this));
        final HashMap<Var, Expr> nonLocal;

        public VarContext(HashMap<Var, Expr> bindings) {
            this.nonLocal = bindings;
        }

        public Var addVar(QNm name, SeqType tp, boolean prm) {
            Var var = this.scope.newLocal(QueryParser.this.ctx, name, tp, prm);
            this.stack.push(var);
            return var;
        }
    }

    private class QNmCheck {
        final QNm name;
        final boolean nsElem;

        QNmCheck(QNm nm) {
            this(nm, true);
        }

        QNmCheck(QNm nm, boolean nse) {
            this.name = nm;
            this.nsElem = nse;
        }

        boolean assign(boolean check) throws QueryException {
            if (this.name.hasURI()) {
                return true;
            }
            if (this.name.hasPrefix()) {
                this.name.uri(((QueryParser)QueryParser.this).sc.ns.uri(this.name.prefix()));
                if (check && !this.name.hasURI()) {
                    throw QueryParser.this.error(Err.NOURI, new Object[]{this.name.string()});
                }
            } else if (this.nsElem) {
                this.name.uri(((QueryParser)QueryParser.this).sc.elemNS);
            }
            return this.name.hasURI();
        }
    }
}

