/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Locale;
import org.basex.core.User;
import org.basex.data.Data;
import org.basex.io.IOFile;
import org.basex.io.in.NewlineInput;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Err;
import org.basex.query.value.node.FElem;
import org.basex.server.ClientListener;
import org.basex.server.Log;
import org.basex.server.Sessions;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class FNAdmin
extends StandardFunc {
    private static final String USER = "user";
    private static final String DATABASE = "database";
    private static final String SESSION = "session";
    private static final String PERMISSION = "permission";
    private static final String PASSWORD = "password";
    private static final String ENTRY = "entry";
    private static final String SIZE = "size";
    private static final String TIME = "time";
    private static final String ADDRESS = "address";
    private static final String FILE = "file";
    private static final String TYPE = "type";
    private static final String MS = "ms";

    public FNAdmin(StaticContext sctx, InputInfo ii, Function f, Expr ... e) {
        super(sctx, ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        this.checkAdmin(ctx);
        switch (this.sig) {
            case _ADMIN_LOGS: {
                return this.logs(ctx);
            }
            case _ADMIN_USERS: {
                return this.users(ctx);
            }
            case _ADMIN_SESSIONS: {
                return FNAdmin.sessions(ctx);
            }
        }
        return super.iter(ctx);
    }

    private Iter logs(QueryContext ctx) throws QueryException {
        ValueBuilder vb = new ValueBuilder();
        if (this.expr.length == 0) {
            for (IOFile f : ctx.context.log.files()) {
                String date = f.name().replace(".log", "");
                vb.add(new FElem(FILE).add(date).add(SIZE, Token.token(f.length())));
            }
        } else {
            boolean merge = this.expr.length > 1 && this.checkBln(this.expr[1], ctx);
            String name = Token.string(this.checkStr(this.expr[0], ctx)) + ".log";
            IOFile file = new IOFile(ctx.context.log.dir(), name);
            ArrayList<Log.LogEntry> logs = this.logs(file);
            for (int s = 0; s < logs.size(); ++s) {
                Log.LogEntry l1 = logs.get(s);
                FElem elem = new FElem(ENTRY);
                if (l1.address != null) {
                    if (merge && l1.ms.equals(BigDecimal.ZERO) && !"SERVER".equals(l1.address)) {
                        for (int l = s + 1; l < logs.size(); ++l) {
                            Log.LogEntry l2 = logs.get(l);
                            if (l2 == null || !l1.address.equals(l2.address) || l2.type.equals("REQUEST")) continue;
                            if (l1.type.equals("REQUEST")) {
                                l1.type = "";
                            }
                            l1.type = FNAdmin.merge(l1.type, l2.type);
                            l1.message = FNAdmin.merge(l1.message, l2.message);
                            l1.ms = l1.ms.add(l2.ms);
                            logs.remove(l--);
                            if (!l2.message.equals("REQUEST")) break;
                        }
                    }
                    elem.add(TIME, l1.time).add(ADDRESS, l1.address).add(USER, l1.user);
                    if (l1.type != null) {
                        elem.add(TYPE, l1.type);
                    }
                    if (!l1.ms.equals(BigDecimal.ZERO)) {
                        elem.add(MS, l1.ms.toString());
                    }
                    if (l1.message != null) {
                        elem.add(l1.message);
                    }
                } else {
                    elem.add(l1.message);
                }
                vb.add(elem);
            }
        }
        return vb;
    }

    private static String merge(String s1, String s2) {
        return s2.isEmpty() ? s1 : (s1.isEmpty() ? s2 : s1 + "; " + s2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<Log.LogEntry> logs(IOFile file) throws QueryException {
        ArrayList<Log.LogEntry> arrayList;
        ArrayList<Log.LogEntry> logs = new ArrayList<Log.LogEntry>();
        NewlineInput nli = new NewlineInput(file);
        try {
            String line;
            while ((line = nli.readLine()) != null) {
                Log.LogEntry log = new Log.LogEntry();
                String[] cols = line.split("\t");
                if (cols.length > 2 && (cols[1].matches(".*:\\d+") || cols[1].equals("SERVER"))) {
                    log.time = cols[0];
                    log.address = cols[1];
                    log.user = cols[2];
                    log.type = cols.length > 3 ? cols[3] : "";
                    log.message = cols.length > 4 ? cols[4] : "";
                    log.ms = cols.length > 5 ? new BigDecimal(cols[5].replace(" ms", "")) : BigDecimal.ZERO;
                } else {
                    log.message = line;
                }
                logs.add(log);
            }
            arrayList = logs;
        }
        catch (Throwable throwable) {
            try {
                nli.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw Err.IOERR.get(this.info, ex);
            }
        }
        nli.close();
        return arrayList;
    }

    private Iter users(QueryContext ctx) throws QueryException {
        ValueBuilder vb = new ValueBuilder();
        for (User u : this.expr.length == 0 ? ctx.context.users.users(null) : this.checkData((QueryContext)ctx).meta.users.users(ctx.context.users)) {
            vb.add(new FElem(USER).add(u.name).add(PERMISSION, u.perm.toString().toLowerCase(Locale.ENGLISH)).add(PASSWORD, u.password));
        }
        return vb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Iter sessions(QueryContext ctx) {
        ValueBuilder vb = new ValueBuilder();
        Sessions sessions = ctx.context.sessions;
        synchronized (sessions) {
            for (ClientListener sp : ctx.context.sessions) {
                String user = sp.context().user.name;
                String addr = sp.address();
                Data data = sp.context().data();
                FElem elem = new FElem(SESSION).add(USER, user).add(ADDRESS, addr);
                if (data != null) {
                    elem.add(DATABASE, data.meta.name);
                }
                vb.add(elem);
            }
        }
        return vb;
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return !(FNAdmin.oneOf(this.sig, Function._ADMIN_USERS, Function._ADMIN_SESSIONS) && !visitor.lock("%ADMIN") || this.sig == Function._ADMIN_USERS && this.expr.length > 0 && !this.dataLock(visitor) || !super.accept(visitor));
    }
}

