/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.math.BigInteger;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Calc;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.Collation;
import org.basex.query.util.Err;
import org.basex.query.value.item.ADate;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.AStr;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Dur;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.query.var.VarRef;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;

public final class FNAggr
extends StandardFunc {
    public FNAggr(StaticContext sctx, InputInfo ii, Function f, Expr ... e) {
        super(sctx, ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        Iter iter = ctx.iter(this.expr[0]);
        switch (this.sig) {
            case COUNT: {
                long c = iter.size();
                if (c == -1L) {
                    do {
                        ctx.checkStop();
                        ++c;
                    } while (iter.next() != null);
                }
                return Int.get(c);
            }
            case MIN: {
                return this.minmax(iter, CmpV.OpV.GT, ctx);
            }
            case MAX: {
                return this.minmax(iter, CmpV.OpV.LT, ctx);
            }
            case SUM: {
                RangeSeq rs;
                long s;
                if (this.expr[0] instanceof RangeSeq && ((s = (rs = (RangeSeq)this.expr[0]).itemAt(0L).itr(ii)) == 0L || s == 1L)) {
                    long n = rs.size();
                    return Int.get(n < 3037000500L ? n * (n + 1L) / 2L : BigInteger.valueOf(n).multiply(BigInteger.valueOf(n + 1L)).divide(BigInteger.valueOf(2L)).longValue());
                }
                Item it = iter.next();
                return it != null ? this.sum(iter, it, false) : (this.expr.length == 2 ? this.expr[1].item(ctx, this.info) : Int.get(0L));
            }
            case AVG: {
                Item it = iter.next();
                return it == null ? null : this.sum(iter, it, true);
            }
        }
        return super.item(ctx, ii);
    }

    @Override
    protected Expr opt(QueryContext ctx, VarScope scp) {
        Expr e = this.expr[0];
        if (e.has(Expr.Flag.NDT) || e instanceof VarRef) {
            return this;
        }
        long c = e.size();
        switch (this.sig) {
            case COUNT: {
                if (c < 0L) break;
                return Int.get(c);
            }
            case SUM: {
                Type b;
                if (c == 0L) {
                    return this.expr.length == 2 ? this.expr[1] : Int.get(0L);
                }
                Type a = e.type().type;
                Type type = b = this.expr.length == 2 ? this.expr[1].type().type : a;
                if (!a.isNumberOrUntyped() || !b.isNumberOrUntyped()) break;
                this.type = Calc.type(a, b).seqType();
                break;
            }
        }
        return this;
    }

    private Item sum(Iter iter, Item it, boolean avg) throws QueryException {
        Item i;
        boolean ymd;
        Item rs = it.type.isUntyped() ? Dbl.get(it.string(this.info), this.info) : it;
        boolean n = rs instanceof ANum;
        boolean dtd = !n && rs.type == AtomType.DTD;
        boolean bl = ymd = !n && !dtd && rs.type == AtomType.YMD;
        if (!(n || rs instanceof Dur && rs.type != AtomType.DUR)) {
            throw Err.SUMTYPE.get(this.info, this, rs.type);
        }
        int c = 1;
        while ((i = iter.next()) != null) {
            if (i.type.isNumberOrUntyped()) {
                if (!n) {
                    throw Err.FUNDUR.get(this.info, this, i.type);
                }
            } else {
                if (n) {
                    throw Err.FUNNUM.get(this.info, this, i.type);
                }
                if (dtd && i.type != AtomType.DTD || ymd && i.type != AtomType.YMD) {
                    throw Err.FUNCMP.get(this.info, this, it.type, i.type);
                }
            }
            rs = Calc.PLUS.ev(this.info, rs, i);
            ++c;
        }
        return avg ? Calc.DIV.ev(this.info, rs, Int.get(c)) : rs;
    }

    private Item minmax(Iter iter, CmpV.OpV cmp, QueryContext ctx) throws QueryException {
        Item it;
        Collation coll = this.checkColl(this.expr.length == 2 ? this.expr[1] : null, ctx, this.sc);
        Item rs = iter.next();
        if (rs == null) {
            return null;
        }
        cmp.eval(rs, rs, coll, this.info);
        if (rs instanceof AStr) {
            Item it2;
            while ((it2 = iter.next()) != null) {
                if (!(it2 instanceof AStr)) {
                    throw Err.FUNCMP.get(this.info, this, rs.type, it2.type);
                }
                if (!cmp.eval(rs, it2, coll, this.info)) continue;
                rs = it2;
            }
            return rs;
        }
        if (rs instanceof ADate || rs instanceof Dur || rs.type == AtomType.BLN) {
            Item it3;
            while ((it3 = iter.next()) != null) {
                if (rs.type != it3.type) {
                    throw Err.FUNCMP.get(this.info, this, rs.type, it3.type);
                }
                if (!cmp.eval(rs, it3, coll, this.info)) continue;
                rs = it3;
            }
            return rs;
        }
        if (rs.type.isUntyped()) {
            rs = AtomType.DBL.cast(rs, ctx, this.sc, this.info);
        }
        while ((it = iter.next()) != null) {
            Type t = this.numType(rs, it);
            if (cmp.eval(rs, it, coll, this.info) || Double.isNaN(it.dbl(this.info))) {
                rs = it;
            }
            if (rs.type == t) continue;
            rs = (Item)t.cast(rs, ctx, this.sc, this.info);
        }
        return rs;
    }

    private Type numType(Item r, Item i) throws QueryException {
        Type tr = r.type;
        Type ti = i.type;
        if (ti.isUntyped()) {
            return AtomType.DBL;
        }
        if (!(i instanceof ANum)) {
            throw Err.FUNCMP.get(this.info, this, tr, ti);
        }
        if (tr == ti) {
            return tr;
        }
        if (tr == AtomType.DBL || ti == AtomType.DBL) {
            return AtomType.DBL;
        }
        if (tr == AtomType.FLT || ti == AtomType.FLT) {
            return AtomType.FLT;
        }
        if (tr == AtomType.DEC || ti == AtomType.DEC) {
            return AtomType.DEC;
        }
        return AtomType.ITR;
    }
}

