/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.CharacterCodingException;
import java.util.Arrays;
import org.basex.io.IOContent;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.FNConvert;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.iter.ValueIter;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Flt;
import org.basex.query.value.item.Hex;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.seq.IntSeq;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.list.ByteList;

public class FNBin
extends StandardFunc {
    private static final byte[][] BIG = Token.tokens("most-significant-first", "big-endian", "BE");
    private static final byte[][] LITTLE = Token.tokens("least-significant-first", "little-endian", "LE");

    public FNBin(StaticContext sctx, InputInfo ii, Function f, Expr ... e) {
        super(sctx, ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case _BIN_TO_OCTETS: {
                return this.toOctetsIter(ctx);
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case _BIN_TO_OCTETS: {
                return this.toOctets(ctx);
            }
        }
        return super.value(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.sig) {
            case _BIN_HEX: {
                return this.hex(ctx);
            }
            case _BIN_BIN: {
                return this.bin(ctx);
            }
            case _BIN_OCTAL: {
                return this.octal(ctx);
            }
            case _BIN_FROM_OCTETS: {
                return this.fromOctets(ctx);
            }
            case _BIN_LENGTH: {
                return this.length(ctx);
            }
            case _BIN_PART: {
                return this.part(ctx);
            }
            case _BIN_JOIN: {
                return this.join(ctx);
            }
            case _BIN_INSERT_BEFORE: {
                return this.insertBefore(ctx);
            }
            case _BIN_PAD_LEFT: {
                return this.pad(ctx, true);
            }
            case _BIN_PAD_RIGHT: {
                return this.pad(ctx, false);
            }
            case _BIN_FIND: {
                return this.find(ctx);
            }
            case _BIN_DECODE_STRING: {
                return this.decodeString(ctx);
            }
            case _BIN_ENCODE_STRING: {
                return this.encodeString(ctx);
            }
            case _BIN_PACK_DOUBLE: {
                return this.packDouble(ctx);
            }
            case _BIN_PACK_FLOAT: {
                return this.packFloat(ctx);
            }
            case _BIN_PACK_INTEGER: {
                return this.packInteger(ctx);
            }
            case _BIN_UNPACK_DOUBLE: {
                return Dbl.get(this.unpack(ctx, 8L).getDouble());
            }
            case _BIN_UNPACK_FLOAT: {
                return Flt.get(this.unpack(ctx, 4L).getFloat());
            }
            case _BIN_UNPACK_INTEGER: {
                return this.unpackInteger(ctx, true);
            }
            case _BIN_UNPACK_UNSIGNED_INTEGER: {
                return this.unpackInteger(ctx, false);
            }
            case _BIN_OR: {
                return this.bit(Bit.OR, ctx);
            }
            case _BIN_XOR: {
                return this.bit(Bit.XOR, ctx);
            }
            case _BIN_AND: {
                return this.bit(Bit.AND, ctx);
            }
            case _BIN_NOT: {
                return this.not(ctx);
            }
            case _BIN_SHIFT: {
                return this.shift(ctx);
            }
        }
        return super.item(ctx, ii);
    }

    private B64 hex(QueryContext ctx) throws QueryException {
        byte[] bytes = this.str(0, ctx);
        if (bytes == null) {
            return null;
        }
        if ((bytes.length & 1) != 0) {
            bytes = Token.concat(Token.ZERO, bytes);
        }
        try {
            return new B64(Hex.decode(bytes, this.info));
        }
        catch (QueryException ex) {
            throw Err.BIN_NNC.get(this.info, new Object[0]);
        }
    }

    private B64 bin(QueryContext ctx) throws QueryException {
        byte[] bytes = this.str(0, ctx);
        if (bytes == null) {
            return null;
        }
        return new B64(this.binary2bytes(bytes));
    }

    private B64 octal(QueryContext ctx) throws QueryException {
        byte[] bytes = this.str(0, ctx);
        if (bytes == null) {
            return null;
        }
        int bl = bytes.length;
        if (bl == 0) {
            return new B64(Token.EMPTY);
        }
        try {
            byte[] bin = Token.token(new BigInteger(Token.string(bytes), 8).toString(2));
            int expl = bl * 3;
            int binl = bin.length;
            if (binl != expl) {
                byte[] tmp = new byte[expl];
                Arrays.fill(tmp, 0, expl - binl, (byte)48);
                System.arraycopy(bin, 0, tmp, expl - binl, binl);
                bin = tmp;
            }
            return new B64(this.binary2bytes(bin));
        }
        catch (NumberFormatException ex) {
            throw Err.BIN_NNC.get(this.info, new Object[0]);
        }
    }

    private byte[] binary2bytes(byte[] bytes) throws QueryException {
        int bl = bytes.length;
        int r = bl & 7;
        int l = 8 - r & 7;
        int s = bl + 7 >>> 3;
        byte[] tmp = new byte[s];
        for (int i = 0; i < bl; ++i) {
            byte b = bytes[i];
            if (b == 49) {
                int n = l + i >>> 3;
                tmp[n] = (byte)(tmp[n] | 128 >>> (i - r & 7));
                continue;
            }
            if (b == 48) continue;
            throw Err.BIN_NNC.get(this.info, new Object[0]);
        }
        return tmp;
    }

    private Value toOctets(QueryContext ctx) throws QueryException {
        B64 b = this.b64(this.expr[0], false, ctx);
        byte[] bytes = b.binary(this.info);
        long[] vals = new long[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            vals[i] = bytes[i] & 0xFF;
        }
        return IntSeq.get(vals, AtomType.ITR);
    }

    private Iter toOctetsIter(QueryContext ctx) throws QueryException {
        B64 b = this.b64(this.expr[0], false, ctx);
        final byte[] bytes = b.binary(this.info);
        return new ValueIter(){
            final int s;
            int c;
            {
                this.s = bytes.length;
            }

            @Override
            public Int get(long i) {
                return Int.get(bytes[(int)i] & 0xFF);
            }

            @Override
            public Int next() {
                return this.c < this.s ? this.get(this.c++) : null;
            }

            @Override
            public boolean reset() {
                this.c = 0;
                return true;
            }

            @Override
            public long size() {
                return this.s;
            }

            @Override
            public Value value() {
                long[] vals = new long[bytes.length];
                for (int i = 0; i < bytes.length; ++i) {
                    vals[i] = bytes[i];
                }
                return IntSeq.get(vals, AtomType.ITR);
            }
        };
    }

    private B64 fromOctets(QueryContext ctx) throws QueryException {
        Item it;
        Iter ir = ctx.iter(this.expr[0]);
        ByteList bl = new ByteList(Math.max(8, (int)ir.size()));
        while ((it = ir.next()) != null) {
            long l = this.checkItr(it);
            if (l < 0L || l > 255L) {
                throw Err.BIN_OOR_X.get(this.info, l);
            }
            bl.add((int)l);
        }
        return new B64(bl.toArray());
    }

    private Int length(QueryContext ctx) throws QueryException {
        B64 b = this.b64(this.expr[0], false, ctx);
        return Int.get(b.binary(this.info).length);
    }

    private B64 part(QueryContext ctx) throws QueryException {
        Long len;
        B64 b64 = this.b64(this.expr[0], true, ctx);
        Long off = this.checkItr(this.expr[1], ctx);
        Long l = len = this.expr.length > 2 ? Long.valueOf(this.checkItr(this.expr[2], ctx)) : null;
        if (b64 == null) {
            return null;
        }
        byte[] bytes = b64.binary(this.info);
        int bl = bytes.length;
        int[] bounds = this.bounds(off, len, bl);
        byte[] tmp = new byte[bounds[1]];
        System.arraycopy(bytes, bounds[0], tmp, 0, bounds[1]);
        return new B64(tmp);
    }

    private B64 join(QueryContext ctx) throws QueryException {
        Item it;
        ByteList bl = new ByteList();
        Iter ir = ctx.iter(this.expr[0]);
        while ((it = ir.next()) != null) {
            bl.add(this.checkBinary(it, ctx).binary(this.info));
        }
        return new B64(bl.toArray());
    }

    private B64 insertBefore(QueryContext ctx) throws QueryException {
        B64 b64 = this.b64(this.expr[0], true, ctx);
        Long off = this.checkItr(this.expr[1], ctx);
        B64 xtr = this.b64(this.expr[2], true, ctx);
        if (b64 == null) {
            return null;
        }
        byte[] bytes = b64.binary(this.info);
        int bl = bytes.length;
        int[] bounds = this.bounds(off, null, bl);
        if (xtr == null) {
            return b64;
        }
        byte[] extra = xtr.binary(this.info);
        int xl = extra.length;
        byte[] tmp = new byte[bl + xl];
        int o = bounds[0];
        System.arraycopy(bytes, 0, tmp, 0, o);
        System.arraycopy(extra, 0, tmp, o, xl);
        System.arraycopy(bytes, o, tmp, o + xl, bl - o);
        return new B64(tmp);
    }

    private B64 pad(QueryContext ctx, boolean left) throws QueryException {
        long octet;
        B64 b64 = this.b64(this.expr[0], true, ctx);
        long sz = this.checkItr(this.expr[1], ctx);
        long l = octet = this.expr.length > 2 ? this.checkItr(this.expr[2], ctx) : 0L;
        if (b64 == null) {
            return null;
        }
        byte[] bytes = b64.binary(this.info);
        int bl = bytes.length;
        if (sz < 0L) {
            throw Err.BIN_NS_X.get(this.info, sz);
        }
        if (octet < 0L || octet > 255L) {
            throw Err.BIN_OOR_X.get(this.info, octet);
        }
        byte[] tmp = new byte[(int)((long)bl + sz)];
        if (left) {
            Arrays.fill(tmp, 0, (int)sz, (byte)octet);
            System.arraycopy(bytes, 0, tmp, (int)sz, bl);
        } else {
            System.arraycopy(bytes, 0, tmp, 0, bl);
            Arrays.fill(tmp, bl, tmp.length, (byte)octet);
        }
        return new B64(tmp);
    }

    private Int find(QueryContext ctx) throws QueryException {
        int[] bounds;
        B64 b64 = this.b64(this.expr[0], true, ctx);
        Long off = this.checkItr(this.expr[1], ctx);
        B64 srch = this.b64(this.expr[2], false, ctx);
        if (b64 == null) {
            return null;
        }
        byte[] bytes = b64.binary(this.info);
        int bl = bytes.length;
        byte[] search = srch.binary(this.info);
        int pos = Token.indexOf(bytes, search, (bounds = this.bounds(off, null, bl))[0]);
        return pos == -1 ? null : Int.get(pos);
    }

    private Str decodeString(QueryContext ctx) throws QueryException {
        Long len;
        B64 b64 = this.b64(this.expr[0], true, ctx);
        String enc = this.encoding(1, Err.BIN_UE_X, ctx);
        Long off = this.expr.length > 2 ? Long.valueOf(this.checkItr(this.expr[2], ctx)) : null;
        Long l = len = this.expr.length > 3 ? Long.valueOf(this.checkItr(this.expr[3], ctx)) : null;
        if (b64 == null) {
            return null;
        }
        byte[] bytes = b64.binary(this.info);
        int bl = bytes.length;
        int[] bounds = this.bounds(off, len, bl);
        if (bounds[0] > 0 || bounds[1] < bl) {
            byte[] tmp = new byte[bounds[1]];
            System.arraycopy(bytes, bounds[0], tmp, 0, bounds[1]);
            bytes = tmp;
        }
        try {
            return Str.get(FNConvert.toString((InputStream)new IOContent(bytes).inputStream(), enc, true));
        }
        catch (IOException ex) {
            throw Err.BIN_CE.get(this.info, ex);
        }
    }

    private B64 encodeString(QueryContext ctx) throws QueryException {
        byte[] str = this.str(0, ctx);
        String enc = this.encoding(1, Err.BIN_UE_X, ctx);
        if (str == null) {
            return null;
        }
        try {
            return new B64(enc == null || enc == "UTF-8" ? str : FNConvert.toBinary(str, enc));
        }
        catch (CharacterCodingException ex) {
            throw Err.BIN_CE.get(this.info, ex);
        }
    }

    private B64 packDouble(QueryContext ctx) throws QueryException {
        double d = this.checkDbl(this.expr[0], ctx);
        ByteOrder bo = this.order(1, ctx);
        return new B64(ByteBuffer.wrap(new byte[8]).order(bo).putDouble(d).array());
    }

    private B64 packFloat(QueryContext ctx) throws QueryException {
        float f = this.checkFlt(this.expr[0], ctx);
        ByteOrder bo = this.order(1, ctx);
        return new B64(ByteBuffer.wrap(new byte[4]).order(bo).putFloat(f).array());
    }

    private B64 packInteger(QueryContext ctx) throws QueryException {
        long b = this.checkItr(this.expr[0], ctx);
        long sz = this.checkItr(this.expr[1], ctx);
        ByteOrder bo = this.order(2, ctx);
        if (sz < 0L || sz > Long.MAX_VALUE) {
            throw Err.BIN_NS_X.get(this.info, sz);
        }
        byte[] tmp = new byte[(int)sz];
        int tl = tmp.length;
        if (bo == ByteOrder.BIG_ENDIAN) {
            for (int t = tl - 1; t >= 0; --t) {
                tmp[t] = (byte)b;
                b >>= 8;
            }
        } else {
            for (int t = 0; t < tl; ++t) {
                tmp[t] = (byte)b;
                b >>= 8;
            }
        }
        return new B64(tmp);
    }

    private ByteBuffer unpack(QueryContext ctx, long len) throws QueryException {
        B64 b64 = this.b64(this.expr[0], false, ctx);
        Long off = this.checkItr(this.expr[1], ctx);
        ByteOrder bo = this.order(2, ctx);
        byte[] bytes = b64.binary(this.info);
        int bl = bytes.length;
        int[] bounds = this.bounds(off, len, bl);
        ByteBuffer bb = ByteBuffer.allocate(bounds[1]).order(bo);
        bb.put(bytes, bounds[0], bounds[1]).position(0);
        return bb;
    }

    private Int unpackInteger(QueryContext ctx, boolean signed) throws QueryException {
        boolean neg;
        B64 b64 = this.b64(this.expr[0], false, ctx);
        Long off = this.checkItr(this.expr[1], ctx);
        Long sz = this.checkItr(this.expr[2], ctx);
        ByteOrder bo = this.order(3, ctx);
        byte[] bytes = b64.binary(this.info);
        int bl = bytes.length;
        int[] bounds = this.bounds(off, sz, bl);
        int o = bounds[0];
        int l = Math.min(8, bounds[1]);
        if (l == 0) {
            return Int.get(0L);
        }
        byte[] tmp = new byte[8];
        boolean bl2 = neg = signed && (bytes[0] & 0x80) != 0;
        if (bo == ByteOrder.BIG_ENDIAN) {
            int s = 8 - l;
            if (neg) {
                for (int i = 0; i < s; ++i) {
                    tmp[i] = -1;
                }
            }
            System.arraycopy(bytes, o, tmp, s, l);
        } else {
            int s = l;
            System.arraycopy(bytes, o, tmp, 0, l);
            if (neg) {
                for (int i = s; i < 8; ++i) {
                    tmp[i] = -1;
                }
            }
        }
        return Int.get(ByteBuffer.wrap(tmp).order(bo).getLong());
    }

    private B64 bit(Bit op, QueryContext ctx) throws QueryException {
        byte[] bytes2;
        int bl2;
        B64 b1 = this.b64(this.expr[0], true, ctx);
        B64 b2 = this.b64(this.expr[1], true, ctx);
        if (b1 == null || b2 == null) {
            return null;
        }
        byte[] bytes1 = b1.binary(this.info);
        int bl1 = bytes1.length;
        if (bl1 != (bl2 = (bytes2 = b2.binary(this.info)).length)) {
            throw Err.BIN_DLA_X_X.get(this.info, bl1, bl2);
        }
        byte[] tmp = new byte[bl1];
        for (int b = 0; b < bl1; ++b) {
            tmp[b] = (byte)(op == Bit.OR ? bytes1[b] | bytes2[b] : (op == Bit.XOR ? bytes1[b] ^ bytes2[b] : bytes1[b] & bytes2[b]));
        }
        return new B64(tmp);
    }

    private B64 not(QueryContext ctx) throws QueryException {
        B64 b64 = this.b64(this.expr[0], true, ctx);
        if (b64 == null) {
            return null;
        }
        byte[] bytes = b64.binary(this.info);
        int bl = bytes.length;
        byte[] tmp = new byte[bl];
        for (int b = 0; b < bl; ++b) {
            tmp[b] = ~bytes[b];
        }
        return new B64(tmp);
    }

    private B64 shift(QueryContext ctx) throws QueryException {
        B64 b64 = this.b64(this.expr[0], true, ctx);
        long by = this.checkItr(this.expr[1], ctx);
        if (b64 == null) {
            return null;
        }
        if (by == 0L) {
            return b64;
        }
        byte[] bytes = b64.binary(this.info);
        int bl = bytes.length;
        byte[] tmp = new byte[bl];
        int r = 0;
        if (by > 7L) {
            tmp = new BigInteger(bytes).shiftLeft((int)by).toByteArray();
            if (tmp.length != bl) {
                bytes = tmp;
                tmp = new byte[bl];
                System.arraycopy(bytes, bytes.length - bl, tmp, 0, bl);
            }
        } else if (by > 0L) {
            for (int i = bl - 1; i >= 0; --i) {
                byte b = bytes[i];
                tmp[i] = (byte)(b << (int)by | r);
                r = b >>> (int)(32L - by);
            }
        } else if (by > -8L) {
            by = -by;
            for (int i = 0; i < bl; ++i) {
                int b = bytes[i] & 0xFF;
                tmp[i] = (byte)(b >>> (int)by | r);
                r = b << (int)(32L - by);
            }
        } else {
            by = -by;
            BigInteger bi = new BigInteger(bytes);
            if (bi.signum() >= 0) {
                bi = bi.shiftRight((int)by);
            } else {
                BigInteger o = BigInteger.ONE.shiftLeft(bl * 8 + 1);
                BigInteger m = o.subtract(BigInteger.ONE).shiftRight((int)by + 1);
                bi = bi.subtract(o).shiftRight((int)by).and(m);
            }
            tmp = bi.toByteArray();
            int tl = tmp.length;
            if (tl != bl) {
                bytes = tmp;
                tmp = new byte[bl];
                System.arraycopy(bytes, 0, tmp, bl - tl, tl);
            }
        }
        return new B64(tmp);
    }

    private B64 b64(Expr e, boolean empty, QueryContext ctx) throws QueryException {
        Item it = e.item(ctx, this.info);
        if (it == null) {
            if (empty) {
                return null;
            }
            throw Err.INVEMPTY.get(this.info, this.description());
        }
        return (B64)this.checkType(it, AtomType.B64);
    }

    private byte[] str(int o, QueryContext ctx) throws QueryException {
        Item it = this.expr[o].item(ctx, this.info);
        return it == null ? null : this.checkStr(it);
    }

    private ByteOrder order(int o, QueryContext ctx) throws QueryException {
        if (o >= this.expr.length) {
            return ByteOrder.BIG_ENDIAN;
        }
        byte[] order = this.checkStr(this.expr[o], ctx);
        if (Token.eq(order, BIG)) {
            return ByteOrder.BIG_ENDIAN;
        }
        if (Token.eq(order, LITTLE)) {
            return ByteOrder.LITTLE_ENDIAN;
        }
        throw Err.BIN_USO_X.get(this.info, new Object[]{order});
    }

    private int[] bounds(Long off, Long len, int sz) throws QueryException {
        int o = 0;
        int s = sz;
        if (off != null) {
            if (off < 0L || off > (long)sz || off > Integer.MAX_VALUE) {
                throw Err.BIN_IOOR_X_X.get(this.info, off, sz);
            }
            o = (int)off.longValue();
        }
        if (len != null) {
            if (len < 0L) {
                throw Err.BIN_NS_X.get(this.info, off);
            }
            if ((long)o + len > (long)sz || len > Integer.MAX_VALUE) {
                throw Err.BIN_IOOR_X_X.get(this.info, (long)o + len, sz);
            }
            s = (int)len.longValue();
        } else {
            s = sz - o;
        }
        return new int[]{o, s};
    }

    private static enum Bit {
        OR,
        XOR,
        AND;

    }
}

