/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.expr.List;
import org.basex.query.func.DynFuncCall;
import org.basex.query.func.Function;
import org.basex.query.func.Functions;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.StaticFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.FuncType;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;

public final class FNFunc
extends StandardFunc {
    static final int UNROLL_LIMIT = 10;

    public FNFunc(StaticContext sctx, InputInfo ii, Function f, Expr ... e) {
        super(sctx, ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case FOR_EACH: {
                return this.forEach(ctx);
            }
            case FILTER: {
                return this.filter(ctx);
            }
            case FOR_EACH_PAIR: {
                return this.forEachPair(ctx);
            }
            case FOLD_LEFT: {
                return this.foldLeft(ctx);
            }
            case FOLD_RIGHT: {
                return this.foldRight(ctx);
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.sig) {
            case FUNCTION_ARITY: {
                return Int.get(this.checkFunc(this.expr[0], ctx).arity());
            }
            case FUNCTION_NAME: {
                return this.checkFunc(this.expr[0], ctx).funcName();
            }
            case FUNCTION_LOOKUP: {
                return this.lookup(ctx, ii);
            }
        }
        return super.item(ctx, ii);
    }

    @Override
    Expr opt(QueryContext ctx, VarScope scp) throws QueryException {
        if (FNFunc.oneOf(this.sig, Function.FOLD_LEFT, Function.FOLD_RIGHT, Function.FOR_EACH) && this.allAreValues() && this.expr[0].size() < 10L) {
            ctx.compInfo("unrolling %", this);
            Value seq = (Value)this.expr[0];
            int len = (int)seq.size();
            if (this.sig == Function.FOR_EACH) {
                Expr[] results = new Expr[len];
                for (int i = 0; i < len; ++i) {
                    results[i] = new DynFuncCall(this.info, this.expr[1], new Expr[]{seq.itemAt(i)}).optimize(ctx, scp);
                }
                return new List(this.info, results).optimize(ctx, scp);
            }
            Expr e = this.expr[1];
            if (this.sig == Function.FOLD_LEFT) {
                for (Item it : seq) {
                    e = new DynFuncCall(this.info, this.expr[2], new Expr[]{e, it}).optimize(ctx, scp);
                }
            } else {
                int i = len;
                while (--i >= 0) {
                    e = new DynFuncCall(this.info, this.expr[2], new Expr[]{seq.itemAt(i), e}).optimize(ctx, scp);
                }
            }
            return e;
        }
        if (this.sig == Function.FUNCTION_LOOKUP) {
            for (StaticFunc sf : ctx.funcs.funcs()) {
                sf.compile(ctx);
            }
        }
        return this;
    }

    private Item lookup(QueryContext ctx, InputInfo ii) throws QueryException {
        QNm name = this.checkQNm(this.expr[0], ctx, this.sc);
        long arity = this.checkItr(this.expr[1], ctx);
        if (arity < 0L || arity > Integer.MAX_VALUE) {
            throw Err.FUNCUNKNOWN.get(ii, name);
        }
        try {
            Expr lit = Functions.getLiteral(name, (int)arity, ctx, this.sc, ii);
            return lit == null ? null : lit.item(ctx, ii);
        }
        catch (QueryException e) {
            return null;
        }
    }

    private Iter forEach(final QueryContext ctx) throws QueryException {
        final FItem f = this.withArity(1, 1, ctx);
        final Iter xs = this.expr[0].iter(ctx);
        return new Iter(){
            Iter ys = Empty.ITER;

            @Override
            public Item next() throws QueryException {
                Item it;
                while ((it = this.ys.next()) == null) {
                    Item x = xs.next();
                    if (x == null) {
                        return null;
                    }
                    this.ys = f.invokeValue(ctx, FNFunc.this.info, x).iter();
                }
                return it;
            }
        };
    }

    private Iter filter(final QueryContext ctx) throws QueryException {
        final FItem f = this.withArity(1, 1, ctx);
        final Iter xs = this.expr[0].iter(ctx);
        return new Iter(){

            @Override
            public Item next() throws QueryException {
                Item it;
                do {
                    if ((it = xs.next()) != null) continue;
                    return null;
                } while (!FNFunc.this.checkBln(FNFunc.this.checkNoEmpty(f.invokeItem(ctx, FNFunc.this.info, it)), ctx));
                return it;
            }
        };
    }

    private Iter forEachPair(final QueryContext ctx) throws QueryException {
        final FItem zipper = this.withArity(2, 2, ctx);
        final Iter xs = this.expr[0].iter(ctx);
        final Iter ys = this.expr[1].iter(ctx);
        return new Iter(){
            Iter zs = Empty.ITER;

            @Override
            public Item next() throws QueryException {
                Item it;
                while ((it = this.zs.next()) == null) {
                    Item x = xs.next();
                    Item y = ys.next();
                    if (x == null || y == null) {
                        return null;
                    }
                    this.zs = zipper.invokeValue(ctx, FNFunc.this.info, x, y).iter();
                }
                return it;
            }
        };
    }

    private Iter foldLeft(QueryContext ctx) throws QueryException {
        FItem f = this.withArity(2, 2, ctx);
        Iter xs = this.expr[0].iter(ctx);
        Item x = xs.next();
        if (x == null) {
            return this.expr[1].iter(ctx);
        }
        Value sum = ctx.value(this.expr[1]);
        do {
            sum = f.invokeValue(ctx, this.info, sum, x);
        } while ((x = xs.next()) != null);
        return sum.iter();
    }

    private Iter foldRight(QueryContext ctx) throws QueryException {
        FItem f = this.withArity(2, 2, ctx);
        Value xs = ctx.value(this.expr[0]);
        if (xs.isEmpty()) {
            return this.expr[1].iter(ctx);
        }
        Value res = ctx.value(this.expr[1]);
        long i = xs.size();
        while (--i >= 0L) {
            res = f.invokeValue(ctx, this.info, xs.itemAt(i), res);
        }
        return res.iter();
    }

    private FItem withArity(int p, int a, QueryContext ctx) throws QueryException {
        FItem fi;
        Item it = this.checkItem(this.expr[p], ctx);
        if (it instanceof FItem && (fi = (FItem)it).arity() == a) {
            return fi;
        }
        throw Err.typeError(this, FuncType.arity(a), it);
    }
}

