/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.Random;
import java.util.UUID;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.util.InputInfo;

public final class FNRandom
extends StandardFunc {
    private static final Random RND = new Random();

    public FNRandom(StaticContext sctx, InputInfo ii, Function f, Expr ... e) {
        super(sctx, ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.sig) {
            case _RANDOM_DOUBLE: {
                return Dbl.get(FNRandom.randomDouble());
            }
            case _RANDOM_INTEGER: {
                return Int.get(this.randomInt(ctx));
            }
            case _RANDOM_UUID: {
                return Str.get(UUID.randomUUID().toString());
            }
        }
        return super.item(ctx, ii);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case _RANDOM_SEEDED_DOUBLE: {
                return this.randomSeededDouble(ctx);
            }
            case _RANDOM_SEEDED_INTEGER: {
                return this.randomSeededInt(ctx);
            }
            case _RANDOM_GAUSSIAN: {
                return this.randomGaussian(ctx);
            }
        }
        return super.iter(ctx);
    }

    private int randomInt(QueryContext ctx) throws QueryException {
        if (this.expr.length == 0) {
            return RND.nextInt();
        }
        long s = this.checkItr(this.expr[0], ctx);
        return s < 1L || s > Integer.MAX_VALUE ? 0 : RND.nextInt((int)s);
    }

    private Iter randomSeededInt(final QueryContext ctx) throws QueryException {
        return new Iter(){
            int count;
            final long seed;
            final int num;
            final Random r;
            {
                this.seed = FNRandom.this.checkItr(FNRandom.this.expr[0], ctx);
                this.num = (int)FNRandom.this.checkItr(FNRandom.this.expr[1], ctx);
                this.r = new Random(this.seed);
            }

            @Override
            public Item next() throws QueryException {
                if (FNRandom.this.expr.length == 3) {
                    int max = (int)FNRandom.this.checkItr(FNRandom.this.expr[2], ctx);
                    return ++this.count <= this.num ? Int.get(this.r.nextInt(max)) : null;
                }
                return ++this.count <= this.num ? Int.get(this.r.nextInt()) : null;
            }
        };
    }

    private static double randomDouble() {
        return RND.nextDouble();
    }

    private Iter randomSeededDouble(final QueryContext ctx) throws QueryException {
        return new Iter(){
            int count;
            final long seed;
            final int num;
            final Random r;
            {
                this.seed = FNRandom.this.checkItr(FNRandom.this.expr[0], ctx);
                this.num = (int)FNRandom.this.checkItr(FNRandom.this.expr[1], ctx);
                this.r = new Random(this.seed);
            }

            @Override
            public Item next() {
                return ++this.count <= this.num ? Dbl.get(this.r.nextDouble()) : null;
            }
        };
    }

    private Iter randomGaussian(final QueryContext ctx) throws QueryException {
        return new Iter(){
            final int num;
            int count;
            {
                this.num = (int)FNRandom.this.checkItr(FNRandom.this.expr[0], ctx);
            }

            @Override
            public Item next() {
                return ++this.count <= this.num ? Dbl.get(RND.nextGaussian()) : null;
            }
        };
    }
}

