/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.IOFile;
import org.basex.io.IOStream;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.StrSeq;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.TokenList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class FNValidate
extends StandardFunc {
    public FNValidate(StaticContext sctx, InputInfo ii, Function f, Expr ... e) {
        super(sctx, ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        this.checkCreate(ctx);
        switch (this.sig) {
            case _VALIDATE_XSD_INFO: {
                return this.xsdInfo(ctx).iter();
            }
            case _VALIDATE_DTD_INFO: {
                return this.dtdInfo(ctx).iter();
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case _VALIDATE_XSD_INFO: {
                return this.xsdInfo(ctx);
            }
            case _VALIDATE_DTD_INFO: {
                return this.dtdInfo(ctx);
            }
        }
        return super.value(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        this.checkCreate(ctx);
        switch (this.sig) {
            case _VALIDATE_XSD: {
                return this.xsd(ctx);
            }
            case _VALIDATE_DTD: {
                return this.dtd(ctx);
            }
        }
        return super.item(ctx, ii);
    }

    private Item xsd(QueryContext ctx) throws QueryException {
        Value seq = this.xsdInfo(ctx);
        if (seq == Empty.SEQ) {
            return null;
        }
        throw Err.BXVA_FAIL.get(this.info, seq.iter().next());
    }

    private Value xsdInfo(final QueryContext ctx) throws QueryException {
        return this.process(new Validate(){

            @Override
            void process(ErrorHandler handler) throws IOException, SAXException, QueryException {
                Schema schema;
                IO in = FNValidate.this.read(FNValidate.this.checkItem(FNValidate.this.expr[0], ctx), ctx, null);
                SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                if (FNValidate.this.expr.length < 2) {
                    schema = sf.newSchema();
                } else {
                    Item it = FNValidate.this.checkItem(FNValidate.this.expr[1], ctx);
                    IO scio = FNValidate.this.read(it, ctx, null);
                    this.tmp = FNValidate.createTmp(scio);
                    if (this.tmp != null) {
                        scio = this.tmp;
                    }
                    schema = sf.newSchema(new URL(scio.url()));
                }
                Validator v = schema.newValidator();
                v.setErrorHandler(handler);
                v.validate(new StreamSource(in.inputStream()));
            }
        });
    }

    private Item dtd(QueryContext ctx) throws QueryException {
        Value seq = this.dtdInfo(ctx);
        if (seq == Empty.SEQ) {
            return null;
        }
        throw Err.BXVA_FAIL.get(this.info, seq.iter().next());
    }

    private Value dtdInfo(final QueryContext ctx) throws QueryException {
        return this.process(new Validate(){

            @Override
            void process(ErrorHandler handler) throws IOException, ParserConfigurationException, SAXException, QueryException {
                Item it = FNValidate.this.checkItem(FNValidate.this.expr[0], ctx);
                SerializerOptions sp = null;
                if (FNValidate.this.expr.length > 1) {
                    sp = new SerializerOptions();
                    IO dtd = FNValidate.this.checkPath(FNValidate.this.expr[1], ctx);
                    this.tmp = FNValidate.createTmp(dtd);
                    if (this.tmp != null) {
                        dtd = this.tmp;
                    }
                    sp.set(SerializerOptions.DOCTYPE_SYSTEM, dtd.url());
                }
                IO in = FNValidate.this.read(it, ctx, sp);
                SAXParserFactory sf = SAXParserFactory.newInstance();
                sf.setValidating(true);
                sf.newSAXParser().parse(in.inputSource(), (DefaultHandler)handler);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Value process(Validate v) throws QueryException {
        ErrorHandler handler = new ErrorHandler();
        try {
            v.process(handler);
        }
        catch (IOException ex) {
            throw Err.BXVA_START.get(this.info, ex);
        }
        catch (ParserConfigurationException ex) {
            throw Err.BXVA_START.get(this.info, ex);
        }
        catch (SAXException ex) {
            Throwable e = ex;
            while (((Throwable)e).getCause() != null) {
                Util.debug(e);
                e = ((Throwable)e).getCause();
            }
            Str str = Str.get("Fatal:" + ex.getLocalizedMessage());
            return str;
        }
        finally {
            if (v.tmp != null) {
                v.tmp.delete();
            }
        }
        return StrSeq.get(handler.getExceptions());
    }

    private static IOFile createTmp(IO in) throws IOException {
        if (!(in instanceof IOContent) && !(in instanceof IOStream)) {
            return null;
        }
        IOFile tmp = new IOFile(File.createTempFile("validate", ".basex"));
        tmp.write(in.read());
        return tmp;
    }

    IO read(Item it, QueryContext ctx, SerializerOptions sopts) throws QueryException, IOException {
        if (it.type.isNode()) {
            ArrayOutput ao = new ArrayOutput();
            Serializer.get(ao, sopts).serialize(it);
            IOContent io = new IOContent(ao.toArray());
            io.name(Token.string(((ANode)it).baseURI()));
            return io;
        }
        if (it.type.isStringOrUntyped()) {
            IO io = this.checkPath(it, ctx);
            if (sopts != null) {
                ArrayOutput ao = new ArrayOutput();
                Serializer.get(ao, sopts).serialize((Item)new DBNode(io, ctx.context.options));
                io = new IOContent(ao.toArray());
                io.name(io.path());
            }
            return io;
        }
        throw Err.STRNODTYPE.get(this.info, this, it.type);
    }

    static abstract class Validate {
        IOFile tmp;

        Validate() {
        }

        abstract void process(ErrorHandler var1) throws IOException, ParserConfigurationException, SAXException, QueryException;
    }

    static class ErrorHandler
    extends DefaultHandler {
        private final TokenList exceptions = new TokenList();

        ErrorHandler() {
        }

        @Override
        public void fatalError(SAXParseException ex) {
            this.error(ex, "Fatal");
        }

        @Override
        public void error(SAXParseException ex) {
            this.error(ex, "Error");
        }

        @Override
        public void warning(SAXParseException ex) {
            this.error(ex, "Warning");
        }

        private void error(SAXParseException ex, String type) {
            String msg = ex.getMessage();
            if (msg.contains("Exception:")) {
                Throwable e = ex;
                while (e.getCause() != null) {
                    e = e.getCause();
                }
                if (e instanceof SAXException) {
                    msg = e.getLocalizedMessage();
                }
            } else {
                TokenBuilder report = new TokenBuilder();
                String id = ex.getSystemId();
                if (id != null) {
                    report.add(IO.get(id).name()).add(", ");
                }
                report.addExt(ex.getLineNumber(), new Object[0]).add(":").addExt(ex.getColumnNumber(), new Object[0]);
                report.add(": ").add(msg);
                msg = report.toString();
            }
            this.exceptions.add(type + ":" + msg);
        }

        TokenList getExceptions() {
            return this.exceptions;
        }
    }
}

