/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.expr.Cast;
import org.basex.query.expr.Expr;
import org.basex.query.func.FuncLit;
import org.basex.query.func.Function;
import org.basex.query.func.JavaMapping;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.StaticFunc;
import org.basex.query.util.Ann;
import org.basex.query.util.Err;
import org.basex.query.util.NSGlobal;
import org.basex.query.util.TypedFunc;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.ListType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.query.var.VarScope;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.Levenshtein;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.TokenSet;

public final class Functions
extends TokenSet {
    private static final Functions INSTANCE = new Functions();
    private Function[] funcs = new Function[8];

    public static Functions get() {
        return INSTANCE;
    }

    private Functions() {
        for (Function def : Function.VALUES) {
            String dsc = def.desc;
            byte[] ln = Token.token(dsc.substring(0, dsc.indexOf("(")));
            int i = this.put(new QNm(ln, def.uri()).id());
            if (this.funcs[i] != null) {
                throw Util.notExpected("Function defined twice: " + (Object)((Object)def));
            }
            this.funcs[i] = def;
        }
    }

    private static Type getCast(QNm name, long arity, InputInfo ii) throws QueryException {
        byte[] ln = name.local();
        Enum type = ListType.find(name);
        if (type == null) {
            type = AtomType.find(name, false);
        }
        if (type != null && type != AtomType.NOT && type != AtomType.AAT) {
            if (arity == 1L) {
                return type;
            }
            throw Err.FUNCTYPEPL.get(ii, name.string(), arity, 1);
        }
        Levenshtein ls = new Levenshtein();
        for (AtomType t : AtomType.VALUES) {
            byte[] u;
            if (t.par == null || !Token.eq(u = t.name.uri(), QueryText.XSURI) || t == AtomType.NOT || t == AtomType.AAT || !ls.similar(Token.lc(ln), Token.lc(t.string()))) continue;
            throw Err.FUNCSIMILAR.get(ii, name.string(), t.string());
        }
        throw Err.FUNCUNKNOWN.get(ii, new Object[]{name.string()});
    }

    private Function getBuiltIn(QNm name, long arity, InputInfo ii) throws QueryException {
        int id = this.id(name.id());
        if (id == 0) {
            return null;
        }
        Function fl = this.funcs[id];
        if (!Token.eq(fl.uri(), name.uri())) {
            return null;
        }
        if (arity >= (long)fl.min && arity <= (long)fl.max) {
            return fl;
        }
        throw (arity == 1L ? Err.FUNCARGSG : Err.FUNCARGPL).get(ii, new Object[]{fl, arity});
    }

    public StandardFunc get(QNm name, Expr[] args, StaticContext sc, InputInfo ii) throws QueryException {
        Function fl = this.getBuiltIn(name, args.length, ii);
        return fl == null ? null : fl.get(sc, ii, args);
    }

    public static Expr getLiteral(QNm name, int arity, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
        if (Token.eq(name.uri(), QueryText.XSURI)) {
            Type type = Functions.getCast(name, arity, ii);
            VarScope scp = new VarScope(sc);
            Var[] args = new Var[]{scp.newLocal(ctx, new QNm("item", ""), SeqType.AAT_ZO, true)};
            Cast e = new Cast(sc, ii, new VarRef(ii, args[0]), type.seqType());
            FuncType tp = FuncType.get(((Expr)e).type(), SeqType.AAT_ZO);
            return new FuncItem(sc, new Ann(), name, args, tp, e, scp.stackSize());
        }
        Function fn = Functions.get().getBuiltIn(name, arity, ii);
        if (fn != null) {
            Ann a = new Ann();
            if (fn.has(Expr.Flag.UPD)) {
                throw Err.UPFUNCITEM.get(ii, new Object[0]);
            }
            VarScope scp = new VarScope(sc);
            FuncType ft = fn.type(arity);
            QNm[] argNames = fn.argNames(arity);
            Var[] args = new Var[arity];
            Expr[] calls = new Expr[arity];
            for (int i = 0; i < arity; ++i) {
                args[i] = scp.newLocal(ctx, argNames[i], ft.args[i], true);
                calls[i] = new VarRef(ii, args[i]);
            }
            StandardFunc f = fn.get(sc, calls);
            if (!f.has(Expr.Flag.CTX) && !f.has(Expr.Flag.FCS)) {
                return new FuncItem(sc, a, name, args, ft, f, scp.stackSize());
            }
            return new FuncLit(a, name, args, f, ft, scp, sc, ii);
        }
        StaticFunc sf = ctx.funcs.get(name, arity, ii, true);
        if (sf != null) {
            FuncItem fi = Functions.getUser(sf, ctx, sc, ii);
            if (fi.annotations().contains(Ann.Q_UPDATING)) {
                throw Err.UPFUNCITEM.get(ii, new Object[0]);
            }
            return fi;
        }
        VarScope scp = new VarScope(sc);
        FuncType jt = FuncType.arity(arity);
        Var[] vs = new Var[arity];
        Expr[] refs = new Expr[vs.length];
        for (int i = 0; i < vs.length; ++i) {
            vs[i] = scp.newLocal(ctx, new QNm("arg" + (i + 1), ""), SeqType.ITEM_ZM, true);
            refs[i] = new VarRef(ii, vs[i]);
        }
        JavaMapping jm = JavaMapping.get(name, refs, ctx, sc, ii);
        if (jm != null) {
            return new FuncLit(new Ann(), name, vs, jm, jt, scp, sc, ii);
        }
        return null;
    }

    public static FuncItem getUser(StaticFunc sf, QueryContext ctx, StaticContext sc, InputInfo info) throws QueryException {
        FuncType ft = sf.funcType();
        VarScope scp = new VarScope(sc);
        int arity = sf.args.length;
        Var[] args = new Var[arity];
        Expr[] calls = new Expr[args.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = scp.newLocal(ctx, sf.argName(i), ft.args[i], true);
            calls[i] = new VarRef(info, args[i]);
        }
        TypedFunc tf = ctx.funcs.getFuncRef(sf.name, calls, sc, info);
        return new FuncItem(sc, tf.ann, sf.name, args, ft, tf.fun, scp.stackSize());
    }

    public static TypedFunc get(QNm name, Expr[] args, boolean dyn, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
        if (Token.eq(name.uri(), QueryText.XSURI)) {
            Type type = Functions.getCast(name, args.length, ii);
            SeqType to = SeqType.get(type, SeqType.Occ.ZERO_ONE);
            return TypedFunc.constr(new Cast(sc, ii, args[0], to), to);
        }
        StandardFunc fun = Functions.get().get(name, args, sc, ii);
        if (fun != null) {
            if (!sc.xquery3() && fun.has(Expr.Flag.X30)) {
                throw Err.FUNC30.get(ii, new Object[0]);
            }
            if (fun.sig.has(Expr.Flag.UPD)) {
                ctx.updating(true);
            }
            return new TypedFunc(fun, new Ann(), fun.sig.type(args.length));
        }
        TypedFunc tf = ctx.funcs.getRef(name, args, sc, ii);
        if (tf != null) {
            return tf;
        }
        JavaMapping jf = JavaMapping.get(name, args, ctx, sc, ii);
        if (jf != null) {
            return TypedFunc.java(jf);
        }
        if (!dyn && FuncType.find(name) == null) {
            return ctx.funcs.getFuncRef(name, args, sc, ii);
        }
        return null;
    }

    QueryException similarError(QNm name, InputInfo ii) {
        byte[] ln = name.local();
        Levenshtein ls = new Levenshtein();
        for (int k = 1; k < this.size; ++k) {
            int i = Token.indexOf(this.keys[k], 125);
            byte[] u = Token.substring(this.keys[k], 2, i);
            byte[] l = Token.substring(this.keys[k], i + 1);
            if (Token.eq(ln, l)) {
                byte[] prefix = NSGlobal.prefix(name.uri());
                return Err.FUNCSIMILAR.get(ii, prefix.length != 0 ? Token.concat(prefix, Token.token(":"), l) : name.id(), new TokenBuilder(NSGlobal.prefix(u)).add(58).add(l));
            }
            if (!ls.similar(ln, l)) continue;
            return Err.FUNCSIMILAR.get(ii, name.string(), l);
        }
        return null;
    }

    @Override
    protected void rehash(int s) {
        super.rehash(s);
        this.funcs = Array.copy(this.funcs, new Function[s]);
    }
}

