/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.Arrays;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.func.DynFuncCall;
import org.basex.query.util.Ann;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.query.var.VarScope;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.IntObjMap;

public final class PartFunc
extends Arr {
    private final StaticContext sc;
    private final int[] holes;

    public PartFunc(StaticContext sctx, InputInfo ii, Expr fn, Expr[] arg, int[] hl) {
        super(ii, Array.add(arg, fn));
        this.sc = sctx;
        this.holes = hl;
        this.type = SeqType.FUN_O;
    }

    @Override
    public Expr compile(QueryContext ctx, VarScope scp) throws QueryException {
        super.compile(ctx, scp);
        return this.optimize(ctx, scp);
    }

    @Override
    public Expr optimize(QueryContext ctx, VarScope scp) throws QueryException {
        Expr f = this.expr[this.expr.length - 1];
        if (this.allAreValues()) {
            return this.preEval(ctx);
        }
        SeqType t = f.type();
        if (t.instanceOf(SeqType.FUN_O) && t.type != FuncType.ANY_FUN) {
            FuncType ft = (FuncType)t.type;
            int arity = this.expr.length + this.holes.length - 1;
            if (ft.args.length != arity) {
                throw Err.INVARITY.get(this.info, f, arity);
            }
            SeqType[] ar = new SeqType[this.holes.length];
            for (int i = 0; i < this.holes.length; ++i) {
                ar[i] = ft.args[this.holes[i]];
            }
            this.type = FuncType.get(ft.ret, ar).seqType();
        }
        return this;
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        Expr fn = this.expr[this.expr.length - 1];
        FItem f = (FItem)this.checkType(fn.item(ctx, ii), FuncType.ANY_FUN);
        FuncType ft = f.funcType();
        int arity = this.expr.length + this.holes.length - 1;
        if (f.arity() != arity) {
            throw Err.INVARITY.get(ii, f, arity);
        }
        Expr[] args = new Expr[arity];
        VarScope scp = new VarScope(this.sc);
        Var[] vars = new Var[this.holes.length];
        int p = -1;
        for (int i = 0; i < this.holes.length; ++i) {
            while (++p < this.holes[i]) {
                args[p] = this.expr[p - i].value(ctx);
            }
            vars[i] = scp.newLocal(ctx, f.argName(this.holes[i]), null, false);
            args[p] = new VarRef(this.info, vars[i]);
            vars[i].refineType(ft.args[p], ctx, ii);
        }
        while (++p < args.length) {
            args[p] = this.expr[p - this.holes.length].value(ctx);
        }
        Ann ann = f.annotations();
        FuncType tp = FuncType.get(ann, vars, ft.ret);
        return new FuncItem(this.sc, ann, null, vars, tp, new DynFuncCall(this.info, (Expr)f, args), ctx.value, ctx.pos, ctx.size, scp.stackSize());
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        return this.item(ctx, this.info);
    }

    @Override
    public Expr copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        return new PartFunc(this.sc, this.info, this.expr[this.expr.length - 1].copy(ctx, scp, vs), PartFunc.copyAll((QueryContext)ctx, (VarScope)scp, vs, (Expr[])Arrays.copyOf(this.expr, this.expr.length - 1)), (int[])this.holes.clone());
    }

    @Override
    public void plan(FElem plan) {
        FElem e = this.planElem(new Object[0]);
        int es = this.expr.length;
        int hs = this.holes.length;
        this.expr[es - 1].plan(e);
        int p = -1;
        for (int i = 0; i < hs; ++i) {
            while (++p < this.holes[i]) {
                this.expr[p - i].plan(e);
            }
            FElem a = new FElem("arg");
            e.add(a.add(this.planAttr(QueryText.POS, Token.token(i))));
        }
        while (++p < es + hs - 1) {
            this.expr[p - hs].plan(e);
        }
        plan.add(e);
    }

    @Override
    public String toString() {
        TokenBuilder tb = new TokenBuilder(this.expr[this.expr.length - 1].toString()).add(40);
        int p = -1;
        int es = this.expr.length;
        int hs = this.holes.length;
        for (int i = 0; i < hs; ++i) {
            while (++p < this.holes[i]) {
                tb.add(p > 0 ? ", " : "").add(this.expr[p - i].toString());
            }
            tb.add(p > 0 ? ", " : "").add(63);
        }
        while (++p < es + hs - 1) {
            tb.add(", ").add(this.expr[p - hs].toString());
        }
        return tb.add(41).toString();
    }
}

