/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives;

import java.io.IOException;
import java.util.List;
import org.basex.build.DirParser;
import org.basex.build.MemBuilder;
import org.basex.build.Parser;
import org.basex.core.Context;
import org.basex.core.MainOptions;
import org.basex.data.Data;
import org.basex.data.MemData;
import org.basex.data.atomic.DataClip;
import org.basex.io.IOFile;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.up.primitives.NewInput;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;
import org.basex.util.Token;

final class DBNew {
    protected final QueryContext qc;
    private final InputInfo info;
    protected List<NewInput> inputs;
    protected Data md;

    DBNew(QueryContext qc, List<NewInput> inputs, InputInfo info) {
        this.qc = qc;
        this.inputs = inputs;
        this.info = info;
    }

    void addDocs(MemData dt, String name) throws QueryException {
        this.md = dt;
        long ds = this.inputs.size();
        int i = 0;
        while ((long)i < ds) {
            this.md.insert(this.md.meta.size, -1, this.data(this.inputs.get(i), name));
            this.inputs.set(i, null);
            ++i;
        }
        this.inputs = null;
    }

    private DataClip data(NewInput ni, String dbname) throws QueryException {
        Context ctx = this.qc.context;
        if (ni.node != null) {
            MemData mdata = (MemData)ni.node.dbCopy((MainOptions)ctx.options).data;
            mdata.update(0, 0, ni.path);
            return new DataClip(mdata);
        }
        IOFile dbpath = ctx.globalopts.dbpath(Token.string(ni.dbname));
        try {
            Parser p = new DirParser(ni.io, ctx.options, dbpath).target(Token.string(ni.path));
            MemBuilder b = new MemBuilder(dbname, p);
            return new DataClip(b.build());
        }
        catch (IOException ex) {
            throw Err.IOERR.get(this.info, ex);
        }
    }
}

