/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util;

import org.basex.io.serial.Serializer;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.util.Compare;
import org.basex.query.util.Err;
import org.basex.query.util.NSGlobal;
import org.basex.query.value.Value;
import org.basex.query.value.item.QNm;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.ElementList;

public final class Ann
extends ElementList {
    public static final QNm Q_PRIVATE = new QNm("private", QueryText.XQURI);
    public static final QNm Q_PUBLIC = new QNm("public", QueryText.XQURI);
    public static final QNm Q_UPDATING = new QNm("updating", QueryText.XQURI);
    private static final byte[][] ANN_REST = Token.tokens("error", "path", "produces", "consumes", "query-param", "form-param", "header-param", "cookie-param", "error-param", "GET", "POST", "PUT", "DELETE", "HEAD", "OPTIONS");
    private static final byte[][] ANN_UNIT = Token.tokens("test", "ignore", "before", "after", "before-module", "after-module", "expected");
    public InputInfo[] infos = new InputInfo[1];
    public QNm[] names = new QNm[1];
    public Value[] values = new Value[1];

    public void add(QNm name, Value value, InputInfo info) {
        if (this.size == this.names.length) {
            int s = this.newSize();
            this.names = Array.copy(this.names, new QNm[s]);
            this.values = Array.copy(this.values, new Value[s]);
            this.infos = Array.copy(this.infos, new InputInfo[s]);
        }
        this.names[this.size] = name;
        this.values[this.size] = value;
        this.infos[this.size] = info;
        ++this.size;
    }

    public boolean contains(QNm e) {
        for (int i = 0; i < this.size; ++i) {
            if (!this.names[i].eq(e)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(QNm k, Value v) {
        try {
            for (int i = 0; i < this.size; ++i) {
                if (!this.names[i].eq(k) || !Compare.deep(v, this.values[i], null)) continue;
                return true;
            }
            return false;
        }
        catch (QueryException e) {
            throw Util.notExpected(e);
        }
    }

    public Ann union(Ann ann) {
        int i;
        Ann o = new Ann();
        boolean pub = false;
        boolean priv = false;
        boolean up = false;
        for (i = 0; i < this.size; ++i) {
            if (this.names[i].eq(Q_PUBLIC)) {
                pub = true;
            } else if (this.names[i].eq(Q_PRIVATE)) {
                priv = true;
            } else if (this.names[i].eq(Q_UPDATING)) {
                up = true;
            }
            o.add(this.names[i], this.values[i], this.infos[i]);
        }
        for (i = 0; i < ann.size; ++i) {
            QNm name = ann.names[i];
            if (name.eq(Q_PUBLIC)) {
                if (pub) continue;
                if (priv) {
                    return null;
                }
            } else if (name.eq(Q_PRIVATE)) {
                if (pub) {
                    return null;
                }
                if (priv) {
                    continue;
                }
            } else if (name.eq(Q_UPDATING) && up) continue;
            o.add(ann.names[i], ann.values[i], ann.infos[i]);
        }
        return o;
    }

    public Ann intersect(Ann ann) {
        Ann o = new Ann();
        for (int i = 0; i < this.size; ++i) {
            QNm name = this.names[i];
            Value val = this.values[i];
            try {
                for (int j = 0; j < ann.size; ++j) {
                    if (!name.eq(ann.names[j]) || !Compare.deep(val, ann.values[j], null)) continue;
                    o.add(name, val, this.infos[i]);
                }
                continue;
            }
            catch (QueryException ex) {
                throw Util.notExpected(ex);
            }
        }
        return o;
    }

    public void check(boolean var) throws QueryException {
        boolean up = false;
        boolean vis = false;
        for (int a = 0; a < this.size(); ++a) {
            QNm name = this.names[a];
            byte[] local = name.local();
            byte[] uri = name.uri();
            if (name.eq(Q_UPDATING)) {
                if (up) {
                    throw Err.DUPLUPD.get(this.infos[a], new Object[0]);
                }
                up = true;
                continue;
            }
            if (name.eq(Q_PUBLIC) || name.eq(Q_PRIVATE)) {
                if (vis) {
                    throw (var ? Err.DUPLVARVIS : Err.DUPLVIS).get(this.infos[a], new Object[0]);
                }
                vis = true;
                continue;
            }
            if (NSGlobal.reserved(name.uri())) {
                throw Err.ANNRES.get(this.infos[a], Character.valueOf('%'), name.string());
            }
            if (Token.eq(uri, QueryText.OUTPUTURI)) {
                if (Serializer.OPTIONS.option(Token.string(local)) == null) {
                    throw Err.BASX_ANNOT.get(this.infos[a], Character.valueOf('%'), name.string());
                }
                if (this.values[a].size() == 1L && this.values[a].itemAt((long)0L).type.isStringOrUntyped()) continue;
                throw Err.BASX_ANNOTARGS.get(this.infos[a], Character.valueOf('%'), name.string());
            }
            if (!(Token.eq(uri, QueryText.RESTURI) ? !Token.eq(local, ANN_REST) : Token.eq(uri, QueryText.UNITURI) && !Token.eq(local, ANN_UNIT))) continue;
            throw Err.BASX_ANNOT.get(this.infos[a], Character.valueOf('%'), name.string());
        }
    }

    public String toString() {
        TokenBuilder tb = new TokenBuilder();
        for (int i = 0; i < this.size; ++i) {
            tb.add(37).add(this.names[i].string());
            long s = this.values[i].size();
            if (s != 0L) {
                tb.add(40);
                int a = 0;
                while ((long)a < s) {
                    if (a != 0) {
                        tb.add(44);
                    }
                    tb.add(this.values[i].itemAt(a).toString());
                    ++a;
                }
                tb.add(41);
            }
            tb.add(32);
        }
        return tb.toString();
    }
}

