/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util;

import java.text.CollationElementIterator;
import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.HashMap;
import java.util.Locale;
import org.basex.core.Text;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.util.Err;
import org.basex.query.value.item.Uri;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.TokenObjMap;

public final class Collation {
    private static final byte[] URL = Token.token(Text.URL + "/collation");
    private static final HashMap<String, Locale> LOCALES = new HashMap();
    private static final byte[][] STRENGTHS = Token.tokens("primary", "secondary", "tertiary", "identical");
    private static final byte[][] DECOMPOSITIONS = Token.tokens("none", "full", "standard");
    private static final byte[] LANG = Token.token("lang");
    private static final byte[] STRENGTH = Token.token("strength");
    private static final byte[] DECOMPOSITION = Token.token("decomposition");
    private final Collator coll;
    private final byte[] uri;

    private Collation(Collator cl, byte[] u) {
        this.coll = cl;
        this.uri = u;
    }

    public static Collation get(byte[] uri, QueryContext ctx, StaticContext sc, InputInfo info, Err err) throws QueryException {
        Collation coll;
        if (uri == null) {
            return sc.collation;
        }
        byte[] args = uri;
        Uri u = Uri.uri(args);
        if (!u.isValid()) {
            throw Err.INVURI.get(info, new Object[]{args});
        }
        if (!u.isAbsolute() && !Token.startsWith(args, 63)) {
            args = sc.baseURI().resolve(u, info).string();
        }
        if (Token.eq(QueryText.COLLATIONURI, args)) {
            return null;
        }
        if (Token.startsWith(args, URL)) {
            args = Token.substring(args, URL.length);
        }
        if (Token.startsWith(args, 63)) {
            args = Token.substring(args, 1);
        }
        args = Token.replace(args, 38, 59);
        byte[] full = new TokenBuilder(URL).add(63).add(args).finish();
        if (ctx.collations == null) {
            ctx.collations = new TokenObjMap();
        }
        if ((coll = ctx.collations.get(full)) == null) {
            Collator cl = Collation.get(args);
            if (cl == null) {
                throw err.get(info, new Object[]{uri});
            }
            coll = new Collation(cl, full);
            ctx.collations.put(full, coll);
        }
        return coll;
    }

    private static Collator get(byte[] args) {
        Locale locale = Locale.getDefault();
        int strngth = -1;
        int dcmpstn = -1;
        for (byte[] param : Token.split(args, 59)) {
            int s;
            int ss;
            byte[][] kv = Token.split(param, 61);
            if (kv.length != 2) {
                return null;
            }
            byte[] key = kv[0];
            byte[] val = kv[1];
            if (Token.eq(key, LANG)) {
                locale = LOCALES.get(Token.string(val));
                if (locale != null) continue;
                return null;
            }
            if (Token.eq(key, STRENGTH)) {
                ss = STRENGTHS.length;
                s = -1;
                while (++s < ss && !Token.eq(val, STRENGTHS[s])) {
                }
                if (s == ss) {
                    return null;
                }
                strngth = s;
                continue;
            }
            if (Token.eq(key, DECOMPOSITION)) {
                ss = DECOMPOSITIONS.length;
                s = -1;
                while (++s < ss && !Token.eq(val, DECOMPOSITIONS[s])) {
                }
                if (s == ss) {
                    return null;
                }
                dcmpstn = s;
                continue;
            }
            return null;
        }
        Collator coll = Collator.getInstance(locale);
        if (strngth != -1) {
            coll.setStrength(strngth);
        }
        if (dcmpstn != -1) {
            coll.setDecomposition(dcmpstn);
        }
        return coll;
    }

    public int compare(byte[] string, byte[] compare) {
        return this.coll.compare(Token.string(string), Token.string(compare));
    }

    public boolean contains(byte[] string, byte[] sub, InputInfo info) throws QueryException {
        return this.indexOf(Token.string(string), Token.string(sub), false, false, info) != -1;
    }

    public boolean startsWith(byte[] string, byte[] sub, InputInfo info) throws QueryException {
        RuleBasedCollator rbc = this.rbc(info);
        return Collation.startsWith(rbc.getCollationElementIterator(Token.string(string)), rbc.getCollationElementIterator(Token.string(sub)));
    }

    public boolean endsWith(byte[] string, byte[] sub, InputInfo info) throws QueryException {
        return this.indexOf(Token.string(string), Token.string(sub), false, true, info) != -1;
    }

    public byte[] after(byte[] string, byte[] sub, InputInfo info) throws QueryException {
        String st = Token.string(string);
        int i = this.indexOf(st, Token.string(sub), false, false, info);
        return i == -1 ? Token.EMPTY : Token.token(st.substring(i));
    }

    public byte[] before(byte[] string, byte[] sub, InputInfo info) throws QueryException {
        String st = Token.string(string);
        int i = this.indexOf(st, Token.string(sub), true, false, info);
        return i == -1 ? Token.EMPTY : Token.token(st.substring(0, i));
    }

    public byte[] uri() {
        return this.uri;
    }

    private int indexOf(String string, String sub, boolean start, boolean ends, InputInfo info) throws QueryException {
        RuleBasedCollator rbc = this.rbc(info);
        CollationElementIterator i = rbc.getCollationElementIterator(string);
        CollationElementIterator is = rbc.getCollationElementIterator(sub);
        int cs;
        while ((cs = Collation.next(is)) != -1) {
            int c;
            do {
                if ((c = Collation.next(i)) != -1) continue;
                return -1;
            } while (c != cs);
            int s = i.getOffset();
            if (Collation.startsWith(i, is) && (!ends || Collation.next(i) == -1)) {
                return start ? s - 1 : i.getOffset();
            }
            i.setOffset(s);
            is.reset();
        }
        return 0;
    }

    private static boolean startsWith(CollationElementIterator i, CollationElementIterator is) {
        int cs;
        do {
            if ((cs = Collation.next(is)) != -1) continue;
            return true;
        } while (cs == Collation.next(i));
        return false;
    }

    private static int next(CollationElementIterator i) {
        int c;
        while ((c = i.next()) == 0) {
        }
        return c;
    }

    private RuleBasedCollator rbc(InputInfo info) throws QueryException {
        if (this.coll instanceof RuleBasedCollator) {
            return (RuleBasedCollator)this.coll;
        }
        throw Err.CHARCOLL.get(info, new Object[0]);
    }

    static {
        for (Locale l : Locale.getAvailableLocales()) {
            LOCALES.put(l.toString().replace('_', '-'), l);
        }
    }
}

