/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util;

import org.basex.data.Data;
import org.basex.data.FTPos;
import org.basex.data.FTPosData;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTSpan;
import org.basex.util.list.TokenList;

final class DataFTBuilder {
    private static final byte[] DOTS = Token.token("...");
    private final FTPosData ftpos;
    private final int ftlen;

    DataFTBuilder(FTPosData pos, int len) {
        this.ftpos = pos;
        this.ftlen = len;
    }

    TokenList build(ANode nd) {
        if (!(nd instanceof DBNode)) {
            return null;
        }
        DBNode node = (DBNode)nd;
        return this.build(node.data, node.pre, nd.string());
    }

    TokenList build(Data d, int p, byte[] str) {
        FTPos ftp = this.ftpos.get(d, p);
        if (ftp == null) {
            return null;
        }
        boolean marked = false;
        TokenList tl = new TokenList();
        TokenBuilder tb = new TokenBuilder();
        FTLexer lex = new FTLexer().sc().init(str);
        int len = -this.ftlen;
        while (lex.hasNext()) {
            FTSpan span = lex.next();
            if (ftp.contains(span.pos) || marked) {
                if (!tb.isEmpty()) {
                    tl.add(tb.finish());
                    tb.reset();
                    if ((len += tb.size()) >= 0 && tl.size() > 1 && !marked) break;
                }
                if (!marked) {
                    tl.add((byte[])null);
                }
                marked ^= true;
            }
            tb.add(span.text);
        }
        if (!tb.isEmpty()) {
            tl.add(tb.finish());
            len += tb.size();
        }
        if (len > 0) {
            int ll;
            byte[] last;
            int ts = tl.size();
            byte[] first = tl.get(0) != null ? tl.get(0) : Token.EMPTY;
            byte[] byArray = last = tl.get(ts - 2) != null ? tl.get(ts - 1) : Token.EMPTY;
            if (first != Token.EMPTY) {
                double l = first.length + last.length;
                ll = Math.min(first.length, (int)((double)first.length / l * (double)len));
                tl.set(0, Token.concat(DOTS, Token.subtoken(first, ll)));
                len -= ll;
            }
            if (last != Token.EMPTY && len > 0) {
                int ll2 = Math.min(last.length, len);
                tl.set(ts - 1, Token.concat(Token.subtoken(last, 0, last.length - ll2), DOTS));
                len -= ll2;
            }
            for (int t = ts - 2; t > 0 && len > 0; --t) {
                byte[] txt = tl.get(t);
                if (txt == null || tl.get(t - 1) == null) continue;
                ll = Math.min(txt.length, len);
                tl.set(t, Token.concat(Token.subtoken(txt, 0, (txt.length - ll) / 2), DOTS, Token.subtoken(txt, (txt.length + ll) / 2)));
                len -= ll;
            }
        }
        return tl;
    }
}

