/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util;

import org.basex.core.Text;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.StaticVar;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public enum Err {
    BASX_GENERIC(ErrType.BASX, 0, "%"),
    BASX_PERM(ErrType.BASX, 1, "% permission required."),
    BASX_OPTIONS(ErrType.BASX, 2, "Unknown database option '%'."),
    BASX_VALUE(ErrType.BASX, 2, "Database option '%' cannot be set to '%'."),
    BASX_RESTXQ(ErrType.BASX, 3, "%"),
    BASX_DBTRANSFORM(ErrType.BASX, 4, "No database updates allowed within transform expression."),
    BASX_STACKOVERFLOW(ErrType.BASX, 5, "Stack Overflow: Try tail recursion?"),
    BASX_ANNOT(ErrType.BASX, 6, "Annotation %% is invalid or not supported."),
    BASX_ANNOTARGS(ErrType.BASX, 6, "Annotation %% has invalid arguments."),
    BXCL_CONN(ErrType.BXCL, 1, "Connection failed: %"),
    BXCL_NOTAVL(ErrType.BXCL, 2, "Session is not available or has already been closed: %"),
    BXCL_COMM(ErrType.BXCL, 3, "An error occurred: %"),
    BXCL_COMMAND(ErrType.BXCL, 4, "Command could not be executed: %"),
    BXCL_QUERY(ErrType.BXCL, 5, "Query could not be executed: %"),
    BXCL_ITEM(ErrType.BXCL, 6, "Value to be bound is no single item: %"),
    BXCO_STRING(ErrType.BXCO, 1, "String conversion: %."),
    BXCO_BASE64(ErrType.BXCO, 1, "String cannot be converted to the supplied encoding."),
    BXCO_ENCODING(ErrType.BXCO, 2, "Unknown encoding '%'."),
    BXCS_PARSE(ErrType.BXCS, 1, "CSV parser: %."),
    BXCS_SERIAL(ErrType.BXCS, 2, "CSV serializer: %."),
    BXDB_NODB(ErrType.BXDB, 1, "%: database node expected."),
    BXDB_OPEN(ErrType.BXDB, 2, "%"),
    BXDB_WHICH(ErrType.BXDB, 2, "Database not found: %."),
    BXDB_WHICHBACK(ErrType.BXDB, 2, "No backup file found: %."),
    BXDB_MEM(ErrType.BXDB, 3, "Operation requires database '%' to be persistent."),
    BXDB_INDEX(ErrType.BXDB, 4, "Database '%' has no % index."),
    BXDB_DBRETURN(ErrType.BXDB, 5, "Query must yield database nodes."),
    BXDB_NODOC(ErrType.BXDB, 6, "Database path '%' yields no documents."),
    BXDB_SINGLE(ErrType.BXDB, 6, "Database path '%' points to more than one document."),
    BXDB_OPENED(ErrType.BXDB, 7, "Database '%' cannot be updated, as it is opened by another process."),
    BXDB_RENAME(ErrType.BXDB, 8, "Invalid target path: %."),
    BXDB_RANGE(ErrType.BXDB, 9, "%: value '%' is out of range."),
    BXDB_EVENT(ErrType.BXDB, 10, "Event '%' is unknown."),
    BXDB_NAME(ErrType.BXDB, 11, "Invalid database name: '%'."),
    BXDB_ALTERDROP(ErrType.BXDB, 12, "Database '%' cannot be both altered and dropped."),
    BXDB_ONCE(ErrType.BXDB, 12, "Database '%' can only be % once."),
    BXDB_ONCEBACK(ErrType.BXDB, 12, "Backup '%' can only be % once."),
    BXDB_CREATEARGS(ErrType.BXDB, 13, "Number of specified inputs and paths differs: % vs. %."),
    BXDB_DIR(ErrType.BXDB, 14, "Database path '%' points to a directory."),
    BXDB_NOBACKUP(ErrType.BXDB, 15, "No backup found: %."),
    BXDB_SAME(ErrType.BXDB, 16, "Name of source and target database is equal: %."),
    BXFE_IO(ErrType.BXFE, 1, "%"),
    BXFE_ENCODING(ErrType.BXFE, 2, "Unknown encoding '%'."),
    BXFT_MATCH(ErrType.BXFT, 1, "Wildcards and fuzzy option cannot be both specified."),
    BXHL_IO(ErrType.BXHL, 1, "%"),
    BXJS_PARSE(ErrType.BXJS, 1, "JSON parser (%:%): %."),
    BXJS_PARSEML(ErrType.BXJS, 1, "JsonML parser: %."),
    BXJS_SERIAL(ErrType.BXJS, 2, "JSON serializer: %."),
    BXPR_ENC(ErrType.BXPR, 9999, "Unknown encoding '%'."),
    BXRE_WHICH(ErrType.BXRE, 1, "Package '%' does not exist."),
    BXRE_URI(ErrType.BXRE, 2, "Namespace URI is invalid: '%'."),
    BXRE_NOTINST(ErrType.BXRE, 3, "Required package '%' is not installed."),
    BXRE_DESC(ErrType.BXRE, 4, "Package descriptor: %."),
    BXRE_INST(ErrType.BXRE, 5, "Module % is already installed within another package."),
    BXRE_PARSE(ErrType.BXRE, 6, "Package '%' could not be parsed: %."),
    BXRE_DELETE(ErrType.BXRE, 7, "File '%' could not be deleted."),
    BXRE_DEP(ErrType.BXRE, 8, "Package '%' depends on package '%'."),
    BXRE_VERSION(ErrType.BXRE, 9, "Package version is not supported."),
    BXRE_JARDESC(ErrType.BXRE, 10, "JAR descriptor: %."),
    BXRE_JARFAIL(ErrType.BXRE, 11, "Reading JAR descriptor failed: %."),
    BXSL_ERROR(ErrType.BXSL, 1, "%"),
    BXSQ_ERROR(ErrType.BXSQ, 1, "An SQL exception occurred: '%'"),
    BXSQ_CONN(ErrType.BXSQ, 2, "No opened connection with id %"),
    BXSQ_STATE(ErrType.BXSQ, 2, "No prepared statement with id %"),
    BXSQ_PARAMS(ErrType.BXSQ, 3, "Number of parameters differs from number of placeholders"),
    BXSQ_TYPE(ErrType.BXSQ, 4, "No parameter type supplied."),
    BXSQ_ATTR(ErrType.BXSQ, 5, "Not expected attribute: %"),
    BXSQ_FORMAT(ErrType.BXSQ, 6, "Illegal % format"),
    BXSQ_DRIVER(ErrType.BXSQ, 7, "Could not initialize supplied driver: '%'"),
    BXVA_FAIL(ErrType.BXVA, 1, "Validation failed. %"),
    BXVA_START(ErrType.BXVA, 2, "Validation could not be started. %"),
    BXXQ_UPDATING(ErrType.BXXQ, 1, "No updating expression allowed."),
    BXXQ_NEWDB(ErrType.BXXQ, 2, "Opening new resources is not permitted."),
    BXXQ_PERM(ErrType.BXXQ, 3, "%"),
    BXXQ_STOPPED(ErrType.BXXQ, 4, "Timeout or assigned memory was exceeded."),
    UNIT_ASSERT(ErrType.UNIT, 1, "Assertion failed."),
    UNIT_ASSERT_EQUALS(ErrType.UNIT, 1, "Item %: % expected, % returned."),
    UNIT_MESSAGE(ErrType.UNIT, 1, "%"),
    UNIT_ARGS(ErrType.UNIT, 2, "Test function '%' must have no arguments."),
    UNIT_UPDATE(ErrType.UNIT, 3, "Function '%' is updating."),
    UNIT_TWICE(ErrType.UNIT, 4, "Annotation %:% was declare twice."),
    UNIT_ANN(ErrType.UNIT, 5, "Annotation '%%' has invalid arguments."),
    ARCH_DIFF(ErrType.ARCH, 1, "Number of supplied entries and contents differs: % vs. %."),
    ARCH_UNKNOWN(ErrType.ARCH, 2, "Packing format not supported."),
    ARCH_SUPP(ErrType.ARCH, 2, "% not supported: '%'."),
    ARCH_EMPTY(ErrType.ARCH, 3, "Name of ZIP entry must not be empty."),
    ARCH_LEVEL(ErrType.ARCH, 3, "Invalid compression level: '%'."),
    ARCH_DATETIME(ErrType.ARCH, 3, "xs:dateTime value is invalid : '%'."),
    ARCH_ENCODING(ErrType.ARCH, 4, "Unknown encoding '%'."),
    ARCH_ENCODE(ErrType.ARCH, 4, "String conversion: %."),
    ARCH_MODIFY(ErrType.ARCH, 5, "Entries of % archive cannot be modified."),
    ARCH_ONE(ErrType.ARCH, 6, "% archives are limited to a single entry."),
    ARCH_FAIL(ErrType.ARCH, 9999, "Operation failed: %."),
    BIN_DLA_X_X(ErrType.BIN, "differing-length-arguments", "Inputs are of different length (%/%)."),
    BIN_IOOR_X_X(ErrType.BIN, "index-out-of-range", "Index '%' is out of range (0-%)."),
    BIN_NS_X(ErrType.BIN, "negative-size", "Size '%' is negative."),
    BIN_OOR_X(ErrType.BIN, "octet-out-of-range", "Octet '%' is out of range."),
    BIN_NNC(ErrType.BIN, "non-numeric-character", "Invalid character in constructor string."),
    BIN_UE_X(ErrType.BIN, "unknown-encoding", "Unknown encoding '%'."),
    BIN_CE(ErrType.BIN, "conversion-error", "%."),
    BIN_USO_X(ErrType.BIN, "unknown-significance-order", "Unknown octet-order value: '%'."),
    CX_CANINV(ErrType.CX, 1, "Canonicalization algorithm is not supported."),
    CX_DIGINV(ErrType.CX, 2, "Digest algorithm is not supported."),
    CX_SIGINV(ErrType.CX, 3, "Signature algorithm is not supported."),
    CX_XPINV(ErrType.CX, 4, "XPath expression is invalid."),
    CX_INVNM(ErrType.CX, 5, "Invalid name for $digital-certificate root."),
    CX_KSNULL(ErrType.CX, 7, "Key store is null: %"),
    CX_NOKEY(ErrType.CX, 12, "Cannot find key for alias in given keystore."),
    CX_INVHASH(ErrType.CX, 13, "Hashing algorithm is not supported."),
    CX_ENC(ErrType.CX, 14, "The encoding method is not supported."),
    CX_NOSIG(ErrType.CX, 15, "Cannot find signature element."),
    CX_NOPAD(ErrType.CX, 16, "No such padding."),
    CX_BADPAD(ErrType.CX, 17, "Incorrect padding."),
    CX_ENCTYP(ErrType.CX, 18, "Encryption type is not supported."),
    CX_KEYINV(ErrType.CX, 19, "Secret key is invalid."),
    CX_ILLBLO(ErrType.CX, 20, "Illegal block size."),
    CX_INVALGO(ErrType.CX, 21, "Algorithm is not supported."),
    CX_ALINV(ErrType.CX, 23, "Invalid certificate alias %."),
    CX_ALGEXC(ErrType.CX, 24, "Invalid algorithm."),
    CX_IOEXC(ErrType.CX, 25, "IO Exception."),
    CX_KSEXC(ErrType.CX, 26, "Keystore exception."),
    CX_SIGEXC(ErrType.CX, 27, "Signature exception."),
    CX_SIGTYPINV(ErrType.CX, 28, "Signature type is not supported."),
    FILE_NF(ErrType.FILE, "not-found", "File '%' does not exist."),
    FILE_E(ErrType.FILE, "exists", "File '%' already exists."),
    FILE_ND(ErrType.FILE, "no-dir", "Path '%' is no directory."),
    FILE_ID(ErrType.FILE, "is-dir", "Path '%' is a directory."),
    FILE_ID_FULL(ErrType.FILE, "is-dir", "Path '%' is a non-empty directory."),
    FILE_UE(ErrType.FILE, "unknown-encoding", "Unknown encoding '%'."),
    FILE_OOR(ErrType.FILE, "out-of-range", "Requested file chunk [%,%] exceeds file bounds."),
    FILE_IE(ErrType.FILE, "io-error", "%"),
    FILE_IE_DIR(ErrType.FILE, "io-error", "Directory '%' cannot be created."),
    FILE_IE_DEL(ErrType.FILE, "io-error", "Path '%' cannot be deleted."),
    FILE_IE_MOVE(ErrType.FILE, "io-error", "Moving '%' to '%' failed."),
    FILE_IE_ACCESS(ErrType.FILE, "io-error", "Files of '%' cannot be accessed."),
    FILE_IE_PATH(ErrType.FILE, "io-error", "Invalid file path: '%'."),
    HASH_ALG(ErrType.HASH, 1, "Algorithm not supported: '%'."),
    HC_ERROR(ErrType.HC, 1, "%"),
    HC_PARSE(ErrType.HC, 2, "Conversion failed: %"),
    HC_ATTR(ErrType.HC, 3, "No attribute beside 'src' and 'media-type' allowed."),
    HC_REQ(ErrType.HC, 4, "Invalid request element: %."),
    HC_URL(ErrType.HC, 5, "No URL supplied."),
    HC_PARAMS(ErrType.HC, 6, "Specify request element or HTTP URI."),
    ZIP_NOTFOUND(ErrType.ZIP, 1, "Path '%' is not found."),
    ZIP_INVALID(ErrType.ZIP, 2, "% element: attribute '%' expected."),
    ZIP_UNKNOWN(ErrType.ZIP, 2, "ZIP definition: unknown element %."),
    ZIP_FAIL(ErrType.ZIP, 3, "Operation failed: %."),
    DIVZERO(ErrType.FOAR, 1, "% cannot be divided by zero."),
    DIVFLOW(ErrType.FOAR, 2, "Invalid division result: % / %."),
    RANGE(ErrType.FOAR, 2, "Value out of range: %."),
    INVALUE(ErrType.FOCA, 2, "Invalid value for %: %."),
    INTRANGE(ErrType.FOCA, 3, "Integer value out of range: %."),
    DATECALC(ErrType.FOCA, 5, "Invalid % calculation: %."),
    INVCODE(ErrType.FOCH, 1, "Invalid XML character '&#x%;'."),
    WHICHCOLL(ErrType.FOCH, 2, "Unknown collation \"%\"."),
    NORMUNI(ErrType.FOCH, 3, "Unsupported normalization form (\"%\")."),
    CHARCOLL(ErrType.FOCH, 4, "Collation does not support function."),
    IDDOC(ErrType.FODC, 1, "Specified node has no document node as root."),
    NODEERR(ErrType.FODC, 2, "% could not be created: %."),
    NODEFCOLL(ErrType.FODC, 2, "No default collection available."),
    IOERR(ErrType.FODC, 2, "%"),
    WHICHRES(ErrType.FODC, 2, "Resource \"%\" does not exist."),
    INVCOLL(ErrType.FODC, 4, "Invalid collection URI \"%\"."),
    INVDOC(ErrType.FODC, 5, "Invalid document URI \"%\"."),
    SAXERR(ErrType.FODC, 6, "SAX: %"),
    RESINV(ErrType.FODC, 7, "Resource path \"%\" is invalid."),
    INVDB(ErrType.FODC, 7, "Invalid database name: \"%\"."),
    FORMNUM(ErrType.FODF, 1280, "Unknown decimal format: %."),
    PICEMPTY(ErrType.FODF, 1310, "The picture string may not be empty."),
    PICNUM(ErrType.FODF, 1310, "Invalid picture string: '%'."),
    OPTAFTER(ErrType.FODF, 1310, "Optional digit sign follows mandatory digit signs: '%'."),
    INVGROUP(ErrType.FODF, 1310, "Invalid position of grouping separator signs: '%'."),
    DIFFMAND(ErrType.FODF, 1310, "Mandatory digits must be of the same group: '%'."),
    INVORDINAL(ErrType.FODF, 1310, "Invalid specification of ordinal numbering: '%'."),
    INVDDPATTERN(ErrType.FODF, 1310, "Invalid decimal-digit-pattern: '%'."),
    DATERANGE(ErrType.FODT, 1, "%: '%' out of range."),
    YEARRANGE(ErrType.FODT, 1, "Year '%' out of range."),
    SECRANGE(ErrType.FODT, 1, "Seconds '%' out of range."),
    DURRANGE(ErrType.FODT, 2, "%: '%' out of range."),
    MONTHRANGE(ErrType.FODT, 2, "Months '%' out of range."),
    SECDURRANGE(ErrType.FODT, 2, "Seconds '%' out of range."),
    DATEZERO(ErrType.FODT, 2, "Invalid % calculation: infinity/zero."),
    INVALZONE(ErrType.FODT, 3, "Timezone out of range (-14:00 to +14:00): %."),
    ZONESEC(ErrType.FODT, 3, "No seconds allowed in timezone: %."),
    FUNERR1(ErrType.FOER, 0, "Halted on error()."),
    INVCOMPSPEC(ErrType.FOFD, 1340, "Invalid variable marker: '[%]'."),
    PICDATE(ErrType.FOFD, 1340, "Invalid picture string: '%'."),
    CALQNAME(ErrType.FOFD, 1340, "Invalid EQName: '%'."),
    CALWHICH(ErrType.FOFD, 1340, "Unknown calendar: '%'."),
    PICINVCOMP(ErrType.FOFD, 1350, "Component '[%]' not applicable to % values."),
    NSDECL(ErrType.FONS, 4, "No namespace declared for prefix '%'."),
    INVALIDZONE(ErrType.FORG, 1, "Invalid timezone: %."),
    FUNCAST(ErrType.FORG, 1, "Invalid % cast: \"%\"."),
    FUNCCASTEX(ErrType.FORG, 1, "Invalid cast from % to %: %."),
    DATEFORMAT(ErrType.FORG, 1, "Wrong % format: '%' (try e.g. '%')."),
    URIINVRES(ErrType.FORG, 2, "URI argument is invalid: %."),
    URIABS(ErrType.FORG, 2, "Base URI % is not absolute."),
    EXPECTZ0(ErrType.FORG, 3, "Zero or one value expected."),
    EXPECTOM(ErrType.FORG, 4, "One or more values expected."),
    EXPECTO(ErrType.FORG, 5, "Exactly one value expected."),
    FUNCMP(ErrType.FORG, 6, "%: % expected, % found."),
    CONDTYPE(ErrType.FORG, 6, "% not allowed as condition type."),
    SUMTYPE(ErrType.FORG, 6, "%: invalid argument type '%'."),
    FUNNUM(ErrType.FORG, 6, "%: number expected, % found."),
    FUNDUR(ErrType.FORG, 6, "%: duration expected, % found."),
    TYPECMP(ErrType.FORG, 6, "% is not comparable."),
    JAVACON(ErrType.FORG, 6, "Unknown constructor: %(%)."),
    JAVAMTH(ErrType.FORG, 6, "Unknown method: %(%)."),
    JAVAFUN(ErrType.FORG, 6, "Invalid call of Java function: %(%)."),
    JAVAMOD(ErrType.FORG, 6, "Invalid arguments: % expected, % found."),
    INVBASE(ErrType.FORG, 6, "Unsupported base: %."),
    INVDIG(ErrType.FORG, 6, "Invalid digit for base %: %."),
    JAVAERR(ErrType.FORG, 6, "Java function call failed: %."),
    ERRFORM(ErrType.FORG, 6, "%: %."),
    BINARYTYPE(ErrType.FORG, 6, "Binary item expected, % found"),
    STRNODTYPE(ErrType.FORG, 6, "%: string or node expected, % found."),
    ELMMAPTYPE(ErrType.FORG, 6, "element(%) or map expected, % found"),
    ELMSTRTYPE(ErrType.FORG, 6, "element(%) or string expected, % found"),
    STRBINTYPE(ErrType.FORG, 6, "String or binary type expected, % found"),
    INVALIDOPT(ErrType.FORG, 6, "%"),
    INVALIDOPTX(ErrType.FORG, 6, Text.UNKNOWN_OPTION_X),
    FUNZONE(ErrType.FORG, 8, "% and % have different timezones."),
    REGMOD(ErrType.FORX, 1, "Invalid regular modifier: '%'."),
    REGPAT(ErrType.FORX, 2, "Invalid pattern: %."),
    REGROUP(ErrType.FORX, 3, "Pattern matches empty string."),
    FUNREPBS(ErrType.FORX, 4, "Replacement string: invalid backslash."),
    FUNREPDOL(ErrType.FORX, 4, "Replacement string: invalid dollar sign."),
    FIVALUE(ErrType.FOTY, 13, "Items of type % have no typed value."),
    FIATOM(ErrType.FOTY, 13, "Items of type % cannot be atomized."),
    FIEQ(ErrType.FOTY, 13, "Items of type % have no defined equality."),
    FISTR(ErrType.FOTY, 14, "Items of type % have no string representation."),
    FICMP(ErrType.FOTY, 15, "Items of type % cannot be compared."),
    UPFOTYPE(ErrType.FOUP, 1, "Document or element expected, % found."),
    UPDOCTYPE(ErrType.FOUP, 1, "Document expected, % found."),
    UPFOURI(ErrType.FOUP, 2, "No valid URI: \"%\"."),
    UPPUTERR(ErrType.FOUP, 2, "\"%\" could not be written."),
    UPDROPBACK(ErrType.FOUP, 2, "Backup \"%\" could not be %."),
    UPDBERROR(ErrType.FOUP, 2, "Database \"%\" could not be %."),
    UPDBPUTERR(ErrType.FOUP, 2, "Resource \"%\" could not be written."),
    UPDBDELERR(ErrType.FOUP, 2, "Resource \"%\" could not be deleted."),
    UPDBRENAMEERR(ErrType.FOUP, 2, "Resource \"%\" could not be renamed."),
    UPDBOPTERR(ErrType.FOUP, 2, "%"),
    RESNF(ErrType.FOUT, 1170, "Resource '%' cannot be retrieved."),
    FRAGID(ErrType.FOUT, 1170, "URI contains a fragment identifier: %"),
    INVURL(ErrType.FOUT, 1170, "URI is invalid: %"),
    WHICHENC(ErrType.FOUT, 1190, "Unknown encoding '%'."),
    INVCHARS(ErrType.FOUT, 1190, "%."),
    WHICHCHARS(ErrType.FOUT, 1200, "Resource contains invalid input: %."),
    FTWEIGHT(ErrType.FTDY, 16, "Weight value out of range: %."),
    FTMILD(ErrType.FTDY, 17, "Invalid 'mild not' selection."),
    FTREG(ErrType.FTDY, 20, "Invalid wildcard syntax: '%'."),
    FTIGNORE(ErrType.FTST, 7, "Ignore option not supported."),
    NOSTOPFILE(ErrType.FTST, 8, "Stop word file not found: '%'."),
    FTNOSTEM(ErrType.FTST, 9, "No stemmer available for language '%'."),
    FTNOTOK(ErrType.FTST, 9, "No tokenizer available for language '%'."),
    NOTHES(ErrType.FTST, 18, "Thesaurus not found: '%'."),
    FTDUP(ErrType.FTST, 19, "Match option '%' was declared twice."),
    SERATTR(ErrType.SENR, 1, "Attributes cannot be serialized:%."),
    SERNS(ErrType.SENR, 1, "Namespaces cannot be serialized:%."),
    SERFUNC(ErrType.SENR, 1, "Items of type % cannot be serialized."),
    SERSA(ErrType.SEPM, 4, "If 'standalone' is specified, the root must be a single element."),
    SERDT(ErrType.SEPM, 4, "If 'doctype-system' is specified, the root must be a single element."),
    SERENCODING(ErrType.SESU, 7, "Unknown encoding '%'."),
    SERSTAND(ErrType.SEPM, 9, "Invalid combination of 'omit-xml-declaration'."),
    SERUNDECL(ErrType.SEPM, 10, "XML 1.0: undeclaring prefixes not allowed."),
    SERNOTSUPP(ErrType.SESU, 13, "%"),
    SERILL(ErrType.SERE, 14, "Illegal HTML character found: #x%;."),
    SERPI(ErrType.SERE, 15, "Processing construction contains '>'."),
    SERMAP(ErrType.SEPM, 16, "Character map '%' is not defined."),
    SERANY(ErrType.SEPM, 16, "%"),
    SEROPT(ErrType.SEPM, 17, "%."),
    SERWHICH(ErrType.SEPM, 17, "Serialization parameter '%' is invalid."),
    NOCTX(ErrType.XPDY, 2, "No context item defined to evaluate '%'."),
    VAREMPTY(ErrType.XPDY, 2, "No value assigned to %."),
    CTXNODE(ErrType.XPDY, 50, "Root of the context item must be a document node."),
    NOTREAT(ErrType.XPDY, 50, "%: % cannot be treated as %."),
    NOTREATS(ErrType.XPDY, 50, "%: % expected, sequence found."),
    STBASEURI(ErrType.XPST, 1, "Static Base URI is undefined."),
    QUERYEMPTY(ErrType.XPST, 3, "Empty query."),
    QUERYINV(ErrType.XPST, 3, "Query contains an illegal character (#%)."),
    NOQUOTE(ErrType.XPST, 3, "Expecting quote%."),
    NOVALIDATE(ErrType.XPST, 3, "Invalid validation expression."),
    NUMBERWS(ErrType.XPST, 3, "Expecting separator after number."),
    NUMBERDBL(ErrType.XPST, 3, "Incomplete double value: '%'."),
    NUMBERDEC(ErrType.XPST, 3, "Incomplete decimal value: '%'."),
    NUMBERITR(ErrType.XPST, 3, "Unexpected decimal point."),
    QUERYEND(ErrType.XPST, 3, "Unexpected end of query: '%'."),
    MODEXPR(ErrType.XPST, 3, "No expression allowed in a library module."),
    MAINMOD(ErrType.XPST, 3, "Library modules cannot be evaluated."),
    CMPEXPR(ErrType.XPST, 3, "Comparison is incomplete."),
    COPYEXPR(ErrType.XPST, 3, "Copy expression is incomplete."),
    NOTAG(ErrType.XPST, 3, "Expecting tag name."),
    TAGNAME(ErrType.XPST, 3, "Expecting tag name, '<%' found."),
    NOATTNAME(ErrType.XPST, 3, "Expecting attribute name."),
    NOLOCSTEP(ErrType.XPST, 3, "Incomplete location step."),
    NOEXPR(ErrType.XPST, 3, "Expecting expression."),
    WRONGCHAR(ErrType.XPST, 3, "Expecting '%'%."),
    INVENTITY(ErrType.XPST, 3, "Invalid entity '%'."),
    INCOMPLETE(ErrType.XPST, 3, "Incomplete expression."),
    EVALUNARY(ErrType.XPST, 3, "Unary operator expects a numeric value."),
    PATHMISS(ErrType.XPST, 3, "Expecting location path%."),
    DECLINCOMPLETE(ErrType.XPST, 3, "Expecting 'function', 'variable', ..."),
    FUNCNAME(ErrType.XPST, 3, "Expecting function name."),
    RESERVED(ErrType.XPST, 3, "'%' is a reserved keyword."),
    PREDMISSING(ErrType.XPST, 3, "Expecting expression before predicate."),
    NOVARNAME(ErrType.XPST, 3, "Expecting variable name."),
    NOVARDECL(ErrType.XPST, 3, "Expecting variable declaration."),
    PIWRONG(ErrType.XPST, 3, "Expecting name of processing-instruction."),
    NSWRONG(ErrType.XPST, 3, "Expecting namespace prefix."),
    NOENCLEXPR(ErrType.XPST, 3, "Expecting valid expression after curly brace."),
    NOFTSELECT(ErrType.XPST, 3, "Expecting quote or opening curly brace%."),
    NODOCCONS(ErrType.XPST, 3, "Expecting expression in document constructor."),
    NOTXTCONS(ErrType.XPST, 3, "Expecting expression in text constructor."),
    NOCOMCONS(ErrType.XPST, 3, "Expecting expression in comment constructor."),
    NOFUNBODY(ErrType.XPST, 3, "Expecting function body."),
    FUNCMISS(ErrType.XPST, 3, "Expecting closing bracket for function '%'."),
    MAPTAAT(ErrType.XPST, 3, "Expecting atomic key type for map, found '%'."),
    TYPEINVALID(ErrType.XPST, 3, "Expecting type declaration."),
    NODECLFORM(ErrType.XPST, 3, "Decimal-format property '%' is invalid."),
    NOTYPESWITCH(ErrType.XPST, 3, "Incomplete typeswitch expression."),
    NOSWITCH(ErrType.XPST, 3, "Incomplete switch expression."),
    TYPEPAR(ErrType.XPST, 3, "Expecting '(' after 'switch' or 'typeswitch'."),
    PRAGMAINV(ErrType.XPST, 3, "Invalid pragma expression."),
    CALCEXPR(ErrType.XPST, 3, "Calculation is incomplete."),
    INVMAPKEY(ErrType.XPST, 3, "Invalid key, simple expression expected."),
    INVMAPVAL(ErrType.XPST, 3, "Invalid value, simple expression expected."),
    NORETURN(ErrType.XPST, 3, "Expecting return value."),
    NOWHERE(ErrType.XPST, 3, "Expecting valid expression after 'where'."),
    ORDERBY(ErrType.XPST, 3, "Expecting valid expression after 'order by'."),
    GRPBY(ErrType.XPST, 3, "Expecting valid expression after 'group by'."),
    FLWORRETURN(ErrType.XPST, 3, "Incomplete FLWOR expression: expecting 'return'."),
    NOSOME(ErrType.XPST, 3, "Incomplete quantifier expression."),
    IFPAR(ErrType.XPST, 3, "Expecting '(' after 'if' expression."),
    NOIF(ErrType.XPST, 3, "Incomplete 'if' expression."),
    NOFOR(ErrType.XPST, 3, "Incomplete 'for' expression."),
    NOLET(ErrType.XPST, 3, "Incomplete 'let' expression."),
    NOWINDOW(ErrType.XPST, 3, "Incomplete 'window' expression."),
    NOCOUNT(ErrType.XPST, 3, "Incomplete 'count' expression."),
    NOCLOSING(ErrType.XPST, 3, "Expecting closing tag </%>."),
    COMCLOSE(ErrType.XPST, 3, "Unclosed XQuery comment (: ..."),
    EXPREMPTY(ErrType.XPST, 3, "Unknown function or expression."),
    NOTYPE(ErrType.XPST, 3, "Unknown type '%'."),
    PIXML(ErrType.XPST, 3, "Processing instruction has illegal name: '%'."),
    QNAMEINV(ErrType.XPST, 3, "Expecting QName, '%' found."),
    PROLOGORDER(ErrType.XPST, 3, "Default declarations must be declared first."),
    FTRANGE(ErrType.XPST, 3, "Expecting full-text range."),
    FTSTOP(ErrType.XPST, 3, "Stop words expected."),
    FTMATCH(ErrType.XPST, 3, "Unknown match option '%...'."),
    INVALPI(ErrType.XPST, 3, "Processing instruction has invalid name."),
    INTEXP(ErrType.XPST, 3, "Integer expected."),
    VARFUNC(ErrType.XPST, 3, "Variable or function declaration expected."),
    NOANN(ErrType.XPST, 3, "No annotation allowed here."),
    NOCATCH(ErrType.XPST, 3, "Expecting catch clause."),
    ANNVALUE(ErrType.XPST, 3, "Literal expected after annotation."),
    UPDATINGVAR(ErrType.XPST, 3, "Variable cannot be updating."),
    NSNOTALL(ErrType.XPST, 3, "Namespace axis is not available in XQuery."),
    SIMPLETYPE(ErrType.XPST, 3, "Simple type expected, '%(' found."),
    VARUNDEF(ErrType.XPST, 8, "Undefined variable %."),
    CIRCREF(ErrType.XPST, 8, "Static variable references itself: %"),
    VARPRIVATE(ErrType.XPST, 8, "Variable % is not visible from this module."),
    TYPEUNDEF(ErrType.XPST, 8, "Undefined type '%'."),
    SCHEMAINV(ErrType.XPST, 8, "Undefined schema name '%'."),
    FUNCPRIV(ErrType.XPST, 17, "Function '%' is not visible from this module."),
    FUNCSIMILAR(ErrType.XPST, 17, "Unknown function '%'; similar: '%'."),
    FUNCARGSG(ErrType.XPST, 17, "%: % argument supplied."),
    FUNCARGPL(ErrType.XPST, 17, "%: % arguments supplied."),
    FUNCTYPESG(ErrType.XPST, 17, "Function '%': % argument supplied, % expected."),
    FUNCTYPEPL(ErrType.XPST, 17, "Function '%': % arguments supplied, % expected."),
    FUNCUNKNOWN(ErrType.XPST, 17, "Function '%' is unknown."),
    FUNCNOIMPL(ErrType.XPST, 17, "Function '%' is not implemented."),
    FUNCJAVA(ErrType.XPST, 17, "Java function '%' is not found."),
    JAVAAMBIG(ErrType.XPST, 17, "Several implementations found for '%'."),
    JAVAINIT(ErrType.XPST, 17, "Class cannot be initialized: %."),
    FUNC30(ErrType.XPST, 17, "Function not available in XQuery 1.0."),
    TYPEUNKNOWN(ErrType.XPST, 51, "Unknown type '%'."),
    CASTUNKNOWN(ErrType.XPST, 80, "Invalid cast type '%'."),
    NOURI(ErrType.XPST, 81, "No namespace declared for '%'."),
    NSMISS(ErrType.XPST, 81, "QName '%' has no namespace."),
    SEQCAST(ErrType.XPTY, 4, "Single item expected, % found."),
    INVCAST(ErrType.XPTY, 4, "Cannot cast from % to %."),
    INVCASTEX(ErrType.XPTY, 4, "Invalid cast from % to %: %."),
    INVTREAT(ErrType.XPTY, 4, "Cannot treat % as %: %."),
    CALCTYPE(ErrType.XPTY, 4, "% not defined for % and %."),
    INVFUNCITEM(ErrType.XPTY, 4, "Function item required for function call, % found."),
    NOSUBDUR(ErrType.XPTY, 4, "%: only supported on subtypes of xs:duration, not %."),
    INVEMPTY(ErrType.XPTY, 4, "%: no empty sequence allowed."),
    INVEMPTYEX(ErrType.XPTY, 4, "%: % expected, empty sequence found."),
    NODUR(ErrType.XPTY, 4, "%: duration expected, % found."),
    INVTYPECMP(ErrType.XPTY, 4, "% and % cannot be compared."),
    NONUMBER(ErrType.XPTY, 4, "%: number expected, % found."),
    NONAME(ErrType.XPTY, 4, "Expecting name, '%' found."),
    DOCATTS(ErrType.XPTY, 4, "Cannot add attributes to a document node."),
    DOCNS(ErrType.XPTY, 4, "Cannot add namespaces to a document node."),
    CPIWRONG(ErrType.XPTY, 4, "Name has invalid type: '%'."),
    INVQNAME(ErrType.XPTY, 4, "Invalid QName: '%'."),
    INVARITY(ErrType.XPTY, 4, "Wrong number of arguments in %, expected %."),
    INVNCNAME(ErrType.XPTY, 4, "Invalid NCName: '%'."),
    CITYPES(ErrType.XPTY, 4, "Incompatible types in context item declarations: % vs. %."),
    EVALNODESVALS(ErrType.XPTY, 18, "Path yields both nodes and atomic values."),
    PATHNODE(ErrType.XPTY, 19, "Steps within a path expression must yield nodes; % found."),
    STEPNODE(ErrType.XPTY, 20, "Context node required for %; % found."),
    NSSENS(ErrType.XPTY, 117, "Cannot cast from % to %."),
    CATTDUPL(ErrType.XQDY, 25, "Duplicate attribute '%'."),
    CPICONT(ErrType.XQDY, 26, "Processing instruction has invalid content: '%'."),
    CPIINVAL(ErrType.XQDY, 41, "Processing instruction has invalid name: '%'."),
    CAXML(ErrType.XQDY, 44, "XML prefix and namespace cannot be rebound."),
    CAINV(ErrType.XQDY, 44, "Invalid attribute prefix/namespace '%'."),
    CIRCVAR30(ErrType.XQDY, 54, "Static variable depends on itself: %"),
    CIRCCTX(ErrType.XQDY, 54, "Context item is not defined."),
    CPIXML(ErrType.XQDY, 64, "Processing instruction has illegal name: '%'."),
    COMINVALID(ErrType.XQDY, 72, "Invalid comment."),
    INVNSNAME(ErrType.XQDY, 74, "Invalid namespace prefix: '%'."),
    INVNAME(ErrType.XQDY, 74, "Invalid QName: '%'."),
    INVPREF(ErrType.XQDY, 74, "No namespace declared for %."),
    CEXML(ErrType.XQDY, 96, "XML prefix and namespace cannot be rebound."),
    CEINV(ErrType.XQDY, 96, "Invalid element prefix/namespace '%'."),
    CNXML(ErrType.XQDY, 101, "XML prefix and namespace cannot be rebound."),
    CNINV(ErrType.XQDY, 101, "Invalid prefix/namespace '%'."),
    DUPLNSCONS(ErrType.XQDY, 102, "Duplicate namespace declaration: '%'."),
    IMPLSCHEMA(ErrType.XQST, 9, "Schema import not supported."),
    NSCONS(ErrType.XQST, 22, "Constant namespace value expected."),
    XQUERYVER(ErrType.XQST, 31, "XQuery version '%' not supported."),
    DUPLBASE(ErrType.XQST, 32, "Duplicate 'base-uri' declaration."),
    DUPLNSDECL(ErrType.XQST, 33, "Duplicate declaration of prefix '%'."),
    FUNCDEFINED(ErrType.XQST, 34, "Duplicate declaration of function '%'."),
    DUPLCOLL(ErrType.XQST, 38, "Duplicate 'collation' declaration."),
    WHICHDEFCOLL(ErrType.XQST, 38, "Unknown collation \"%\"."),
    FUNCDUPL(ErrType.XQST, 39, "Duplicate function argument %."),
    ATTDUPL(ErrType.XQST, 40, "Duplicate attribute '%'."),
    NAMERES(ErrType.XQST, 45, "Function '%' is in reserved namespace."),
    ANNRES(ErrType.XQST, 45, "Annotation %% is in reserved namespace."),
    INVURI(ErrType.XQST, 46, "URI '%' is invalid."),
    DUPLMODULE(ErrType.XQST, 47, "Module namespace is declared twice: '%'."),
    MODNS(ErrType.XQST, 48, "Declaration % does not match the module namespace."),
    VARDUPL(ErrType.XQST, 49, "Duplicate declaration of static variable $%."),
    TYPEUNKNOWN30(ErrType.XQST, 52, "Unknown cast type '%'."),
    CIRCVAR(ErrType.XQST, 54, "Global variable depends on itself: %"),
    DUPLCOPYNS(ErrType.XQST, 55, "Duplicate 'copy-namespace' declaration."),
    NSEMPTY(ErrType.XQST, 57, "Namespace URI cannot be empty."),
    INSTERR(ErrType.XQST, 59, "Could not instantiate module '%'."),
    WHICHMODULE(ErrType.XQST, 59, "Module '%' not found."),
    WHICHCLASS(ErrType.XQST, 59, "Class not found: '%'."),
    MODINITERR(ErrType.XQST, 59, "Module not initialized: %."),
    WHICHMODFILE(ErrType.XQST, 59, "Could not retrieve module '%'."),
    WRONGMODULE(ErrType.XQST, 59, "Wrong URI '%' in imported module '%'."),
    FUNNONS(ErrType.XQST, 60, "Namespace needed for function '%'."),
    DUPLORD(ErrType.XQST, 65, "Duplicate 'ordering' declaration."),
    DUPLNS(ErrType.XQST, 66, "Duplicate 'default namespace' declaration."),
    DUPLCONS(ErrType.XQST, 67, "Duplicate 'construction' declaration."),
    DUPLBOUND(ErrType.XQST, 68, "Duplicate 'boundary-space' declaration."),
    DUPLORDEMP(ErrType.XQST, 69, "Duplicate 'order empty' declaration."),
    BINDXML(ErrType.XQST, 70, "Prefix '%' cannot be rebound."),
    XMLNSDEF(ErrType.XQST, 70, "'%' cannot be default namespace."),
    BINDXMLURI(ErrType.XQST, 70, "'%' can only be bound to '%'."),
    DUPLNSDEF(ErrType.XQST, 71, "Duplicate declaration of prefix '%'."),
    IMPLVAL(ErrType.XQST, 75, "Validation not supported."),
    FLWORCOLL(ErrType.XQST, 76, "Unknown collation \"%\"."),
    NOPRAGMA(ErrType.XQST, 79, "Expecting pragma expression."),
    NSEMPTYURI(ErrType.XQST, 85, "Namespace URI cannot be empty."),
    XQUERYENC2(ErrType.XQST, 87, "Unknown encoding '%'."),
    NSMODURI(ErrType.XQST, 88, "Module namespace cannot be empty."),
    DUPLVAR(ErrType.XQST, 89, "Duplicate declaration of %."),
    INVCHARREF(ErrType.XQST, 90, "Invalid character reference '%'."),
    CIRCMODULE(ErrType.XQST, 93, "Circular module declaration."),
    GVARNOTDEFINED(ErrType.XQST, 94, "Undeclared grouping variable '%'."),
    INVDECFORM(ErrType.XQST, 97, "Invalid decimal-format property: %='%'."),
    INVDECSINGLE(ErrType.XQST, 97, "Decimal-format property must be a single character: %='%'."),
    INVDECZERO(ErrType.XQST, 97, "Zero-digit property must be Unicode digit with value zero: '%'."),
    DUPLDECFORM(ErrType.XQST, 98, "Duplicate use of decimal-format '%'."),
    DUPLITEM(ErrType.XQST, 99, "Duplicate declaration of context item."),
    WINDOWUNIQ(ErrType.XQST, 103, "Duplicate variable name in window clause: %"),
    DUPLUPD(ErrType.XQST, 106, "More than one updating annotation declared."),
    DUPLVIS(ErrType.XQST, 106, "More than one visibility annotation declared."),
    MODOUT(ErrType.XQST, 108, "No output declarations allowed in library modules."),
    OUTINVALID(ErrType.XQST, 109, "%"),
    OUTDUPL(ErrType.XQST, 110, "Duplicate declaration of 'output:%'."),
    DECDUPL(ErrType.XQST, 111, "Duplicate decimal-format declaration."),
    DECITEM(ErrType.XQST, 113, "Context item cannot be bound in library module."),
    DECDUPLPROP(ErrType.XQST, 114, "Duplicate decimal-format property '%'."),
    DUPLVARVIS(ErrType.XQST, 116, "More than one visibility annotation declared."),
    TAGWRONG(ErrType.XQST, 118, "Start and end tag are different: <%>...</%>."),
    OUTDOC(ErrType.XQST, 119, "Serialization document '%' cannot be parsed."),
    DECLOPTION(ErrType.XQST, 123, "Unknown option: %."),
    INVISIBLE(ErrType.XQST, 125, "No visibility annotation allowed in inline function."),
    NOATTALL(ErrType.XQTY, 24, "Attribute must follow the root element."),
    NONSALL(ErrType.XQTY, 24, "Namespaces must follow the root element."),
    CONSFUNC(ErrType.XQTY, 105, "Invalid content: %."),
    UPNOPAR(ErrType.XUDY, 9, "Target % has no parent."),
    UPNOTCOPIED(ErrType.XUDY, 14, "% was not created by copy clause."),
    UPMULTREN(ErrType.XUDY, 15, "Node can only be renamed once: %."),
    UPPATHREN(ErrType.XUDY, 15, "Path can only be renamed once: '%'."),
    UPMULTREPL(ErrType.XUDY, 16, "Node can only be replaced once: %."),
    UPMULTREPV(ErrType.XUDY, 17, "Node can only be replaced once: %"),
    UPATTDUPL(ErrType.XUDY, 21, "Duplicate attribute %."),
    UPNSCONFL(ErrType.XUDY, 23, "Conflicts with existing namespaces."),
    UPNSCONFL2(ErrType.XUDY, 24, "New namespaces conflict with each other."),
    UPSEQEMP(ErrType.XUDY, 27, "% target must not be empty."),
    UPPAREMPTY(ErrType.XUDY, 29, "Target has no parent node."),
    UPATTELM(ErrType.XUDY, 30, "Attributes cannot be inserted as child of a document."),
    UPURIDUP(ErrType.XUDY, 31, "URI '%' is addressed multiple times."),
    UPFUNCITEM(ErrType.XUST, 1, "Updating function items are not supported yet."),
    UPNOT(ErrType.XUST, 1, "%: no updating expression allowed."),
    UPALL(ErrType.XUST, 1, "%: all expressions must be updating or return an empty sequence."),
    UPCTX(ErrType.XUST, 1, "Context item may not declare an updating expression."),
    UPMODIFY(ErrType.XUST, 2, "Modify clause: all expressions must be updating or return an empty sequence."),
    UPEXPECTF(ErrType.XUST, 2, "Function body must be an updating expression."),
    DUPLREVAL(ErrType.XUST, 3, "Duplicate 'revalidation' declaration."),
    NOREVAL(ErrType.XUST, 26, "Revalidation mode not supported."),
    UPFUNCTYPE(ErrType.XUST, 28, "No return type allowed in updating functions."),
    UPNOATTRPER(ErrType.XUTY, 4, "Attribute must follow the root element."),
    UPTRGTYP(ErrType.XUTY, 5, "Single element or document expected as insert target."),
    UPTRGTYP2(ErrType.XUTY, 6, "Single element, text, comment or pi expected as insert target."),
    UPTRGDELEMPT(ErrType.XUTY, 7, "Only nodes can be deleted."),
    UPTRGMULT(ErrType.XUTY, 8, "Single element, text, attribute, comment or pi expected as replace target."),
    UPWRELM(ErrType.XUTY, 10, "Replacing nodes must be no attribute nodes."),
    UPWRATTR(ErrType.XUTY, 11, "Replacing nodes must be attribute nodes."),
    UPWRTRGTYP(ErrType.XUTY, 12, "Single element, attribute or pi expected as rename target."),
    UPCOPYMULT(ErrType.XUTY, 13, "Value assigned to $% must be a single node."),
    UPSOURCE(ErrType.XUTY, 13, "Source of copy expression must be a single node."),
    UPATTELM2(ErrType.XUTY, 22, "Insert target must be an element.");

    private static final Err[] VALUES;
    public final String code;
    public final byte[] uri;
    public final String prefix;
    public final String desc;
    private static final int MAX = 64;

    private Err(ErrType type, String msg, String dsc) {
        this.code = msg;
        this.uri = type.uri;
        this.prefix = type.prefix;
        this.desc = dsc;
    }

    private Err(ErrType type, int nr, String dsc) {
        StringBuilder sb = new StringBuilder(8).append((Object)type);
        String n2 = Integer.toString(nr);
        int s = 4 - n2.length();
        for (int i = 0; i < s; ++i) {
            sb.append('0');
        }
        this.code = sb.append(n2).toString();
        this.uri = type.uri;
        this.prefix = type.prefix;
        this.desc = dsc;
    }

    public QueryException get(InputInfo ii, Object ... ext) {
        return new QueryException(ii, this, ext);
    }

    public QueryIOException getIO(Object ... ext) {
        return new QueryIOException(this.get(null, ext));
    }

    public final QNm qname() {
        return new QNm(this.prefix + ':' + this.code, this.uri);
    }

    public final boolean is(ErrType type) {
        return this.code.startsWith(type.name());
    }

    public static QueryException get(String name, InputInfo ii, String msg) {
        for (Err e : VALUES) {
            if (!e.toString().equals(name)) continue;
            return new QueryException(ii, e.qname(), msg, new Object[0]).err(e);
        }
        return null;
    }

    public static QueryException diffError(InputInfo ii, Item it1, Item it2) {
        return (it1 == it2 ? TYPECMP : INVTYPECMP).get(ii, it1.type, it2.type);
    }

    public static QueryException castError(InputInfo ii, Type t, Value v) {
        return INVCASTEX.get(ii, v.type, t, v);
    }

    public static QueryException treatError(InputInfo ii, SeqType t, Expr e) {
        return INVTREAT.get(ii, e.description(), t, e);
    }

    public static QueryException typeError(ParseExpr e, Type t, Item it) {
        return INVCAST.get(e.info, it.type, t);
    }

    public static QueryException numberError(ParseExpr e, Item it) {
        return NONUMBER.get(e.info, e.description(), it.type);
    }

    public static QueryException valueError(InputInfo ii, Type t, Object v) {
        return INVALUE.get(ii, t, v);
    }

    public static QueryException circVarError(StaticVar var) {
        return (var.sc.xquery3() ? CIRCVAR30 : CIRCVAR).get(var.info, var);
    }

    public static byte[] chop(Object object) throws QueryException {
        byte[] string;
        TokenBuilder tb = new TokenBuilder();
        int l = 0;
        for (int n : string = object instanceof byte[] ? (byte[])object : (object instanceof Item ? ((Item)object).string(null) : Token.token(object.toString()))) {
            int ts = tb.size();
            if (ts == 64) {
                tb.add("...");
                break;
            }
            if (n == 10 || n == 13) {
                n = 32;
            }
            if (n != 32 || l != 32) {
                tb.addByte((byte)n);
            }
            l = n;
        }
        return tb.array();
    }

    public String toString() {
        return this.code;
    }

    static {
        VALUES = Err.values();
    }

    public static enum ErrType {
        BASX(QueryText.BXERR, QueryText.BXERRORS),
        BXCL(QueryText.BXERR, QueryText.BXERRORS),
        BXCO(QueryText.BXERR, QueryText.BXERRORS),
        BXCS(QueryText.BXERR, QueryText.BXERRORS),
        BXDB(QueryText.BXERR, QueryText.BXERRORS),
        BXFE(QueryText.BXERR, QueryText.BXERRORS),
        BXFT(QueryText.BXERR, QueryText.BXERRORS),
        BXHL(QueryText.BXERR, QueryText.BXERRORS),
        BXJS(QueryText.BXERR, QueryText.BXERRORS),
        BXPR(QueryText.BXERR, QueryText.BXERRORS),
        BXRE(QueryText.BXERR, QueryText.BXERRORS),
        BXSL(QueryText.BXERR, QueryText.BXERRORS),
        BXSQ(QueryText.BXERR, QueryText.BXERRORS),
        BXVA(QueryText.BXERR, QueryText.BXERRORS),
        BXXQ(QueryText.BXERR, QueryText.BXERRORS),
        HASH(QueryText.BXERR, QueryText.BXERRORS),
        UNIT(QueryText.UNIT, QueryText.UNITURI),
        ARCH(QueryText.EXPERR, QueryText.EXPERROR),
        BIN(QueryText.BIN, QueryText.BINURI),
        CX(QueryText.EXPERR, QueryText.EXPERROR),
        FILE(QueryText.FILE, QueryText.FILEURI),
        HC(QueryText.EXPERR, QueryText.EXPERROR),
        ZIP(QueryText.EXPERR, QueryText.EXPERROR),
        FOAR,
        FOCA,
        FOCH,
        FODC,
        FODF,
        FODT,
        FOFD,
        FOER,
        FONS,
        FORG,
        FORX,
        FOTY,
        FOUP,
        FOUT,
        FTDY,
        FTST,
        SENR,
        SEPM,
        SERE,
        SESU,
        XPDY,
        XPST,
        XPTY,
        XQDY,
        XQST,
        XQTY,
        XUDY,
        XUST,
        XUTY;

        public final String prefix;
        public final byte[] uri;

        private ErrType(byte[] pref, byte[] u) {
            this.prefix = Token.string(pref);
            this.uri = u;
        }

        private ErrType() {
            this(QueryText.ERR, QueryText.ERRORURI);
        }
    }
}

