/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.pkg;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.basex.core.Context;
import org.basex.core.GlobalOptions;
import org.basex.core.Text;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.IOFile;
import org.basex.io.Zip;
import org.basex.io.in.NewlineInput;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.util.Err;
import org.basex.query.util.pkg.ModuleLoader;
import org.basex.query.util.pkg.Package;
import org.basex.query.util.pkg.PkgParser;
import org.basex.query.util.pkg.PkgValidator;
import org.basex.query.util.pkg.Repo;
import org.basex.util.InputInfo;
import org.basex.util.Table;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenMap;
import org.basex.util.list.StringList;
import org.basex.util.list.TokenList;

public final class RepoManager {
    private static final Pattern MAIN_CLASS = Pattern.compile("^Main-Class: *(.+?) *$");
    private final Repo repo;
    private InputInfo info;

    public RepoManager(Context ctx) {
        this.repo = ctx.repo;
    }

    public RepoManager(Context ctx, InputInfo ii) {
        this(ctx);
        this.info = ii;
    }

    public boolean install(String path) throws QueryException {
        IO io = IO.get(path);
        byte[] cont = null;
        try {
            cont = io.read();
        }
        catch (IOException ex) {
            Util.debug(ex);
            throw Err.BXRE_WHICH.get(this.info, path);
        }
        try {
            if (io.hasSuffix(IO.XQSUFFIXES)) {
                return this.installXQ(cont, path);
            }
            if (io.hasSuffix(".jar")) {
                return this.installJAR(cont);
            }
            return this.installXAR(cont);
        }
        catch (IOException ex) {
            throw Err.BXRE_PARSE.get(this.info, io.name(), ex);
        }
    }

    public Table table() {
        Table t = new Table();
        t.description = Text.PACKAGES_X;
        t.header.add(Text.NAME);
        t.header.add(Text.VERSINFO);
        t.header.add(Text.TYPE);
        t.header.add(Text.PATH);
        TokenMap pkg = this.repo.pkgDict();
        for (byte[] p : pkg) {
            if (p == null) continue;
            t.contents.add(RepoManager.entry(Token.string(Package.name(p)), Token.string(Package.version(p)), "EXPath", Token.string(pkg.get(p))));
        }
        for (IOFile ch : this.repo.path().children()) {
            String n = ch.name();
            if (!ch.isDir()) {
                t.contents.add(RepoManager.entry(n.replaceAll("\\..*", "").replace('/', '.'), "-", "Internal", n));
                continue;
            }
            if (n.indexOf(45) != -1) continue;
            for (String s : ch.descendants()) {
                t.contents.add(RepoManager.entry(n + '.' + s.replaceAll("\\..*", "").replace('/', '.'), "-", "Internal", n + '/' + s));
            }
        }
        return t.sort();
    }

    private static TokenList entry(String name, String version, String type, String path) {
        TokenList tl = new TokenList();
        tl.add(name);
        tl.add(version);
        tl.add(type);
        tl.add(path);
        return tl;
    }

    public StringList list() {
        StringList sl = new StringList();
        for (byte[] p : this.repo.pkgDict()) {
            if (p == null) continue;
            sl.add(Token.string(p));
        }
        for (IOFile ch : this.repo.path().children()) {
            String n = ch.name();
            if (!ch.isDir()) {
                sl.add(n.replaceAll("\\..*", "").replace('/', '.'));
                continue;
            }
            if (n.indexOf(45) != -1) continue;
            for (String s : ch.descendants()) {
                sl.add(n + '.' + s.replaceAll("\\..*", "").replace('/', '.'));
            }
        }
        return sl.sort(false);
    }

    public void delete(String pkg) throws QueryException {
        boolean found = false;
        TokenMap dict = this.repo.pkgDict();
        byte[] pp = Token.token(pkg);
        for (byte[] nextPkg : dict) {
            if (nextPkg == null || !Token.eq(nextPkg, pp) && !Token.eq(Package.name(nextPkg), pp)) continue;
            byte[] primPkg = this.primary(nextPkg);
            if (primPkg != null) {
                throw Err.BXRE_DEP.get(this.info, Token.string(primPkg), pkg);
            }
            IOFile f = this.repo.path(Token.string(dict.get(nextPkg)));
            this.repo.delete(new PkgParser(this.repo, this.info).parse(new IOFile(f, "expath-pkg.xml")));
            if (!f.delete()) {
                throw Err.BXRE_DELETE.get(this.info, f);
            }
            found = true;
        }
        IOFile file = RepoManager.file(pkg, this.repo);
        if (file != null) {
            if (!file.delete()) {
                throw Err.BXRE_DELETE.get(this.info, file);
            }
            return;
        }
        if (!found) {
            throw Err.BXRE_WHICH.get(this.info, pkg);
        }
    }

    public static IOFile file(String name, Repo repo) {
        IOFile path = new IOFile(repo.path(), name);
        for (IOFile ch : path.dir().children()) {
            if (!ch.name().equals(path.name())) continue;
            return ch;
        }
        path = new IOFile(repo.path(), name.replace('.', '/'));
        String start = path.name() + '.';
        for (IOFile ch : path.dir().children()) {
            if (!ch.name().startsWith(start)) continue;
            return ch;
        }
        return null;
    }

    private boolean installXQ(byte[] content, String path) throws QueryException, IOException {
        Context ctx = this.repo.context;
        byte[] uri = new QueryContext((Context)ctx).parseLibrary((String)Token.string((byte[])content), (String)path, null).name.uri();
        String uriPath = ModuleLoader.uri2path(Token.string(uri));
        if (uriPath == null) {
            throw Err.BXRE_URI.get(this.info, new Object[]{uri});
        }
        return this.write(uriPath + ".xqm", content);
    }

    private boolean installJAR(byte[] content) throws IOException {
        String s;
        Zip zip = new Zip(new IOContent(content));
        IOContent mf = new IOContent(zip.read("META-INF/MANIFEST.MF"));
        NewlineInput nli = new NewlineInput(mf);
        while ((s = nli.readLine()) != null) {
            Matcher m = MAIN_CLASS.matcher(s);
            if (!m.find()) continue;
            return this.write(m.group(1).replace('.', '/') + ".jar", content);
        }
        return false;
    }

    private boolean write(String path, byte[] content) throws IOException {
        IOFile rp = new IOFile(this.repo.context.globalopts.get(GlobalOptions.REPOPATH));
        IOFile target = new IOFile(rp, path);
        boolean exists = target.exists();
        target.dir().md();
        target.write(content);
        return exists;
    }

    private boolean installXAR(byte[] content) throws QueryException, IOException {
        boolean exists;
        Zip zip = new Zip(new IOContent(content));
        IOContent dsc = new IOContent(zip.read("expath-pkg.xml"));
        Package pkg = new PkgParser(this.repo, this.info).parse(dsc);
        byte[] name = pkg.uniqueName();
        boolean bl = exists = this.repo.pkgDict().get(name) != null;
        if (exists) {
            this.delete(Token.string(name));
        }
        new PkgValidator(this.repo, this.info).check(pkg);
        IOFile file = this.uniqueDir(Token.string(name).replaceAll("[^\\w.-]+", "-"));
        zip.unzip(file);
        this.repo.add(pkg, file.name());
        return exists;
    }

    private IOFile uniqueDir(String name) {
        String nm = name;
        int c = 0;
        IOFile io;
        while ((io = this.repo.path(nm)).exists()) {
            nm = name + '-' + ++c;
        }
        return io;
    }

    private byte[] primary(byte[] pkgName) throws QueryException {
        TokenMap dict = this.repo.pkgDict();
        for (byte[] nextPkg : dict) {
            if (nextPkg == null || Token.eq(nextPkg, pkgName)) continue;
            IOFile desc = new IOFile(this.repo.path(Token.string(dict.get(nextPkg))), "expath-pkg.xml");
            Package pkg = new PkgParser(this.repo, this.info).parse(desc);
            byte[] name = Package.name(pkgName);
            for (Package.Dependency dep : pkg.dep) {
                if (dep.pkg == null || !Token.eq(dep.pkg, name)) continue;
                return Package.name(nextPkg);
            }
        }
        return null;
    }
}

