/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.util.LinkedList;
import org.basex.core.MainOptions;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.Scope;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.TypeCheck;
import org.basex.query.func.DynFuncCall;
import org.basex.query.gflwor.GFLWOR;
import org.basex.query.gflwor.Let;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Ann;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.FuncType;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.IntObjMap;

public final class FuncItem
extends FItem
implements Scope {
    private final StaticContext sc;
    private final QNm name;
    private final Var[] params;
    private final Expr expr;
    private final Value ctxVal;
    private final long pos;
    private final long size;
    private final int stackSize;

    public FuncItem(StaticContext sctx, Ann annotations, QNm n, Var[] arg, FuncType t, Expr body, int stSize) {
        this(sctx, annotations, n, arg, t, body, null, 0L, 0L, stSize);
    }

    public FuncItem(StaticContext sctx, Ann annotations, QNm n, Var[] arg, FuncType t, Expr body, Value vl, long ps, long sz, int stSize) {
        super(t, annotations);
        this.name = n;
        this.params = arg;
        this.expr = body;
        this.stackSize = stSize;
        this.sc = sctx;
        this.ctxVal = vl;
        this.pos = ps;
        this.size = sz;
    }

    @Override
    public int arity() {
        return this.params.length;
    }

    @Override
    public QNm funcName() {
        return this.name;
    }

    @Override
    public QNm argName(int ps) {
        return this.params[ps].name;
    }

    @Override
    public FuncType funcType() {
        return (FuncType)this.type;
    }

    @Override
    public int stackFrameSize() {
        return this.stackSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value invValue(QueryContext ctx, InputInfo ii, Value ... args) throws QueryException {
        Value cv = ctx.value;
        long ps = ctx.pos;
        long sz = ctx.size;
        try {
            ctx.value = this.ctxVal;
            ctx.pos = this.pos;
            ctx.size = this.size;
            for (int i = 0; i < this.params.length; ++i) {
                ctx.set(this.params[i], args[i], ii);
            }
            Value value = ctx.value(this.expr);
            return value;
        }
        finally {
            ctx.value = cv;
            ctx.pos = ps;
            ctx.size = sz;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Item invItem(QueryContext ctx, InputInfo ii, Value ... args) throws QueryException {
        Value cv = ctx.value;
        long ps = ctx.pos;
        long sz = ctx.size;
        try {
            ctx.value = this.ctxVal;
            ctx.pos = this.pos;
            ctx.size = this.size;
            for (int i = 0; i < this.params.length; ++i) {
                ctx.set(this.params[i], args[i], ii);
            }
            Item item = this.expr.item(ctx, ii);
            return item;
        }
        finally {
            ctx.value = cv;
            ctx.pos = ps;
            ctx.size = sz;
        }
    }

    @Override
    public FItem coerceTo(FuncType ft, QueryContext ctx, InputInfo ii, boolean opt) throws QueryException {
        ParseExpr checked;
        DynFuncCall optimized;
        if (this.params.length != ft.args.length) {
            throw Err.castError(ii, ft, this);
        }
        FuncType tp = this.funcType();
        if (tp.instanceOf(ft)) {
            return this;
        }
        VarScope vsc = new VarScope(this.sc);
        Var[] vs = new Var[this.params.length];
        Expr[] refs = new Expr[vs.length];
        int i = vs.length;
        while (i-- > 0) {
            vs[i] = vsc.newLocal(ctx, this.params[i].name, ft.args[i], true);
            refs[i] = new VarRef(ii, vs[i]);
        }
        DynFuncCall e = new DynFuncCall(ii, (Expr)this, refs);
        Expr expr = optimized = opt ? ((Expr)e).optimize(ctx, vsc) : e;
        if (ft.ret == null || tp.ret != null && tp.ret.instanceOf(ft.ret)) {
            checked = optimized;
        } else {
            TypeCheck tc = new TypeCheck(this.sc, ii, optimized, ft.ret, true);
            checked = opt ? tc.optimize(ctx, vsc) : tc;
        }
        ((Expr)checked).markTailCalls(null);
        return new FuncItem(this.sc, this.ann, this.name, vs, ft, checked, vsc.stackSize());
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem("type", this.type), new Object[]{this.params, this.expr});
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return visitor.funcItem(this);
    }

    @Override
    public boolean visit(ASTVisitor visitor) {
        for (Var var : this.params) {
            if (visitor.declared(var)) continue;
            return false;
        }
        return this.expr.accept(visitor);
    }

    @Override
    public void compile(QueryContext ctx) {
    }

    @Override
    public boolean compiled() {
        return true;
    }

    @Override
    public Object toJava() {
        throw Util.notExpected(new Object[0]);
    }

    @Override
    public String toString() {
        FuncType ft = (FuncType)this.type;
        TokenBuilder tb = new TokenBuilder("function").add(40);
        for (Var v : this.params) {
            tb.addExt(v, new Object[0]).add(v == this.params[this.params.length - 1] ? "" : ", ");
        }
        tb.add(41).add(ft.ret != null ? " as " + ft.ret : "").add(" { ").addExt(this.expr, new Object[0]).add(" }");
        return tb.toString();
    }

    @Override
    public Expr inlineExpr(Expr[] exprs, QueryContext ctx, VarScope scp, InputInfo ii) throws QueryException {
        if (!this.expr.isValue() && (this.expr.exprSize() >= ctx.context.options.get(MainOptions.INLINELIMIT) || this.expr.has(Expr.Flag.CTX))) {
            return null;
        }
        ctx.compInfo("inlining %", this);
        LinkedList<GFLWOR.Clause> cls = exprs.length == 0 ? null : new LinkedList<GFLWOR.Clause>();
        IntObjMap<Var> vs = new IntObjMap<Var>();
        for (int i = 0; i < this.params.length; ++i) {
            Var old = this.params[i];
            Var v = scp.newCopyOf(ctx, old);
            vs.put(old.id, v);
            cls.add(new Let(v, exprs[i], false, ii).optimize(ctx, scp));
        }
        Expr rt = this.expr.copy(ctx, scp, vs);
        rt.accept(new ASTVisitor(){

            @Override
            public boolean inlineFunc(Scope sub) {
                return sub.visit(this);
            }

            @Override
            public boolean dynFuncCall(DynFuncCall call) {
                call.markInlined(FuncItem.this);
                return true;
            }
        });
        return cls == null ? rt : new GFLWOR(ii, cls, rt).optimize(ctx, scp);
    }
}

