/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import org.basex.data.ExprInfo;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;

public final class RangeSeq
extends Seq {
    private final long start;
    private final boolean asc;

    private RangeSeq(long s, long sz, boolean a) {
        super(sz, AtomType.ITR);
        this.start = s;
        this.asc = a;
    }

    public static Value get(long min, long sz, boolean asc) {
        return sz < 1L ? Empty.SEQ : (sz == 1L ? Int.get(min) : new RangeSeq(min, sz, asc));
    }

    @Override
    public Object toJava() {
        long[] obj = new long[(int)this.size];
        int s = 0;
        while ((long)s < this.size) {
            obj[s] = this.start + (long)(this.asc ? s : -s);
            ++s;
        }
        return obj;
    }

    @Override
    public Item ebv(QueryContext ctx, InputInfo ii) throws QueryException {
        throw Err.CONDTYPE.get(ii, this);
    }

    @Override
    public SeqType type() {
        return SeqType.ITR_OM;
    }

    @Override
    public boolean sameAs(Expr cmp) {
        if (!(cmp instanceof RangeSeq)) {
            return false;
        }
        RangeSeq is = (RangeSeq)cmp;
        return this.start == is.start && this.size == is.size && this.asc == is.asc;
    }

    @Override
    public int writeTo(Item[] arr, int pos) {
        int i = 0;
        while ((long)i < this.size) {
            arr[pos + i] = this.itemAt(i);
            ++i;
        }
        return (int)this.size;
    }

    @Override
    public Item itemAt(long pos) {
        return Int.get(this.start + (this.asc ? pos : -pos));
    }

    @Override
    public Value reverse() {
        long s = this.size();
        return this.asc ? RangeSeq.get(this.start + s - 1L, s, false) : RangeSeq.get(this.start - s + 1L, s, true);
    }

    @Override
    public boolean homogeneous() {
        return true;
    }

    @Override
    public void plan(FElem plan) {
        long s = this.start;
        long e = this.asc ? this.start + this.size - 1L : this.start - this.size + 1L;
        this.addPlan(plan, this.planElem("from", s, "to", e), new ExprInfo[0]);
    }

    @Override
    public String toString() {
        long s = this.asc ? this.start : this.start - this.size + 1L;
        long e = this.asc ? this.start + this.size - 1L : this.start;
        String str = "(" + s + ' ' + "to" + ' ' + e + ")";
        return this.asc ? str : Function.REVERSE.args(str);
    }
}

