/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;

public final class SubSeq
extends Seq {
    private final Seq sub;
    private final long start;

    public static Value get(Value val, long from, long len) {
        long vLen = val.size();
        long n = Math.min(vLen - from, len);
        if (n == vLen) {
            return val;
        }
        if (n <= 0L) {
            return Empty.SEQ;
        }
        if (n == 1L) {
            return val.itemAt(from);
        }
        if (val instanceof SubSeq) {
            SubSeq sSeq = (SubSeq)val;
            return new SubSeq(sSeq.sub, sSeq.start + from, n);
        }
        return new SubSeq((Seq)val, from, n);
    }

    private SubSeq(Seq seq, long from, long len) {
        super(len, seq.type);
        this.sub = seq;
        this.start = from;
    }

    @Override
    public Value reverse() {
        int n = (int)this.size;
        Item[] items = new Item[n];
        for (int i = 0; i < n; ++i) {
            items[n - 1 - i] = this.sub.itemAt(this.start + (long)i);
        }
        return Seq.get(items, n);
    }

    @Override
    public int writeTo(Item[] arr, int st) {
        int n = (int)Math.min((long)(arr.length - st), this.size);
        for (int i = 0; i < n; ++i) {
            arr[st + i] = this.sub.itemAt(this.start + (long)i);
        }
        return n;
    }

    @Override
    public Item itemAt(long pos) {
        return this.sub.itemAt(this.start + pos);
    }

    @Override
    public boolean homogeneous() {
        return this.sub.homogeneous();
    }

    @Override
    public Item ebv(QueryContext ctx, InputInfo ii) throws QueryException {
        Item fst = this.itemAt(0L);
        if (fst instanceof ANode) {
            return fst;
        }
        throw Err.CONDTYPE.get(ii, this);
    }

    @Override
    public SeqType type() {
        return this.sub.type();
    }
}

