/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.type;

import java.util.Arrays;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.util.Ann;
import org.basex.query.util.Err;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public class FuncType
implements Type {
    public static final FuncType ANY_FUN = new FuncType(null, null, null);
    public final Ann ann;
    public final SeqType[] args;
    public final SeqType ret;
    private SeqType seq;

    FuncType(Ann a, SeqType[] arg, SeqType typ) {
        this.ann = a != null ? a : new Ann();
        this.args = arg;
        this.ret = typ;
    }

    @Override
    public final boolean isNode() {
        return false;
    }

    @Override
    public final boolean isNumber() {
        return false;
    }

    @Override
    public final boolean isUntyped() {
        return false;
    }

    @Override
    public final boolean isNumberOrUntyped() {
        return false;
    }

    @Override
    public final boolean isStringOrUntyped() {
        return false;
    }

    @Override
    public final SeqType seqType() {
        if (this.seq == null) {
            this.seq = new SeqType(this);
        }
        return this.seq;
    }

    @Override
    public byte[] string() {
        return Token.token("function");
    }

    @Override
    public FItem cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
        if (!(it instanceof FItem)) {
            throw Err.castError(ii, this, it);
        }
        FItem f = (FItem)it;
        return this == ANY_FUN ? f : f.coerceTo(this, ctx, ii, false);
    }

    @Override
    public final Item cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) {
        throw Util.notExpected(o);
    }

    @Override
    public final Item castString(String s, QueryContext ctx, StaticContext sc, InputInfo ii) {
        throw Util.notExpected(s);
    }

    @Override
    public boolean eq(Type t) {
        int i;
        if (this == t) {
            return true;
        }
        if (t.getClass() != FuncType.class) {
            return false;
        }
        FuncType ft = (FuncType)t;
        if (this.ann.size() != ft.ann.size()) {
            return false;
        }
        for (i = 0; i < this.ann.size(); ++i) {
            if (this.ann.contains(ft.ann.names[i], ft.ann.values[i])) continue;
            return false;
        }
        if (this == ANY_FUN || ft == ANY_FUN || this.args.length != ft.args.length) {
            return false;
        }
        for (i = 0; i < this.args.length; ++i) {
            if (this.args[i].eq(ft.args[i])) continue;
            return false;
        }
        return this.ret.eq(ft.ret);
    }

    @Override
    public boolean instanceOf(Type t) {
        if (!(t instanceof FuncType)) {
            return t == AtomType.ITEM;
        }
        if (t instanceof MapType) {
            return false;
        }
        FuncType ft = (FuncType)t;
        for (int i = 0; i < ft.ann.size(); ++i) {
            if (this.ann.contains(ft.ann.names[i], ft.ann.values[i])) continue;
            return false;
        }
        if (this == ft || ft == ANY_FUN) {
            return true;
        }
        if (this == ANY_FUN || this.args.length != ft.args.length || !this.ret.instanceOf(ft.ret)) {
            return false;
        }
        for (int a = 0; a < this.args.length; ++a) {
            if (ft.args[a].instanceOf(this.args[a])) continue;
            return false;
        }
        return true;
    }

    @Override
    public Type union(Type t) {
        if (!(t instanceof FuncType)) {
            return AtomType.ITEM;
        }
        FuncType ft = (FuncType)t;
        if (this == ANY_FUN || ft == ANY_FUN || this.args.length != ft.args.length) {
            return ANY_FUN;
        }
        SeqType[] arg = new SeqType[this.args.length];
        for (int i = 0; i < arg.length; ++i) {
            arg[i] = this.args[i].intersect(ft.args[i]);
            if (arg[i] != null) continue;
            return ANY_FUN;
        }
        return FuncType.get(this.ann.intersect(ft.ann), this.ret.union(ft.ret), arg);
    }

    @Override
    public Type intersect(Type t) {
        if (t instanceof MapType) {
            return t.intersect(this);
        }
        if (this.instanceOf(t)) {
            return this;
        }
        if (t.instanceOf(this)) {
            return t;
        }
        if (t instanceof FuncType) {
            FuncType ft = (FuncType)t;
            SeqType rt = this.ret.intersect(ft.ret);
            if (rt != null && this.args.length == ft.args.length) {
                SeqType[] arg = new SeqType[this.args.length];
                for (int i = 0; i < arg.length; ++i) {
                    arg[i] = this.args[i].union(ft.args[i]);
                }
                Ann a = this.ann.union(ft.ann);
                return a == null ? null : FuncType.get(a, rt, arg);
            }
        }
        return null;
    }

    public static FuncType get(Ann a, SeqType ret, SeqType ... args) {
        return args == null || ret == null ? ANY_FUN : new FuncType(a, args, ret);
    }

    public static FuncType get(SeqType ret, SeqType ... args) {
        return FuncType.get(new Ann(), ret, args);
    }

    public static Type find(QNm type) {
        if (type.uri().length == 0) {
            byte[] ln = type.local();
            if (Token.eq(ln, Token.token("function"))) {
                return ANY_FUN;
            }
            if (Token.eq(ln, QueryText.MAP)) {
                return SeqType.ANY_MAP;
            }
        }
        return null;
    }

    public static FuncType arity(int a) {
        Object[] args = new SeqType[a];
        Arrays.fill(args, SeqType.ITEM_ZM);
        return FuncType.get(null, SeqType.ITEM_ZM, (SeqType[])args);
    }

    public static FuncType get(Ann an, Var[] args, SeqType ret) {
        SeqType[] at = new SeqType[args.length];
        for (int a = 0; a < at.length; ++a) {
            at[a] = args[a] == null ? SeqType.ITEM_ZM : args[a].declaredType();
        }
        return new FuncType(an, at, ret == null ? SeqType.ITEM_ZM : ret);
    }

    @Override
    public Type.ID id() {
        return Type.ID.FUN;
    }

    @Override
    public String toString() {
        TokenBuilder tb = new TokenBuilder(this.ann.toString()).add("function").add(40);
        if (this == ANY_FUN) {
            tb.add(42).add(41);
        } else {
            tb.addSep(this.args, ", ").add(") as ").add(this.ret.toString());
        }
        return tb.toString();
    }

    @Override
    public boolean nsSensitive() {
        return false;
    }
}

