/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.var;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.basex.data.ExprInfo;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.util.Ann;
import org.basex.query.util.Err;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.StaticVar;
import org.basex.query.var.StaticVarRef;
import org.basex.query.var.VarScope;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.Util;

public final class Variables
extends ExprInfo
implements Iterable<StaticVar> {
    private final HashMap<QNm, VarEntry> vars = new HashMap();

    public StaticVar declare(QNm nm, SeqType t, Ann a, Expr e, boolean ext, StaticContext sctx, VarScope scp, String xqdoc, InputInfo ii) throws QueryException {
        StaticVar var = new StaticVar(sctx, scp, a, nm, t, e, ext, xqdoc, ii);
        VarEntry ve = this.vars.get(nm);
        if (ve != null) {
            ve.setVar(var);
        } else {
            this.vars.put(nm, new VarEntry(var));
        }
        return var;
    }

    public void checkUp() throws QueryException {
        for (VarEntry e : this.vars.values()) {
            e.var.checkUp();
        }
    }

    public void check() throws QueryException {
        for (Map.Entry<QNm, VarEntry> e : this.vars.entrySet()) {
            VarEntry ve = e.getValue();
            if (ve.var != null) continue;
            throw Err.VARUNDEF.get(ve.refs[0].info, ve.refs[0]);
        }
    }

    @Override
    public void plan(FElem plan) {
        if (this.vars.isEmpty()) {
            return;
        }
        FElem e = this.planElem(new Object[0]);
        for (VarEntry v : this.vars.values()) {
            v.var.plan(e);
        }
        plan.add(e);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (VarEntry v : this.vars.values()) {
            sb.append(v.var);
        }
        return sb.toString();
    }

    public boolean declared(QNm nm) {
        VarEntry entry = this.vars.get(nm);
        return entry != null && entry.var != null;
    }

    public StaticVarRef newRef(QNm nm, StaticContext sctx, InputInfo ii) throws QueryException {
        VarEntry entry;
        StaticVarRef ref = new StaticVarRef(ii, nm, sctx);
        VarEntry e = this.vars.get(nm);
        VarEntry varEntry = entry = e != null ? e : new VarEntry(null);
        if (e == null) {
            this.vars.put(nm, entry);
        }
        entry.addRef(ref);
        return ref;
    }

    public void bindExternal(QueryContext ctx, HashMap<QNm, Expr> bindings) throws QueryException {
        for (Map.Entry<QNm, Expr> e : bindings.entrySet()) {
            VarEntry ve = this.vars.get(e.getKey());
            if (ve == null) continue;
            ve.var.bind(e.getValue(), ctx);
        }
    }

    @Override
    public Iterator<StaticVar> iterator() {
        final Iterator<Map.Entry<QNm, VarEntry>> iter = this.vars.entrySet().iterator();
        return new Iterator<StaticVar>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public StaticVar next() {
                return ((VarEntry)((Map.Entry)iter.next()).getValue()).var;
            }

            @Override
            public void remove() {
                throw Util.notExpected(new Object[0]);
            }
        };
    }

    private static class VarEntry {
        StaticVar var;
        StaticVarRef[] refs = new StaticVarRef[0];

        VarEntry(StaticVar vr) {
            this.var = vr;
        }

        void setVar(StaticVar vr) throws QueryException {
            if (this.var != null) {
                throw Err.VARDUPL.get(vr.info, new Object[]{this.var.name.string()});
            }
            this.var = vr;
            for (StaticVarRef ref : this.refs) {
                ref.init(this.var);
            }
        }

        void addRef(StaticVarRef ref) throws QueryException {
            this.refs = Array.add(this.refs, new StaticVarRef[this.refs.length + 1], ref);
            if (this.var != null) {
                ref.init(this.var);
            }
        }
    }
}

