/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import org.basex.util.Array;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public final class Token {
    private static final byte MAXLENGTH = 96;
    private static final int MAXINT = 0xCCCCCCC;
    private static final long MAXLONG = 0xCCCCCCCCCCCCCCCL;
    public static final byte[] EMPTY = new byte[0];
    public static final byte[] XML = Token.token("xml");
    public static final byte[] XMLC = Token.token("xml:");
    public static final byte[] XMLNS = Token.token("xmlns");
    public static final byte[] XMLNSC = Token.token("xmlns:");
    public static final byte[] TRUE = Token.token("true");
    public static final byte[] FALSE = Token.token("false");
    public static final byte[] NULL = Token.token("null");
    public static final byte[] NAN = Token.token("NaN");
    public static final byte[] INF = Token.token("INF");
    public static final byte[] NINF = Token.token("-INF");
    public static final byte[] SPACE = new byte[]{32};
    public static final byte[] ZERO = new byte[]{48};
    private static final byte[] MZERO = new byte[]{45, 48};
    public static final byte[] ONE = new byte[]{49};
    public static final byte[] SLASH = new byte[]{47};
    public static final byte[] COLON = new byte[]{58};
    public static final byte[] HEX = Token.token("0123456789ABCDEF");
    private static final byte[] IRIRES = Token.token("!#$%&*'()+,-./:;=?@[]~_");
    private static final byte[] RES = Token.token("-._~");
    public static final String UTF8 = "UTF-8";
    public static final String UTF16 = "UTF-16";
    public static final String UTF16BE = "UTF-16BE";
    public static final String UTF16LE = "UTF-16LE";
    public static final String UTF32 = "UTF-32";
    private static final String[] ALL_UTF8 = new String[]{"UTF-8", "UTF8"};
    private static final String[] ALL_UTF16 = new String[]{"UTF-16", "UTF16"};
    private static final String[] ALL_UTF32 = new String[]{"UTF-32", "UTF32"};
    public static final Comparator<byte[]> COMP = new Comparator<byte[]>(){

        @Override
        public int compare(byte[] o1, byte[] o2) {
            return Token.diff(o1, o2);
        }
    };
    public static final Comparator<byte[]> LC_COMP = new Comparator<byte[]>(){

        @Override
        public int compare(byte[] o1, byte[] o2) {
            return Token.diff(Token.lc(o1), Token.lc(o2));
        }
    };
    private static final int[] CHLEN = new int[]{1, 1, 1, 1, 2, 2, 3, 4};
    private static final byte[] MININT = Token.token("-2147483648");
    private static final int[] INTSIZE = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    private static final DecimalFormatSymbols LOC = new DecimalFormatSymbols(Locale.US);
    private static final DecimalFormat SD = new DecimalFormat("0.0##################E0", LOC);
    private static final DecimalFormat DD = new DecimalFormat("#####0.0################", LOC);
    private static final DecimalFormat SF = new DecimalFormat("0.0######E0", LOC);
    private static final DecimalFormat DF = new DecimalFormat("#####0.0######", LOC);
    private static final float[] FLT = new float[]{1.0E17f, 1.0E15f, 1.0E13f, 1.0E11f, -1.0E17f, -1.0E15f, -1.0E13f, -1.0E11f};
    private static final byte[][] FLTSTR = Token.tokens("1.0E17", "1.0E15", "1.0E13", "1.0E11", "-1.0E17", "-1.0E15", "-1.0E13", "-1.0E11");
    private static final boolean[] LOD = new boolean[]{true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false};
    private static char[] norm;
    private static final char[][] NC;

    private Token() {
    }

    public static String string(byte[] token) {
        return Token.string(token, 0, token.length);
    }

    public static String string(byte[] token, int start, int length) {
        if (length <= 0) {
            return "";
        }
        int e = start + length;
        for (int p = start; p < e; ++p) {
            if (token[p] >= 0) continue;
            return Token.utf8(token, start, length);
        }
        char[] str = new char[length];
        for (int p = 0; p < length; ++p) {
            str[p] = (char)token[start + p];
        }
        return new String(str);
    }

    private static String utf8(byte[] token, int start, int length) {
        StringBuilder sb = new StringBuilder(length << 1);
        int il = Math.min(start + length, token.length);
        for (int i = start; i < il; i += Token.cl(token, i)) {
            int cp = Token.cp(token, i);
            if (cp < 65536) {
                sb.append((char)cp);
                continue;
            }
            int o = cp - 65536;
            sb.append((char)((o >>> 10) + 55296));
            sb.append((char)((o & 0x3FF) + 56320));
        }
        return sb.toString();
    }

    public static boolean ascii(byte[] token) {
        for (byte t : token) {
            if (t >= 0) continue;
            return false;
        }
        return true;
    }

    public static byte[] token(String string) {
        int l = string.length();
        if (l == 0) {
            return EMPTY;
        }
        byte[] b = new byte[l];
        for (int i = 0; i < l; ++i) {
            char c = string.charAt(i);
            if (c > '\u007f') {
                return Token.utf8(string);
            }
            b[i] = (byte)c;
        }
        return b;
    }

    public static byte[][] tokens(String ... strings) {
        byte[][] t = new byte[strings.length][];
        for (int i = 0; i < t.length; ++i) {
            t[i] = Token.token(strings[i]);
        }
        return t;
    }

    private static byte[] utf8(String string) {
        char[] arr = string.toCharArray();
        int al = arr.length;
        TokenBuilder tb = new TokenBuilder(al << 1);
        for (int c = 0; c < al; ++c) {
            int ch = arr[c];
            tb.add(Character.isHighSurrogate((char)ch) && c < al - 1 && Character.isLowSurrogate(arr[c + 1]) ? Character.toCodePoint((char)ch, arr[++c]) : ch);
        }
        return tb.finish();
    }

    public static byte[] utf8(byte[] token, String encoding) {
        if (encoding == UTF8 || Token.ascii(token)) {
            return token;
        }
        try {
            return Token.token(new String(token, encoding));
        }
        catch (Exception ex) {
            Util.debug(ex);
            return EMPTY;
        }
    }

    public static String normEncoding(String encoding) {
        return Token.normEncoding(encoding, false);
    }

    public static String normEncoding(String encoding, boolean utf16) {
        if (encoding == null) {
            return UTF8;
        }
        String e = encoding.toUpperCase(Locale.ENGLISH);
        if (Token.eq(e, ALL_UTF8)) {
            return UTF8;
        }
        if (e.equals(UTF16LE)) {
            return UTF16LE;
        }
        if (e.equals(UTF16BE)) {
            return UTF16BE;
        }
        if (Token.eq(e, ALL_UTF16)) {
            return utf16 ? UTF16BE : UTF16;
        }
        if (Token.eq(e, ALL_UTF32)) {
            return UTF32;
        }
        return encoding;
    }

    public static boolean supported(String encoding) {
        try {
            return Charset.isSupported(encoding);
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static int cp(byte[] token, int pos) {
        byte v = token[pos];
        if ((v & 0xFF) < 192) {
            return v & 0xFF;
        }
        int vl = Token.cl(v);
        if (pos + vl > token.length) {
            return 65533;
        }
        if (vl == 2) {
            return (v & 0x1F) << 6 | token[pos + 1] & 0x3F;
        }
        if (vl == 3) {
            return (v & 0xF) << 12 | (token[pos + 1] & 0x3F) << 6 | token[pos + 2] & 0x3F;
        }
        return (v & 7) << 18 | (token[pos + 1] & 0x3F) << 12 | (token[pos + 2] & 0x3F) << 6 | token[pos + 3] & 0x3F;
    }

    public static int cl(byte cp) {
        return cp >= 0 ? 1 : CHLEN[cp >> 4 & 7];
    }

    public static int cl(byte[] token, int pos) {
        return Token.cl(token[pos]);
    }

    public static int[] cps(byte[] token) {
        int pos = 0;
        int len = token.length;
        int[] cp = new int[len];
        for (int i = 0; i < len; i += Token.cl(token, i)) {
            cp[pos++] = Token.cp(token, i);
        }
        return pos < len ? Arrays.copyOf(cp, pos) : cp;
    }

    public static int len(byte[] token) {
        int l = 0;
        for (int t = 0; t < token.length; t += Token.cl(token, t)) {
            ++l;
        }
        return l;
    }

    public static byte[] token(boolean bool) {
        return bool ? TRUE : FALSE;
    }

    public static byte[] token(int integer) {
        int q;
        boolean m;
        if (integer == 0) {
            return ZERO;
        }
        if (integer == Integer.MIN_VALUE) {
            return MININT;
        }
        int n = integer;
        boolean bl = m = n < 0;
        if (m) {
            n = -n;
        }
        int j = Token.numDigits(n);
        if (m) {
            ++j;
        }
        byte[] num = new byte[j];
        while (n > 81919) {
            q = n / 10;
            num[--j] = (byte)(n - (q << 3) - (q << 1) + 48);
            n = q;
        }
        while (n != 0) {
            q = n * 52429 >>> 19;
            num[--j] = (byte)(n - (q << 3) - (q << 1) + 48);
            n = q;
        }
        if (m) {
            num[--j] = 45;
        }
        return num;
    }

    public static int numDigits(int integer) {
        int i = 0;
        while (integer > INTSIZE[i]) {
            ++i;
        }
        return i + 1;
    }

    public static byte[] token(long integer) {
        return integer >= Integer.MIN_VALUE && integer <= Integer.MAX_VALUE ? Token.token((int)integer) : Token.token(Long.toString(integer));
    }

    public static byte[] token(double dbl) {
        byte[] b = Token.tok(dbl);
        if (b != null) {
            return b;
        }
        double a = Math.abs(dbl);
        return Token.chopNumber(Token.token(a >= 1.0E-6 && a < 1000000.0 ? DD.format(dbl) : SD.format(dbl)));
    }

    public static byte[] token(float flt) {
        byte[] b = Token.tok(flt);
        if (b != null) {
            return b;
        }
        for (int i = 0; i < FLT.length; ++i) {
            if (flt != FLT[i]) continue;
            return FLTSTR[i];
        }
        float a = Math.abs(flt);
        boolean small = a >= 1.0E-6f && a < 1000000.0f;
        String s1 = small ? DF.format(flt) : SF.format(flt);
        String s2 = Float.toString(flt);
        if (!(s2.length() >= s1.length() || s2.contains("E") && small)) {
            s1 = s2;
        }
        return Token.chopNumber(Token.token(s1));
    }

    private static byte[] tok(double dbl) {
        int i;
        if (dbl == Double.POSITIVE_INFINITY) {
            return INF;
        }
        if (dbl == Double.NEGATIVE_INFINITY) {
            return NINF;
        }
        if (dbl == 0.0) {
            return 1.0 / dbl > 0.0 ? ZERO : MZERO;
        }
        if (Double.isNaN(dbl)) {
            return NAN;
        }
        double a = Math.abs(dbl);
        if (a < 1000000.0 && (double)(i = (int)dbl) == dbl) {
            return Token.token(i);
        }
        return null;
    }

    public static byte[] chopNumber(byte[] token) {
        if (!Token.contains(token, 46) || Token.contains(token, 101) || Token.contains(token, 69)) {
            return token;
        }
        int l = token.length;
        while (--l > 0 && token[l] == 48) {
        }
        return Token.substring(token, 0, token[l] == 46 ? l : l + 1);
    }

    public static double toDouble(byte[] token) {
        int tl = token.length;
        boolean f = false;
        for (byte t : token) {
            if (t >= 0 && t <= 32 || Token.digit(t)) continue;
            boolean bl = f = t == 101 || t == 69 || t == 46 || t == 45;
            if (f) continue;
            return Double.NaN;
        }
        if (f || tl > 9) {
            return Token.dbl(token);
        }
        int d = Token.toInt(token);
        return d == Integer.MIN_VALUE ? Double.NaN : (double)d;
    }

    private static double dbl(byte[] token) {
        try {
            return Double.parseDouble(Token.string(token));
        }
        catch (Exception ex) {
            return Double.NaN;
        }
    }

    public static long toLong(String string) {
        return Token.toLong(Token.token(string));
    }

    public static long toLong(byte[] token) {
        return Token.toLong(token, 0, token.length);
    }

    public static long toLong(byte[] token, int start, int end) {
        byte c;
        int t;
        for (t = start; t < end && token[t] <= 32; ++t) {
        }
        if (t == end) {
            return Long.MIN_VALUE;
        }
        boolean m = false;
        if (token[t] == 45 || token[t] == 43) {
            boolean bl = m = token[t++] == 45;
        }
        if (t == end) {
            return Long.MIN_VALUE;
        }
        long v = 0L;
        while (t < end && (c = token[t]) >= 48 && c <= 57) {
            if (v >= 0xCCCCCCCCCCCCCCCL && (c > 55 || v > 0xCCCCCCCCCCCCCCCL)) {
                return Long.MIN_VALUE;
            }
            v = (v << 3) + (v << 1) + (long)c - 48L;
            ++t;
        }
        while (t < end && token[t] <= 32) {
            ++t;
        }
        return t < end ? Long.MIN_VALUE : (m ? -v : v);
    }

    public static int toInt(String string) {
        return Token.toInt(Token.token(string));
    }

    public static int toInt(byte[] token) {
        return Token.toInt(token, 0, token.length);
    }

    public static int toInt(byte[] token, int start, int end) {
        byte c;
        int t;
        for (t = start; t < end && token[t] <= 32; ++t) {
        }
        if (t == end) {
            return Integer.MIN_VALUE;
        }
        boolean m = false;
        if (token[t] == 45 || token[t] == 43) {
            boolean bl = m = token[t++] == 45;
        }
        if (t == end) {
            return Integer.MIN_VALUE;
        }
        int v = 0;
        while (t < end && (c = token[t]) >= 48 && c <= 57) {
            if (v >= 0xCCCCCCC && (c > 55 || v > 0xCCCCCCC)) {
                return Integer.MIN_VALUE;
            }
            v = (v << 3) + (v << 1) + c - 48;
            ++t;
        }
        while (t < end && token[t] <= 32) {
            ++t;
        }
        return t < end || v < 0 ? Integer.MIN_VALUE : (m ? -v : v);
    }

    public static int toSimpleInt(byte[] token) {
        int te = token.length;
        if (te >= 10 || te == 0) {
            return Integer.MIN_VALUE;
        }
        if (token[0] == 48) {
            return te == 1 ? 0 : Integer.MIN_VALUE;
        }
        int v = 0;
        for (byte c : token) {
            if (c < 48 || c > 57) {
                return Integer.MIN_VALUE;
            }
            v = (v << 3) + (v << 1) + c - 48;
        }
        return v;
    }

    public static int hash(byte[] token) {
        int h = 0;
        int l = Math.min(token.length, 96);
        for (int i = 0; i != l; ++i) {
            h = (h << 5) - h + token[i];
        }
        return h;
    }

    public static boolean eq(byte[] token1, byte[] token2) {
        int tl = token2.length;
        if (tl != token1.length) {
            return false;
        }
        for (int t = 0; t != tl; ++t) {
            if (token2[t] == token1[t]) continue;
            return false;
        }
        return true;
    }

    public static boolean eq(byte[] token, byte[] ... tokens) {
        for (byte[] t : tokens) {
            if (!Token.eq(token, t)) continue;
            return true;
        }
        return false;
    }

    public static boolean eq(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    public static boolean eq(String str, String ... strings) {
        for (String s : strings) {
            if (!(str == null ? s == null : str.equals(s))) continue;
            return true;
        }
        return false;
    }

    public static boolean eqic(String str, String ... strings) {
        for (String s : strings) {
            if (!(str == null ? s == null : str.equalsIgnoreCase(s))) continue;
            return true;
        }
        return false;
    }

    public static int diff(byte[] token, byte[] compare) {
        int tl = token.length;
        int cl = compare.length;
        int l = Math.min(tl, cl);
        for (int i = 0; i < l; ++i) {
            int c = (token[i] & 0xFF) - (compare[i] & 0xFF);
            if (c == 0) continue;
            return c;
        }
        return tl - cl;
    }

    public static byte[] min(byte[] token, byte[] compare) {
        return Token.diff(token, compare) < 0 ? token : compare;
    }

    public static byte[] max(byte[] token, byte[] compare) {
        return Token.diff(token, compare) > 0 ? token : compare;
    }

    public static boolean contains(byte[] token, byte[] sub) {
        return Token.contains(token, sub, 0);
    }

    public static boolean contains(byte[] token, byte[] sub, int pos) {
        return Token.indexOf(token, sub, pos) != -1;
    }

    public static boolean contains(byte[] token, int c) {
        return Token.indexOf(token, c) != -1;
    }

    public static int indexOf(byte[] token, int c) {
        int tl = token.length;
        if (c < 128) {
            for (int t = 0; t < tl; ++t) {
                if (token[t] != c) continue;
                return t;
            }
        } else {
            for (int t = 0; t < tl; t += Token.cl(token, t)) {
                if (Token.cp(token, t) != c) continue;
                return t;
            }
        }
        return -1;
    }

    public static int lastIndexOf(byte[] token, int c) {
        int tl = token.length;
        int p = -1;
        if (c < 128) {
            for (int t = tl - 1; t >= 0; --t) {
                if (token[t] != c) continue;
                return t;
            }
        } else {
            for (int t = 0; t < tl; t += Token.cl(token, t)) {
                if (Token.cp(token, t) != c) continue;
                p = t;
            }
        }
        return p;
    }

    public static int indexOf(byte[] token, byte[] sub) {
        return Token.indexOf(token, sub, 0);
    }

    public static int indexOf(byte[] token, byte[] sub, int pos) {
        int sl = sub.length;
        if (sl == 0) {
            return pos;
        }
        int tl = token.length - sl;
        if (pos > tl) {
            return -1;
        }
        for (int t = pos; t <= tl; ++t) {
            int s = 0;
            while (sub[s] == token[t + s]) {
                if (++s != sl) continue;
                return t;
            }
        }
        return -1;
    }

    public static boolean startsWith(byte[] token, int ch) {
        return Token.startsWith(token, ch, 0);
    }

    public static boolean startsWith(byte[] token, int ch, int pos) {
        return pos < token.length && token[pos] == ch;
    }

    public static boolean startsWith(byte[] token, byte[] sub) {
        return Token.startsWith(token, sub, 0);
    }

    public static boolean startsWith(byte[] token, byte[] sub, int pos) {
        int sl = sub.length;
        if (sl > token.length - pos) {
            return false;
        }
        int s = 0;
        int p = pos;
        while (s < sl) {
            if (sub[s] != token[p]) {
                return false;
            }
            ++s;
            ++p;
        }
        return true;
    }

    public static boolean endsWith(byte[] token, int ch) {
        return token.length != 0 && token[token.length - 1] == ch;
    }

    public static boolean endsWith(byte[] token, byte[] sub) {
        int sl = sub.length;
        int tl = token.length;
        if (sl > tl) {
            return false;
        }
        for (int s = sl; s > 0; --s) {
            if (sub[sl - s] == token[tl - s]) continue;
            return false;
        }
        return true;
    }

    public static byte[] substring(byte[] token, int start) {
        return Token.substring(token, start, token.length);
    }

    public static byte[] substring(byte[] token, int start, int end) {
        int s = Math.max(0, start);
        int e = Math.min(end, token.length);
        if (s == 0 && e == token.length) {
            return token;
        }
        return s >= e ? EMPTY : Arrays.copyOfRange(token, s, e);
    }

    public static byte[] subtoken(byte[] token, int start) {
        return Token.subtoken(token, start, token.length);
    }

    public static byte[] subtoken(byte[] token, int start, int end) {
        int t;
        int s = Math.max(0, start);
        int e = Math.min(end, token.length);
        if (s == 0 && e == token.length) {
            return token;
        }
        if (s >= e) {
            return EMPTY;
        }
        for (t = Math.max(0, s - 4); t != s && t < e; t += Token.cl(token, t)) {
            if (t < s) continue;
            s = t;
        }
        while (t < e) {
            t += Token.cl(token, t);
        }
        return Arrays.copyOfRange(token, s, t);
    }

    public static byte[][] split(byte[] token, int sep) {
        int l = token.length;
        byte[][] split = new byte[l][];
        int s = 0;
        TokenBuilder tb = new TokenBuilder();
        for (int i = 0; i < l; i += Token.cl(token, i)) {
            int c = Token.cp(token, i);
            if (c == sep) {
                if (tb.isEmpty()) continue;
                split[s++] = tb.finish();
                tb.reset();
                continue;
            }
            tb.add(c);
        }
        if (!tb.isEmpty()) {
            split[s++] = tb.finish();
        }
        return Array.copyOf(split, s);
    }

    public static boolean ws(byte[] token) {
        for (byte t : token) {
            if (t >= 0 && t <= 32) continue;
            return false;
        }
        return true;
    }

    public static byte[] replace(byte[] token, int search, int replace) {
        TokenBuilder tb = new TokenBuilder(token.length);
        int tl = token.length;
        for (int i = 0; i < tl; i += Token.cl(token, i)) {
            int c = Token.cp(token, i);
            tb.add(c == search ? replace : c);
        }
        return tb.finish();
    }

    public static byte[] trim(byte[] token) {
        int s = -1;
        int e = token.length;
        while (++s < e && token[s] <= 32 && token[s] >= 0) {
        }
        while (--e > s && token[e] <= 32 && token[e] >= 0) {
        }
        if (++e == token.length && s == 0) {
            return token;
        }
        return s == e ? EMPTY : Arrays.copyOfRange(token, s, e);
    }

    public static byte[] chop(byte[] token, int max) {
        if (token.length <= max) {
            return token;
        }
        byte[] tt = Arrays.copyOf(token, max);
        if (max > 2) {
            tt[max - 3] = 46;
        }
        if (max > 1) {
            tt[max - 2] = 46;
        }
        if (max > 0) {
            tt[max - 1] = 46;
        }
        return tt;
    }

    public static byte[] concat(byte[] token1, byte[] token2) {
        int t1 = token1.length;
        int t2 = token2.length;
        byte[] tmp = new byte[t1 + t2];
        System.arraycopy(token1, 0, tmp, 0, t1);
        System.arraycopy(token2, 0, tmp, t1, t2);
        return tmp;
    }

    public static byte[] concat(byte[] token1, byte[] token2, byte[] token3) {
        int t1 = token1.length;
        int t2 = token2.length;
        int t3 = token3.length;
        byte[] tmp = new byte[t1 + t2 + t3];
        System.arraycopy(token1, 0, tmp, 0, t1);
        System.arraycopy(token2, 0, tmp, t1, t2);
        System.arraycopy(token3, 0, tmp, t1 + t2, t3);
        return tmp;
    }

    public static byte[] delete(byte[] token, int ch) {
        if (ch < 128 && !Token.contains(token, ch)) {
            return token;
        }
        TokenBuilder tb = new TokenBuilder(token.length);
        int tl = token.length;
        for (int i = 0; i < tl; i += Token.cl(token, i)) {
            int c = Token.cp(token, i);
            if (c == ch) continue;
            tb.add(c);
        }
        return tb.finish();
    }

    public static byte[] norm(byte[] token) {
        int l = token.length;
        byte[] tmp = new byte[l];
        int c = 0;
        boolean ws1 = true;
        for (int n : token) {
            boolean ws2 = Token.ws(n);
            if (ws2 && ws1) continue;
            tmp[c++] = ws2 ? 32 : n;
            ws1 = ws2;
        }
        if (c > 0 && Token.ws(tmp[c - 1])) {
            --c;
        }
        return c == l ? tmp : Arrays.copyOf(tmp, c);
    }

    public static boolean ws(int ch) {
        return ch == 9 || ch == 10 || ch == 13 || ch == 32;
    }

    public static boolean letter(int ch) {
        return ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || ch == 95;
    }

    public static boolean digit(int ch) {
        return ch >= 48 && ch <= 57;
    }

    public static boolean letterOrDigit(int ch) {
        return Token.letter(ch) || Token.digit(ch);
    }

    public static boolean ftChar(int ch) {
        return ch >= 48 && (ch < 128 ? LOD[ch - 48] : Character.isLetterOrDigit(ch));
    }

    public static byte[] uc(byte[] token) {
        if (Token.ascii(token)) {
            byte[] tok = new byte[token.length];
            for (int i = 0; i < token.length; ++i) {
                tok[i] = (byte)Token.uc(token[i]);
            }
            return tok;
        }
        return Token.token(Token.string(token).toUpperCase(Locale.ENGLISH));
    }

    public static int uc(int ch) {
        return ch >= 97 && ch <= 122 ? ch - 32 : (ch > 127 ? Character.toUpperCase(ch) : ch);
    }

    public static byte[] lc(byte[] token) {
        if (Token.ascii(token)) {
            byte[] tok = new byte[token.length];
            for (int i = 0; i < token.length; ++i) {
                tok[i] = (byte)Token.lc(token[i]);
            }
            return tok;
        }
        return Token.token(Token.string(token).toLowerCase(Locale.ENGLISH));
    }

    public static int lc(int ch) {
        return ch >= 65 && ch <= 90 ? ch | 0x20 : (ch > 127 ? Character.toLowerCase(ch) : ch);
    }

    public static byte[] prefix(byte[] name) {
        int i = Token.indexOf(name, 58);
        return i == -1 ? EMPTY : Token.substring(name, 0, i);
    }

    public static byte[] local(byte[] name) {
        int i = Token.indexOf(name, 58);
        return i == -1 ? name : Token.substring(name, i + 1);
    }

    public static byte[] uri(byte[] token, boolean iri) {
        TokenBuilder tb = new TokenBuilder();
        for (byte t : token) {
            if (Token.letterOrDigit(t) || Token.contains(iri ? IRIRES : RES, t)) {
                tb.addByte(t);
                continue;
            }
            Token.hex(tb, t);
        }
        return tb.finish();
    }

    public static byte[] escape(byte[] token) {
        TokenBuilder tb = new TokenBuilder();
        for (byte t : token) {
            if (t >= 32 && t <= 126) {
                tb.addByte(t);
                continue;
            }
            Token.hex(tb, t);
        }
        return tb.finish();
    }

    private static void hex(TokenBuilder tb, byte b) {
        tb.add(37);
        tb.addByte(HEX[(b & 0xFF) >> 4]);
        tb.addByte(HEX[b & 0xFF & 0xF]);
    }

    public static String md5(String string) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return Token.string(Token.hex(md.digest(Token.token(string)), false));
        }
        catch (Exception ex) {
            throw Util.notExpected(ex);
        }
    }

    public static String camelCase(String string) {
        StringBuilder sb = new StringBuilder(string.length());
        boolean dash = false;
        for (int p = 0; p < string.length(); ++p) {
            char ch = string.charAt(p);
            if (dash) {
                sb.append(Character.toUpperCase(ch));
                dash = false;
                continue;
            }
            boolean bl = dash = ch == '-';
            if (dash) continue;
            sb.append(ch);
        }
        return sb.toString();
    }

    public static byte[] hex(byte[] val, boolean uc) {
        int u = uc ? 55 : 87;
        byte[] data = new byte[val.length << 1];
        int c = 0;
        for (int d = 0; d < val.length; ++d) {
            int b = val[d] >> 4 & 0xF;
            data[c++] = (byte)(b + (b > 9 ? u : 48));
            b = val[d] & 0xF;
            data[c++] = (byte)(b + (b > 9 ? u : 48));
        }
        return data;
    }

    public static int norm(int ch) {
        return ch < 128 || ch >= 1024 ? ch : Token.ch()[ch];
    }

    private static synchronized char[] ch() {
        if (norm == null) {
            norm = new char[1024];
            for (int n = 0; n < norm.length; ++n) {
                Token.norm[n] = (char)n;
            }
            for (char[] aNC : NC) {
                Token.norm[aNC[0]] = aNC[1];
            }
        }
        return norm;
    }

    static {
        NC = new char[][]{{'\u00c0', 'A'}, {'\u00c1', 'A'}, {'\u00c2', 'A'}, {'\u00c3', 'A'}, {'\u00c4', 'A'}, {'\u00c5', 'A'}, {'\u00c6', 'A'}, {'\u00c7', 'C'}, {'\u00c8', 'E'}, {'\u00c9', 'E'}, {'\u00ca', 'E'}, {'\u00cb', 'E'}, {'\u00cc', 'I'}, {'\u00cd', 'I'}, {'\u00ce', 'I'}, {'\u00cf', 'I'}, {'\u00d0', 'D'}, {'\u00d1', 'N'}, {'\u00d2', 'O'}, {'\u00d3', 'O'}, {'\u00d4', 'O'}, {'\u00d5', 'O'}, {'\u00d6', 'O'}, {'\u00d8', 'O'}, {'\u00d9', 'U'}, {'\u00da', 'U'}, {'\u00db', 'U'}, {'\u00dc', 'U'}, {'\u00dd', 'Y'}, {'\u00de', 'd'}, {'\u00df', 's'}, {'\u00e0', 'a'}, {'\u00e1', 'a'}, {'\u00e2', 'a'}, {'\u00e3', 'a'}, {'\u00e4', 'a'}, {'\u00e5', 'a'}, {'\u00e6', 'a'}, {'\u00e7', 'c'}, {'\u00e8', 'e'}, {'\u00e9', 'e'}, {'\u00ea', 'e'}, {'\u00eb', 'e'}, {'\u00ec', 'i'}, {'\u00ed', 'i'}, {'\u00ee', 'i'}, {'\u00ef', 'i'}, {'\u00f0', 'd'}, {'\u00f1', 'n'}, {'\u00f2', 'o'}, {'\u00f3', 'o'}, {'\u00f4', 'o'}, {'\u00f5', 'o'}, {'\u00f6', 'o'}, {'\u00f8', 'o'}, {'\u00f9', 'u'}, {'\u00fa', 'u'}, {'\u00fb', 'u'}, {'\u00fc', 'u'}, {'\u00fd', 'y'}, {'\u00fe', 'd'}, {'\u00ff', 'y'}, {'\u0100', 'A'}, {'\u0101', 'a'}, {'\u0102', 'A'}, {'\u0103', 'a'}, {'\u0104', 'A'}, {'\u0105', 'a'}, {'\u0106', 'C'}, {'\u0107', 'c'}, {'\u0108', 'C'}, {'\u0109', 'c'}, {'\u010a', 'C'}, {'\u010b', 'c'}, {'\u010c', 'C'}, {'\u010d', 'c'}, {'\u010e', 'D'}, {'\u010f', 'd'}, {'\u0110', 'D'}, {'\u0111', 'd'}, {'\u0112', 'E'}, {'\u0113', 'e'}, {'\u0114', 'E'}, {'\u0115', 'e'}, {'\u0116', 'E'}, {'\u0117', 'e'}, {'\u0118', 'E'}, {'\u0119', 'e'}, {'\u011a', 'E'}, {'\u011b', 'e'}, {'\u011c', 'G'}, {'\u011d', 'g'}, {'\u011e', 'G'}, {'\u011f', 'g'}, {'\u0120', 'G'}, {'\u0121', 'g'}, {'\u0122', 'G'}, {'\u0123', 'g'}, {'\u0124', 'H'}, {'\u0125', 'h'}, {'\u0126', 'H'}, {'\u0127', 'h'}, {'\u0128', 'I'}, {'\u0129', 'i'}, {'\u012a', 'I'}, {'\u012b', 'i'}, {'\u012c', 'I'}, {'\u012d', 'i'}, {'\u012e', 'I'}, {'\u012f', 'i'}, {'\u0130', 'I'}, {'\u0131', 'i'}, {'\u0132', 'I'}, {'\u0133', 'i'}, {'\u0134', 'J'}, {'\u0135', 'j'}, {'\u0136', 'K'}, {'\u0137', 'k'}, {'\u0138', 'k'}, {'\u0139', 'L'}, {'\u013a', 'l'}, {'\u013b', 'L'}, {'\u013c', 'l'}, {'\u013d', 'L'}, {'\u013e', 'l'}, {'\u013f', 'L'}, {'\u0140', 'l'}, {'\u0141', 'L'}, {'\u0142', 'l'}, {'\u0143', 'N'}, {'\u0144', 'n'}, {'\u0145', 'N'}, {'\u0146', 'n'}, {'\u0147', 'N'}, {'\u0148', 'n'}, {'\u0149', 'n'}, {'\u014a', 'N'}, {'\u014b', 'n'}, {'\u014c', 'O'}, {'\u014d', 'o'}, {'\u014e', 'O'}, {'\u014f', 'o'}, {'\u0150', 'O'}, {'\u0151', 'o'}, {'\u0152', 'O'}, {'\u0153', 'o'}, {'\u0154', 'R'}, {'\u0155', 'r'}, {'\u0156', 'R'}, {'\u0157', 'r'}, {'\u0158', 'R'}, {'\u0159', 'r'}, {'\u015a', 'S'}, {'\u015b', 's'}, {'\u015c', 'S'}, {'\u015d', 's'}, {'\u015e', 'S'}, {'\u015f', 's'}, {'\u0160', 'S'}, {'\u0161', 's'}, {'\u0162', 'T'}, {'\u0163', 't'}, {'\u0164', 'T'}, {'\u0165', 't'}, {'\u0166', 'T'}, {'\u0167', 't'}, {'\u0168', 'U'}, {'\u0169', 'u'}, {'\u016a', 'U'}, {'\u016b', 'u'}, {'\u016c', 'U'}, {'\u016d', 'u'}, {'\u016e', 'U'}, {'\u016f', 'u'}, {'\u0170', 'U'}, {'\u0171', 'u'}, {'\u0172', 'U'}, {'\u0173', 'u'}, {'\u0174', 'W'}, {'\u0175', 'w'}, {'\u0176', 'Y'}, {'\u0177', 'y'}, {'\u0178', 'Y'}, {'\u0179', 'Z'}, {'\u017a', 'z'}, {'\u017b', 'Z'}, {'\u017c', 'z'}, {'\u017d', 'Z'}, {'\u017e', 'z'}, {'\u01fa', 'A'}, {'\u01fb', 'a'}, {'\u01fc', 'A'}, {'\u01fd', 'a'}, {'\u01fe', 'O'}, {'\u01ff', 'o'}, {'\u0390', '\u03b9'}, {'\u03b0', '\u03c5'}, {'\u03d3', '\u03a5'}, {'\u03d4', '\u03a5'}, {'\u0386', '\u0391'}, {'\u0388', '\u0395'}, {'\u0389', '\u0397'}, {'\u038a', '\u0399'}, {'\u03aa', '\u0399'}, {'\u03ca', '\u03b9'}, {'\u03ab', '\u03a5'}, {'\u03cb', '\u03c5'}, {'\u038c', '\u039f'}, {'\u03ac', '\u03b1'}, {'\u03cc', '\u03bf'}, {'\u03ad', '\u03b5'}, {'\u03cd', '\u03c5'}, {'\u038e', '\u03a5'}, {'\u03ae', '\u03b7'}, {'\u03ce', '\u03c9'}, {'\u038f', '\u03a9'}, {'\u03af', '\u03b9'}};
    }
}

