/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import org.basex.util.Token;

public final class Version
implements Comparable<Version> {
    private final int major;
    private final int minor;
    private final int patch;

    public Version(String version) {
        this(Token.token(version));
    }

    public Version(byte[] version) {
        byte[][] versions = Token.split(version, 46);
        this.major = Token.toInt(versions[0]);
        this.minor = versions.length > 1 ? Token.toInt(versions[1]) : -1;
        this.patch = versions.length > 2 ? Token.toInt(versions[2]) : -1;
    }

    public boolean isCompatible(Version ver) {
        if (this.major != ver.major) {
            return false;
        }
        if (ver.minor == -1) {
            return true;
        }
        if (ver.patch == -1) {
            return this.minor == ver.minor;
        }
        return this.minor == ver.minor && this.patch == ver.patch;
    }

    @Override
    public int compareTo(Version ver) {
        return this.major == ver.major ? (this.minor == ver.minor ? this.patch - ver.patch : this.minor - ver.minor) : this.major - ver.major;
    }

    public boolean equals(Object o) {
        return o instanceof Version && this.compareTo((Version)o) == 0;
    }

    public int hashCode() {
        return this.major + (this.minor << 8) + (this.patch << 16);
    }

    public String toString() {
        return this.major + (this.minor == -1 ? "" : "." + this.minor + (this.patch == -1 ? "" : "." + this.patch));
    }
}

