/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.corpusstructure;

import java.io.File;
import nl.mpi.corpusstructure.AccessInfo;
import nl.mpi.util.OurURL;

public class ResAccessInfo
extends AccessInfo {
    private String mNodeID;
    private OurURL mObjUrl;

    protected ResAccessInfo(String nodeid, OurURL url, String readRights, String writeRights, int accessLevel) {
        if (this.isValidConstant(readRights)) {
            this.setReadRule(readRights);
        } else {
            try {
                this.setReadUsers(readRights);
            }
            catch (IllegalArgumentException ex) {
                if (ex.getMessage().equals("Readrights user list must not be empty")) {
                    this.setReadRule("nobody");
                }
                throw ex;
            }
        }
        if (this.isValidConstant(writeRights)) {
            this.setWriteRule(writeRights);
        } else {
            try {
                this.setWriteUsers(writeRights);
            }
            catch (IllegalArgumentException ex) {
                if (ex.getMessage().equals("Writerights user list must not be empty")) {
                    this.setWriteRule("nobody");
                }
                throw ex;
            }
        }
        this.setAccessLevel(accessLevel);
        this.setNodeID(nodeid);
        this.setObjUrl(url);
    }

    public String getNodeID() {
        return this.mNodeID;
    }

    private void setNodeID(String nodeID) {
        this.mNodeID = nodeID;
    }

    public OurURL getObjUrl() {
        return this.mObjUrl;
    }

    private void setObjUrl(OurURL objURL) {
        this.mObjUrl = objURL;
    }

    public File getDirectory() {
        File file = this.getFile();
        return file != null ? file.getParentFile() : null;
    }

    public File getFile() {
        String url;
        File result = null;
        String string = url = this.getObjUrl() != null ? this.getObjUrl().getFile() : null;
        if (url == null) {
            return result;
        }
        result = new File(url);
        return result;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer("resAccessInfo for ");
        result.append(this.getNodeID());
        result.append(" +Readers: ").append(this.getReadRights());
        result.append(" +Writers: ").append(this.getWriteRights());
        result.append(" +AccessLevel: ").append(this.getAccessLevel());
        return result.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        ResAccessInfo rai = (ResAccessInfo)obj;
        if (this.getNodeID() == null || !this.getNodeID().equals(rai.getNodeID())) {
            return false;
        }
        if (this.getObjUrl() == null && rai.getObjUrl() != null || this.getObjUrl() != null && !this.getObjUrl().equals((Object)rai.getObjUrl())) {
            return false;
        }
        if (this.getAccessLevel() != rai.getAccessLevel()) {
            return false;
        }
        if (this.getWriteRights() == null || !this.getWriteRights().equals(rai.getWriteRights())) {
            return false;
        }
        return this.getReadRights() != null && this.getReadRights().equals(rai.getReadRights());
    }

    @Override
    public int hashCode() {
        int hash = this.getNodeID() == null ? -1 : this.getNodeID().hashCode();
        hash ^= this.getObjUrl() == null ? -1 : this.getObjUrl().hashCode();
        return hash ^= super.hashCode();
    }
}

