/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.imdidb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import nl.mpi.corpusstructure.Node;
import nl.mpi.corpusstructure.NodeIdUtils;
import nl.mpi.corpusstructure.UnknownNodeException;
import nl.mpi.imdidb.DBImpl;
import nl.mpi.imdidb.IMDIDB;
import nl.mpi.imdidb.IMDIDBTable;
import nl.mpi.imdidb.IMDIQueryToSQL;
import nl.mpi.imdidb.IMDIRdbModel;
import nl.mpi.imdidb.MDDigester;
import nl.mpi.imdidb.MDTable;
import nl.mpi.util.DBConnection;
import nl.mpi.util.OurURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class IMDIDBImpl
extends DBImpl
implements IMDIDB {
    private static String adminTableName = "IMDIADMIN";
    private static final String IMDI_VERSION = "IMDI_VERSION";
    private static final String CREATION_DATE = "CREATION_DATE";
    private String imdiVersion = "3.0";
    private static Logger logger = LoggerFactory.getLogger((String)IMDIDB.class.getName());
    private static final Object staticSyncFlag = new Object();
    private static boolean bootstrapMode;
    static int id;

    public static void setLogger(Logger l) {
        DBImpl.setLogger(l);
        IMDIDBTable.setLogger(l);
        logger = l;
    }

    public IMDIDBImpl() {
        this("lams.Configuration.IMDIDBname", false, "lams.Configuration.IMDIDBuser", "lams.Configuration.IMDIDBpasswd");
    }

    public IMDIDBImpl(String dbname) {
        this(dbname, false, null, null);
    }

    public IMDIDBImpl(String dbname, boolean bootstrapMode) {
        this(dbname, bootstrapMode, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMDIDBImpl(String dbname, boolean bootstrapMode, String user, String passwd) {
        super(new DBConnection(dbname, user, passwd, "IMDIDBImpl:constr()"));
        Object object = staticSyncFlag;
        synchronized (object) {
            logger.debug("IMDIDBImpl: constr(): dbname=" + dbname + ", bootstrap=" + bootstrapMode);
            if (bootstrapMode && IMDIDBImpl.bootstrapMode) {
                logger.error("IMDIDBImpl: ERROR: attempt to use bootstrap mode more than once at a time");
                this.setStatus(false);
                return;
            }
            IMDIDBImpl.bootstrapMode = bootstrapMode;
            IMDIDBTable.setBootstrapMode(bootstrapMode);
            ++id;
            this.setStatus(this.db.getStatus());
            if (!this.getStatus()) {
                logger.error("IMDIDBImpl: ERROR creating DB for " + dbname);
                return;
            }
            this.initPreparedStatements();
            if (bootstrapMode) {
                this.dropTmpTables();
                IMDIDBTable.setTmpTableNames();
                adminTableName = "TMP" + adminTableName;
                this.init();
                this.insertAdminKey(IMDI_VERSION, this.imdiVersion);
                this.insertAdminKey(CREATION_DATE, new Date().toString());
            } else {
                this.imdiVersion = this.getAdminKey(IMDI_VERSION);
                if (this.imdiVersion == null) {
                    logger.error("IMDIDBImpl: constr(): error getting values from Admin table");
                }
            }
        }
    }

    @Override
    public void flush() {
        IMDIDBTable.flushAllTables(this.db);
    }

    public Vector getTableNames() {
        return IMDIDBTable.getTableNames(this.db, "IMDIMD_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dumpTable(String name, Writer w) throws IOException {
        logger.info("dumptable: " + name);
        if (!this.getStatus()) {
            logger.error("IMDIDBImpl:dumpTable(): No connection: status=false");
            return false;
        }
        Statement statement = null;
        ResultSet rs = null;
        String cmd = "SELECT * FROM " + name;
        try {
            int i;
            statement = this.db.getConnection().createStatement();
            rs = statement.executeQuery(cmd);
            ResultSetMetaData rsmd = rs.getMetaData();
            int numberOfColumns = rsmd.getColumnCount();
            w.write("#");
            for (i = 0; i < numberOfColumns; ++i) {
                w.write(rsmd.getColumnName(i + 1) + "\t");
            }
            w.write("\n");
            while (rs.next()) {
                for (i = 0; i < numberOfColumns - 1; ++i) {
                    this.writeColumn(rs.getString(i + 1), w);
                    w.write("\t");
                }
                this.writeColumn(rs.getString(numberOfColumns), w);
                w.write("\n");
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    logger.warn("Failed to close statement");
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warn("Failed to close resultset");
                }
            }
            statement = null;
            rs = null;
        }
        return true;
    }

    private void writeColumn(String s, Writer w) throws IOException {
        if (s != null) {
            w.write(s);
        } else {
            w.write("NULL");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void finishUpdate() {
        logger.debug("IMDIDBImpl: finishUpdate called");
        Object object = staticSyncFlag;
        synchronized (object) {
            if (!bootstrapMode) {
                IMDIDBTable.createAllIndexes(this.db);
            }
            if (bootstrapMode) {
                logger.debug("IMDIDBImpl: finishUpdate: dropping old DB objects, renaming tables, creating new indexes");
                this.reset();
                this.renameTmpAdminTable();
                IMDIDBTable.renameTmpTables(this.db);
                IMDIDBTable.unsetTmpTableNames();
                IMDIDBTable.createAllIndexes(this.db);
                bootstrapMode = false;
            }
            IMDIDBTable.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        logger.debug("IMDIDBImpl: shutdown called");
        Object object = staticSyncFlag;
        synchronized (object) {
            if (this.db.dbType == 2) {
                String cmd = "SHUTDOWN COMPACT";
                logger.debug("IMDIDBImpl:" + id + " shutdown()");
                Statement statement = null;
                try {
                    statement = this.db.getConnection().createStatement();
                    statement.execute(cmd);
                }
                catch (SQLException sqle) {
                    if (sqle.toString().indexOf("is shutdown") != -1) {
                        logger.debug("database already shutdown");
                    } else {
                        logger.error("IMDIDBImpl: shutdown(): SQLException: ", (Throwable)sqle);
                    }
                }
                finally {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException e) {
                            logger.warn("IMDIDBImpl: shutdown(): Failed to close statement");
                        }
                    }
                    statement = null;
                }
            }
        }
        this.close();
    }

    @Override
    public boolean addIMDINode(Node node, OurURL url, String treepath) {
        return this.processIMDINode(node, url, treepath);
    }

    @Override
    public boolean deleteIMDINode(String nodeId) {
        try {
            IMDIDBTable.deleteFromAllTables(this.db, nodeId);
        }
        catch (UnknownNodeException e) {
            logger.error("Cannot delete noe: " + e.getMessage());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getDBMatches(String[] queries, int limit, int offset, Set nodeIdsToFilter) {
        IMDIQueryToSQL iq = new IMDIQueryToSQL();
        if (!this.getStatus()) {
            logger.error("IMDIDBImpl:getIMDINodesByQuery(): No connection: status=false");
            return null;
        }
        String sql = iq.IMDIqueryToSQL(queries, limit, offset, nodeIdsToFilter);
        Statement stat = null;
        ResultSet rs = null;
        try {
            stat = this.db.getConnection().createStatement();
            rs = stat.executeQuery(sql);
            ArrayList<String[]> hs = new ArrayList<String[]>();
            while (rs.next()) {
                String[] tarr = new String[3];
                tarr[0] = NodeIdUtils.TONODEID(rs.getInt("NODEID"));
                try {
                    tarr[1] = rs.getString("TREEPATH");
                }
                catch (SQLException sqle) {
                    logger.debug("Failed to getString TREEPATH");
                }
                try {
                    tarr[2] = rs.getString("CODE");
                }
                catch (SQLException sqle) {
                    logger.debug("Failed to getString CODE");
                }
                hs.add(tarr);
            }
            ArrayList<String[]> arrayList = hs;
            return arrayList;
        }
        catch (SQLException sqle) {
            logger.error("IMDIDBImpl: getIMDINodesByQuery(): SQLException ", (Throwable)sqle);
        }
        finally {
            try {
                if (stat != null) {
                    stat.close();
                }
            }
            catch (SQLException e) {
                logger.warn("IMDIDBImpl: getIMDINodesByQuery(): Failed to close statement");
            }
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                logger.warn("IMDIDBImpl: getIMDINodesByQuery(): Failed to close resultset");
            }
            stat = null;
            rs = null;
        }
        return null;
    }

    @Override
    protected boolean createTables() {
        return this.createAdminTable();
    }

    protected void dropTmpTables() {
        logger.debug("IMDIDBImpl: dropTmpTables called");
        this.dropTable("TMP" + adminTableName);
        IMDIDBTable.deleteAllTmpTables(this.db);
    }

    @Override
    protected void dropOldTables() {
        logger.debug("IMDIDBImpl: dropOldTables called");
        String name = adminTableName;
        if (adminTableName.startsWith("TMP")) {
            name = name.substring(3);
        }
        this.dropTable(name);
        IMDIDBTable.deleteAllTables(this.db);
    }

    @Override
    protected boolean createIndexes() {
        return true;
    }

    @Override
    protected void dropOldIndexes() {
        logger.debug("IMDIDBImpl: dropOldIndexes called");
    }

    @Override
    protected boolean initPreparedStatements() {
        return true;
    }

    @Override
    protected void closePreparedStatements() {
    }

    protected void dropPreparedStatements() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertAdminKey(String name, String value) {
        Statement ps = null;
        try {
            ps = this.db.getConnection().prepareStatement("UPDATE " + adminTableName + " SET Value = ? WHERE Name = ?");
            ps.clearParameters();
            ps.setString(2, name);
            ps.setString(1, value);
            if (ps.executeUpdate() == 0) {
                ps.close();
                ps = this.db.getConnection().prepareStatement("INSERT INTO " + adminTableName + " (Name, Value) VALUES (?, ?)");
                ps.clearParameters();
                ps.setString(1, name);
                ps.setString(2, value);
                ps.executeUpdate();
            }
        }
        catch (SQLException sqle) {
            logger.error("IMDIDBImpl: insertAdminKey(): SQLException ", (Throwable)sqle);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                logger.warn("IMDIDBImpl: Failed to close prepared statement after use: " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAdminKey(String name) {
        Statement ps = null;
        String answer = null;
        ResultSet rs = null;
        try {
            Object o;
            ps = this.db.getConnection().prepareStatement("SELECT Value FROM " + adminTableName + " WHERE NAME = ?");
            ps.clearParameters();
            ps.setString(1, name);
            rs = ps.executeQuery();
            while (rs.next()) {
                answer = answer == null ? "" : answer + ";";
                o = rs.getObject(1);
                if (o != null) {
                    answer = answer + o.toString();
                    continue;
                }
                logger.error("getAdminKey: " + name + " error Object is null");
            }
            o = answer;
            return o;
        }
        catch (SQLException sqle) {
            logger.error("getAdminKey: SQLException: ", (Throwable)sqle);
            String string = null;
            return string;
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.warn("getAdminKey: Failed to close prepared statement");
                }
            }
            ps = null;
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warn("getAdminKey: Failed to close prepared resultset");
                }
            }
            rs = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameTmpAdminTable() {
        logger.debug("IMDIDBImpl: RenameTmpAdminTable");
        Statement stat = null;
        if (adminTableName.startsWith("TMP")) {
            try {
                stat = this.db.getConnection().createStatement();
                stat.execute("ALTER TABLE " + adminTableName + " RENAME TO " + adminTableName.substring(3));
                adminTableName = adminTableName.substring(3);
            }
            catch (SQLException sqle) {
                logger.error("IMDIDBImpl: renameTmpAdminTable(): SQLException", (Throwable)sqle);
            }
            finally {
                try {
                    if (stat != null) {
                        stat.close();
                    }
                }
                catch (SQLException e) {
                    logger.warn("IMDIDBImpl: renameTmpAdminTable(): Failed to close statement");
                }
                stat = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createAdminTable() {
        logger.debug("IMDIDBImpl: Creating Admin table");
        Statement stat = null;
        try {
            String varType = "VARCHAR";
            if (this.db.dbType == 2) {
                varType = "VARCHAR(1024)";
            }
            stat = this.db.getConnection().createStatement();
            stat.execute("CREATE " + this.db.tableType + " TABLE " + adminTableName + " (Name " + varType + ", Value " + varType + ")");
            stat.execute("INSERT INTO " + adminTableName + " ( NAME, VALUE) VALUES('UPDATEINPROGRESS','TRUE')");
            stat.execute("GRANT SELECT ON " + adminTableName + " TO PUBLIC");
        }
        catch (SQLException sqle) {
            logger.error("IMDIDBImpl: createAdminTable(): SQLException ", (Throwable)sqle);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (stat != null) {
                    stat.close();
                }
            }
            catch (SQLException e) {
                logger.warn("IMDIDBImpl: createAdminTable(): Failed to close statement");
            }
            stat = null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropTable(String name) {
        Statement stat = null;
        try {
            stat = this.db.getConnection().createStatement();
            String cmd = "DROP TABLE " + name;
            if (this.db.dbType == 1) {
                cmd = "DROP TABLE IF EXISTS " + name;
            }
            stat.executeUpdate(cmd);
            logger.debug("IMDIDBImpl:dropTable() Dropped table: " + name);
        }
        catch (SQLException e) {
            if (!name.startsWith("TMP")) {
                logger.error("IMDIDBImpl:dropTable() Error dropping table: " + name + ", " + e);
            }
        }
        finally {
            try {
                if (stat != null) {
                    stat.close();
                }
            }
            catch (SQLException slqe) {
                logger.warn("IMDIDBImpl: dropTable(): Failed to close statement");
            }
            stat = null;
        }
    }

    private boolean processIMDINode(Node node, OurURL url, String treePath) {
        boolean result = false;
        try {
            switch (node.getNodeType()) {
                case 1: {
                    MDTable sessionTable = MDDigester.processSessionNode(url);
                    sessionTable.addColumn("TREEPATH", treePath);
                    result = this.processTable(node, url, sessionTable);
                    break;
                }
                case 128: {
                    MDTable catalogTable = MDDigester.processCatalogueNode(url);
                    catalogTable.addColumn("TREEPATH", treePath);
                    result = this.processTable(node, url, catalogTable);
                    break;
                }
            }
        }
        catch (UnknownNodeException e) {
            logger.error("Error while attempting to find node= " + node + ", url=" + url, (Throwable)e);
        }
        catch (SAXException e) {
            logger.error("Error while parsing node= " + node + ", url=" + url, (Throwable)e);
        }
        catch (IOException e) {
            logger.error("IO error while processing node= " + node + ", url=" + url, (Throwable)e);
        }
        catch (SQLException e) {
            logger.error("Error while persisting node= " + node + ", url=" + url, (Throwable)e);
        }
        return result;
    }

    private boolean processTable(Node node, OurURL url, MDTable table) throws SQLException, UnknownNodeException {
        int id = NodeIdUtils.TOINT(node.getNodeId());
        LinkedList<Integer> foreignKeyIds = new LinkedList<Integer>();
        foreignKeyIds.add(id);
        this.storeMDTable(table, foreignKeyIds, url, table.getTableName());
        return true;
    }

    private void storeMDTable(MDTable table, LinkedList<Integer> foreignKeyIds, OurURL url, String mainTableName) throws SQLException {
        String tableName = table.getTableName();
        IMDIDBTable imdidbTable = IMDIDBTable.get(this.db, tableName, foreignKeyIds.size(), true, mainTableName);
        List<MDTable.MDColumn> columns = table.getColumns();
        for (MDTable.MDColumn column : columns) {
            imdidbTable.insert(column.getName(), this.adjustColumnValue(column, url), this.adjustColumnType(column.getType()), foreignKeyIds);
        }
        List<MDTable> tables = table.getTables();
        int tableInstanceCount = 0;
        HashSet<String> tableNames = new HashSet<String>();
        for (int i = 0; i < tables.size(); ++i) {
            MDTable subTable = tables.get(i);
            tableInstanceCount = tableNames.add(subTable.getTableName()) ? 0 : ++tableInstanceCount;
            foreignKeyIds.addLast(tableInstanceCount);
            this.storeMDTable(subTable, foreignKeyIds, url, mainTableName);
            foreignKeyIds.removeLast();
        }
    }

    private String adjustColumnType(String type) {
        if (this.db.dbType == 2 && "VARCHAR".equals(type)) {
            return "VARCHAR_IGNORECASE";
        }
        return type;
    }

    private String adjustColumnValue(MDTable.MDColumn column, OurURL url) {
        String result = null;
        String name = column.getName();
        String value = column.getValue();
        if (name.equals("Age")) {
            try {
                Float age = IMDIRdbModel.agePeriodToFloat(value);
                if (age != null) {
                    result = age.toString();
                }
            }
            catch (NumberFormatException e) {
                logger.warn("Illegal age format: " + value + " in file " + url);
                result = null;
            }
        } else if (name.endsWith("Date")) {
            try {
                Float date = IMDIRdbModel.datePeriodToFloat(value);
                if (date != null) {
                    result = date.toString();
                }
            }
            catch (NumberFormatException e) {
                logger.warn("Illegal date format: " + value + " in file " + url);
                result = null;
            }
        } else if (name.endsWith("Link")) {
            if (!(value.equals("") || value.startsWith("notyet:") || value.startsWith("file:") || value.startsWith("http:") || value.startsWith("ftp:"))) {
                try {
                    OurURL ourUrl = new OurURL(url, value);
                    result = ourUrl.toString();
                }
                catch (MalformedURLException mue) {
                    logger.error("ERROR IMDI2RDB making url from " + value + " in file " + url);
                    result = "";
                }
            }
        } else {
            result = value;
        }
        if ((column.getType().equals("INTEGER") || column.getType().equals("DECIMAL")) && result != null && (result.equalsIgnoreCase("Unknown") || result.equals("Unspecified"))) {
            result = null;
        }
        return result;
    }

    static {
        id = 0;
    }

    public static class MyEntityResolver
    implements EntityResolver {
        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            if (systemId.endsWith("IMDI_3.0.xsd")) {
                try {
                    InputSource inputSource = new InputSource(new FileInputStream(new File("IMDI_3.0.xsd")));
                    return inputSource;
                }
                catch (FileNotFoundException e) {
                    logger.debug("IMDI2RDB: put IMDI_3.0.xsd in current dir!!!");
                    return null;
                }
            }
            if (systemId.endsWith("IMDI.xsd")) {
                try {
                    InputSource inputSource = new InputSource(new FileInputStream(new File("IMDI.xsd")));
                    return inputSource;
                }
                catch (FileNotFoundException e) {
                    logger.debug("IMDI2RDB: put IMDI.xsd in current dir!!!");
                    return null;
                }
            }
            return null;
        }
    }
}

