/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.localisation;

import java.io.InputStream;
import java.util.Locale;

public class LocalisationUtils {
    private final Class referenceClass;

    public LocalisationUtils(Class referenceClass) {
        this.referenceClass = referenceClass;
    }

    public LocalisationUtils() {
        this(LocalisationUtils.class);
    }

    public InputStream getLocalizedResourceStream(String resourceLocation) {
        Locale locale = Locale.getDefault();
        int extensionLocation = resourceLocation.lastIndexOf(".");
        if (extensionLocation >= 0) {
            InputStream resourceStream = this.tryLocalizedResourceStream(resourceLocation, extensionLocation, locale.toString());
            if (resourceStream != null) {
                return resourceStream;
            }
            resourceStream = this.tryLocalizedResourceStream(resourceLocation, extensionLocation, locale.getLanguage());
            if (resourceStream != null) {
                return resourceStream;
            }
        }
        return this.referenceClass.getResourceAsStream(resourceLocation);
    }

    private InputStream tryLocalizedResourceStream(String resourceLocation, int extensionLocation, String localeString) {
        String localizedResourceLocation = String.format("%s_%s%s", resourceLocation.substring(0, extensionLocation), localeString, resourceLocation.substring(extensionLocation));
        return this.referenceClass.getResourceAsStream(localizedResourceLocation);
    }
}

