/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import nl.mpi.arbil.ArbilMetadataException;
import nl.mpi.arbil.clarin.HandleUtils;
import nl.mpi.arbil.data.ArbilComponentBuilder;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilDataNodeContainer;
import nl.mpi.arbil.data.ArbilField;
import nl.mpi.arbil.data.DataNodeLoader;
import nl.mpi.arbil.data.FieldUpdateRequest;
import nl.mpi.arbil.data.MetadataBuilder;
import nl.mpi.arbil.data.MetadataFormat;
import nl.mpi.arbil.data.metadatafile.MetadataReader;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.arbil.util.MimeHashQueue;
import nl.mpi.arbil.util.TreeHelper;
import nl.mpi.arbilcommons.journal.ArbilJournal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArbilDataNodeService {
    private static final Logger logger = LoggerFactory.getLogger(ArbilDataNodeService.class);
    private static final ResourceBundle widgets = ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets");
    private final DataNodeLoader dataNodeLoader;
    private final MessageDialogHandler messageDialogHandler;
    private final SessionStorage sessionStorage;
    private final MimeHashQueue mimeHashQueue;
    private final TreeHelper treeHelper;
    private final ArbilComponentBuilder componentBuilder = new ArbilComponentBuilder();
    private final MetadataReader metadataReader = MetadataReader.getSingleInstance();
    private final MetadataFormat metadataFormat = new MetadataFormat();

    public ArbilDataNodeService(DataNodeLoader dataNodeLoader, MessageDialogHandler messageDialogHandler, SessionStorage sessionStorage, MimeHashQueue mimeHashQueue, TreeHelper treeHelper) {
        this.messageDialogHandler = messageDialogHandler;
        this.sessionStorage = sessionStorage;
        this.mimeHashQueue = mimeHashQueue;
        this.treeHelper = treeHelper;
        this.dataNodeLoader = dataNodeLoader;
    }

    public boolean isEditable(ArbilDataNode dataNode) {
        if (dataNode.isLocal()) {
            return this.sessionStorage.pathIsInsideCache(dataNode.getFile()) || this.sessionStorage.pathIsInFavourites(dataNode.getFile());
        }
        return false;
    }

    public boolean isFavorite(ArbilDataNode dataNode) {
        if (!dataNode.isLocal()) {
            return false;
        }
        return this.sessionStorage.pathIsInFavourites(dataNode.getFile());
    }

    public void pasteIntoNode(ArbilDataNode dataNode) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transfer = clipboard.getContents(null);
        try {
            String clipBoardString = "";
            Object clipBoardData = transfer.getTransferData(DataFlavor.stringFlavor);
            if (clipBoardData != null) {
                clipBoardString = clipBoardData.toString();
                logger.debug("clipBoardString: {}", (Object)clipBoardString);
                String[] elements = clipBoardString.contains("\n") ? clipBoardString.split("\n") : new String[]{clipBoardString};
                for (String element : elements) {
                }
                for (ArbilDataNode clipboardNode : this.pasteIntoNode(dataNode, elements)) {
                    new MetadataBuilder().requestAddNode(dataNode, MessageFormat.format(widgets.getString("COPY OF {0}"), clipboardNode), clipboardNode);
                }
            }
        }
        catch (Exception ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
    }

    private Collection<ArbilDataNode> pasteIntoNode(ArbilDataNode dataNode, String[] clipBoardStrings) {
        try {
            ArrayList<ArbilDataNode> nodesToAdd = new ArrayList<ArbilDataNode>();
            boolean ignoreSaveChanges = false;
            for (String clipBoardString : clipBoardStrings) {
                if (dataNode.isCorpus()) {
                    if (MetadataFormat.isPathMetadata(clipBoardString) || MetadataFormat.isStringChildNode(clipBoardString)) {
                        ArbilDataNode clipboardNode = this.dataNodeLoader.getArbilDataNode(null, ArbilDataNodeService.conformStringToUrl(clipBoardString));
                        if (this.sessionStorage.pathIsInsideCache(clipboardNode.getFile())) {
                            if (!MetadataFormat.isStringChildNode(clipBoardString) || dataNode.isSession() || dataNode.isChildNode()) {
                                if (dataNode.getFile().exists()) {
                                    if (!ignoreSaveChanges && clipboardNode.getNeedsSaveToDisk(false)) {
                                        if (2 == this.messageDialogHandler.showDialogBox(widgets.getString("SOME OF THE NODES TO BE COPIED CONTAIN UNSAVED CHANGES"), widgets.getString("COPYING WITH UNSAVED CHANGES"), 2, -1)) {
                                            return new ArrayList<ArbilDataNode>(0);
                                        }
                                        ignoreSaveChanges = true;
                                    }
                                    nodesToAdd.add(clipboardNode);
                                    continue;
                                }
                                this.messageDialogHandler.addMessageDialogToQueue(widgets.getString("THE TARGET NODE'S FILE DOES NOT EXIST"), null);
                                continue;
                            }
                            this.messageDialogHandler.addMessageDialogToQueue(widgets.getString("CANNOT PASTE SESSION SUBNODES INTO A CORPUS"), null);
                            continue;
                        }
                        this.messageDialogHandler.addMessageDialogToQueue(widgets.getString("THE TARGET FILE IS NOT IN THE CACHE"), null);
                        continue;
                    }
                    this.messageDialogHandler.addMessageDialogToQueue(widgets.getString("PASTED STRING IS NOT AND IMDI FILE"), null);
                    continue;
                }
                if (dataNode.isMetaDataNode() || dataNode.isSession()) {
                    ArbilDataNode templateDataNode = this.dataNodeLoader.getArbilDataNode(null, ArbilDataNodeService.conformStringToUrl(clipBoardString));
                    if (this.metadataReader.nodeCanExistInNode(dataNode, templateDataNode)) {
                        new MetadataBuilder().requestAddNode(dataNode, templateDataNode.toString(), templateDataNode);
                        continue;
                    }
                    this.messageDialogHandler.addMessageDialogToQueue(MessageFormat.format(widgets.getString("CANNOT COPY {0} TO {1}"), templateDataNode.toString(), dataNode.toString()), "Cannot copy");
                    continue;
                }
                this.messageDialogHandler.addMessageDialogToQueue(widgets.getString("NODES OF THIS TYPE CANNOT BE PASTED INTO AT THIS STAGE"), null);
            }
            return nodesToAdd;
        }
        catch (URISyntaxException ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addCorpusLink(ArbilDataNode dataNode, ArbilDataNode targetNode) {
        boolean linkAlreadyExists = false;
        if (targetNode.isCatalogue() && dataNode.hasCatalogue()) {
            return false;
        }
        for (String[] currentLinkPair : dataNode.getChildLinks()) {
            String currentChildPath = currentLinkPair[0];
            if (!targetNode.waitTillLoaded()) {
                this.messageDialogHandler.addMessageDialogToQueue(widgets.getString("ERROR ADDING NODE, COULD NOT WAIT FOR FILE TO LOAD"), widgets.getString("LOADING ERROR"));
                return false;
            }
            if (!currentChildPath.equals(targetNode.getUrlString())) continue;
            linkAlreadyExists = true;
        }
        if (targetNode.getUrlString().equals(dataNode.getUrlString())) {
            this.messageDialogHandler.addMessageDialogToQueue(widgets.getString("CANNOT LINK OR MOVE A NODE INTO ITSELF"), null);
            return false;
        }
        if (linkAlreadyExists) {
            this.messageDialogHandler.addMessageDialogToQueue(MessageFormat.format(widgets.getString("{0} ALREADY EXISTS IN {1} AND WILL NOT BE ADDED AGAIN"), targetNode, dataNode), null);
            return false;
        }
        if (dataNode.isNeedsSaveToDisk()) {
            dataNode.saveChangesToCache(true);
        }
        try {
            this.bumpHistory(dataNode.getFile());
            this.copyLastHistoryToCurrent(dataNode);
            Object i$ = dataNode.getParentDomLockObject();
            synchronized (i$) {
                return dataNode.getMetadataUtils().addCorpusLink(dataNode.getURI(), new URI[]{targetNode.getURI()});
            }
        }
        catch (IOException ex) {
            BugCatcherManager.getBugCatcher().logError("I/O exception while moving node " + targetNode.toString() + " to " + dataNode.toString(), ex);
            this.messageDialogHandler.addMessageDialogToQueue(widgets.getString("COULD NOT MOVE NODES BECAUSE AN ERROR OCCURRED WHILE SAVING HISTORY FOR NODE. SEE ERROR LOG FOR DETAILS."), widgets.getString("ERROR WHILE MOVING NODES"));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCorpusLink(ArbilDataNode dataNode, ArbilDataNode[] targetImdiNodes) {
        if (dataNode.nodeNeedsSaveToDisk) {
            dataNode.saveChangesToCache(false);
        }
        try {
            dataNode.bumpHistory();
            this.copyLastHistoryToCurrent(dataNode);
            Object object = dataNode.getParentDomLockObject();
            synchronized (object) {
                logger.debug("deleting by corpus link");
                URI[] copusUriList = new URI[targetImdiNodes.length];
                for (int nodeCounter = 0; nodeCounter < targetImdiNodes.length; ++nodeCounter) {
                    copusUriList[nodeCounter] = targetImdiNodes[nodeCounter].getURI();
                }
                dataNode.getMetadataUtils().removeCorpusLink(dataNode.getURI(), copusUriList);
                dataNode.getParentDomNode().loadArbilDom();
            }
            for (ArbilDataNode removedChild : targetImdiNodes) {
                removedChild.removeFromAllContainers();
            }
        }
        catch (IOException ex) {
            BugCatcherManager.getBugCatcher().logError("I/O exception while deleting nodes from " + dataNode.toString(), ex);
            this.messageDialogHandler.addMessageDialogToQueue(widgets.getString("COULD NOT DELETE NODES BECAUSE AN ERROR OCCURRED WHILE SAVING HISTORY FOR NODE. SEE ERROR LOG FOR DETAILS."), widgets.getString("ERROR WHILE MOVING NODES"));
        }
        dataNode.getParentDomNode().clearIcon();
        dataNode.getParentDomNode().clearChildIcons();
        dataNode.clearIcon();
    }

    public void insertResourceLocation(ArbilDataNode dataNode, URI location) throws ArbilMetadataException {
        if (dataNode.isCmdiMetaDataNode()) {
            ArbilDataNode resourceNode = null;
            try {
                resourceNode = this.dataNodeLoader.getArbilDataNodeWithoutLoading(location);
            }
            catch (Exception ex) {
                throw new ArbilMetadataException("Error creating resource node for URI: " + location.toString(), ex);
            }
            if (resourceNode == null) {
                throw new ArbilMetadataException(MessageFormat.format(widgets.getString("UNKNOWN ERROR CREATING RESOURCE NODE FOR URI: {0}"), location.toString()));
            }
            new MetadataBuilder().requestAddNode(dataNode, null, resourceNode);
        } else if (dataNode.hasResource()) {
            dataNode.resourceUrlField.setFieldValue(location.toString(), true, false);
        }
    }

    public void addField(ArbilDataNode dataNode, ArbilField fieldToAdd) {
        ArbilField[] currentFieldsArray = dataNode.getFieldArray(fieldToAdd.getTranslateFieldName());
        if (currentFieldsArray == null) {
            currentFieldsArray = new ArbilField[]{fieldToAdd};
        } else {
            ArbilField[] appendedFieldsArray = new ArbilField[currentFieldsArray.length + 1];
            System.arraycopy(currentFieldsArray, 0, appendedFieldsArray, 0, currentFieldsArray.length);
            appendedFieldsArray[appendedFieldsArray.length - 1] = fieldToAdd;
            currentFieldsArray = appendedFieldsArray;
        }
        dataNode.addFieldArray(fieldToAdd.getTranslateFieldName(), currentFieldsArray);
        if (fieldToAdd.xmlPath.endsWith(".ResourceLink") && fieldToAdd.getParentDataNode().isChildNode()) {
            dataNode.resourceUrlField = fieldToAdd;
            this.mimeHashQueue.addToQueue(dataNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveChangesToCache(ArbilDataNode datanode) {
        if (datanode != datanode.getParentDomNode()) {
            this.saveChangesToCache(datanode.getParentDomNode());
            return;
        }
        logger.debug("saveChangesToCache {}", (Object)datanode);
        Object object = datanode.getParentDomLockObject();
        synchronized (object) {
            ArbilJournal.getSingleInstance().clearFieldChangeHistory();
            if (!datanode.isLocal()) {
                logger.debug("should not try to save remote files");
                return;
            }
            List<FieldUpdateRequest> fieldUpdateRequests = this.createFieldUpdateRequests(datanode);
            if (this.componentBuilder.setFieldValues(datanode, fieldUpdateRequests)) {
                datanode.nodeNeedsSaveToDisk = false;
            } else {
                this.messageDialogHandler.addMessageDialogToQueue(widgets.getString("ERROR SAVING CHANGES TO DISK, CHECK THE LOG FILE VIA THE HELP MENU FOR MORE INFORMATION."), widgets.getString("SAVE"));
            }
        }
    }

    private List<FieldUpdateRequest> createFieldUpdateRequests(ArbilDataNode datanode) {
        ArrayList<FieldUpdateRequest> fieldUpdateRequests = new ArrayList<FieldUpdateRequest>();
        ArrayList<ArbilField[]> allFields = new ArrayList<ArbilField[]>();
        this.getAllFields(datanode, allFields);
        for (ArbilField[] currentFieldArray : allFields) {
            for (int fieldCounter = 0; fieldCounter < currentFieldArray.length; ++fieldCounter) {
                ArbilField currentField = currentFieldArray[fieldCounter];
                if (!currentField.fieldNeedsSaveToDisk()) continue;
                FieldUpdateRequest currentFieldUpdateRequest = new FieldUpdateRequest();
                currentFieldUpdateRequest.keyNameValue = currentField.getKeyName();
                currentFieldUpdateRequest.fieldOldValue = currentField.originalFieldValue;
                currentFieldUpdateRequest.fieldNewValue = currentField.getFieldValueForXml();
                currentFieldUpdateRequest.fieldPath = currentField.getFullXmlPath();
                currentFieldUpdateRequest.fieldLanguageId = currentField.getLanguageId();
                currentFieldUpdateRequest.attributeValuesMap = currentField.getAttributeValuesMap();
                fieldUpdateRequests.add(currentFieldUpdateRequest);
            }
        }
        return fieldUpdateRequests;
    }

    protected void getAllFields(ArbilDataNode dataNode, List<ArbilField[]> allFields) {
        logger.debug("getAllFields: {}", (Object)this);
        allFields.addAll(dataNode.getFields().values());
        for (ArbilDataNode currentChild : dataNode.getChildArray()) {
            if (!currentChild.isChildNode()) continue;
            this.getAllFields(currentChild, allFields);
        }
    }

    public void setDataNodeNeedsSaveToDisk(ArbilDataNode dataNode, ArbilField originatingField, boolean updateUI) {
        boolean needsSaveToDisk;
        if (dataNode.resourceUrlField != null && dataNode.resourceUrlField.equals(originatingField)) {
            dataNode.hashString = null;
            dataNode.mpiMimeType = null;
            dataNode.thumbnailFile = null;
            dataNode.typeCheckerMessage = null;
            this.mimeHashQueue.addToQueue(dataNode);
        }
        boolean bl = needsSaveToDisk = dataNode.hasChangedFields() || dataNode.hasDomIdAttribute;
        if (dataNode.isMetaDataNode() && !dataNode.isChildNode()) {
            if (!needsSaveToDisk) {
                for (ArbilDataNode childNode : dataNode.getAllChildren()) {
                    if (!childNode.nodeNeedsSaveToDisk) continue;
                    needsSaveToDisk = true;
                }
            }
            if (dataNode.nodeNeedsSaveToDisk != needsSaveToDisk) {
                if (needsSaveToDisk) {
                    this.dataNodeLoader.addNodeNeedingSave(dataNode);
                } else {
                    this.dataNodeLoader.removeNodesNeedingSave(dataNode);
                }
                dataNode.nodeNeedsSaveToDisk = needsSaveToDisk;
            }
        } else {
            dataNode.nodeNeedsSaveToDisk = needsSaveToDisk;
            this.setDataNodeNeedsSaveToDisk(dataNode.getParentDomNode(), null, updateUI);
        }
        if (updateUI) {
            dataNode.clearIcon();
        }
    }

    public void bumpHistory(File dataNodeFile) throws IOException {
        int versionCounter = 0;
        File headVersion = dataNodeFile;
        if (new File(dataNodeFile.getAbsolutePath() + ".x").exists()) {
            ++versionCounter;
            headVersion = new File(dataNodeFile.getAbsolutePath() + ".x");
        }
        while (new File(dataNodeFile.getAbsolutePath() + "." + versionCounter).exists()) {
            ++versionCounter;
        }
        while (versionCounter >= 0) {
            File lastFile = new File(dataNodeFile.getAbsolutePath() + "." + versionCounter);
            File nextFile = new File(dataNodeFile.getAbsolutePath() + "." + --versionCounter);
            if (versionCounter >= 0) {
                logger.debug("renaming: {}: {}", (Object)nextFile, (Object)lastFile);
                if (nextFile.renameTo(lastFile)) continue;
                throw new IOException("Error while copying history files for metadata. Could not rename " + nextFile.toString() + " to " + lastFile.toString());
            }
            logger.debug("renaming: {}: {}", (Object)headVersion, (Object)lastFile);
            if (headVersion.renameTo(lastFile)) continue;
            throw new IOException("Error while copying history files for metadata. Could not rename " + headVersion.toString() + " to " + lastFile.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resurrectHistory(ArbilDataNode dataNode, String historyVersion) {
        block42: {
            InputStream historyFile = null;
            OutputStream activeVersionFile = null;
            try {
                int len;
                if (historyVersion.equals(".x")) {
                    if (dataNode.getFile().delete()) {
                        if (!new File(dataNode.getFile().getAbsolutePath() + ".x").renameTo(dataNode.getFile())) {
                            throw new IOException("Could not rename history file '" + dataNode.getFile().getAbsolutePath() + ".x'");
                        }
                        break block42;
                    }
                    throw new IOException("Could not delete old history file: " + dataNode.getFile().getAbsolutePath());
                }
                try {
                    this.messageDialogHandler.offerUserToSaveChanges();
                }
                catch (Exception e) {
                    boolean bl = false;
                    if (null != historyFile) {
                        try {
                            historyFile.close();
                        }
                        catch (IOException ex) {
                            BugCatcherManager.getBugCatcher().logError(ex);
                        }
                    }
                    if (null != activeVersionFile) {
                        try {
                            activeVersionFile.close();
                        }
                        catch (IOException ex) {
                            BugCatcherManager.getBugCatcher().logError(ex);
                        }
                    }
                    return bl;
                }
                if (!new File(dataNode.getFile().getAbsolutePath() + ".x").exists()) {
                    if (!dataNode.getFile().renameTo(new File(dataNode.getFile().getAbsolutePath() + ".x"))) {
                        throw new IOException("Could not rename to history file: " + dataNode.getFile().getAbsolutePath());
                    }
                } else if (!dataNode.getFile().delete()) {
                    throw new IOException("Could not delete history file: " + dataNode.getFile().getAbsolutePath());
                }
                historyFile = new FileInputStream(new File(dataNode.getFile().getAbsolutePath() + historyVersion));
                activeVersionFile = new FileOutputStream(dataNode.getFile(), true);
                byte[] copyBuffer = new byte[1024];
                while ((len = historyFile.read(copyBuffer)) > 0) {
                    activeVersionFile.write(copyBuffer, 0, len);
                }
            }
            catch (FileNotFoundException e) {
                this.messageDialogHandler.addMessageDialogToQueue(MessageFormat.format(widgets.getString("{0}. HISTORY MAY BE BROKEN FOR {1}"), e.getLocalizedMessage(), dataNode.toString()), "File not found");
                BugCatcherManager.getBugCatcher().logError(e);
                boolean bl = false;
                return bl;
            }
            catch (IOException e) {
                this.messageDialogHandler.addMessageDialogToQueue(MessageFormat.format(widgets.getString("{0}. HISTORY MAY BE BROKEN FOR {1}"), e.getLocalizedMessage(), dataNode.toString()), "Error while reading or writing to disk");
                BugCatcherManager.getBugCatcher().logError(e);
                boolean bl = false;
                return bl;
            }
            finally {
                if (null != historyFile) {
                    try {
                        historyFile.close();
                    }
                    catch (IOException ex) {
                        BugCatcherManager.getBugCatcher().logError(ex);
                    }
                }
                if (null != activeVersionFile) {
                    try {
                        activeVersionFile.close();
                    }
                    catch (IOException ex) {
                        BugCatcherManager.getBugCatcher().logError(ex);
                    }
                }
            }
        }
        this.dataNodeLoader.requestReload(dataNode.getParentDomNode());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyLastHistoryToCurrent(ArbilDataNode dataNode) {
        FileOutputStream outFile = null;
        InputStream inputStream = null;
        try {
            outFile = new FileOutputStream(dataNode.getFile());
            inputStream = new FileInputStream(new File(dataNode.getFile().getAbsolutePath() + ".0"));
            int bufferLength = 4096;
            byte[] buffer = new byte[bufferLength];
            int bytesread = 0;
            while (bytesread >= 0) {
                bytesread = inputStream.read(buffer);
                if (bytesread == -1) {
                    break;
                }
                outFile.write(buffer, 0, bytesread);
            }
        }
        catch (IOException iOException) {
            this.messageDialogHandler.addMessageDialogToQueue(widgets.getString("COULD NOT COPY FILE WHEN RECOVERING FROM THE LAST HISTORY FILE."), widgets.getString("RECOVER HISTORY"));
            BugCatcherManager.getBugCatcher().logError(iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
            if (outFile != null) {
                try {
                    outFile.close();
                }
                catch (IOException ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        }
    }

    public ArbilDataNode loadArbilDataNode(Object registeringObject, URI localUri) {
        return this.dataNodeLoader.getArbilDataNode(registeringObject, localUri);
    }

    public void reloadNodeShallowly(ArbilDataNode dataNode) {
        dataNode.getParentDomNode().nodeNeedsSaveToDisk = false;
        this.dataNodeLoader.requestShallowReload(dataNode.getParentDomNode());
    }

    public void reloadNode(ArbilDataNode dataNode) {
        dataNode.getParentDomNode().nodeNeedsSaveToDisk = false;
        this.dataNodeLoader.requestReload(dataNode.getParentDomNode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadArbilDom(ArbilDataNode dataNode) {
        if (dataNode.getParentDomNode() != dataNode) {
            dataNode.getParentDomNode().loadArbilDom();
        } else {
            if (dataNode.getFormatType() == MetadataFormat.FileType.UNKNOWN) {
                dataNode.setFormatType(this.metadataFormat.deepCheck(dataNode.getURI()));
            }
            Object object = dataNode.getParentDomLockObject();
            synchronized (object) {
                dataNode.initNodeVariables();
                if (!dataNode.isMetaDataNode() && !dataNode.isDirectory() && dataNode.isLocal()) {
                    this.mimeHashQueue.addToQueue(dataNode);
                    dataNode.setLoadingState(ArbilDataNode.LoadingState.LOADED);
                }
                if (dataNode.isDirectory()) {
                    this.getDirectoryLinks(dataNode);
                    dataNode.setLoadingState(ArbilDataNode.LoadingState.LOADED);
                }
                if (dataNode.isMetaDataNode()) {
                    this.loadMetadataDom(dataNode);
                    ArbilDataNode.LoadingState requestedLoadingState = dataNode.getRequestedLoadingState();
                    if (requestedLoadingState == null) {
                        requestedLoadingState = ArbilDataNode.LoadingState.LOADED;
                    }
                    dataNode.setLoadingState(requestedLoadingState);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFullArbilDom(ArbilDataNode dataNode) {
        dataNode.setLoadingState(ArbilDataNode.LoadingState.UNLOADED);
        dataNode.setRequestedLoadingState(ArbilDataNode.LoadingState.LOADED);
        dataNode.updateLoadingState(1);
        try {
            dataNode.loadArbilDom();
        }
        finally {
            dataNode.updateLoadingState(-1);
        }
    }

    public ArbilDataNode getParentOfNode(ArbilDataNode node) {
        return this.searchParentOf(node.getParentDomNode(), node);
    }

    private ArbilDataNode searchParentOf(ArbilDataNode ancestor, ArbilDataNode targetChild) {
        if (!ancestor.equals(targetChild)) {
            for (ArbilDataNode child : ancestor.getChildArray()) {
                if (child.equals(targetChild)) {
                    return ancestor;
                }
                ArbilDataNode childResult = this.searchParentOf(child, targetChild);
                if (childResult == null) continue;
                return childResult;
            }
        }
        return null;
    }

    public String urlEncodePath(String inputPath) {
        String encodedString = null;
        try {
            for (String inputStringPart : inputPath.split("/")) {
                encodedString = encodedString == null ? URLEncoder.encode(inputStringPart, "UTF-8") : encodedString + "/" + URLEncoder.encode(inputStringPart, "UTF-8");
            }
        }
        catch (Exception ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
        return encodedString;
    }

    public static URI conformStringToUrl(String inputUrlString) throws URISyntaxException {
        if (!(inputUrlString.toLowerCase().startsWith("hdl:") || inputUrlString.toLowerCase().startsWith("http") || inputUrlString.toLowerCase().startsWith("file:") || inputUrlString.toLowerCase().startsWith("."))) {
            return new File(inputUrlString).toURI();
        }
        int protocolEndIndex = inputUrlString.startsWith(".") ? 0 : inputUrlString.indexOf(":");
        String protocolComponent = inputUrlString.substring(0, protocolEndIndex);
        String remainingComponents = inputUrlString.substring(protocolEndIndex + 1);
        String[] pathComponentArray = remainingComponents.split("#");
        String pathComponent = pathComponentArray[0];
        String fragmentComponent = null;
        if (pathComponentArray.length > 1) {
            fragmentComponent = pathComponentArray[1];
        }
        return new URI(protocolComponent, pathComponent, fragmentComponent);
    }

    public static URI normaliseURI(URI inputURI) {
        boolean isUncPath = inputURI.toString().toLowerCase().startsWith("file:////");
        URI returnURI = inputURI.normalize();
        if (isUncPath) {
            try {
                returnURI = new URI("file:////" + returnURI.toString().substring("file:/".length()));
            }
            catch (URISyntaxException urise) {
                System.err.println(urise.toString());
            }
        }
        return returnURI;
    }

    private void loadMetadataDom(ArbilDataNode dataNode) {
        if (dataNode.isLocal() && !dataNode.getFile().exists() && new File(dataNode.getFile().getAbsolutePath() + ".0").exists()) {
            this.copyLastHistoryToCurrent(dataNode);
            this.messageDialogHandler.addMessageDialogToQueue(widgets.getString("MISSING FILE HAS BEEN RECOVERED FROM THE LAST HISTORY ITEM."), widgets.getString("RECOVER HISTORY"));
        }
        try {
            dataNode.nodeText = "unknown";
            this.initComponentLinkReader(dataNode);
            this.updateMetadataChildNodes(dataNode);
        }
        catch (Exception mue) {
            BugCatcherManager.getBugCatcher().logError(dataNode.getUrlString(), mue);
            File nodeFile = dataNode.getFile();
            if (nodeFile != null && nodeFile.exists()) {
                dataNode.nodeText = widgets.getString("COULD NOT LOAD DATA");
            }
            dataNode.nodeText = widgets.getString("FILE NOT FOUND");
            dataNode.fileNotFound = true;
        }
    }

    private void initComponentLinkReader(ArbilDataNode dataNode) {
        if (dataNode.isCmdiMetaDataNode()) {
            URI matadataUri = new HandleUtils().resolveHandle(dataNode.getURI());
            dataNode.getCmdiComponentLinkReader().readLinks(matadataUri);
        }
    }

    private void updateMetadataChildNodes(ArbilDataNode dataNode) throws ParserConfigurationException, SAXException, IOException, TransformerException, ArbilMetadataException {
        URI matadataUri = new HandleUtils().resolveHandle(dataNode.getURI());
        Document nodDom = ArbilComponentBuilder.getDocument(matadataUri);
        HashMap<ArbilDataNode, Set<ArbilDataNode>> parentChildTree = new HashMap<ArbilDataNode, Set<ArbilDataNode>>();
        dataNode.childLinks = this.loadMetadataChildNodes(dataNode, nodDom, parentChildTree);
        this.checkRemovedChildNodes(parentChildTree);
    }

    private List<String[]> loadMetadataChildNodes(ArbilDataNode dataNode, Document nodDom, Map<ArbilDataNode, Set<ArbilDataNode>> parentChildTree) throws TransformerException, ArbilMetadataException {
        ArrayList<String[]> childLinks = new ArrayList<String[]>();
        HashMap<String, Integer> siblingNodePathCounter = new HashMap<String, Integer>();
        String fullNodePath = "";
        Node startNode = nodDom.getFirstChild();
        boolean shallowLoading = ArbilDataNode.LoadingState.PARTIAL.equals((Object)dataNode.getRequestedLoadingState());
        this.metadataReader.iterateChildNodes(dataNode, childLinks, startNode, "", "", parentChildTree, siblingNodePathCounter, 0, shallowLoading);
        if (dataNode.isCmdiMetaDataNode()) {
            this.metadataReader.addUnreferencedResources(dataNode, parentChildTree, childLinks);
        }
        return childLinks;
    }

    private void checkRemovedChildNodes(Map<ArbilDataNode, Set<ArbilDataNode>> parentChildTree) {
        for (Map.Entry<ArbilDataNode, Set<ArbilDataNode>> entry : parentChildTree.entrySet()) {
            ArbilDataNode currentNode = entry.getKey();
            ArbilDataNode[] oldChildArray = currentNode.childArray;
            Set<ArbilDataNode> newChildren = entry.getValue();
            currentNode.childArray = newChildren.toArray(new ArbilDataNode[newChildren.size()]);
            List<ArbilDataNode> currentChildList = Arrays.asList(currentNode.childArray);
            for (ArbilDataNode currentOldChild : oldChildArray) {
                if (currentChildList.contains(currentOldChild)) continue;
                for (ArbilDataNodeContainer currentContainer : currentOldChild.getRegisteredContainers()) {
                    currentContainer.dataNodeRemoved(currentOldChild);
                }
            }
        }
    }

    private void getDirectoryLinks(ArbilDataNode dataNode) {
        File nodeFile = dataNode.getFile();
        if (nodeFile != null && nodeFile.isDirectory()) {
            File[] dirLinkArray = nodeFile.listFiles();
            ArrayList<ArbilDataNode> childLinksTemp = new ArrayList<ArbilDataNode>();
            for (int linkCount = 0; linkCount < dirLinkArray.length; ++linkCount) {
                try {
                    URI childURI = dirLinkArray[linkCount].toURI();
                    ArbilDataNode currentNode = this.dataNodeLoader.getArbilDataNodeWithoutLoading(childURI);
                    if (!this.treeHelper.isShowHiddenFilesInTree() && currentNode.getFile().isHidden()) continue;
                    childLinksTemp.add(currentNode);
                    continue;
                }
                catch (Exception ex) {
                    this.messageDialogHandler.addMessageDialogToQueue(dirLinkArray[linkCount] + " could not be loaded in\n" + dataNode.getUrlString(), "Load Directory");
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
            dataNode.childArray = childLinksTemp.toArray(new ArbilDataNode[childLinksTemp.size()]);
        }
    }
}

