/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.userstorage;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import nl.mpi.arbil.clarin.profiles.CmdiProfileReader;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.importexport.ShibbolethNegotiator;
import nl.mpi.arbil.userstorage.CommonsSessionStorage;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.DownloadAbortFlag;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.arbil.util.ProgressListener;
import nl.mpi.arbil.util.TreeHelper;
import nl.mpi.arbil.util.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArbilSessionStorage
extends CommonsSessionStorage
implements SessionStorage {
    private static final Logger logger = LoggerFactory.getLogger(ArbilSessionStorage.class);
    private static final String TYPECHECKER_CONFIG_FILENAME = "filetypes.txt";
    public static final String UTF8_ENCODING = "UTF8";
    public static final String CONFIG_FILE = "arbil.config";
    private final ResourceBundle services = ResourceBundle.getBundle("nl/mpi/arbil/localisation/Services");
    private WindowManager windowManager;
    private TreeHelper treeHelper;
    private Boolean propertiesReaderWriterAvailable = null;

    public void setMessageDialogHandler(MessageDialogHandler handler) {
        this.messageDialogHandler = handler;
    }

    public void setWindowManager(WindowManager windowManagerInstance) {
        this.windowManager = windowManagerInstance;
    }

    public void setTreeHelper(TreeHelper treeHelperInstance) {
        this.treeHelper = treeHelperInstance;
    }

    protected void logError(Exception exception) {
        BugCatcherManager.getBugCatcher().logError(exception);
    }

    protected void logError(String message, Exception exception) {
        BugCatcherManager.getBugCatcher().logError(message, exception);
    }

    protected String[] getAppDirectoryAlternatives() {
        return new String[]{".arbil", ".linorg"};
    }

    public ArbilSessionStorage() {
        HttpURLConnection.setFollowRedirects(false);
    }

    public void changeCacheDirectory(File preferedCacheDirectory, boolean moveFiles) {
        File fromDirectory = this.getProjectWorkingDirectory();
        if (!(preferedCacheDirectory.getAbsolutePath().contains(this.getProjectDirectoryName()) || preferedCacheDirectory.getAbsolutePath().contains(".arbil/imdicache") || this.localCacheDirectory.getAbsolutePath().contains(".linorg/imdicache"))) {
            preferedCacheDirectory = new File(preferedCacheDirectory, this.getProjectDirectoryName());
        }
        if (!moveFiles || 0 == this.messageDialogHandler.showDialogBox(MessageFormat.format(this.services.getString("CHANGING YOUR CURRENT PROJECT FROM {0} TO {1}"), fromDirectory.getParent(), preferedCacheDirectory.getParent()) + "\n" + this.services.getString("ARBIL WILL NEED TO CLOSE ALL TABLES ONCE THE FILES ARE MOVED"), "Arbil", 2, -1)) {
            this.saveString("cacheDirectory", preferedCacheDirectory.getAbsolutePath());
        }
    }

    private void changeStorageDirectory(File fromDirectory, File toDirectory) {
        String toDirectoryUriString = toDirectory.toURI().toString().replaceAll("/$", "");
        String fromDirectoryUriString = fromDirectory.toURI().toString().replaceAll("/$", "");
        logger.debug("toDirectoryUriString: {}", (Object)toDirectoryUriString);
        logger.debug("fromDirectoryUriString: {}", (Object)fromDirectoryUriString);
        try {
            toDirectoryUriString = URLDecoder.decode(toDirectoryUriString, "UTF-8");
            fromDirectoryUriString = URLDecoder.decode(fromDirectoryUriString, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
        boolean success = fromDirectory.renameTo(toDirectory);
        if (!success) {
            if (0 == this.messageDialogHandler.showDialogBox(this.services.getString("THE FILES IN YOUR 'LOCAL CORPUS' COULD NOT BE MOVED TO THE REQUESTED LOCATION"), "Arbil", 2, -1)) {
                this.saveString("cacheDirectory", toDirectory.getAbsolutePath());
                this.localCacheDirectory = null;
                this.getProjectWorkingDirectory();
                this.treeHelper.loadLocationsList();
                this.treeHelper.applyRootLocations();
            }
        } else {
            try {
                Vector<String> locationsList = new Vector<String>();
                ArbilDataNode[][] arr$ = new ArbilDataNode[][]{this.treeHelper.getRemoteCorpusNodes(), this.treeHelper.getLocalCorpusNodes(), this.treeHelper.getLocalFileNodes(), this.treeHelper.getFavouriteNodes()};
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    ArbilDataNode[] currentTreeArray;
                    for (ArbilDataNode currentLocation : currentTreeArray = arr$[i$]) {
                        String currentLocationString = URLDecoder.decode(currentLocation.getUrlString(), "UTF-8");
                        logger.debug("currentLocationString: {}", (Object)currentLocationString);
                        logger.debug("prefferedDirectoryUriString: {}", (Object)toDirectoryUriString);
                        logger.debug("storageDirectoryUriString: {}", (Object)fromDirectoryUriString);
                        locationsList.add(currentLocationString.replace(fromDirectoryUriString, toDirectoryUriString));
                    }
                }
                this.saveStringArray("locationsList", locationsList.toArray(new String[0]));
                this.saveString("cacheDirectory", toDirectory.getAbsolutePath());
                this.localCacheDirectory = null;
                this.getProjectWorkingDirectory();
                this.treeHelper.loadLocationsList();
                this.treeHelper.applyRootLocations();
                this.windowManager.closeAllWindows();
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            catch (IOException ex) {
                logger.error("Could not save locations list", (Throwable)ex);
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
    }

    public boolean pathIsInFavourites(File fullTestFile) {
        String favouritesString = "favourites";
        int foundPos = fullTestFile.getPath().indexOf(favouritesString) + favouritesString.length();
        if (foundPos == -1) {
            return false;
        }
        if (foundPos > fullTestFile.getPath().length()) {
            return false;
        }
        File testFile = new File(fullTestFile.getPath().substring(0, foundPos));
        return testFile.equals(this.getFavouritesDir());
    }

    public URI getOriginatingUri(URI locationInCacheURI) {
        URI returnUri = null;
        String uriPath = locationInCacheURI.getPath();
        logger.debug("uriPath: {}", (Object)uriPath);
        int foundPos = uriPath.indexOf("imdicache");
        if (foundPos == -1 && (foundPos = uriPath.indexOf(this.getProjectDirectoryName())) == -1) {
            return null;
        }
        uriPath = uriPath.substring(foundPos);
        String[] uriParts = uriPath.split("/", 4);
        try {
            if (uriParts[1].toLowerCase().equals("http")) {
                returnUri = new URI(uriParts[1], uriParts[2], "/" + uriParts[3], null);
                logger.debug("returnUri: {}", (Object)returnUri);
            }
        }
        catch (URISyntaxException urise) {
            logger.error("Could not construct orginating URI from {}", (Object)uriPath, (Object)urise);
        }
        return returnUri;
    }

    public boolean pathIsInsideCache(File fullTestFile) {
        File cacheDirectory = this.getProjectWorkingDirectory();
        for (File testFile = fullTestFile; testFile != null; testFile = testFile.getParentFile()) {
            if (!testFile.equals(cacheDirectory)) continue;
            return true;
        }
        return false;
    }

    public File getFavouritesDir() {
        File favDirectory = new File(this.getProjectDirectory(), "favourites");
        boolean favDirExists = favDirectory.exists();
        if (!favDirExists && !favDirectory.mkdir()) {
            this.logError("Could not create favourites directory", null);
            return null;
        }
        return favDirectory;
    }

    protected String getProjectDirectoryName() {
        return "ArbilWorkingFiles";
    }

    public void saveObject(Serializable object, String filename) throws IOException {
        logger.debug("saveObject: {}", (Object)filename);
        ObjectOutputStream objstream = new ObjectOutputStream(new FileOutputStream(new File(this.getApplicationSettingsDirectory(), filename)));
        objstream.writeObject(object);
        objstream.close();
    }

    public Object loadObject(String filename) throws Exception {
        logger.debug("loadObject: " + filename);
        ObjectInputStream objstream = new ObjectInputStream(new FileInputStream(new File(this.getApplicationSettingsDirectory(), filename)));
        Object object = objstream.readObject();
        objstream.close();
        if (object == null) {
            throw new Exception("Loaded object is null");
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] loadStringArray(String filename) throws IOException {
        File currentConfigFile = null;
        if (filename.equals("locationsList")) {
            currentConfigFile = new File(this.getProjectDirectory(), filename + ".config");
        }
        if (currentConfigFile == null || !currentConfigFile.exists()) {
            currentConfigFile = new File(this.getApplicationSettingsDirectory(), filename + ".config");
        }
        if (currentConfigFile.exists()) {
            ArrayList<String> stringArrayList = new ArrayList<String>();
            FileInputStream fstream = new FileInputStream(currentConfigFile);
            DataInputStream in = new DataInputStream(fstream);
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, UTF8_ENCODING));
                try {
                    String strLine;
                    while ((strLine = br.readLine()) != null) {
                        stringArrayList.add(strLine);
                    }
                }
                finally {
                    br.close();
                }
            }
            finally {
                in.close();
                fstream.close();
            }
            return stringArrayList.toArray(new String[0]);
        }
        return null;
    }

    public void saveStringArray(String filename, String[] storableValue) throws IOException {
        File destinationDirectory = filename.equals("locationsList") ? this.getProjectDirectory() : this.getApplicationSettingsDirectory();
        File destinationConfigFile = new File(destinationDirectory, filename + ".config");
        File tempConfigFile = new File(destinationDirectory, filename + ".config.tmp");
        Writer out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tempConfigFile), UTF8_ENCODING));
            for (String currentString : storableValue) {
                out.write(currentString + "\r\n");
            }
        }
        catch (IOException ex) {
            this.logError(ex);
            throw ex;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        if (!destinationConfigFile.exists() || destinationConfigFile.delete()) {
            if (!tempConfigFile.renameTo(destinationConfigFile)) {
                this.messageDialogHandler.addMessageDialogToQueue(MessageFormat.format(this.services.getString("ERROR SAVING CONFIGURATION TO {0}"), filename), this.services.getString("ERROR SAVING CONFIGURATION"));
            }
        } else {
            this.messageDialogHandler.addMessageDialogToQueue(MessageFormat.format(this.services.getString("COULD NOT WRITE NEW CONFIGURATION TO {0}"), filename), this.services.getString("ERROR SAVING CONFIGURATION"));
        }
    }

    public String loadString(String filename) {
        Properties configObject = this.getConfig();
        String stringProperty = configObject.getProperty("nl.mpi.arbil." + filename);
        return stringProperty;
    }

    public void saveString(String filename, String storableValue) {
        Properties configObject = this.getConfig();
        configObject.setProperty("nl.mpi.arbil." + filename, storableValue);
        this.saveConfig(configObject);
    }

    public final boolean loadBoolean(String filename, boolean defaultValue) {
        Properties configObject = this.getConfig();
        String stringProperty = configObject.getProperty("nl.mpi.arbil." + filename);
        if (stringProperty == null) {
            stringProperty = Boolean.toString(defaultValue);
            this.saveBoolean(filename, defaultValue);
        }
        return Boolean.valueOf(stringProperty);
    }

    public void saveBoolean(String filename, boolean storableValue) {
        Properties configObject = this.getConfig();
        configObject.setProperty("nl.mpi.arbil." + filename, Boolean.toString(storableValue));
        this.saveConfig(configObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getConfig() {
        Properties propertiesObject = new Properties();
        FileInputStream propertiesInStream = null;
        try {
            propertiesInStream = new FileInputStream(new File(this.getApplicationSettingsDirectory(), CONFIG_FILE));
            if (this.canUsePropertiesReaderWriter()) {
                InputStreamReader reader = new InputStreamReader((InputStream)propertiesInStream, UTF8_ENCODING);
                propertiesObject.load(reader);
            } else {
                propertiesObject.load(propertiesInStream);
            }
        }
        catch (IOException ioe) {
            this.saveConfig(propertiesObject);
        }
        finally {
            if (propertiesInStream != null) {
                try {
                    propertiesInStream.close();
                }
                catch (IOException ioe) {
                    this.logError(ioe);
                }
            }
        }
        return propertiesObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveConfig(Properties configObject) {
        FileOutputStream propertiesOutputStream = null;
        try {
            propertiesOutputStream = new FileOutputStream(new File(this.getApplicationSettingsDirectory(), CONFIG_FILE));
            if (this.canUsePropertiesReaderWriter()) {
                OutputStreamWriter propertiesOutputStreamWriter = new OutputStreamWriter((OutputStream)propertiesOutputStream, UTF8_ENCODING);
                configObject.store(propertiesOutputStreamWriter, null);
                propertiesOutputStreamWriter.close();
            } else {
                configObject.store(propertiesOutputStream, null);
            }
            propertiesOutputStream.close();
        }
        catch (IOException ioe) {
            this.logError(ioe);
        }
        finally {
            if (propertiesOutputStream != null) {
                try {
                    propertiesOutputStream.close();
                }
                catch (IOException ioe2) {
                    this.logError(ioe2);
                }
            }
        }
    }

    public File getFromCache(String pathString, boolean followRedirect) {
        return this.updateCache(pathString, null, false, followRedirect, new DownloadAbortFlag(), null);
    }

    public File updateCache(String pathString, int expireCacheDays, boolean followRedirect) {
        boolean fileNeedsUpdate;
        File targetFile = this.getSaveLocation(pathString);
        boolean bl = fileNeedsUpdate = !targetFile.exists();
        if (!fileNeedsUpdate) {
            Date lastModified = new Date(targetFile.lastModified());
            Date expireDate = new Date(System.currentTimeMillis());
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(expireDate);
            calendar.add(5, -expireCacheDays);
            expireDate.setTime(calendar.getTime().getTime());
            fileNeedsUpdate = expireDate.after(lastModified);
            if (fileNeedsUpdate) {
                logger.info("Existing file {} in cache will be updated (at least {} days since {})", new Object[]{pathString, expireCacheDays, lastModified});
            }
        }
        return this.updateCache(pathString, targetFile, null, fileNeedsUpdate, followRedirect, new DownloadAbortFlag(), null);
    }

    public File updateCache(String pathString, ShibbolethNegotiator shibbolethNegotiator, boolean expireCacheCopy, boolean followRedirect, DownloadAbortFlag abortFlag, ProgressListener progressLabel) {
        return this.updateCache(pathString, this.getSaveLocation(pathString), shibbolethNegotiator, expireCacheCopy, followRedirect, abortFlag, progressLabel);
    }

    private File updateCache(String pathString, File cachePath, ShibbolethNegotiator shibbolethNegotiator, boolean expireCacheCopy, boolean followRedirect, DownloadAbortFlag abortFlag, ProgressListener progressLabel) {
        try {
            URL resourceURL;
            URL pathUrl = null;
            if (expireCacheCopy && (resourceURL = this.getFromResources(pathString)) != null) {
                pathUrl = resourceURL;
            }
            if (pathUrl == null) {
                pathUrl = new URL(pathString);
            }
            this.saveRemoteResource(pathUrl, cachePath, shibbolethNegotiator, expireCacheCopy, followRedirect, abortFlag, progressLabel);
        }
        catch (MalformedURLException mul) {
            this.logError(pathString, mul);
        }
        return cachePath;
    }

    public boolean replaceCacheCopy(String pathString) {
        File cachePath = this.getSaveLocation(pathString);
        boolean fileDownloadedBoolean = false;
        try {
            fileDownloadedBoolean = this.saveRemoteResource(new URL(pathString), cachePath, null, true, false, new DownloadAbortFlag(), null);
        }
        catch (MalformedURLException mul) {
            this.logError(mul);
        }
        return fileDownloadedBoolean;
    }

    public File getExportPath(String pathString, String destinationDirectory) {
        logger.debug("pathString: {}", (Object)pathString);
        logger.debug("destinationDirectory: {}", (Object)destinationDirectory);
        String cachePath = pathString;
        for (String testDirectory : new String[]{"imdicache", this.getProjectDirectoryName()}) {
            if (!pathString.contains(testDirectory)) continue;
            cachePath = destinationDirectory + cachePath.substring(cachePath.lastIndexOf(testDirectory) + testDirectory.length());
        }
        File returnFile = new File(cachePath);
        if (!returnFile.getParentFile().exists() && !returnFile.getParentFile().mkdirs()) {
            logger.error("Could not create directory structure for export of {}", (Object)pathString);
            return null;
        }
        return returnFile;
    }

    public URI getNewArbilFileName(File parentDirectory, String nodeType) {
        String suffixString = nodeType.endsWith(".cmdi") || CmdiProfileReader.pathIsProfile(nodeType) ? ".cmdi" : ".imdi";
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        int fileCounter = 0;
        File returnFile = new File(parentDirectory, formatter.format(new Date()) + suffixString);
        while (returnFile.exists()) {
            returnFile = new File(parentDirectory, formatter.format(new Date()) + fileCounter++ + suffixString);
        }
        return returnFile.toURI();
    }

    public URL getFromResources(String pathString) {
        URL resourceURL;
        if (pathString.endsWith(".xsd") && (resourceURL = ArbilSessionStorage.class.getResource(pathString = this.fixCachePath("/nl/mpi/arbil/resources/xsd/" + this.preProcessPathString(pathString)))) != null) {
            return resourceURL;
        }
        return null;
    }

    public File getSaveLocation(String pathString) {
        pathString = this.preProcessPathString(pathString);
        for (String searchString : new String[]{".linorg/imdicache", ".arbil/imdicache", ".linorg\\imdicache", ".arbil\\imdicache", this.getProjectDirectoryName()}) {
            if (pathString.indexOf(searchString) <= -1) continue;
            logger.error("Recursive path error (about to be corrected) in: {}", (Object)pathString);
            pathString = pathString.substring(pathString.lastIndexOf(searchString) + searchString.length());
        }
        String cachePath = this.fixCachePath(pathString);
        File returnFile = new File(this.getProjectWorkingDirectory(), cachePath);
        if (!returnFile.getParentFile().exists() && !returnFile.getParentFile().mkdirs()) {
            logger.error("Could not ccrate directory structure for saving {}", (Object)pathString);
            return null;
        }
        return returnFile;
    }

    private String preProcessPathString(String pathString) {
        try {
            pathString = URLDecoder.decode(pathString, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            this.logError(uee);
        }
        pathString = pathString.replace("//", "/");
        return pathString;
    }

    private String fixCachePath(String pathString) {
        String cachePath = pathString.replace(":/", "/").replace("//", "/").replace('?', '/').replace('&', '/').replace('=', '/');
        while (cachePath.contains(":")) {
            cachePath = cachePath.replace(":", "_");
        }
        if ((cachePath = cachePath.replaceAll("/xsd$", ".xsd")).matches(".*/[^.]*$")) {
            cachePath = cachePath + ".dat";
        }
        return cachePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveRemoteResource(URL targetUrl, File destinationFile, ShibbolethNegotiator shibbolethNegotiator, boolean expireCacheCopy, boolean followRedirect, DownloadAbortFlag abortFlag, ProgressListener progressLabel) {
        boolean downloadSucceeded = false;
        if (destinationFile.length() == 0L && destinationFile.delete()) {
            logger.debug("Deleted zero length (!) file: " + destinationFile);
        }
        String fileName = destinationFile.getName();
        if (!destinationFile.exists() || expireCacheCopy || destinationFile.length() <= 0L) {
            FileOutputStream outFile = null;
            File tempFile = null;
            try {
                URLConnection urlConnection = this.openResourceConnection(targetUrl, shibbolethNegotiator, followRedirect);
                if (urlConnection != null) {
                    tempFile = File.createTempFile(destinationFile.getName(), "tmp", destinationFile.getParentFile());
                    tempFile.deleteOnExit();
                    int bufferLength = 3072;
                    outFile = new FileOutputStream(tempFile);
                    logger.debug("getting file");
                    InputStream stream = urlConnection.getInputStream();
                    byte[] buffer = new byte[bufferLength];
                    int bytesread = 0;
                    int totalRead = 0;
                    while (bytesread >= 0 && !abortFlag.abortDownload) {
                        bytesread = stream.read(buffer);
                        totalRead += bytesread;
                        if (bytesread == -1) break;
                        outFile.write(buffer, 0, bytesread);
                        if (progressLabel == null) continue;
                        progressLabel.setProgressText(fileName + " : " + totalRead / 1024 + " Kb");
                    }
                    outFile.close();
                    outFile = null;
                    if (tempFile.length() > 0L && !abortFlag.abortDownload) {
                        if (destinationFile.exists() && !destinationFile.delete()) {
                            throw new Exception("Changes not saved. Could not delete old file " + destinationFile.toString());
                        }
                        if (!tempFile.renameTo(destinationFile)) {
                            throw new Exception("Changes not saved. Could not rename temporary file to " + destinationFile.toString());
                        }
                        tempFile = null;
                        downloadSucceeded = true;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("Downloaded: %.3f Mb", (double)totalRead / 1048576.0));
                    }
                }
            }
            catch (Exception ex) {
                this.logError(ex);
            }
            finally {
                if (outFile != null) {
                    try {
                        outFile.close();
                    }
                    catch (IOException ioe) {
                        this.logError(ioe);
                    }
                }
                if (tempFile != null && tempFile.exists() && !tempFile.delete()) {
                    BugCatcherManager.getBugCatcher().logError("Could not delete temporary file " + tempFile.getAbsolutePath(), null);
                }
            }
        }
        return downloadSucceeded;
    }

    private URLConnection openResourceConnection(URL resourceUrl, ShibbolethNegotiator shibbolethNegotiator, boolean followRedirects) throws IOException {
        URLConnection urlConnection = resourceUrl.openConnection();
        if (urlConnection instanceof JarURLConnection) {
            return urlConnection;
        }
        HttpURLConnection httpConnection = null;
        if (urlConnection instanceof HttpURLConnection) {
            httpConnection = (HttpURLConnection)urlConnection;
            if (logger.isDebugEnabled()) {
                logger.debug("Code: {}, Message: {}", (Object)httpConnection.getResponseCode(), (Object)(httpConnection.getResponseMessage() + resourceUrl.toString()));
            }
        }
        if (httpConnection != null && httpConnection.getResponseCode() != 200) {
            int responseCode = httpConnection.getResponseCode();
            if (responseCode == 301 || responseCode == 302 || responseCode == 303 || responseCode == 307) {
                String redirectLocation = httpConnection.getHeaderField("Location");
                logger.debug("{}, redirect to {}", (Object)responseCode, (Object)redirectLocation);
                if (followRedirects) {
                    if (redirectLocation != null && redirectLocation.length() > 0) {
                        try {
                            URI resolvedRedirectLocation = resourceUrl.toURI().resolve(redirectLocation);
                            return this.openResourceConnection(resolvedRedirectLocation.toURL(), shibbolethNegotiator, true);
                        }
                        catch (URISyntaxException ex) {
                            BugCatcherManager.getBugCatcher().logError(String.format("Cannot resolve redirect location: %s. Reference URL: %s", redirectLocation, resourceUrl), ex);
                            return null;
                        }
                    }
                } else {
                    logger.debug("Not following redirect. Skipping file");
                }
            } else {
                logger.debug("non 200 response, skipping file");
            }
            return null;
        }
        return urlConnection;
    }

    public File getTypeCheckerConfig() {
        File typeCheckerConfig = new File(this.getApplicationSettingsDirectory(), TYPECHECKER_CONFIG_FILENAME);
        if (typeCheckerConfig.exists()) {
            return typeCheckerConfig;
        }
        return null;
    }

    private synchronized boolean canUsePropertiesReaderWriter() throws SecurityException {
        if (this.propertiesReaderWriterAvailable == null) {
            try {
                this.propertiesReaderWriterAvailable = null != Properties.class.getMethod("store", Writer.class, String.class);
            }
            catch (NoSuchMethodException ex) {
                this.propertiesReaderWriterAvailable = false;
            }
        }
        return this.propertiesReaderWriterAvailable;
    }
}

