/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.util;

import java.awt.Color;
import java.io.Serializable;
import nl.mpi.util.DescriptedObject;

public class CVEntry
implements Comparable,
Serializable,
DescriptedObject {
    private String value;
    private String description;
    private Object externalRef;
    private int shortcutKeyCode = -1;
    private Color prefColor;

    public void setValue(String s) {
        this.value = s;
    }

    public CVEntry() {
    }

    public CVEntry(String value) {
        this(value, null);
    }

    public CVEntry(String value, String description) {
        if (value == null) {
            throw new IllegalArgumentException("The value can not be null.");
        }
        this.value = value;
        this.description = description;
    }

    public CVEntry(CVEntry origEntry) {
        if (origEntry == null) {
            throw new IllegalArgumentException("The CVEntry can not be null.");
        }
        this.value = origEntry.getValue();
        this.description = origEntry.getDescription();
        this.externalRef = origEntry.getExternalRef();
        this.prefColor = origEntry.getPrefColor();
        this.shortcutKeyCode = origEntry.getShortcutKeyCode();
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String getValue() {
        return this.value;
    }

    public Object getExternalRef() {
        return this.externalRef;
    }

    public void setExternalRef(Object externalRef) {
        this.externalRef = externalRef;
    }

    public int getShortcutKeyCode() {
        return this.shortcutKeyCode;
    }

    public void setShortcutKeyCode(int shortcutKeyCode) {
        this.shortcutKeyCode = shortcutKeyCode;
    }

    public Color getPrefColor() {
        return this.prefColor;
    }

    public void setPrefColor(Color prefColor) {
        this.prefColor = prefColor;
    }

    public int compareTo(Object o) {
        CVEntry other = (CVEntry)o;
        int compare = this.getValue().compareTo(other.getValue());
        if (compare == 0) {
            compare = this.getDescription().compareTo(other.getDescription());
        }
        return compare;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        CVEntry other = (CVEntry)obj;
        if (this.value.equals(other.getValue())) {
            if (this.description == null ? other.getDescription() != null : !this.description.equals(other.getDescription())) {
                return false;
            }
            return !(this.externalRef == null ? other.getExternalRef() != null : !this.externalRef.equals(other.getExternalRef()));
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value;
    }
}

