/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.util;

import java.util.List;
import javax.swing.AbstractListModel;

public class PagingListModel
extends AbstractListModel {
    public static final int DEFAULT_PAGE_SIZE = 50;
    protected List data;
    protected int pageOffset = 0;
    protected int pageSize = 50;

    @Override
    public Object getElementAt(int index) {
        if (index >= this.pageSize) {
            throw new IndexOutOfBoundsException("Index " + index + ", viewable Size " + this.pageSize);
        }
        int realIndex = index + this.pageOffset * this.pageSize;
        return this.data.get(realIndex);
    }

    public int getFirstShownRealIndex() {
        return this.data.size() == 0 ? -1 : this.pageOffset * this.pageSize;
    }

    public int getLastShownRealIndex() {
        return this.pageOffset * this.pageSize + this.getSize() - 1;
    }

    public int getPageCount() {
        return (int)Math.ceil((double)this.getRealSize() / (double)this.pageSize);
    }

    public int getPageOffset() {
        return this.pageOffset;
    }

    public void setPageSize(int s) {
        if (s == this.pageSize) {
            return;
        }
        int oldPageSize = this.pageSize;
        this.pageSize = s;
        this.pageOffset = oldPageSize * this.pageOffset / this.pageSize;
        this.fireContentsChanged(this, 0, this.getSize());
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getRealSize() {
        return this.data.size();
    }

    @Override
    public int getSize() {
        return Math.min(this.pageSize, this.data.size() - this.pageOffset * this.pageSize);
    }

    public void pageDown() {
        if (this.pageOffset > 0) {
            --this.pageOffset;
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }

    public void pageUp() {
        if (this.pageOffset < this.getPageCount() - 1) {
            ++this.pageOffset;
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }
}

